/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgbatch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.common.model.CalibratorBean;

public class OrgBatchOperateTaskCheckServiceImpl
implements IOrgBatchBillCheckService {
    private static final Log LOG = LogFactory.getLog(OrgBatchOperateTaskCheckServiceImpl.class);

    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        ArrayList result = Lists.newArrayListWithCapacity((int)3);
        List<String> entryKeys = EntryEntityEnum.getEntryKeys();
        DynamicObject[] operateTaskIng = cacheModel.getOperateTaskArr();
        if (operateTaskIng.length == 0) {
            return result;
        }
        for (String entryKey : entryKeys) {
            if (HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.addEntry.getEntryKey()) || HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.mergeEntry.getEntryKey()) || HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.splitEntry.getEntryKey())) continue;
            DynamicObjectCollection orgColl = targetObject.getDynamicObjectCollection(entryKey);
            for (DynamicObject dynamicObject : orgColl) {
                this.checkOperateTask(dynamicObject, result, operateTaskIng, entryKey);
            }
        }
        return result;
    }

    private void checkOperateTask(DynamicObject entityDy, List<CalibratorBean> result, DynamicObject[] operateTaskIng, String entryKey) {
        DynamicObject adminorgDy = entityDy.getDynamicObject("adminorg");
        Long orgId = adminorgDy.getLong("boid");
        String orgStructLongNumber = adminorgDy.getString("structlongnumber");
        for (DynamicObject orgOperateTask : operateTaskIng) {
            if (orgId.equals(orgOperateTask.getLong("adminorgid.id"))) {
                result.add(new CalibratorBean("FastOrgOperateTaskCheckServiceImpl_0", ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6b63\u5728\u6267\u884c\u201c\u53d8\u66f4\u201d\uff0c\u8bf7\u7a0d\u540e\u8fdb\u884c\u64cd\u4f5c\u3002\u53ef\u901a\u8fc7\u201c\u7ec4\u7ec7\u53d1\u5c55\u4e91>\u7ec4\u7ec7\u7ba1\u7406>\u7ec4\u7ec7\u5feb\u901f\u7ef4\u62a4\u201d\u70b9\u51fb\u201c\u66f4\u591a>\u67e5\u770b\u7ec4\u7ec7\u53d8\u52a8\u5f02\u6b65\u5904\u7406\u7ed3\u679c\u201d\u67e5\u770b\u5904\u7406\u8fdb\u5ea6\u3002", (String)"FastOrgOperateTaskCheckServiceImpl_0", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
                return;
            }
            if (!HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.parentEntry.getEntryKey()) && !HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.infoEntry.getEntryKey())) continue;
            String operateTaskStructLongNumber = orgOperateTask.getString("structlongnumber");
            DynamicObject adminorg = orgOperateTask.getDynamicObject("adminorgid");
            if (orgId.equals(adminorg.getLong("id"))) continue;
            if (orgStructLongNumber.startsWith(operateTaskStructLongNumber)) {
                result.add(new CalibratorBean("FastOrgOperateTaskCheckServiceImpl_1", ResManager.loadKDString((String)"\u56e0\u4e0a\u7ea7\u7ec4\u7ec7\u201c%1$s\u201d/\u201c%2$s\u201d\u53d8\u66f4\u540c\u6b65\u66f4\u65b0\u672c\u7ec4\u7ec7\u7684\u4fe1\u606f\uff0c\u8be5\u52a8\u4f5c\u5c1a\u672a\u5b8c\u6210\uff0c\u8bf7\u7a0d\u540e\u8fdb\u884c\u64cd\u4f5c\u3002\u53ef\u901a\u8fc7\u201c\u7ec4\u7ec7\u53d1\u5c55\u4e91>\u7ec4\u7ec7\u7ba1\u7406>\u7ec4\u7ec7\u5feb\u901f\u7ef4\u62a4\u201d\u70b9\u51fb\u201c\u66f4\u591a>\u67e5\u770b\u7ec4\u7ec7\u53d8\u52a8\u5f02\u6b65\u5904\u7406\u7ed3\u679c\u201d\u67e5\u770b\u5904\u7406\u8fdb\u5ea6\u3002", (String)"FastOrgOperateTaskCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{adminorg.getString("name"), adminorg.getString("number")}));
                return;
            }
            if (!operateTaskStructLongNumber.startsWith(orgStructLongNumber)) continue;
            result.add(new CalibratorBean("FastOrgOperateTaskCheckServiceImpl_2", ResManager.loadKDString((String)"\u56e0\u672c\u7ec4\u7ec7\u53d8\u66f4\u9700\u8981\u540c\u6b65\u5904\u7406\u4e0b\u7ea7\u7ec4\u7ec7\u7684\u4fe1\u606f\uff0c\u4f46\u662f\u8fd9\u4e9b\u4e0b\u7ea7\u7ec4\u7ec7\u5728\u7ec4\u7ec7\u201c%1$s\u201d/\u201c%2$s\u201d\u53d8\u66f4\u4e8b\u52a1\u4e2d\u5c1a\u672a\u5b8c\u6210\uff0c\u8bf7\u7a0d\u540e\u8fdb\u884c\u64cd\u4f5c\u3002\u53ef\u901a\u8fc7\u201c\u7ec4\u7ec7\u53d1\u5c55\u4e91>\u7ec4\u7ec7\u7ba1\u7406>\u7ec4\u7ec7\u5feb\u901f\u7ef4\u62a4\u201d\u70b9\u51fb\u201c\u66f4\u591a>\u67e5\u770b\u7ec4\u7ec7\u53d8\u52a8\u5f02\u6b65\u5904\u7406\u7ed3\u679c\u201d\u67e5\u770b\u5904\u7406\u8fdb\u5ea6\u3002", (String)"FastOrgOperateTaskCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{adminorg.getString("name"), adminorg.getString("number")}));
            return;
        }
    }
}

