/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgbatch;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.validcommon.BillEntryHelperEnum;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckConstants;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.CalibratorBean;

public class OrgBatchUniqueNumberCheckServiceImpl
implements IOrgBatchBillCheckService {
    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        Map<String, String> multiEntryNameMap = OrgBatchBillCheckHelper.assembleMultiEntryName();
        List<OrgBatchCheckDto> ownEnableOrgList = cacheModel.getOwnEnableOrgList();
        int ownEnableOrgSize = ownEnableOrgList.size();
        HashSet orgIdSet = Sets.newHashSetWithExpectedSize((int)ownEnableOrgSize);
        HashSet boIdSet = Sets.newHashSetWithExpectedSize((int)ownEnableOrgSize);
        HashSet numberSet = Sets.newHashSetWithExpectedSize((int)ownEnableOrgSize);
        for (OrgBatchCheckDto dto2 : ownEnableOrgList) {
            orgIdSet.add(dto2.getOrgId());
            boIdSet.add(dto2.getOrgBoId());
            numberSet.add(dto2.getNumber());
        }
        Map<String, List<DynamicObject>> numberOrgsMap = this.queryAdminOrgColl(numberSet, boIdSet);
        HashSet ownNumberSet = Sets.newHashSetWithExpectedSize((int)10);
        Map<String, List<OrgBatchCheckDto>> numberObjMap = ownEnableOrgList.stream().filter(dto -> HRStringUtils.isNotEmpty((String)dto.getNumber())).collect(Collectors.groupingBy(OrgBatchCheckDto::getNumber));
        numberObjMap.forEach((k, v) -> {
            if (v.size() > 1) {
                ownNumberSet.add(k);
            }
        });
        Map<String, String> billNumberSet = cacheModel.getBillOrgList().stream().filter(dto -> !cacheModel.getCurrentBillId().equals(dto.getBillId())).filter(dto -> !orgIdSet.contains(dto.getOrgId())).collect(Collectors.toMap(dto -> dto.getNumber(), dto -> dto.getBillNo(), (v1, v2) -> v1));
        Map<String, Long> billChangeType = cacheModel.getBillOrgList().stream().filter(dto -> !cacheModel.getCurrentBillId().equals(dto.getBillId())).filter(dto -> !orgIdSet.contains(dto.getOrgId())).collect(Collectors.toMap(dto -> dto.getNumber(), dto -> dto.getChangeTypeId(), (v1, v2) -> v1));
        Map<String, OrgBatchCheckDto> billChangeMap = cacheModel.getBillOrgList().stream().filter(dto -> !cacheModel.getCurrentBillId().equals(dto.getBillId())).filter(dto -> !orgIdSet.contains(dto.getOrgId())).collect(Collectors.toMap(dto -> dto.getNumber(), dto -> dto, (v1, v2) -> v1));
        Set<String> bosOrgNumberSet = OrgBatchBillCheckHelper.queryBosOrgNumberSet(boIdSet, numberSet);
        ArrayList<CalibratorBean> result = new ArrayList<CalibratorBean>();
        List<String> entryKeys = EntryEntityEnum.getEntryKeys();
        for (String entryKey : entryKeys) {
            if (HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.disableEntry.getEntryKey()) || HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.mergeEntry.getEntryKey()) || HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.splitEntry.getEntryKey())) continue;
            String entryName = multiEntryNameMap.get(entryKey);
            DynamicObjectCollection orgColl = targetObject.getDynamicObjectCollection(entryKey);
            for (DynamicObject dynamicObject : orgColl) {
                AdminNumberCheckParam isExists;
                String orgNumber = dynamicObject.getString("number");
                String originalName = null;
                if (dynamicObject.get("adminorg") != null) {
                    originalName = dynamicObject.getString("adminorg.name");
                }
                String orgName = dynamicObject.getString("name");
                long changeType = dynamicObject.getLong("changetype.id");
                if (StringUtils.isEmpty((CharSequence)orgNumber)) {
                    DynamicObject adminorgHrDy = AdminOrgBatchChgHelper.getAdminorgHrDy(dynamicObject);
                    boolean codeRuleExistFlag = CodeRuleServiceHelper.isExist((String)"haos_adminorghr", (DynamicObject)adminorgHrDy, (String)String.valueOf(dynamicObject.getString("org.id")));
                    if (changeType != OrgBatchChgBillConstants.CHANGE_TYPE_ADD || !codeRuleExistFlag) {
                        result.add(new CalibratorBean("OrgBatchUniqueNumberCheckServiceImpl_4", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"OrgBatchUniqueNumberCheckServiceImpl_4", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, originalName != null ? originalName : orgName}));
                    }
                }
                if (StringUtils.isEmpty((CharSequence)orgNumber)) continue;
                CalibratorBean bean = new CalibratorBean("OrgBatchUniqueNumberCheckServiceImpl_1", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchUniqueNumberCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, originalName != null ? originalName : orgName});
                List numberDys = numberOrgsMap.getOrDefault(orgNumber, new ArrayList());
                Date checkDate = cacheModel.getEffectDate();
                if (changeType == OrgBatchChgBillConstants.CHANGE_TYPE_ADD) {
                    checkDate = dynamicObject.getDate("establishmentdate");
                }
                if ((isExists = this.isExistsAdminNumber(checkDate, numberDys)).isExists()) {
                    result.add(new CalibratorBean("OrgBatchUniqueNumberCheckServiceImpl_5", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u5728\u201c%3$s\u201d\u671f\u95f4\uff0c\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchUniqueNumberCheckServiceImpl_5", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, originalName != null ? originalName : orgName, OrgBatchBillCheckHelper.getTimeSpan(isExists.getStartTime(), isExists.getEndTime())}));
                }
                if (ownNumberSet.contains(orgNumber)) {
                    result.add(bean);
                }
                if (billNumberSet.containsKey(orgNumber)) {
                    Long type = billChangeType.get(orgNumber);
                    if (billChangeMap.get(orgNumber) != null && !Objects.equals(changeType, OrgBatchChgBillConstants.CHANGE_TYPE_ADD) && Objects.equals(billChangeMap.get(orgNumber).getOrgBoId(), dynamicObject.get("adminorg") != null ? dynamicObject.getLong("adminorg.boid") : 0L)) {
                        result.add(new CalibratorBean("OrgBatchUniqueNumberCheckServiceImpl_8", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u5df2\u5b58\u5728\u5355\u636e\u201c%3$s\u201d\u7684\u201c%4$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5bf9\u7ec4\u7ec7\u8fdb\u884c\u591a\u79cd\u53d8\u52a8\u64cd\u4f5c\u3002", (String)"OrgBatchUniqueNumberCheckServiceImpl_8", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, originalName != null ? originalName : orgName, billNumberSet.get(orgNumber), BillEntryHelperEnum.getEntryDescriptionByChangeType(type)}));
                    } else if (billChangeMap.get(orgNumber) != null && !Objects.equals(billChangeMap.get(orgNumber).getOrgBoId(), dynamicObject.get("adminorg") != null ? dynamicObject.getLong("adminorg.boid") : 0L)) {
                        result.add(new CalibratorBean("OrgBatchUniqueNumberCheckServiceImpl_2", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u201c%3$s\u201d\u5df2\u5b58\u5728\u5728\u9014\u5355\u636e\u201c%4$s\u201d\u4e2d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchUniqueNumberCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, originalName != null ? originalName : orgName, orgNumber, billNumberSet.get(orgNumber)}));
                    }
                }
                if (bosOrgNumberSet.contains(orgNumber)) {
                    result.add(new CalibratorBean("OrgBatchUniqueNumberCheckServiceImpl_3", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u5728\u201c\u57fa\u7840\u670d\u52a1\u4e91>\u4f01\u4e1a\u5efa\u6a21>\u7ec4\u7ec7\u7ba1\u7406>\u884c\u653f\u7ec4\u7ec7/\u4e1a\u52a1\u5355\u5143\u201d\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchUniqueNumberCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, originalName != null ? originalName : orgName}));
                }
                if (!orgNumber.contains("!") && !orgNumber.contains("\uff01")) continue;
                result.add(new CalibratorBean("OrgBatchUniqueNumberCheckServiceImpl_9", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\uff08!\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBatchUniqueNumberCheckServiceImpl_9", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, originalName != null ? originalName : orgName}));
            }
        }
        return result;
    }

    private Map<String, List<DynamicObject>> queryAdminOrgColl(Set<String> numberSet, Set<Long> boIdSet) {
        QFilter adminFilter = new QFilter("number", "in", numberSet);
        adminFilter.and(new QFilter("boid", "not in", boIdSet));
        adminFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        adminFilter.and(new QFilter("datastatus", "in", OrgBatchCheckConstants.DATASTATUS_EFFECT_SET));
        HRBaseServiceHelper adminHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObjectCollection orgColl = adminHelper.queryOriginalCollection("number,bsed,bsled", new QFilter[]{adminFilter});
        return orgColl.stream().collect(Collectors.groupingBy(dy -> dy.getString("number")));
    }

    private AdminNumberCheckParam isExistsAdminNumber(Date checkDate, List<DynamicObject> numberDys) {
        for (DynamicObject dy : numberDys) {
            boolean isExists = OrgBatchBillCheckHelper.isExistsHisInterval(checkDate, dy);
            if (!isExists) continue;
            Date bsled = dy.getDate("bsled");
            return new AdminNumberCheckParam(checkDate, bsled, isExists);
        }
        return new AdminNumberCheckParam(null, null, false);
    }

    public static class AdminNumberCheckParam {
        private Date startTime;
        private Date endTime;
        private boolean isExists;

        public AdminNumberCheckParam(Date startTime, Date endTime, boolean isExists) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.isExists = isExists;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Date startTime) {
            this.startTime = startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Date endTime) {
            this.endTime = endTime;
        }

        public boolean isExists() {
            return this.isExists;
        }

        public void setExists(boolean exists) {
            this.isExists = exists;
        }
    }
}

