/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgbatch;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.haos.common.util.PlatformRootUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckConstants;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.CalibratorBean;

public class OrgChgFeasibleCheckServiceImpl
implements IOrgBatchBillCheckService {
    private OrgBatchCheckCacheModel cacheModel;
    private Map<Long, String> changeTypeIdNameMap;
    private Set<Long> currentDisableOrgIdSet;

    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        this.cacheModel = cacheModel;
        this.changeTypeIdNameMap = OrgBatchBillCheckHelper.queryBaseDataInfo("haos_orgchangetype", "id,name");
        ArrayList<CalibratorBean> result = new ArrayList<CalibratorBean>();
        String changeType = cacheModel.getChangeType();
        if (HRStringUtils.equals((String)EntryEntityEnum.parentEntry.getChangeType(), (String)changeType) || HRStringUtils.equals((String)EntryEntityEnum.infoEntry.getChangeType(), (String)changeType)) {
            String orgName = targetObject.getString("name");
            DynamicObject adminorg = targetObject.getDynamicObject("adminorg");
            Long boId = adminorg.getLong("boid");
            Long orgId = adminorg.getLong("id");
            Long entryId = targetObject.getLong("id");
            this.currentDisableOrgIdSet = OrgBatchBillCheckHelper.queryCurrentDisableOrgIdSet(Sets.newHashSet((Object[])new Long[]{boId}));
            Map<Long, Long> boIdOrgIdMap = OrgBatchBillCheckHelper.queryNewBoIdOrgIdMap(Sets.newHashSet((Object[])new Long[]{boId}));
            Long newOrgId = boIdOrgIdMap.get(boId);
            if (!Objects.isNull(newOrgId) && !newOrgId.equals(orgId)) {
                result.add(new CalibratorBean("OrgChgFeasibleCheckServiceImpl_1", ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u57fa\u4e8e\u6700\u65b0\u7684\u4fe1\u606f\u8fdb\u884c\u8c03\u6574\u3002", (String)"OrgChgFeasibleCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
            }
            DynamicObjectCollection currentOrgColl = cacheModel.getCurrentOrgColl();
            HashMap idChangetypeMap = Maps.newHashMapWithExpectedSize((int)currentOrgColl.size());
            for (DynamicObject dy : currentOrgColl) {
                if (entryId.equals(dy.getLong("id"))) continue;
                idChangetypeMap.put(dy.getLong("adminorg.id"), dy.getLong("changetype.id"));
            }
            if (idChangetypeMap.containsKey(orgId) && !HRStringUtils.equals((String)targetObject.getString("mergesplitstatus"), (String)"0")) {
                result.add(new CalibratorBean("OrgChgFeasibleCheckServiceImpl_4", ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u5b58\u5728\u201c%2$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5bf9\u7ec4\u7ec7\u8fdb\u884c\u591a\u79cd\u53d8\u52a8\u64cd\u4f5c\u3002", (String)"OrgChgFeasibleCheckServiceImpl_4", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, this.changeTypeIdNameMap.get(idChangetypeMap.get(orgId))}));
            }
            this.checkParentChg(changeType, boId, orgId, targetObject, result);
            this.checkInfoChg(changeType, boId, orgId, targetObject, result);
        } else if (HRStringUtils.equals((String)EntryEntityEnum.mergeEntry.getChangeType(), (String)changeType) || HRStringUtils.equals((String)EntryEntityEnum.splitEntry.getChangeType(), (String)changeType)) {
            // empty if block
        }
        return result;
    }

    private void checkParentChg(String changeType, Long boId, Long currentOrgId, DynamicObject dynamicObject, List<CalibratorBean> result) {
        if (HRStringUtils.equals((String)EntryEntityEnum.parentEntry.getChangeType(), (String)changeType)) {
            DynamicObject adminOrg = dynamicObject.getDynamicObject("adminorg");
            String orgName = adminOrg.getString("name");
            if (this.currentDisableOrgIdSet.contains(boId) || !HRStringUtils.equals((String)"1", (String)adminOrg.getString("enable"))) {
                result.add(new CalibratorBean("OrgChgFeasibleCheckServiceImpl_2", ResManager.loadKDString((String)"%s\u5df2\u505c\u7528\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u4e0a\u7ea7\u3002", (String)"OrgChgFeasibleCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName}));
            }
            if (!Objects.isNull(boId) && boId == PlatformRootUtils.getLongRootIdOfPlatform()) {
                result.add(new CalibratorBean("OrgChgFeasibleCheckServiceImpl_6", ResManager.loadKDString((String)"\u6839\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u201c\u8c03\u6574\u4e0a\u7ea7\u201d\u3002", (String)"OrgChgFeasibleCheckServiceImpl_6", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
            }
            for (OrgBatchCheckDto dto : this.cacheModel.getBillOrgList()) {
                if (this.cacheModel.getCurrentBillId().equals(dto.getBillId())) continue;
                long billOrgId = dto.getOrgId();
                String billNo = dto.getBillNo();
                long changeTypeId = dto.getChangeTypeId();
                if (billOrgId == currentOrgId && changeTypeId == OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE) {
                    result.add(new CalibratorBean("OrgChgFeasibleCheckServiceImpl_3", ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u5b58\u5728\u5355\u636e\u201c%2$s\u201d \u7684\u201c%3$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u4e0a\u7ea7\u3002", (String)"OrgChgFeasibleCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, billNo, this.changeTypeIdNameMap.get(changeTypeId)}));
                }
                List<Long> changeTypeList = Arrays.asList(OrgBatchChgBillConstants.CHANGE_TYPE_PARENT, OrgBatchChgBillConstants.CHANGE_TYPE_INFO, OrgBatchChgBillConstants.CHANGE_TYPE_MERGE, OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT);
                if (billOrgId != currentOrgId || !changeTypeList.contains(changeTypeId)) continue;
                result.add(new CalibratorBean("OrgChgFeasibleCheckServiceImpl_5", ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u5b58\u5728\u5355\u636e\u201c%2$s\u201d\u7684\u201c%3$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5bf9\u7ec4\u7ec7\u8fdb\u884c\u591a\u79cd\u53d8\u52a8\u64cd\u4f5c\u3002", (String)"OrgChgFeasibleCheckServiceImpl_5", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, billNo, this.changeTypeIdNameMap.get(changeTypeId)}));
            }
        }
    }

    private void checkInfoChg(String changeType, Long boId, Long currentOrgId, DynamicObject dynamicObject, List<CalibratorBean> result) {
        if (HRStringUtils.equals((String)EntryEntityEnum.infoEntry.getChangeType(), (String)changeType)) {
            Long orgTypeId;
            DynamicObject adminorg = dynamicObject.getDynamicObject("adminorg");
            String orgName = adminorg.getString("name");
            if (this.currentDisableOrgIdSet.contains(boId) || !HRStringUtils.equals((String)"1", (String)adminorg.getString("enable"))) {
                result.add(new CalibratorBean("OrgChgFeasibleCheckServiceImpl_8", ResManager.loadKDString((String)"%s\u5df2\u505c\u7528\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u4fe1\u606f\u3002", (String)"OrgChgFeasibleCheckServiceImpl_8", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName}));
            }
            Map<Long, DynamicObject> orgOldInfoMap = OrgBatchBillCheckHelper.batchQueryOrgDetailInfoById(Sets.newHashSet((Object[])new Long[]{adminorg.getLong("boid")}));
            for (OrgBatchCheckDto dto : this.cacheModel.getBillOrgList()) {
                if (this.cacheModel.getCurrentBillId().equals(dto.getBillId())) continue;
                long billOrgId = dto.getOrgId();
                String billNo = dto.getBillNo();
                long changeTypeId = dto.getChangeTypeId();
                if (billOrgId == currentOrgId && changeTypeId == OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE) {
                    result.add(new CalibratorBean("OrgChgFeasibleCheckServiceImpl_10", ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u5b58\u5728\u5355\u636e\u201c%2$s\u201d \u7684\u201c%3$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u4fe1\u606f\u3002", (String)"OrgChgFeasibleCheckServiceImpl_10", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, billNo, this.changeTypeIdNameMap.get(changeTypeId)}));
                }
                List<Long> changeTypeList = Arrays.asList(OrgBatchChgBillConstants.CHANGE_TYPE_PARENT, OrgBatchChgBillConstants.CHANGE_TYPE_INFO, OrgBatchChgBillConstants.CHANGE_TYPE_MERGE, OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT);
                if (billOrgId != currentOrgId || !changeTypeList.contains(changeTypeId)) continue;
                result.add(new CalibratorBean("OrgChgFeasibleCheckServiceImpl_5", ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u5b58\u5728\u5355\u636e\u201c%2$s\u201d\u7684\u201c%3$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5bf9\u7ec4\u7ec7\u8fdb\u884c\u591a\u79cd\u53d8\u52a8\u64cd\u4f5c\u3002", (String)"OrgChgFeasibleCheckServiceImpl_5", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, billNo, this.changeTypeIdNameMap.get(changeTypeId)}));
            }
            if (!Objects.isNull(boId) && boId == PlatformRootUtils.getLongRootIdOfPlatform() && !OrgBatchCheckConstants.LEVEL4_COMPANY_GROPU.contains(orgTypeId = Long.valueOf(dynamicObject.getLong("adminorgtype.adminorgtypestd.id")))) {
                result.add(new CalibratorBean("OrgChgFeasibleCheckServiceImpl_9", ResManager.loadKDString((String)"\u6839\u7ec4\u7ec7\u7684\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%s\u201d\u3002", (String)"OrgChgFeasibleCheckServiceImpl_9", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{OrgBatchBillCheckHelper.groupCompanyStr()}));
            }
        }
    }

    private void checkOrgMerge() {
    }

    private void checkOrgSplit() {
    }
}

