/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgbatch;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.service.adminorg.bean.Pair;
import kd.hr.haos.common.constants.masterdata.AdminOrgType;
import kd.hr.haos.common.util.PlatformRootUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckConstants;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.CalibratorBean;

public class OrgLevel4ModelCheckServiceImpl
implements IOrgBatchBillCheckService {
    private Map<String, String> adminOrgTypeNameMap;
    private List<OrgBatchCheckDto> checkDtoList;
    private Map<Long, Long> orgTypeStdIdMap;

    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        this.adminOrgTypeNameMap = OrgBatchBillCheckHelper.queryAdminOrgTypeNameMap(targetObject.getLong("org.id"));
        Date effectDate = null;
        effectDate = "homs_batchorgentityadd".equals(targetObject.getDataEntityType().toString()) ? targetObject.getDate("establishmentdate") : cacheModel.getEffectDate();
        this.checkDtoList = OrgBatchBillCheckHelper.queryBillOrgList();
        this.orgTypeStdIdMap = OrgBatchBillCheckHelper.queryOrgTypeTypeStdIdMap();
        ArrayList<CalibratorBean> result = new ArrayList<CalibratorBean>();
        String changeType = cacheModel.getChangeType();
        this.aboveLevel4ModelCheck(targetObject, cacheModel, effectDate, result);
        this.lowerLevel4ModelCheck(changeType, targetObject, effectDate, result);
        return result;
    }

    private void aboveLevel4ModelCheck(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel, Date effectDate, List<CalibratorBean> result) {
        Long currentOrgId = targetObject.getLong("adminorg.boid");
        if (PlatformRootUtils.getLongRootIdOfPlatform() == currentOrgId) {
            return;
        }
        DynamicObject orgType = targetObject.getDynamicObject("adminorgtype");
        Long orgTypeStdId = orgType.getLong("adminorgtypestd.id");
        OrgAboveLevel4ModelParam adminorgtypeId = this.getParentAdminOrgType(targetObject, cacheModel, effectDate);
        if (adminorgtypeId != null) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgtype");
            QFilter idFilter = new QFilter("id", "=", (Object)adminorgtypeId.getType());
            DynamicObject parentAdminorgtypeDy = serviceHelper.loadDynamicObject(idFilter);
            Long parentOrgtypeStdId = parentAdminorgtypeDy.getLong("adminorgtypestd.id");
            if (AdminOrgType.GROUP.getId() == orgTypeStdId.longValue() && !OrgBatchCheckConstants.LEVEL4_ABOVE_GROUP.contains(parentOrgtypeStdId)) {
                if (adminorgtypeId.isInOwnBill()) {
                    result.add(new CalibratorBean("OrgLevel4ModelCheckServiceImpl_1", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgLevel4ModelCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgType.getString("name"), this.adminOrgTypeNameMap.get("level4_above_group")}));
                } else {
                    result.add(new CalibratorBean("OrgLevel4ModelCheckServiceImpl_2", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u5728\u201c%3$s\u201d\u671f\u95f4\u4e0d\u6ee1\u8db3\u89c4\u5219\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgLevel4ModelCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgType.getString("name"), this.adminOrgTypeNameMap.get("level4_above_group"), OrgBatchBillCheckHelper.getTimeSpan(adminorgtypeId.getStartTime(), adminorgtypeId.getEndTime())}));
                }
            } else if (AdminOrgType.COMPANY.getId() == orgTypeStdId.longValue() && !OrgBatchCheckConstants.LEVEL4_ABOVE_COMPANY.contains(parentOrgtypeStdId)) {
                if (adminorgtypeId.isInOwnBill()) {
                    result.add(new CalibratorBean("OrgLevel4ModelCheckServiceImpl_1", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgLevel4ModelCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgType.getString("name"), this.adminOrgTypeNameMap.get("level4_above_company")}));
                } else {
                    result.add(new CalibratorBean("OrgLevel4ModelCheckServiceImpl_2", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u5728\u201c%3$s\u201d\u671f\u95f4\u4e0d\u6ee1\u8db3\u89c4\u5219\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgLevel4ModelCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgType.getString("name"), this.adminOrgTypeNameMap.get("level4_above_company"), OrgBatchBillCheckHelper.getTimeSpan(adminorgtypeId.getStartTime(), adminorgtypeId.getEndTime())}));
                }
            }
        }
        Long parentId = targetObject.getLong("parentorg.id");
        this.checkDtoList.forEach(dto -> {
            Long parentStdId;
            if (parentId.equals(dto.getOrgId()) && !Objects.isNull(parentStdId = this.orgTypeStdIdMap.get(dto.getOrgTypeId()))) {
                if (AdminOrgType.GROUP.getId() == orgTypeStdId.longValue() && !OrgBatchCheckConstants.LEVEL4_ABOVE_GROUP.contains(parentStdId)) {
                    result.add(new CalibratorBean("FastOrgLevel4ModelCheckServiceImpl_2", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u76ee\u524d\u6709\u5728\u9014\u5355\u201c%3$s\u201d\u6570\u636e\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastOrgLevel4ModelCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgType.getString("name"), this.adminOrgTypeNameMap.get("level4_above_group"), dto.getBillNo()}));
                } else if (AdminOrgType.COMPANY.getId() == orgTypeStdId.longValue() && !OrgBatchCheckConstants.LEVEL4_ABOVE_COMPANY.contains(parentStdId)) {
                    result.add(new CalibratorBean("FastOrgLevel4ModelCheckServiceImpl_2", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u76ee\u524d\u6709\u5728\u9014\u5355\u201c%3$s\u201d\u6570\u636e\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastOrgLevel4ModelCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgType.getString("name"), this.adminOrgTypeNameMap.get("level4_above_company"), dto.getBillNo()}));
                }
            }
        });
    }

    private void lowerLevel4ModelCheck(String changeType, DynamicObject targetObject, Date effectDate, List<CalibratorBean> result) {
        if (HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.addEntry.getChangeType()) && Objects.isNull(targetObject.getDynamicObject("adminorg"))) {
            return;
        }
        DynamicObject orgtype = targetObject.getDynamicObject("adminorgtype");
        long orgtypeStdId = orgtype.getLong("adminorgtypestd.id");
        Long boId = targetObject.getLong("adminorg.boid");
        Map<Long, Pair<Date, Date>> lowerOrgTypeIds = this.getLowerOrgtypeId(boId, effectDate);
        if (lowerOrgTypeIds != null) {
            if (AdminOrgType.COMPANY.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_LOWER_COMPANY.containsAll(lowerOrgTypeIds.keySet())) {
                result.add(new CalibratorBean("OrgLevel4ModelCheckServiceImpl_3", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u5728\u201c%3$s\u201d\u671f\u95f4\u4e0d\u6ee1\u8db3\u89c4\u5219\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgLevel4ModelCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgtype.getString("name"), this.adminOrgTypeNameMap.get("level4_lower_company"), OrgBatchBillCheckHelper.getTimeSpan(lowerOrgTypeIds.get(1010L) == null ? effectDate : (Date)lowerOrgTypeIds.get(1010L).getKey(), lowerOrgTypeIds.get(1010L) == null ? OrgBatchBillCheckHelper.lastDate : (Date)lowerOrgTypeIds.get(1010L).getValue())}));
            } else if (AdminOrgType.DEPARTMENT.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_LOWER_DEPT.containsAll(lowerOrgTypeIds.keySet())) {
                result.add(new CalibratorBean("OrgLevel4ModelCheckServiceImpl_3", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u5728\u201c%3$s\u201d\u671f\u95f4\u4e0d\u6ee1\u8db3\u89c4\u5219\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgLevel4ModelCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgtype.getString("name"), this.adminOrgTypeNameMap.get("level4_lower_dept"), OrgBatchBillCheckHelper.getTimeSpan(lowerOrgTypeIds.get(1020L) == null ? effectDate : (Date)lowerOrgTypeIds.get(1020L).getKey(), lowerOrgTypeIds.get(1020L) == null ? OrgBatchBillCheckHelper.lastDate : (Date)lowerOrgTypeIds.get(1020L).getValue())}));
            }
        }
        Long orgId = targetObject.getDynamicObject("adminorg").getLong("id");
        this.checkDtoList.forEach(dto -> {
            Long childOrgStdId;
            if (dto.getParentOrgId().equals(orgId) && !Objects.isNull(childOrgStdId = this.orgTypeStdIdMap.get(dto.getOrgTypeId()))) {
                if (AdminOrgType.COMPANY.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_LOWER_COMPANY.contains(childOrgStdId)) {
                    result.add(new CalibratorBean("FastOrgLevel4ModelCheckServiceImpl_4", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u76ee\u524d\u6709\u5728\u9014\u5355\u201c%3$s\u201d\u6570\u636e\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastOrgLevel4ModelCheckServiceImpl_4", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgtype.getString("name"), this.adminOrgTypeNameMap.get("level4_lower_company"), dto.getBillNo()}));
                } else if (AdminOrgType.DEPARTMENT.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_LOWER_DEPT.contains(childOrgStdId)) {
                    result.add(new CalibratorBean("FastOrgLevel4ModelCheckServiceImpl_4", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u76ee\u524d\u6709\u5728\u9014\u5355\u201c%3$s\u201d\u6570\u636e\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastOrgLevel4ModelCheckServiceImpl_4", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgtype.getString("name"), this.adminOrgTypeNameMap.get("level4_lower_dept"), dto.getBillNo()}));
                }
            }
        });
    }

    private OrgAboveLevel4ModelParam getParentAdminOrgType(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel, Date effectDate) {
        long parentOrgId = targetObject.getLong("parentorg.id");
        DynamicObjectCollection dyCollection = cacheModel.getCurrentOrgColl();
        Optional<DynamicObject> dyOptional = dyCollection.stream().filter(dy -> dy.getDynamicObject("adminorg").getLong("id") == parentOrgId && OrgBatchChgBillConstants.CHANGE_TYPE_ADD.longValue() != dy.getDynamicObject("changetype").getLong("id")).findFirst();
        if (dyOptional.isPresent()) {
            return new OrgAboveLevel4ModelParam(true, dyOptional.get().getLong("adminorgtype.id"), null, null);
        }
        long parentOrgBoid = targetObject.getLong("parentorg.boid");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter qFilter = new QFilter("boid", "=", (Object)parentOrgBoid);
        qFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        qFilter.and(new QFilter("datastatus", "in", OrgBatchCheckConstants.DATASTATUS_EFFECT_SET));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        boolean existIn = false;
        Date before = null;
        Date after = null;
        DynamicObject dyn = null;
        for (DynamicObject dy2 : dynamicObjects) {
            if (!OrgBatchBillCheckHelper.isExistsHisInterval(effectDate, dy2)) continue;
            dyn = dy2;
            existIn = true;
            if (before == null) {
                before = dy2.getDate("bsed");
            } else if (!before.before(dy2.getDate("bsed"))) {
                before = dy2.getDate("bsed");
            }
            if (after == null) {
                after = dy2.getDate("bsled");
                continue;
            }
            if (after.after(dy2.getDate("bsled"))) continue;
            after = dy2.getDate("bsled");
        }
        if (existIn) {
            Date returnDate = null;
            returnDate = before != null && before.before(effectDate) ? effectDate : before;
            if (dyn != null && dyn.getDynamicObject("adminorgtype") != null) {
                return new OrgAboveLevel4ModelParam(false, dyn.getDynamicObject("adminorgtype").getLong("id"), returnDate, after);
            }
        }
        return null;
    }

    private Map<Long, Pair<Date, Date>> getLowerOrgtypeId(Long boId, Date effectDate) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter qFilter = new QFilter("parentorg.id", "=", (Object)boId);
        qFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        qFilter.and(new QFilter("datastatus", "in", OrgBatchCheckConstants.DATASTATUS_EFFECT_SET));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("bsled", ">=", (Object)effectDate));
        qFilter.and(new QFilter("bsed", "<=", (Object)effectDate));
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        HashMap<Long, Pair<Date, Date>> orgTypeToTimeSpan = new HashMap<Long, Pair<Date, Date>>();
        try {
            for (DynamicObject dy : dynamicObjects) {
                Date bsled;
                long adminOrgType = dy.getDynamicObject("adminorgtype").getLong("adminorgtypestd.id");
                Pair<Date, Date> typeTimeSpan = orgTypeToTimeSpan.getOrDefault(adminOrgType, (Pair<Date, Date>)new Pair((Object)HRDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd"), (Object)new Date(0L)));
                Date bsed = dy.getDate("bsed");
                if (bsed.before((Date)typeTimeSpan.getKey())) {
                    typeTimeSpan.setKey((Object)bsed);
                }
                if ((bsled = dy.getDate("bsled")).after((Date)typeTimeSpan.getValue())) {
                    typeTimeSpan.setValue((Object)bsled);
                }
                typeTimeSpan.setKey((Object)effectDate);
                orgTypeToTimeSpan.put(adminOrgType, typeTimeSpan);
            }
            return orgTypeToTimeSpan;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static class OrgAboveLevel4ModelParam {
        private boolean inOwnBill;
        private Long type;
        private Date startTime;
        private Date endTime;

        public OrgAboveLevel4ModelParam(boolean inOwnBill, Long type, Date startTime, Date endTime) {
            this.inOwnBill = inOwnBill;
            this.type = type;
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public boolean isInOwnBill() {
            return this.inOwnBill;
        }

        public Long getType() {
            return this.type;
        }

        public void setType(Long type) {
            this.type = type;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Date startTime) {
            this.startTime = startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }
    }
}

