/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgbatch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.util.NameSeparatorTipsUtil;
import kd.hr.haos.business.util.PatternUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckConstants;
import kd.hr.homs.common.model.CalibratorBean;

public class OrgNameCheckServiceImpl
implements IOrgBatchBillCheckService {
    private OrgBatchCheckCacheModel cacheModel;
    private Map<Long, String> billIdToBillNo;
    private PatternUtil patternUtil = new PatternUtil();
    private NameSeparatorTipsUtil nameSeparatorTipsUtil = new NameSeparatorTipsUtil();

    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        this.cacheModel = cacheModel;
        ArrayList<CalibratorBean> result = new ArrayList<CalibratorBean>();
        Long orgId = targetObject.getLong("adminorg.id");
        Long parentOrgId = targetObject.getLong("parentorg.id");
        Long parentBoId = targetObject.getLong("parentorg.boid");
        String parentOrgName = targetObject.getString("parentorg.name");
        Long entryId = targetObject.getLong("id");
        Map<String, String> multiNameMap = OrgBatchBillCheckHelper.assembleMultiName();
        Map<String, OrgNameKeyAndTimeSpan> adminOrgNameKeySet = this.queryAdminOrgNameKeySet(parentBoId, targetObject);
        Set<String> currentOrgNameKeySet = this.queryCurrentOrgNameKeySet(parentOrgId, entryId, orgId);
        Map<String, String> billOrgNameKeySet = this.queryBillOrgNameKeySet(parentOrgId, entryId, orgId);
        OrmLocaleValue nameOrm = (OrmLocaleValue)targetObject.get("name");
        for (Map.Entry entry : nameOrm.entrySet()) {
            String ormKey = (String)entry.getKey();
            String orgName = (String)entry.getValue();
            if (!multiNameMap.containsKey(ormKey) || HRStringUtils.isEmpty((String)orgName)) continue;
            String adminMultiNameKey = OrgBatchBillCheckHelper.generateMultiNameComboKey(parentBoId, ormKey, orgName);
            String entryMultiNameKey = OrgBatchBillCheckHelper.generateMultiNameComboKey(parentOrgId, ormKey, orgName);
            if (adminOrgNameKeySet.containsKey(adminMultiNameKey)) {
                result.add(new CalibratorBean("OrgNameCheckServiceImpl_4", ResManager.loadKDString((String)"\u5728\u201c%1$s\u201d\u671f\u95f4,\u201c%2$s\u201d\u4e0b\u5df2\u5b58\u5728\u201c%3$s\u201d\u540d\u79f0\u201c%4$s\u201d\u7684\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgNameCheckServiceImpl_4", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{OrgBatchBillCheckHelper.getTimeSpan(adminOrgNameKeySet.get(adminMultiNameKey).getStartTime(), adminOrgNameKeySet.get(adminMultiNameKey).getEndTime()), parentOrgName, multiNameMap.get(ormKey), orgName}));
            }
            if (currentOrgNameKeySet.contains(entryMultiNameKey)) {
                result.add(new CalibratorBean("OrgNameCheckServiceImpl_1", ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0b\u5df2\u5b58\u5728\u201c%2$s\u201d\u540d\u79f0\u201c%3$s\u201d\u7684\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgNameCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{parentOrgName, multiNameMap.get(ormKey), orgName}));
            }
            if (billOrgNameKeySet.containsKey(entryMultiNameKey) && !HRStringUtils.isEmpty((String)billOrgNameKeySet.get(entryMultiNameKey))) {
                result.add(new CalibratorBean("OrgNameCheckServiceImpl_2", ResManager.loadKDString((String)"\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%1$s\uff09\u4e2d\u201c%2$s\u201d\u4e0b\u5df2\u5b58\u5728\u201c%3$s\u201d\u540d\u79f0\u201c%4$s\u201d\u7684\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgNameCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{billOrgNameKeySet.get(entryMultiNameKey), parentOrgName, multiNameMap.get(ormKey), orgName}));
            }
            if (!this.patternUtil.validName4Config(orgName)) continue;
            result.add(new CalibratorBean("OrgNameCheckServiceImpl_3", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u201c%1$s\u201d\u540d\u79f0\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\uff08%2$s\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgNameCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{multiNameMap.get(ormKey), this.nameSeparatorTipsUtil.getAllSeparator()}));
        }
        return result;
    }

    private Map<String, OrgNameKeyAndTimeSpan> queryAdminOrgNameKeySet(Long parentBoId, DynamicObject targetObject) {
        HashMap<String, OrgNameKeyAndTimeSpan> map = new HashMap<String, OrgNameKeyAndTimeSpan>();
        DynamicObject adminorg = targetObject.getDynamicObject("adminorg");
        QFilter parentFilter = new QFilter("parentorg", "=", (Object)parentBoId);
        if (adminorg != null) {
            parentFilter.and(new QFilter("boid", "<>", (Object)adminorg.getLong("boid")));
        }
        parentFilter.and(new QFilter("enable", "=", (Object)"1"));
        parentFilter.and(new QFilter("datastatus", "in", OrgBatchCheckConstants.DATASTATUS_EFFECT_SET));
        parentFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        HRBaseServiceHelper adminHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObject[] orgArr = adminHelper.loadDynamicObjectArray(new QFilter[]{parentFilter});
        Date checkDate = this.cacheModel.getEffectDate();
        if (HRStringUtils.equals((String)EntryEntityEnum.addEntry.getChangeType(), (String)this.cacheModel.getChangeType())) {
            checkDate = targetObject.getDate("establishmentdate");
        }
        for (DynamicObject dy : orgArr) {
            boolean isExists = OrgBatchBillCheckHelper.isExistsHisInterval(checkDate, dy);
            if (!isExists) continue;
            Date bsled = dy.getDate("bsled");
            Set<String> comboKeys = OrgBatchBillCheckHelper.assembleMultiNameComboKey(dy);
            Date finalCheckDate = checkDate;
            comboKeys.forEach(key -> map.put((String)key, new OrgNameKeyAndTimeSpan(finalCheckDate, bsled)));
        }
        return map;
    }

    private Set<String> queryCurrentOrgNameKeySet(Long parentOrgId, Long entryId, Long orgId) {
        HRBaseServiceHelper entryHelper = new HRBaseServiceHelper("homs_batchorgentity");
        QFilter billIdFilter = new QFilter("billid", "=", (Object)this.cacheModel.getCurrentBillId());
        QFilter parentFilter = new QFilter("parentorg", "=", (Object)parentOrgId);
        QFilter idFilter = new QFilter("id", "<>", (Object)entryId);
        QFilter orgIdFilter = new QFilter("adminorg.id", "<>", (Object)orgId);
        QFilter[] qFilters = new QFilter[]{billIdFilter, parentFilter, idFilter, orgIdFilter};
        return this.queryOrgNameKeySet(entryHelper, qFilters);
    }

    private Map<String, String> queryBillOrgNameKeySet(Long parentOrgId, Long entryId, Long orgId) {
        HRBaseServiceHelper billHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
        QFilter auditFilter = new QFilter("billstatus", "in", Arrays.asList("B", "D"));
        DynamicObjectCollection billColl = billHelper.queryOriginalCollection("id,billno", new QFilter[]{auditFilter});
        List billIdList = billColl.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        this.billIdToBillNo = billColl.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("billno")));
        HRBaseServiceHelper entryHelper = new HRBaseServiceHelper("homs_batchorgentity");
        QFilter entryFilter = new QFilter("billid", "in", billIdList);
        entryFilter.and(new QFilter("parentorg", "=", (Object)parentOrgId));
        entryFilter.and(new QFilter("id", "<>", (Object)entryId));
        if (!OrgBatchBillCheckHelper.isValidateOrgId(orgId)) {
            entryFilter.and(new QFilter("adminorg.id", "<>", (Object)orgId));
        }
        return this.queryOrgNameMap(entryHelper, new QFilter[]{entryFilter});
    }

    private Set<String> queryOrgNameKeySet(HRBaseServiceHelper helper, QFilter[] qFilters) {
        HashSet<String> orgNameKeySet = new HashSet<String>(10);
        DynamicObject[] orgArr = helper.loadDynamicObjectArray(qFilters);
        Map<Long, DynamicObject> unSafeAndDeleteDataMap = Arrays.stream(orgArr).filter(org -> HRStringUtils.equals((String)org.getString("mergesplitstatus"), (String)"0") || HRStringUtils.equals((String)org.getString("mergesplitstatus"), (String)"1")).collect(Collectors.toMap(org -> org.getLong("adminorg.id"), org -> org));
        for (DynamicObject dynamicObject : orgArr) {
            long orgId = dynamicObject.getLong("adminorg.id");
            if (unSafeAndDeleteDataMap.containsKey(orgId)) {
                DynamicObject data = unSafeAndDeleteDataMap.get(orgId);
                String status = data.getString("mergesplitstatus");
                if (!HRStringUtils.equals((String)"0", (String)status)) continue;
                Set<String> comboKeys = OrgBatchBillCheckHelper.assembleMultiNameComboKey(data);
                orgNameKeySet.addAll(comboKeys);
                continue;
            }
            Set<String> comboKeys = OrgBatchBillCheckHelper.assembleMultiNameComboKey(dynamicObject);
            orgNameKeySet.addAll(comboKeys);
        }
        return orgNameKeySet;
    }

    private Map<String, String> queryOrgNameMap(HRBaseServiceHelper helper, QFilter[] qFilters) {
        DynamicObject[] orgArr;
        HashMap<String, String> orgNameKeySet = new HashMap<String, String>(10);
        for (DynamicObject dynamicObject : orgArr = helper.loadDynamicObjectArray(qFilters)) {
            Set<String> comboKeys = OrgBatchBillCheckHelper.assembleMultiNameComboKey(dynamicObject);
            comboKeys.forEach(key -> orgNameKeySet.put((String)key, this.billIdToBillNo.get(dynamicObject.getLong("billid"))));
        }
        return orgNameKeySet;
    }

    private static class OrgNameKeyAndTimeSpan {
        private Date startTime;
        private Date endTime;

        public OrgNameKeyAndTimeSpan(Date startTime, Date endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Date startTime) {
            this.startTime = startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Date endTime) {
            this.endTime = endTime;
        }
    }
}

