/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgbatch;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.business.service.validcommon.StructCycleOrgBean;
import kd.hr.homs.common.model.CalibratorBean;

public class OrgStructAffiliationCheckServiceImpl
implements IOrgBatchBillCheckService {
    private static final Log LOGGER = LogFactory.getLog(OrgStructAffiliationCheckServiceImpl.class);

    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        ArrayList<CalibratorBean> result = new ArrayList<CalibratorBean>();
        String changeType = cacheModel.getChangeType();
        Long orgBoId = targetObject.getLong("adminorg.boid");
        if (orgBoId == 0L) {
            orgBoId = targetObject.getLong("orgid");
        }
        if (HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.addEntry.getChangeType()) || HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.parentEntry.getChangeType()) || HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.infoEntry.getChangeType())) {
            DynamicObjectCollection structCollection = targetObject.getDynamicObjectCollection("struct_project_entry");
            if (CollectionUtils.isEmpty((Collection)structCollection)) {
                return result;
            }
            Set<Long> parentIds = structCollection.stream().map(entryDy -> entryDy.getLong("struct_parent_org.boid")).collect(Collectors.toSet());
            List<StructCycleOrgBean> parentOrgList = OrgBatchBillCheckHelper.queryParentOrgColl(cacheModel.getEffectDate(), parentIds);
            HashMap parentStructMap = Maps.newHashMap();
            for (StructCycleOrgBean structCycleOrgBean : parentOrgList) {
                Map<Long, String> longStringMap;
                Long structproject = structCycleOrgBean.getStructproject();
                if (parentStructMap.containsKey(structproject)) {
                    longStringMap = (Map)parentStructMap.get(structproject);
                    longStringMap.put(structCycleOrgBean.getOrgId(), structCycleOrgBean.getStructLongNumber());
                    continue;
                }
                longStringMap = Maps.newHashMap();
                longStringMap.put(structCycleOrgBean.getOrgId(), structCycleOrgBean.getStructLongNumber());
                parentStructMap.put(structproject, longStringMap);
            }
            DynamicObject[] orgStructDyArr = AdminOrgStructRepository.getInstance().queryHISEffStructInfoByOrgId("id,structlongnumber,structproject", orgBoId, cacheModel.getEffectDate());
            Map<Long, String> orgStructMap = Arrays.asList(orgStructDyArr).stream().collect(Collectors.toMap(orgStructDy -> orgStructDy.getDynamicObject("structproject").getLong("id"), orgStructDy -> orgStructDy.getString("structlongnumber")));
            for (DynamicObject structEntryDy : structCollection) {
                DynamicObject structDy = structEntryDy.getDynamicObject("struct_project");
                Long structId = structDy.getLong("id");
                DynamicObject structParentDy = structEntryDy.getDynamicObject("struct_parent_org");
                if (structParentDy == null) continue;
                Date effectDate = cacheModel.getEffectDate();
                Long parentBoId = structParentDy.getLong("boid");
                if (parentStructMap.containsKey(structId) && ((Map)parentStructMap.get(structId)).containsKey(parentBoId) && orgStructMap.containsKey(structId) && ((String)((Map)parentStructMap.get(structId)).get(parentBoId)).startsWith(orgStructMap.get(structId))) {
                    result.add(new CalibratorBean("OrgStructAffiliationCheckServiceImpl_0", ResManager.loadKDString((String)"\u5728\u201c%s\u201d\u4e2d\uff0c\u4e0d\u80fd\u9009\u62e9\u81ea\u5df1\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgStructAffiliationCheckServiceImpl_0", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{structDy.getString("name")}));
                }
                this.checkOwnCycleOrgs(targetObject, cacheModel, effectDate, result);
                this.checkBillCycleOrgs(targetObject, cacheModel, effectDate, result);
            }
        }
        return result;
    }

    private void checkOwnCycleOrgs(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel, Date effectDate, List<CalibratorBean> result) {
        DynamicObjectCollection structProjectEntryCollection;
        Long orgId = targetObject.getLong("adminorg.id");
        if (orgId == 0L) {
            orgId = targetObject.getLong("orgid");
        }
        if (CollectionUtils.isEmpty((Collection)(structProjectEntryCollection = targetObject.getDynamicObjectCollection("struct_project_entry")))) {
            return;
        }
        for (DynamicObject structEntryDy : structProjectEntryCollection) {
            if (structEntryDy.getDynamicObject("struct_parent_org") == null || structEntryDy.getDynamicObject("struct_parent_org").getLong("id") == 0L) continue;
            StructCycleOrgBean currentCycleOrg = this.assembleCurrentCycleOrg(orgId, structEntryDy, effectDate);
            DynamicObjectCollection currentOrgColl = cacheModel.getCurrentOrgColl();
            ArrayList ownOrgList = Lists.newArrayListWithCapacity((int)currentOrgColl.size());
            currentOrgColl.forEach(dy -> {
                DynamicObjectCollection structCollection = dy.getDynamicObjectCollection("struct_project_entry");
                if (!CollectionUtils.isEmpty((Collection)structCollection)) {
                    structCollection.forEach(ownEntry -> ownOrgList.add(new StructCycleOrgBean((Long)dy.getDynamicObject("adminorg").getLong("id"), (Long)(ownEntry.getDynamicObject("struct_parent_org") != null ? ownEntry.getDynamicObject("struct_parent_org").getLong("id") : 0L), (Long)ownEntry.getDynamicObject("struct_project").getLong("id"))));
                }
            });
            Map<Long, List<StructCycleOrgBean>> ownCyCleMap = ownOrgList.stream().collect(Collectors.groupingBy(StructCycleOrgBean::getOrgId, Collectors.toList()));
            Deque<StructCycleOrgBean> ownCycleOrgs = OrgBatchBillCheckHelper.containsStructCycle(currentCycleOrg, ownCyCleMap, false);
            if (CollectionUtils.isEmpty(ownCycleOrgs)) continue;
            result.add(new CalibratorBean("OrgStructAffiliationCheckServiceImpl_1", ResManager.loadKDString((String)"\u5728\u201c%s\u201d\u4e2d\uff0c\u4e0d\u80fd\u9009\u62e9\u672c\u5355\u4e2d\u81ea\u5df1\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgStructAffiliationCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{structEntryDy.getDynamicObject("struct_project").getString("name")}));
            LOGGER.info("OrgAffiliationCheckServiceImpl own bill org contain cycle:{}", JSONObject.toJSON(ownCycleOrgs));
        }
    }

    private void checkBillCycleOrgs(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel, Date effectDate, List<CalibratorBean> result) {
        List<OrgBatchCheckDto> billOrgList = cacheModel.getBillOrgList();
        DynamicObjectCollection structProjectEntryCollection = targetObject.getDynamicObjectCollection("struct_project_entry");
        if (CollectionUtils.isEmpty((Collection)structProjectEntryCollection)) {
            return;
        }
        Long orgId = targetObject.getLong("adminorg.id");
        if (orgId == 0L) {
            orgId = targetObject.getLong("orgid");
        }
        for (DynamicObject structProjectEntry : structProjectEntryCollection) {
            if (structProjectEntry.getDynamicObject("struct_parent_org") == null || structProjectEntry.getDynamicObject("struct_parent_org").getLong("id") == 0L) continue;
            StructCycleOrgBean currentCycleOrg = this.assembleCurrentCycleOrg(orgId, structProjectEntry, effectDate);
            for (OrgBatchCheckDto orgBatchCheckDto : billOrgList) {
                List<StructCycleOrgBean> billCycleOrgList;
                Map<Long, List<StructCycleOrgBean>> billCyCleMap;
                Deque<StructCycleOrgBean> billCycleOrgs;
                if (CollectionUtils.isEmpty(orgBatchCheckDto.getStructCycleOrgBeans()) || CollectionUtils.isEmpty(billCycleOrgs = OrgBatchBillCheckHelper.containsStructCycle(currentCycleOrg, billCyCleMap = (billCycleOrgList = orgBatchCheckDto.getStructCycleOrgBeans()).stream().collect(Collectors.groupingBy(StructCycleOrgBean::getOrgId, Collectors.toList())), false)) || HRStringUtils.isEmpty((String)billCycleOrgs.getFirst().getBillNo())) continue;
                result.add(new CalibratorBean("OrgStructAffiliationCheckServiceImpl_2", ResManager.loadKDString((String)"\u5728\u201c%1$s\u201d\u4e2d\uff0c\u4e0d\u80fd\u9009\u62e9\u5728\u9014\u5355\u636e\u201c%2$s\u201d\u4e2d\u81ea\u5df1\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgStructAffiliationCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{structProjectEntry.getDynamicObject("struct_project").getString("name"), billCycleOrgs.getFirst().getBillNo()}));
                LOGGER.info("OrgAffiliationCheckServiceImpl on bill org contain cycle:{}", JSONObject.toJSON(billCycleOrgs));
            }
        }
    }

    private StructCycleOrgBean assembleCurrentCycleOrg(Long orgId, DynamicObject structEntryDy, Date effectDate) {
        StructCycleOrgBean cycleOrg = new StructCycleOrgBean();
        cycleOrg.setOrgId(orgId);
        cycleOrg.setParentId(structEntryDy.getDynamicObject("struct_parent_org") != null ? structEntryDy.getDynamicObject("struct_parent_org").getLong("id") : 0L);
        cycleOrg.setStructproject(structEntryDy.getDynamicObject("struct_project").getLong("id"));
        cycleOrg.setBsed(effectDate);
        Date bsled = new Date();
        try {
            bsled = HRDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            LOGGER.error("parseDate error:", (Throwable)e);
        }
        cycleOrg.setBsled(bsled);
        return cycleOrg;
    }
}

