/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgbatch;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.business.service.validcommon.StructCycleOrgBean;
import kd.hr.homs.common.model.CalibratorBean;

public class OrgStructBatchAffiliationCheckServiceImpl
implements IOrgBatchBillCheckService {
    private static final Log LOGGER = LogFactory.getLog(OrgStructBatchAffiliationCheckServiceImpl.class);
    private OrgBatchCheckCacheModel cacheModel;
    private Map<String, String> multiEntryNameMap;
    private Map<Long, List<StructCycleOrgBean>> adminCyCleMap;
    private Map<Long, List<StructCycleOrgBean>> billCyCleMap;

    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        long startTime = System.currentTimeMillis();
        this.cacheModel = cacheModel;
        this.initParam();
        long initTime = System.currentTimeMillis();
        LOGGER.info(String.format("OrgBatchAffiliationCheckServiceImpl init time:%s", initTime - startTime));
        ArrayList<CalibratorBean> result = new ArrayList<CalibratorBean>();
        List<String> entryKeys = EntryEntityEnum.getEntryKeys();
        for (String entryKey : entryKeys) {
            if (HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.disableEntry.getEntryKey()) || HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.mergeEntry.getEntryKey()) || HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.splitEntry.getEntryKey())) continue;
            DynamicObjectCollection orgColl = targetObject.getDynamicObjectCollection(entryKey);
            String entryName = this.multiEntryNameMap.get(entryKey);
            for (DynamicObject dynamicObject : orgColl) {
                this.checkOrgAffiliation(entryName, dynamicObject, result);
                if (CollectionUtils.isEmpty(result)) continue;
                return result;
            }
        }
        LOGGER.info(String.format("OrgBatchAffiliationCheckServiceImpl check time:%s", System.currentTimeMillis() - initTime));
        return result;
    }

    private void checkOrgAffiliation(String entryName, DynamicObject dynamicObject, List<CalibratorBean> result) {
        DynamicObjectCollection structEntryCollection;
        String orgName = dynamicObject.getString("name");
        Long orgId = dynamicObject.getLong("adminorg.id");
        Long boid = dynamicObject.getLong("adminorg.boid");
        long changeTypeId = dynamicObject.getLong("changescene.orgchangetype.id");
        if (changeTypeId == 1010L && this.cacheModel.getOperateType() == 2) {
            boid = orgId = Long.valueOf(dynamicObject.getLong("adminorg"));
        }
        if (!CollectionUtils.isEmpty((Collection)(structEntryCollection = dynamicObject.getDynamicObjectCollection("struct_project_entry")))) {
            for (DynamicObject structEntryDy : structEntryCollection) {
                Deque<StructCycleOrgBean> billCycleOrgs;
                StructCycleOrgBean cycleOrg = this.assembleCurrentCycleOrg(boid, structEntryDy, this.cacheModel.getEffectDate());
                Deque<StructCycleOrgBean> adminCycleOrgs = OrgBatchBillCheckHelper.containsStructCycle(cycleOrg, this.adminCyCleMap, true);
                if (!CollectionUtils.isEmpty(adminCycleOrgs)) {
                    LOGGER.info("OrgBatchAffiliationCheckServiceImpl org contain cycle:{}", JSONObject.toJSON(adminCycleOrgs));
                    for (StructCycleOrgBean bean : adminCycleOrgs) {
                        if (HRStringUtils.equals((String)"admin", (String)bean.getDataSource())) {
                            result.add(new CalibratorBean("OrgStructBatchAffiliationCheckServiceImpl_0", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u5728\u201c%3$s\u201d\u4e2d\uff0c\u4e0d\u80fd\u9009\u62e9\u81ea\u5df1\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgStructBatchAffiliationCheckServiceImpl_0", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName, structEntryDy.getDynamicObject("struct_project").getString("name")}));
                            return;
                        }
                        if (!HRStringUtils.equals((String)"own", (String)bean.getDataSource())) continue;
                        result.add(new CalibratorBean("OrgStructBatchAffiliationCheckServiceImpl_2", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b \u201c%2$s\u201d\uff1a\u5728%3$s\u4e2d\uff0c\u4e0d\u80fd\u9009\u62e9\u672c\u5355\u4e2d\u81ea\u5df1\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgStructBatchAffiliationCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName, structEntryDy.getDynamicObject("struct_project").getString("name")}));
                        return;
                    }
                }
                if (CollectionUtils.isEmpty(billCycleOrgs = OrgBatchBillCheckHelper.containsStructCycle(cycleOrg, this.billCyCleMap, false)) || HRStringUtils.isEmpty((String)billCycleOrgs.getFirst().getBillNo())) continue;
                result.add(new CalibratorBean("OrgStructBatchAffiliationCheckServiceImpl_1", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u5728\u201c%3$s\u201d\u4e2d\uff0c\u4e0d\u80fd\u9009\u62e9\u5728\u9014\u5355\u636e\u201c%4$s\u201d\u4e2d\u81ea\u5df1\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgStructBatchAffiliationCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName, structEntryDy.getDynamicObject("struct_project").getString("name"), billCycleOrgs.getFirst().getBillNo()}));
                LOGGER.info("OrgBatchAffiliationCheckServiceImpl own bill org contain cycle:{}", JSONObject.toJSON(billCycleOrgs));
            }
        }
    }

    private void initParam() {
        this.multiEntryNameMap = OrgBatchBillCheckHelper.assembleMultiEntryName();
        DynamicObjectCollection currentOrgColl = this.cacheModel.getCurrentOrgColl();
        HashSet<Long> orgIds = new HashSet<Long>(currentOrgColl.size());
        currentOrgColl.forEach(dynamicObject -> orgIds.add(dynamicObject.getLong("adminorg.boid")));
        List<StructCycleOrgBean> adminOrgList = OrgBatchBillCheckHelper.queryStructAdminOrgColl(orgIds, this.cacheModel.getEffectDate());
        for (DynamicObject currentOrgDy : currentOrgColl) {
            DynamicObjectCollection dynamicObjectCollection = currentOrgDy.getDynamicObjectCollection("struct_project_entry");
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) continue;
            for (DynamicObject entryDy : dynamicObjectCollection) {
                if (entryDy.getDynamicObject("struct_project") == null) continue;
                adminOrgList.add(this.assembleCurrentCycleOrg(currentOrgDy.getLong("adminorg.boid"), entryDy, this.cacheModel.getEffectDate()));
            }
        }
        this.adminCyCleMap = adminOrgList.stream().collect(Collectors.groupingBy(StructCycleOrgBean::getOrgId, Collectors.toList()));
        List<OrgBatchCheckDto> billOrgList = this.cacheModel.getBillOrgList();
        if (!CollectionUtils.isEmpty(billOrgList)) {
            ArrayList billCycleOrgList = Lists.newArrayListWithCapacity((int)billOrgList.size());
            for (OrgBatchCheckDto orgBatchCheckDto : billOrgList) {
                List<StructCycleOrgBean> structCycleOrgBeans = orgBatchCheckDto.getStructCycleOrgBeans();
                if (CollectionUtils.isEmpty(structCycleOrgBeans)) continue;
                structCycleOrgBeans.forEach(dto -> billCycleOrgList.add(new StructCycleOrgBean(dto.getOrgId(), dto.getParentId(), "bill", dto.getBillNo(), dto.getStructproject())));
            }
            this.billCyCleMap = billCycleOrgList.stream().collect(Collectors.groupingBy(StructCycleOrgBean::getOrgId, Collectors.toList()));
        }
    }

    private StructCycleOrgBean assembleCurrentCycleOrg(Long orgId, DynamicObject structEntryDy, Date effectDate) {
        StructCycleOrgBean cycleOrg = new StructCycleOrgBean();
        cycleOrg.setOrgId(orgId);
        cycleOrg.setParentId(structEntryDy.getDynamicObject("struct_parent_org") != null ? structEntryDy.getDynamicObject("struct_parent_org").getLong("id") : 0L);
        cycleOrg.setStructproject(structEntryDy.getDynamicObject("struct_project").getLong("id"));
        cycleOrg.setBsed(effectDate);
        Date bsled = new Date();
        try {
            bsled = HRDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            LOGGER.error("parseDate error:", (Throwable)e);
        }
        cycleOrg.setBsled(bsled);
        cycleOrg.setDataSource("own");
        return cycleOrg;
    }
}

