/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgbatch;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.orgbatch.OrgBatchUniqueNumberCheckServiceImpl;
import kd.hr.homs.business.service.validcommon.BillEntryHelperEnum;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckConstants;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.CalibratorBean;

public class OrgUniqueNumberCheckServiceImpl
implements IOrgBatchBillCheckService {
    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        ArrayList<CalibratorBean> result = new ArrayList<CalibratorBean>();
        long entryId = targetObject.getLong("id");
        String number = targetObject.getString("number");
        long changeType = targetObject.getLong("changetype.id");
        DynamicObject adminorgHrDy = AdminOrgBatchChgHelper.getAdminorgHrDy(targetObject);
        boolean codeRuleExistFlag = CodeRuleServiceHelper.isExist((String)"haos_adminorghr", (DynamicObject)adminorgHrDy, (String)String.valueOf(targetObject.getString("org.id")));
        if (StringUtils.isEmpty((CharSequence)number) && (changeType != OrgBatchChgBillConstants.CHANGE_TYPE_ADD || !codeRuleExistFlag)) {
            result.add(new CalibratorBean("OrgUniqueNumberCheckServiceImpl_4", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"OrgUniqueNumberCheckServiceImpl_4", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
        }
        if (!StringUtils.isEmpty((CharSequence)number)) {
            HRBaseServiceHelper bosOrgHelper;
            Long boid = targetObject.getLong("adminorg.boid");
            OrgBatchUniqueNumberCheckServiceImpl.AdminNumberCheckParam isExists = this.isExistsAdminNumber(targetObject, cacheModel, number, boid);
            Set currentNumberSet = cacheModel.getCurrentOrgColl().stream().filter(dy -> dy.getLong("id") != entryId).filter(dy -> dy.getLong("adminorg.id") != targetObject.getLong("adminorg.id")).map(dy -> dy.getString("number")).collect(Collectors.toSet());
            if (isExists.isExists()) {
                String timeSpan = OrgBatchBillCheckHelper.getTimeSpan(isExists.getStartTime(), isExists.getEndTime());
                String message = changeType == OrgBatchChgBillConstants.CHANGE_TYPE_ADD ? String.format(ResManager.loadKDString((String)"\u5728\u201c%s\u201d\u671f\u95f4\uff0c\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgUniqueNumberCheckServiceImpl_5", (String)"odc-homs-business", (Object[])new Object[0]), timeSpan) : String.format(ResManager.loadKDString((String)"\u5728\u201c%s\u201d\u671f\u95f4\uff0c\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgUniqueNumberCheckServiceImpl_7", (String)"odc-homs-business", (Object[])new Object[0]), timeSpan);
                result.add(new CalibratorBean(message));
            }
            if (currentNumberSet.contains(number)) {
                result.add(new CalibratorBean("OrgUniqueNumberCheckServiceImpl_1", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgUniqueNumberCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
            }
            Long orgId = targetObject.getLong("adminorg.id");
            Map<String, String> billNumberSet = cacheModel.getBillOrgList().stream().filter(dto -> dto.getEntryId() != entryId).filter(dto -> !dto.getOrgId().equals(orgId)).collect(Collectors.toMap(OrgBatchCheckDto::getNumber, OrgBatchCheckDto::getBillNo, (v1, v2) -> v1));
            Map<String, Long> billChangeType = cacheModel.getBillOrgList().stream().filter(dto -> dto.getEntryId() != entryId).filter(dto -> !dto.getOrgId().equals(orgId)).collect(Collectors.toMap(OrgBatchCheckDto::getNumber, OrgBatchCheckDto::getChangeTypeId, (v1, v2) -> v1));
            Map<String, OrgBatchCheckDto> billNumMap = cacheModel.getBillOrgList().stream().filter(dto -> dto.getEntryId() != entryId).filter(dto -> !dto.getOrgId().equals(orgId)).collect(Collectors.toMap(OrgBatchCheckDto::getNumber, dto -> dto, (v1, v2) -> v1));
            if (!StringUtils.isEmpty((CharSequence)number) && billNumberSet.containsKey(number) && !HRStringUtils.isEmpty((String)billNumberSet.get(number))) {
                Long type = billChangeType.get(number);
                if (billNumMap.get(number) != null && !Objects.equals(changeType, OrgBatchChgBillConstants.CHANGE_TYPE_ADD) && Objects.equals(billNumMap.get(number).getOrgBoId(), boid)) {
                    result.add(new CalibratorBean("OrgUniqueNumberCheckServiceImpl_6", ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u5b58\u5728\u5728\u9014\u5355\u636e\u201c%2$s\u201d\u7684\u201c%3$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5bf9\u7ec4\u7ec7\u8fdb\u884c\u591a\u79cd\u53d8\u52a8\u64cd\u4f5c\u3002", (String)"OrgUniqueNumberCheckServiceImpl_6", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{targetObject.getString("name"), billNumberSet.get(number), BillEntryHelperEnum.getEntryDescriptionByChangeType(type)}));
                } else if (billNumMap.get(number) != null && !Objects.equals(billNumMap.get(number).getOrgBoId(), boid)) {
                    result.add(new CalibratorBean("OrgUniqueNumberCheckServiceImpl_2", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u201c%1$s\u201d\u5df2\u5b58\u5728\u5728\u9014\u5355\u636e\uff08\u5355\u636e\u7f16\u53f7\uff1a%2$s\uff09\u4e2d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgUniqueNumberCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{number, billNumberSet.get(number)}));
                }
            }
            QFilter bosOrgFilter = new QFilter("isfreeze", "=", (Object)"0");
            bosOrgFilter.and("org.number", "=", (Object)number);
            if (boid != 0L) {
                bosOrgFilter.and("org.id", "<>", (Object)boid);
            }
            if ((bosOrgHelper = new HRBaseServiceHelper("bos_org_structure")).isExists(bosOrgFilter)) {
                result.add(new CalibratorBean("OrgUniqueNumberCheckServiceImpl_3", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u4e0e\u201c\u57fa\u7840\u670d\u52a1\u4e91>\u4f01\u4e1a\u5efa\u6a21>\u7ec4\u7ec7\u7ba1\u7406>\u884c\u653f\u7ec4\u7ec7/\u4e1a\u52a1\u5355\u5143\u201d\u4e2d\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgUniqueNumberCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
            }
        }
        if (number.contains("!") || number.contains("\uff01")) {
            result.add(new CalibratorBean("OrgUniqueNumberCheckServiceImpl_8", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u4e2d\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\u201c!\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgUniqueNumberCheckServiceImpl_8", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
        }
        return result;
    }

    private OrgBatchUniqueNumberCheckServiceImpl.AdminNumberCheckParam isExistsAdminNumber(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel, String number, Long boid) {
        Date checkDate = cacheModel.getEffectDate();
        if (HRStringUtils.equals((String)EntryEntityEnum.addEntry.getChangeType(), (String)cacheModel.getChangeType())) {
            checkDate = targetObject.getDate("establishmentdate");
        }
        QFilter adminFilter = new QFilter("number", "=", (Object)number);
        adminFilter.and(new QFilter("boid", "<>", (Object)boid));
        adminFilter.and(new QFilter("enable", "=", (Object)"1"));
        adminFilter.and(new QFilter("datastatus", "in", OrgBatchCheckConstants.DATASTATUS_EFFECT_SET));
        adminFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        HRBaseServiceHelper adminHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObjectCollection orgColl = adminHelper.queryOriginalCollection("number,bsed,bsled", new QFilter[]{adminFilter});
        for (DynamicObject dy : orgColl) {
            boolean isExists = OrgBatchBillCheckHelper.isExistsHisInterval(checkDate, dy);
            if (!isExists) continue;
            return new OrgBatchUniqueNumberCheckServiceImpl.AdminNumberCheckParam(checkDate, dy.getDate("bsled"), true);
        }
        return new OrgBatchUniqueNumberCheckServiceImpl.AdminNumberCheckParam(null, null, false);
    }
}

