/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgbatch;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.adminorg.bean.Pair;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.helper.SystemParamHelper;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.CalibratorBean;

public class ParentOrgBatchCheckServiceImpl
implements IOrgBatchBillCheckService {
    private OrgBatchCheckCacheModel cacheModel;
    private Set<Long> dbParentBoIdSet = Sets.newHashSetWithExpectedSize((int)10);

    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        Map<String, String> multiEntryNameMap = OrgBatchBillCheckHelper.assembleMultiEntryName();
        this.cacheModel = cacheModel;
        Map<Long, String> disableOrgIdMap = cacheModel.getOwnDisableOrgIdSet();
        Map<Long, String> ownTobeDisableOrgIMap = cacheModel.getOwnTobeDisableOrgIMap();
        Map<Long, String> billDisableOrgIdSet = cacheModel.getBillOrgList().stream().filter(dto -> OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE.equals(dto.getChangeTypeId())).collect(Collectors.toMap(dto -> dto.getOrgId(), dto -> dto.getBillNo(), (k1, k2) -> k1));
        Map<Long, Pair> billTobeDisableOrgIdSet = cacheModel.getBillOrgList().stream().filter(dto -> dto.isTobeDisableFlag()).collect(Collectors.toMap(dto -> dto.getOrgId(), dto -> new Pair((Object)dto.getBillNo(), (Object)dto.getName()), (k1, k2) -> k1));
        HashSet ownOrgBoIdSet = Sets.newHashSetWithExpectedSize((int)10);
        HashSet ownParentBoIdSet = Sets.newHashSetWithExpectedSize((int)10);
        cacheModel.getOwnEnableOrgList().forEach(dto -> {
            ownOrgBoIdSet.add(dto.getOrgBoId());
            ownParentBoIdSet.add(dto.getParentOrgBoId());
        });
        if (!CollectionUtils.isEmpty((Collection)ownParentBoIdSet)) {
            this.dbParentBoIdSet = OrgBatchBillCheckHelper.queryDisableOrgBoIdSet(ownParentBoIdSet, cacheModel.getEffectDate());
        }
        ArrayList<CalibratorBean> result = new ArrayList<CalibratorBean>();
        List<String> entryKeys = EntryEntityEnum.getEntryKeys();
        for (String entryKey : entryKeys) {
            if (HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.infoEntry.getEntryKey()) || HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.disableEntry.getEntryKey()) || HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.mergeEntry.getEntryKey()) || HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.splitEntry.getEntryKey())) continue;
            DynamicObjectCollection orgColl = targetObject.getDynamicObjectCollection(entryKey);
            String entryName = multiEntryNameMap.get(entryKey);
            for (DynamicObject dynamicObject : orgColl) {
                Long buOrgId = dynamicObject.getDynamicObject("org") != null ? dynamicObject.getLong("org.id") : 100000L;
                this.checkParentOrgOfParentChg(entryKey, dynamicObject, result);
                DynamicObject parentOrg = dynamicObject.getDynamicObject("parentorg");
                Long parentBoId = parentOrg.getLong("boid");
                Long parentOrgId = parentOrg.getLong("id");
                String orgName = dynamicObject.getString("name");
                CalibratorBean bean = new CalibratorBean("ParentOrgBatchCheckServiceImpl_1", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5df2\u505c\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ParentOrgBatchCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName});
                if (!HRStringUtils.equals((String)"1", (String)parentOrg.getString("enable"))) {
                    result.add(bean);
                }
                if (this.dbParentBoIdSet.contains(parentBoId)) {
                    result.add(bean);
                }
                if (!SystemParamHelper.getAllowTobeDisableChg(buOrgId) && parentOrg.getBoolean("tobedisableflag")) {
                    if (HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.parentEntry.getEntryKey())) {
                        result.add(new CalibratorBean("ParentOrgBatchCheckServiceImpl_10", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d \uff1a\u201c%3$s\u201d\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u8c03\u6574\u5230\u8be5\u7ec4\u7ec7\u4e0b\u3002", (String)"ParentOrgBatchCheckServiceImpl_10", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName, parentOrg.getString("name")}));
                    } else {
                        result.add(new CalibratorBean("ParentOrgBatchCheckServiceImpl_11", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%3$s\u201d\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5728\u8be5\u7ec4\u7ec7\u4e0b\u65b0\u589e\u7ec4\u7ec7\u3002", (String)"ParentOrgBatchCheckServiceImpl_11", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName, parentOrg.getString("name")}));
                    }
                }
                if (!CollectionUtils.isEmpty(disableOrgIdMap.keySet()) && disableOrgIdMap.containsKey(parentOrgId)) {
                    result.add(new CalibratorBean("ParentOrgBatchCheckServiceImpl_2", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%3$s\u201d\u5728\u672c\u5355\u4e2d\u5df2\u505c\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ParentOrgBatchCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName, disableOrgIdMap.get(parentOrgId)}));
                }
                if (!CollectionUtils.isEmpty(ownTobeDisableOrgIMap.keySet()) && ownTobeDisableOrgIMap.containsKey(parentOrgId) && !SystemParamHelper.getAllowTobeDisableChg(buOrgId)) {
                    if (HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.parentEntry.getEntryKey())) {
                        result.add(new CalibratorBean("ParentOrgBatchCheckServiceImpl_8", ResManager.loadKDString((String)"\u201c%1$s\u201d\u201c%2$s\u201d\uff1a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%3$s\u201d\u5728\u672c\u5355\u4e2d\u5df2\u8bbe\u7f6e\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u8c03\u6574\u5230\u8be5\u7ec4\u7ec7\u4e0b\u3002", (String)"ParentOrgBatchCheckServiceImpl_8", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName, ownTobeDisableOrgIMap.get(parentOrgId)}));
                    } else {
                        result.add(new CalibratorBean("ParentOrgBatchCheckServiceImpl_9", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%3$s\u201d\u5728\u672c\u5355\u4e2d\u5df2\u8bbe\u7f6e\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5728\u8be5\u7ec4\u7ec7\u4e0b\u65b0\u589e\u7ec4\u7ec7\u3002", (String)"ParentOrgBatchCheckServiceImpl_9", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName, ownTobeDisableOrgIMap.get(parentOrgId)}));
                    }
                }
                if (billTobeDisableOrgIdSet.containsKey(parentOrgId) && !SystemParamHelper.getAllowTobeDisableChg(buOrgId)) {
                    if (HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.parentEntry.getEntryKey())) {
                        result.add(new CalibratorBean("ParentOrgBatchCheckServiceImpl_5", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%3$s\u201d\u5728\u5728\u9014\u5355\u636e\u201c%4$s\u201d\u4e2d\u5df2\u8bbe\u7f6e\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u8c03\u6574\u5230\u8be5\u7ec4\u7ec7\u4e0b\u3002", (String)"ParentOrgBatchCheckServiceImpl_5", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName, billTobeDisableOrgIdSet.get(parentOrgId).getValue(), billTobeDisableOrgIdSet.get(parentOrgId).getKey()}));
                    } else {
                        result.add(new CalibratorBean("ParentOrgBatchCheckServiceImpl_7", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%3$s\u201d\u5728\u5728\u9014\u5355\u636e\u201c%4$s\u201d\u4e2d\u5df2\u8bbe\u7f6e\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5728\u8be5\u7ec4\u7ec7\u4e0b\u65b0\u589e\u7ec4\u7ec7\u3002", (String)"ParentOrgBatchCheckServiceImpl_7", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName, billTobeDisableOrgIdSet.get(parentOrgId).getValue(), billTobeDisableOrgIdSet.get(parentOrgId).getKey()}));
                    }
                }
                if (CollectionUtils.isEmpty(billDisableOrgIdSet) || !billDisableOrgIdSet.containsKey(parentOrgId)) continue;
                if (HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.parentEntry.getEntryKey())) {
                    result.add(new CalibratorBean("ParentOrgBatchCheckServiceImpl_3", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5728\u5728\u9014\u5355\u636e\u201c%3$s\u201d\u4e2d\u505a\u4e86\u505c\u7528\u64cd\u4f5c\uff0c\u4e0d\u80fd\u8c03\u6574\u5230\u8be5\u7ec4\u7ec7\u4e0b\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ParentOrgBatchCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName, billDisableOrgIdSet.get(parentOrgId)}));
                    continue;
                }
                result.add(new CalibratorBean("ParentOrgBatchCheckServiceImpl_6", ResManager.loadKDString((String)"\u201c%1$s\u201d\u9875\u7b7e\u4e0b\u201c%2$s\u201d\uff1a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5728\u5728\u9014\u5355\u636e\u201c%3$s\u201d\u4e2d\u505a\u4e86\u505c\u7528\u64cd\u4f5c\uff0c\u4e0d\u80fd\u5728\u8be5\u7ec4\u7ec7\u4e0b\u65b0\u589e\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ParentOrgBatchCheckServiceImpl_6", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{entryName, orgName, billDisableOrgIdSet.get(parentOrgId)}));
            }
        }
        return result;
    }

    private void checkParentOrgOfParentChg(String entryKey, DynamicObject dynamicObject, List<CalibratorBean> result) {
        if (HRStringUtils.equals((String)entryKey, (String)EntryEntityEnum.parentEntry.getEntryKey()) && this.cacheModel.getOperateType() != 3) {
            Long parentBoId;
            String orgName = dynamicObject.getString("name");
            DynamicObject adminorg = dynamicObject.getDynamicObject("adminorg");
            long oriParentorgId = adminorg.getLong("parentorg.id");
            if (oriParentorgId == (parentBoId = Long.valueOf(dynamicObject.getLong("parentorg.boid")))) {
                result.add(new CalibratorBean("ParentOrgBatchCheckServiceImpl_4", ResManager.loadKDString((String)"\u201c\u8c03\u6574\u4e0a\u7ea7\u201d\u9875\u7b7e\u4e0b\u201c%s\u201d\uff1a\u8c03\u6574\u540e\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u672a\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ParentOrgBatchCheckServiceImpl_4", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName}));
            }
        }
    }
}

