/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgbatch;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.haos.business.service.adminorg.bean.Pair;
import kd.hr.haos.common.util.PlatformRootUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.helper.SystemParamHelper;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.CalibratorBean;

public class ParentOrgCheckServiceImpl
implements IOrgBatchBillCheckService {
    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        ArrayList<CalibratorBean> result = new ArrayList<CalibratorBean>();
        String changeType = cacheModel.getChangeType();
        Long currentOrgId = targetObject.getLong("adminorg.boid");
        Long buOrgId = targetObject.getLong("org.id");
        if (HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.addEntry.getChangeType()) || HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.parentEntry.getChangeType())) {
            Set billOrgIdSet;
            Set currentOrgIdSet;
            if (PlatformRootUtils.getLongRootIdOfPlatform() == currentOrgId) {
                return result;
            }
            this.checkParentOrgOfParentChg(changeType, targetObject, result);
            DynamicObject parentOrg = targetObject.getDynamicObject("parentorg");
            Long parentOrgId = parentOrg.getLong("id");
            Long parentBoId = parentOrg.getLong("boid");
            Set<Long> boIdSet = OrgBatchBillCheckHelper.queryDisableOrgBoIdSet(Sets.newHashSet((Object[])new Long[]{parentBoId}), cacheModel.getEffectDate());
            CalibratorBean bean = new CalibratorBean("ParentOrgCheckServiceImpl_1", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5df2\u505c\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ParentOrgCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]);
            if (!"1".equals(parentOrg.get("enable"))) {
                result.add(bean);
            }
            if (boIdSet.contains(parentBoId)) {
                result.add(bean);
            }
            if ((currentOrgIdSet = cacheModel.getCurrentOrgColl().stream().filter(dy -> OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE.equals(dy.getDynamicObject("changetype").getLong("id"))).map(dy -> HRDyObjectPropUtil.getId((DynamicObject)dy.getDynamicObject("adminorg"))).collect(Collectors.toSet())).contains(parentOrgId)) {
                result.add(new CalibratorBean("ParentOrgCheckServiceImpl_2", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5728\u672c\u5355\u5df2\u505c\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ParentOrgCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
            }
            if ((billOrgIdSet = cacheModel.getBillOrgList().stream().filter(dto -> OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE.equals(dto.getChangeTypeId())).map(OrgBatchCheckDto::getOrgId).collect(Collectors.toSet())).contains(parentOrgId)) {
                result.add(new CalibratorBean("ParentOrgCheckServiceImpl_3", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5b58\u5728\u5728\u9014\u5355\u505c\u7528\u4e1a\u52a1\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ParentOrgCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
            }
            Map<Long, Pair> billTobeDisableOrgIdSet = cacheModel.getBillOrgList().stream().filter(dto -> dto.isTobeDisableFlag()).collect(Collectors.toMap(dto -> dto.getOrgId(), dto -> new Pair((Object)dto.getBillNo(), (Object)dto.getName()), (k1, k2) -> k1));
            if (!SystemParamHelper.getAllowTobeDisableChg(buOrgId) && parentOrg.getBoolean("tobedisableflag")) {
                if (HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.parentEntry.getChangeType())) {
                    result.add(new CalibratorBean("ParentOrgCheckServiceImpl_9", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u8c03\u6574\u5230\u8be5\u7ec4\u7ec7\u4e0b\u3002", (String)"ParentOrgCheckServiceImpl_9", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{parentOrg.getString("name")}));
                } else {
                    result.add(new CalibratorBean("ParentOrgCheckServiceImpl_10", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5728\u8be5\u7ec4\u7ec7\u4e0b\u65b0\u589e\u7ec4\u7ec7\u3002", (String)"ParentOrgCheckServiceImpl_10", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{parentOrg.getString("name")}));
                }
            }
            if (billTobeDisableOrgIdSet.containsKey(parentOrgId) && !SystemParamHelper.getAllowTobeDisableChg(buOrgId)) {
                if (HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.addEntry.getChangeType())) {
                    result.add(new CalibratorBean("ParentOrgCheckServiceImpl_7", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5728\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%s\uff09\u4e2d\u505a\u4e86\u201c\u5f85\u505c\u7528\u201d\u64cd\u4f5c\uff0c\u4e0d\u80fd\u5728\u8be5\u7ec4\u7ec7\u4e0b\u65b0\u589e\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ParentOrgCheckServiceImpl_7", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{billTobeDisableOrgIdSet.get(parentOrgId).getKey()}));
                } else {
                    result.add(new CalibratorBean("ParentOrgCheckServiceImpl_8", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5728\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%s\uff09\u4e2d\u505a\u4e86\u201c\u5f85\u505c\u7528\u201d\u64cd\u4f5c\uff0c\u4e0d\u80fd\u8c03\u6574\u5230\u8be5\u7ec4\u7ec7\u4e0b\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ParentOrgCheckServiceImpl_8", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{billTobeDisableOrgIdSet.get(parentOrgId).getKey()}));
                }
            }
        }
        return result;
    }

    private void checkParentOrgOfParentChg(String changeType, DynamicObject targetObject, List<CalibratorBean> result) {
        long parentBoId;
        DynamicObject adminorg;
        long oriParentorgId;
        if (HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.parentEntry.getChangeType()) && (oriParentorgId = (adminorg = targetObject.getDynamicObject("adminorg")).getLong("parentorg.id")) == (parentBoId = targetObject.getLong("parentorg.boid"))) {
            result.add(new CalibratorBean("ParentOrgCheckServiceImpl_4", ResManager.loadKDString((String)"\u8c03\u6574\u540e\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u672a\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ParentOrgCheckServiceImpl_4", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
        }
    }
}

