/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgbatch.strategy;

import java.util.HashMap;
import java.util.Map;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.homs.business.service.orgbatch.strategy.AdminOrgBatchAuditViewStrategy;
import kd.hr.homs.business.service.orgbatch.strategy.AdminOrgBatchAuditingViewStrategy;
import kd.hr.homs.business.service.orgbatch.strategy.AdminOrgBatchDiscardViewStrategy;
import kd.hr.homs.business.service.orgbatch.strategy.AdminOrgBatchRejectToSubmitViewStrategy;
import kd.hr.homs.business.service.orgbatch.strategy.AdminOrgBatchSaveViewStrategy;
import kd.hr.homs.business.service.orgbatch.strategy.AdminOrgBatchSubmitViewStrategy;
import kd.hr.homs.business.service.orgbatch.strategy.IAdminOrgBatchViewStrategy;

public class AdminOrgBatchViewStrategyContext {
    private static final Log LOGGER = LogFactory.getLog(AdminOrgBatchViewStrategyContext.class);
    private static Map<String, IAdminOrgBatchViewStrategy> strategyMap = new HashMap<String, IAdminOrgBatchViewStrategy>(16);

    public static void handleViewElementByAuditStatus(String auditStatus, IFormView formView) {
        Map<String, IAdminOrgBatchViewStrategy> strategyMapInstance = StrategyInstanceHolder.getStrategyMapInstance();
        IAdminOrgBatchViewStrategy batchViewStrategy = strategyMapInstance.get(auditStatus);
        if (batchViewStrategy != null) {
            LOGGER.info("handleViewElementByAuditStatus batchViewStrategy type:{}", (Object)batchViewStrategy.getClass().getName());
            batchViewStrategy.handleViewElement(formView);
            LOGGER.info("handleViewElementByAuditStatus handleViewElement end!");
            return;
        }
        LOGGER.warn("%s strategy handle view element class is null !", (Object)auditStatus);
    }

    public static boolean isEdit(String auditStatus, IFormView formView) {
        Map<String, IAdminOrgBatchViewStrategy> strategyMapInstance = StrategyInstanceHolder.getStrategyMapInstance();
        IAdminOrgBatchViewStrategy batchViewStrategy = strategyMapInstance.get(auditStatus);
        if (batchViewStrategy != null) {
            return batchViewStrategy.isEdit(formView);
        }
        return false;
    }

    public static IAdminOrgBatchViewStrategy getAdminOrgBatchViewStrategy(String auditStatus) {
        return StrategyInstanceHolder.getStrategyMapInstance().get(auditStatus);
    }

    private static class StrategyInstanceHolder {
        private StrategyInstanceHolder() {
        }

        static Map<String, IAdminOrgBatchViewStrategy> getStrategyMapInstance() {
            if (strategyMap.isEmpty()) {
                strategyMap.put("A", new AdminOrgBatchSaveViewStrategy());
                strategyMap.put("G", new AdminOrgBatchRejectToSubmitViewStrategy());
                strategyMap.put("B", new AdminOrgBatchSubmitViewStrategy());
                strategyMap.put("C", new AdminOrgBatchAuditViewStrategy());
                strategyMap.put("D", new AdminOrgBatchAuditingViewStrategy());
                strategyMap.put("E", new AdminOrgBatchAuditViewStrategy());
                strategyMap.put("F", new AdminOrgBatchDiscardViewStrategy());
            }
            return strategyMap;
        }
    }
}

