/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgchart;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.domain.repository.OrgCardConfigRepository;
import kd.hr.homs.business.domain.repository.OrgCardStyleNewRepository;
import kd.hr.homs.common.enums.orgchart.CompareEnum;
import kd.hr.homs.common.enums.orgchart.FieldDataTypeEnum;
import kd.hr.homs.common.model.colorschema.ColorSchemaConditionVo;

public class ColorSchemaRuleServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(ColorSchemaRuleServiceHelper.class);

    public static Map<String, Map<String, String>> getCompareMap() {
        HashMap<String, Map<String, String>> compareMap = new HashMap<String, Map<String, String>>(16);
        LinkedHashMap<String, String> numberCompareMap = new LinkedHashMap<String, String>(8);
        compareMap.put(FieldDataTypeEnum.NUMBER.getCode(), numberCompareMap);
        numberCompareMap.put(CompareEnum.BETWEEN.getValue(), CompareEnum.BETWEEN.getName().loadKDString());
        numberCompareMap.put(CompareEnum.EQUALS.getValue(), CompareEnum.EQUALS.getName().loadKDString());
        numberCompareMap.put(CompareEnum.NOT_EQUALS.getValue(), CompareEnum.NOT_EQUALS.getName().loadKDString());
        numberCompareMap.put(CompareEnum.LESS_THAN.getValue(), CompareEnum.LESS_THAN.getName().loadKDString());
        numberCompareMap.put(CompareEnum.LESS_EQUALS.getValue(), CompareEnum.LESS_EQUALS.getName().loadKDString());
        numberCompareMap.put(CompareEnum.LARGE_THAN.getValue(), CompareEnum.LARGE_THAN.getName().loadKDString());
        numberCompareMap.put(CompareEnum.LARGE_EQUALS.getValue(), CompareEnum.LARGE_EQUALS.getName().loadKDString());
        LinkedHashMap<String, String> dateCompareMap = new LinkedHashMap<String, String>(2);
        compareMap.put(FieldDataTypeEnum.DATE.getCode(), dateCompareMap);
        dateCompareMap.put(CompareEnum.BETWEEN.getValue(), ResManager.loadKDString((String)"\u4ece...\u5230", (String)"ColorSchemaRuleServiceHelper_3", (String)"odc-homs-business", (Object[])new Object[0]));
        LinkedHashMap<String, String> dynamicObjectCompareMap = new LinkedHashMap<String, String>(2);
        compareMap.put(FieldDataTypeEnum.DYNAMIC_OBJECT.getCode(), dynamicObjectCompareMap);
        dynamicObjectCompareMap.put(CompareEnum.IN.getValue(), CompareEnum.IN.getName().loadKDString());
        dynamicObjectCompareMap.put(CompareEnum.NOT_IN.getValue(), CompareEnum.NOT_IN.getName().loadKDString());
        LinkedHashMap<String, String> enumCompareMap = new LinkedHashMap<String, String>(2);
        compareMap.put(FieldDataTypeEnum.ENUM.getCode(), enumCompareMap);
        enumCompareMap.put(CompareEnum.IN.getValue(), CompareEnum.IN.getName().loadKDString());
        enumCompareMap.put(CompareEnum.NOT_IN.getValue(), CompareEnum.NOT_IN.getName().loadKDString());
        LinkedHashMap<String, String> stringCompareMap = new LinkedHashMap<String, String>(2);
        compareMap.put(FieldDataTypeEnum.STRING.getCode(), stringCompareMap);
        stringCompareMap.put(CompareEnum.IN.getValue(), CompareEnum.IN.getName().loadKDString());
        stringCompareMap.put(CompareEnum.NOT_IN.getValue(), CompareEnum.NOT_IN.getName().loadKDString());
        stringCompareMap.put(CompareEnum.EQUALS.getValue(), CompareEnum.EQUALS.getName().loadKDString());
        stringCompareMap.put(CompareEnum.NOT_EQUALS.getValue(), CompareEnum.NOT_EQUALS.getName().loadKDString());
        LOGGER.info("compareMap:{}", compareMap);
        return compareMap;
    }

    public static String getConditionDescription(String conditions) {
        if (HRStringUtils.isEmpty((String)conditions)) {
            LOGGER.error("conditions is empty");
            return null;
        }
        List conditionVos = JSONObject.parseArray((String)conditions, ColorSchemaConditionVo.class);
        if (CollectionUtils.isEmpty((Collection)conditionVos)) {
            LOGGER.error("conditionVos is empty");
            return null;
        }
        ColorSchemaConditionVo conditionVo = (ColorSchemaConditionVo)conditionVos.get(0);
        String dimensionId = conditionVo.getDimensionId();
        DynamicObject dimension = OrgCardConfigRepository.getInstance().queryByPk(String.join((CharSequence)",", "fielddatatype", "entityidentifier", "fieldidentifier"), Long.parseLong(dimensionId));
        String name = dimension.getString("name");
        String fieldDataType = dimension.getString("fielddatatype");
        if (HRStringUtils.isEmpty((String)fieldDataType)) {
            LOGGER.error("fieldDataType is empty");
            return null;
        }
        Map<String, Map<String, String>> compareMap = ColorSchemaRuleServiceHelper.getCompareMap();
        Map<String, String> fieldCompareMap = compareMap.get(fieldDataType);
        if (fieldCompareMap == null) {
            LOGGER.error("fieldCompareMap is empty,fieldDataType:{}", (Object)fieldDataType);
            return null;
        }
        String compare = conditionVo.getCompare();
        String compareName = fieldCompareMap.get(compare);
        List conditionValues = conditionVo.getValues();
        if (CollectionUtils.isEmpty((Collection)conditionValues)) {
            LOGGER.error("conditionValues is empty");
            return null;
        }
        List values = null;
        if (HRStringUtils.equals((String)fieldDataType, (String)FieldDataTypeEnum.DYNAMIC_OBJECT.getCode())) {
            List ids = conditionValues.stream().map(Long::parseLong).collect(Collectors.toList());
            String entityName = ColorSchemaRuleServiceHelper.getEntityName(dimension);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)entityName, (String)String.join((CharSequence)",", "id", "name"), (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            if (!collection.isEmpty()) {
                values = collection.stream().map(dy -> dy.getString("name")).collect(Collectors.toList());
            }
        } else if (HRStringUtils.equals((String)fieldDataType, (String)FieldDataTypeEnum.ENUM.getCode())) {
            String fieldIdentifier = dimension.getString("fieldidentifier");
            DynamicProperty property = ColorSchemaRuleServiceHelper.getDynamicProperty(dimension, fieldIdentifier);
            if (property instanceof ComboProp) {
                ComboProp comboProp = (ComboProp)property;
                List comboItems = comboProp.getComboItems();
                values = comboItems.stream().filter(comboItem -> conditionValues.contains(comboItem.getValue())).map(comboItem -> comboItem.getName().getLocaleValue()).collect(Collectors.toList());
            } else if (property instanceof BooleanProp) {
                values = conditionValues.stream().map(value -> HRStringUtils.equals((String)value, (String)"1") ? ResManager.loadKDString((String)"\u662f", (String)"ColorSchemaRuleServiceHelper_1", (String)"odc-homs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ColorSchemaRuleServiceHelper_2", (String)"odc-homs-business", (Object[])new Object[0])).collect(Collectors.toList());
            }
        } else {
            values = conditionValues;
        }
        if (values == null || values.size() == 0) {
            LOGGER.error("values is empty");
            return null;
        }
        StringBuilder valueSb = new StringBuilder(name);
        if (HRStringUtils.equals((String)compare, (String)CompareEnum.BETWEEN.getValue())) {
            valueSb.append(HRStringUtils.equals((String)fieldDataType, (String)FieldDataTypeEnum.DATE.getCode()) ? String.format(ResManager.loadKDString((String)"\u4ece%1$s\u5230%2$s", (String)"ColorSchemaRuleServiceHelper_4", (String)"odc-homs-business", (Object[])new Object[0]), values.get(0), values.get(1)) : String.format(ResManager.loadKDString((String)"\u5728%1$s\u5230%2$s\u4e4b\u95f4", (String)"ColorSchemaRuleServiceHelper_5", (String)"odc-homs-business", (Object[])new Object[0]), values.get(0), values.get(1)));
        } else {
            valueSb.append(compareName);
            for (int i = 0; i < values.size(); ++i) {
                valueSb.append((String)values.get(i));
                if (i == values.size() - 1) continue;
                valueSb.append(ResManager.loadKDString((String)"\u6216\u8005", (String)"ColorSchemaRuleServiceHelper_0", (String)"odc-homs-business", (Object[])new Object[0]));
            }
        }
        return valueSb.toString();
    }

    public static String getDimensionName(String cardStyleId) {
        String dimensionName = ResManager.loadKDString((String)"\u65e0", (String)"ColorSchemaRuleServiceHelper_6", (String)"odc-homs-business", (Object[])new Object[0]);
        if (HRStringUtils.isEmpty((String)cardStyleId)) {
            LOGGER.error("cardStyleId is empty");
            return dimensionName;
        }
        DynamicObject cardStyle = OrgCardStyleNewRepository.getInstance().queryByPk("colorschemaentry.conditions_tag", Long.parseLong(cardStyleId));
        if (HRObjectUtils.isEmpty((Object)cardStyle)) {
            LOGGER.error("cardStyle is empty,cardStyleId:{}", (Object)cardStyle);
            return dimensionName;
        }
        DynamicObjectCollection colorSchemaEntry = cardStyle.getDynamicObjectCollection("colorschemaentry");
        if (colorSchemaEntry.isEmpty()) {
            LOGGER.error("colorSchemaEntry is empty");
            return dimensionName;
        }
        String conditions = ((DynamicObject)colorSchemaEntry.get(0)).getString("conditions_tag");
        if (HRStringUtils.isEmpty((String)conditions)) {
            LOGGER.error("conditions is empty");
            return dimensionName;
        }
        List conditionVos = JSONObject.parseArray((String)conditions, ColorSchemaConditionVo.class);
        if (CollectionUtils.isEmpty((Collection)conditionVos)) {
            return dimensionName;
        }
        ColorSchemaConditionVo conditionVo = (ColorSchemaConditionVo)conditionVos.get(0);
        String dimensionId = conditionVo.getDimensionId();
        if (HRStringUtils.isEmpty((String)dimensionId)) {
            LOGGER.error("dimensionId is empty");
            return dimensionName;
        }
        DynamicObject dimension = OrgCardConfigRepository.getInstance().queryByPk("name", Long.parseLong(dimensionId));
        if (!HRObjectUtils.isEmpty((Object)dimension)) {
            dimensionName = dimension.getString("name");
        }
        return dimensionName;
    }

    public static DynamicProperty getDynamicProperty(DynamicObject dimension, String fieldName) {
        String entityIdentifier = dimension.getString("entityidentifier");
        return MetadataServiceHelper.getDataEntityType((String)entityIdentifier).getProperty(fieldName);
    }

    public static String getEntityName(DynamicObject dimension) {
        String fieldIdentifier = dimension.getString("fieldidentifier");
        String fieldName = fieldIdentifier.substring(0, fieldIdentifier.lastIndexOf("."));
        BasedataProp basedataProp = (BasedataProp)ColorSchemaRuleServiceHelper.getDynamicProperty(dimension, fieldName);
        return basedataProp.getBaseEntityId();
    }
}

