/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgchart;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveRoute;
import kd.bos.db.archive.LogicArchiveRoute;
import kd.bos.db.pktemptable.service.AbstractPKTempTable;
import kd.bos.db.pktemptable.service.PKTempTableServiceFactory;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.filter.FilterContainer;
import kd.bos.form.IFormView;
import kd.bos.list.query.SchemeQuery;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.orgchart.OrgChartServiceHelper;

public class CommonOrgChartServiceHelper {
    private static final Log LOG = LogFactory.getLog(OrgChartServiceHelper.class);

    public static void setDefaultScheme(String eventArgs, IFormView view, String formId) {
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        String schemeId = jsonObject.getString("schemeId");
        Boolean isDefault = jsonObject.getBoolean("isDefault");
        FilterContainer filterContainer = OrgChartServiceHelper.getFilterContainer(view, formId);
        filterContainer.setDefaultScheme(schemeId, isDefault.booleanValue());
        HashMap<String, Object> result = new HashMap<String, Object>();
        String structProjectId = view.getPageCache().get("STRUCT_PROJECT_KEY");
        List<FilterScheme> schemes = OrgChartServiceHelper.getSchemeWithFilter(formId, RequestContext.get().getUserId(), true, structProjectId);
        result.put("schemes", schemes);
        result.put("showScheme", new SchemeQuery().getScheme(schemeId));
        CustomControl customcontrol = (CustomControl)view.getControl("customcontrolap1");
        OrgChartServiceHelper.setSimpleDataForSearchCustomControl("setDefaultScheme", result, customcontrol);
    }

    public static void deleteScheme(String eventArgs, IFormView view, String formId) {
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        String schemeId = jsonObject.getString("schemeId");
        FilterScheme filterScheme = new SchemeQuery().getScheme(schemeId);
        if (filterScheme == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u65b9\u6848\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"CommonOrgChartServiceHelper_10", (String)"odc-homs-business", (Object[])new Object[0]));
        } else {
            FilterContainer filterContainer = OrgChartServiceHelper.getFilterContainer(view, formId);
            filterContainer.deleteScheme(schemeId);
            HRBaseServiceHelper structureSchemeHelper = new HRBaseServiceHelper("homs_strprotofilter");
            structureSchemeHelper.deleteByFilter(new QFilter[]{new QFilter("scheme", "=", (Object)schemeId)});
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        String structProjectId = view.getPageCache().get("STRUCT_PROJECT_KEY");
        List<FilterScheme> schemes = OrgChartServiceHelper.getSchemeWithFilter(formId, RequestContext.get().getUserId(), true, structProjectId);
        result.put("schemes", schemes);
        CustomControl customcontrol = (CustomControl)view.getControl("customcontrolap1");
        OrgChartServiceHelper.setSimpleDataForSearchCustomControl("deleteScheme", result, customcontrol);
    }

    public static AbstractPKTempTable getPKTempTable(int classType) {
        DBRoute dbRoute = new DBRoute("hr");
        AbstractPKTempTable tempTable = 1 == classType ? PKTempTableServiceFactory.getService((DBRoute)dbRoute).createPKLong(true) : (2 == classType ? PKTempTableServiceFactory.getService((DBRoute)dbRoute).createPKString(true) : PKTempTableServiceFactory.getService((DBRoute)dbRoute).createPKBigString(true));
        return tempTable;
    }

    public static String buildSourceSql(List<Long> sources, AbstractPKTempTable pkTempTable) {
        DBRoute dbRoute = new DBRoute("hr");
        DBRoute ofRoute = DBRoute.of((String)LogicArchiveRoute.of((String)ArchiveRoute.getMapRoute((String)dbRoute.getRouteKey())).getRealArchiveKey());
        LOG.info("of db route :\t" + ofRoute.toString());
        StringBuilder sqlBuilder = new StringBuilder();
        if (sources.size() > HugeInConfig.inThreshold()) {
            pkTempTable.insert(sources);
            sqlBuilder.append(" SELECT FID FROM ").append(pkTempTable.getName());
        } else {
            for (int i = 0; i < sources.size(); ++i) {
                sqlBuilder.append('?');
                if (i >= sources.size() - 1) continue;
                sqlBuilder.append(",");
            }
        }
        return sqlBuilder.toString();
    }

    public static DynamicObject getHisOrgTeam(Date queryDate, Long orgTeamBoId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgteam");
        QFilter boIdFilter = new QFilter("boid", "=", (Object)orgTeamBoId);
        QFilter endDateFilter = new QFilter("bsled", ">=", (Object)queryDate);
        QFilter beginDateFilter = new QFilter("bsed", "<=", (Object)queryDate);
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        return helper.queryOne("id,name", new QFilter[]{boIdFilter, endDateFilter, beginDateFilter, currentVersionFilter});
    }

    public static boolean schemeCheck(Map<String, Object> filterSchemeMap, IFormView formView, String formId) {
        Object schemeNameObject = filterSchemeMap.get("schemeName");
        String defaultSchemeName = ResManager.loadKDString((String)"\u5e38\u7528\u6761\u4ef6\u8fc7\u6ee4", (String)"CommonOrgChartServiceHelper_1", (String)"odc-homs-business", (Object[])new Object[0]);
        if (HRStringUtils.equals((String)defaultSchemeName, (String)schemeNameObject.toString().trim())) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u201c\u5e38\u7528\u6761\u4ef6\u8fc7\u6ee4\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CommonOrgChartServiceHelper_2", (String)"odc-homs-business", (Object[])new Object[0]));
            return true;
        }
        if (schemeNameObject.toString().length() > 100) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u65b9\u6848\u540d\u79f0\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c100]", (String)"CommonOrgChartServiceHelper_3", (String)"odc-homs-business", (Object[])new Object[0]));
            return true;
        }
        List<FilterScheme> schemes = OrgChartServiceHelper.getScheme(formId, RequestContext.get().getUserId(), true);
        for (FilterScheme scheme : schemes) {
            if (!schemeNameObject.toString().equalsIgnoreCase(scheme.getSchemeName()) || filterSchemeMap.get("id") != null && (filterSchemeMap.get("id") == null || HRStringUtils.equals((String)filterSchemeMap.get("id").toString(), (String)scheme.getId()))) continue;
            formView.showErrorNotification(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CommonOrgChartServiceHelper_4", (String)"odc-homs-business", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public static boolean orgTeamExist(JSONObject jsonObject, IFormView formView) {
        Map scheme = (Map)jsonObject.get((Object)"scheme");
        String date = scheme.get("datefield").toString();
        Date dateField = new Date();
        try {
            dateField = HRDateTimeUtils.parseDate((String)date);
        }
        catch (ParseException exception) {
            LOG.error("adminOrgExist exception", (Throwable)exception);
        }
        Long orgTeamBoId = Long.parseLong(scheme.get("currentOrgChartRootNodeId").toString());
        DynamicObject dy = CommonOrgChartServiceHelper.getHisOrgTeam(dateField, orgTeamBoId);
        if (HRObjectUtils.isEmpty((Object)dy)) {
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u67e5\u8be2\u65e5\u671f\u4e3a\u201c%s\u201d\u65f6\uff0c\u5bf9\u5e94\u7684\u67e5\u8be2\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CommonOrgChartServiceHelper_5", (String)"odc-homs-business", (Object[])new Object[0]), new SimpleDateFormat("yyyy-MM-dd").format(dateField));
            formView.showTipNotification(message);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void checkSchemeAndSendMessage(JSONObject jsonObject, Map<String, Object> filterSchemeMap, boolean checkResult, IFormView formView, String formId) {
        boolean isExistsScheme;
        FilterContainer filterContainer = OrgChartServiceHelper.getFilterContainer(formView, formId);
        CustomControl customcontrol1 = (CustomControl)formView.getControl("customcontrolap1");
        CustomControl customcontrol = (CustomControl)formView.getControl("customcontrolap");
        String structProjectId = formView.getPageCache().get("STRUCT_PROJECT_KEY");
        if (checkResult) {
            OrgChartServiceHelper.setSimpleDataForCustomControl("queryError", new HashMap<String, Object>(), customcontrol1, "500", " ");
            OrgChartServiceHelper.setSimpleDataForCustomControl("queryError", new HashMap<String, Object>(), customcontrol, "500", " ");
            return;
        }
        boolean adminOrgExist = CommonOrgChartServiceHelper.orgTeamExist(jsonObject, formView);
        if (!adminOrgExist) {
            OrgChartServiceHelper.setSimpleDataForCustomControl("queryError", new HashMap<String, Object>(), customcontrol1, "500", " ");
            OrgChartServiceHelper.setSimpleDataForCustomControl("queryError", new HashMap<String, Object>(), customcontrol, "500", " ");
            return;
        }
        if (CommonOrgChartServiceHelper.schemeCheck(filterSchemeMap, formView, formId)) {
            OrgChartServiceHelper.setErrorDataForSearchCustomControl("queryError", new HashMap<String, Object>(), customcontrol1, " ");
            OrgChartServiceHelper.setSimpleDataForCustomControl("queryError", new HashMap<String, Object>(), customcontrol, "500", " ");
            return;
        }
        filterContainer.saveScheme(filterSchemeMap);
        Object schemeId = filterSchemeMap.get("id");
        long userId = RequestContext.get().getCurrUserId();
        HRBaseServiceHelper structureSchemeHelper = new HRBaseServiceHelper("homs_strprotofilter");
        if (HRStringUtils.isNotEmpty((String)structProjectId) && !(isExistsScheme = structureSchemeHelper.isExists(new QFilter("scheme", "=", schemeId)))) {
            DynamicObject structureScheme = structureSchemeHelper.generateEmptyDynamicObject();
            structureScheme.set("scheme", schemeId);
            structureScheme.set("structproject", (Object)Long.parseLong(structProjectId));
            structureScheme.set("user", (Object)userId);
            structureSchemeHelper.saveOne(structureScheme);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<FilterScheme> schemes = OrgChartServiceHelper.getSchemeWithFilter(formId, RequestContext.get().getUserId(), true, structProjectId);
        result.put("schemes", schemes);
        FilterScheme scheme = null;
        for (FilterScheme filterScheme : schemes) {
            if (!filterScheme.getSchemeName().equals(jsonObject.getString("schemeName"))) continue;
            scheme = filterScheme;
            break;
        }
        result.put("showScheme", scheme);
        OrgChartServiceHelper.setSimpleDataForCustomControl("saveOrUpdateScheme", result, customcontrol1);
    }

    public static Set<String> getChartStyleIdsByCardDimensionId(Long crtsStyDimensionId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_chartstyle");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter cardDimensionIdFilter = new QFilter("carddimensionid", "=", (Object)crtsStyDimensionId);
        DynamicObject[] chartStyles = serviceHelper.query(new QFilter[]{enableFilter, statusFilter, cardDimensionIdFilter});
        HashSet<String> chartStyleIds = new HashSet<String>();
        Stream.of(chartStyles).forEach(dy -> chartStyleIds.add(dy.getString("id")));
        return chartStyleIds;
    }

    public static Set<String> getOrgTeamStructLongNumber(List<Long> orgTeamBoIds) {
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
        currentVersionFilter.and(dataStatusFilter);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        currentVersionFilter.and(enableFilter);
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        currentVersionFilter.and(initStatusFilter);
        QFilter boIdFilter = new QFilter("orgteam.boid", "in", orgTeamBoIds);
        currentVersionFilter.and(boIdFilter);
        String selectFields = "orgteam.boid,structlongnumber";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        DynamicObjectCollection structOrgCollection = serviceHelper.queryOriginalCollection(selectFields, new QFilter[]{currentVersionFilter});
        HashSet<String> structLongNumberList = new HashSet<String>(16);
        if (null == structOrgCollection || structOrgCollection.size() == 0) {
            return structLongNumberList;
        }
        structOrgCollection.forEach(dyn -> {
            String structLongNumber = dyn.getString("structlongnumber");
            structLongNumberList.add(structLongNumber);
        });
        return structLongNumberList;
    }

    public static boolean isSameDay(String date1, Date date2) {
        String dateStr1 = "";
        try {
            Date queryDate = HRDateTimeUtils.parseDate((String)date1, (String)"yyyy-MM-dd");
            dateStr1 = HRDateTimeUtils.format((Date)queryDate, (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            LOG.error(MessageFormat.format("date:{0}", date1));
        }
        if (date1 == null || date2 == null) {
            return false;
        }
        String dateStr2 = HRDateTimeUtils.format((Date)date2, (String)"yyyy-MM-dd");
        return dateStr1.equals(dateStr2);
    }

    public static void addChartExportOperateLog(String formId, String operationKey) {
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)formId);
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        appLogInfo.setBizAppID(appId);
        appLogInfo.setBizObjID(formId);
        switch (formId) {
            case "homs_orgchart": {
                appLogInfo.setOpDesc(new MultiLangEnumBridge("\u884c\u653f\u7ec4\u7ec7\u7ed3\u6784\u56fe", "CommonOrgChartServiceHelper_7", "odc-homs-business"), new String[0]);
                break;
            }
            case "homs_projectchart": {
                appLogInfo.setOpDesc(new MultiLangEnumBridge("\u9879\u76ee\u56e2\u961f\u7ed3\u6784\u56fe", "CommonOrgChartServiceHelper_8", "odc-homs-business"), new String[0]);
                break;
            }
            case "homs_positionrelation": {
                appLogInfo.setOpDesc(new MultiLangEnumBridge("\u5c97\u4f4d\u5173\u7cfb\u56fe", "CommonOrgChartServiceHelper_9", "odc-homs-business"), new String[0]);
                break;
            }
        }
        appLogInfo.setOpName(operationKey, new MultiLangEnumBridge("\u5bfc\u51fa", "CommonOrgChartServiceHelper_6", "odc-homs-business"));
        service.addLog((AppLogInfo)appLogInfo);
    }

    public static void setTermRemaning(Map<String, Object> currentQueryShowParams, String loadOrNot) {
        if ("1".equals(loadOrNot)) {
            HashMap<String, String> termRemain = new HashMap<String, String>();
            termRemain.put("orgbu", ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7", (String)"OrgChartServiceHelper_10", (String)"odc-homs-business", (Object[])new Object[0]));
            termRemain.put("queryDate", ResManager.loadKDString((String)"\u67e5\u8be2\u65e5\u671f", (String)"OrgChartServiceHelper_12", (String)"odc-homs-business", (Object[])new Object[0]));
            termRemain.put("chartStyle", ResManager.loadKDString((String)"\u7ed3\u6784\u56fe\u6837\u5f0f", (String)"OrgChartServiceHelper_8", (String)"odc-homs-business", (Object[])new Object[0]));
            termRemain.put("customizeStyle", ResManager.loadKDString((String)"\u4e2a\u6027\u5316\u6837\u5f0f", (String)"OrgChartServiceHelper_6", (String)"odc-homs-business", (Object[])new Object[0]));
            termRemain.put("customizeStyleName", ResManager.loadKDString((String)"\u4e2a\u6027\u5316\u6837\u5f0f\u540d\u79f0", (String)"OrgChartServiceHelper_16", (String)"odc-homs-business", (Object[])new Object[0]));
            termRemain.put("chartDirecttion", ResManager.loadKDString((String)"\u7ed3\u6784\u56fe\u65b9\u5411", (String)"OrgChartServiceHelper_13", (String)"odc-homs-business", (Object[])new Object[0]));
            termRemain.put("showLevel", ResManager.loadKDString((String)"\u663e\u793a\u5c42\u7ea7", (String)"OrgChartServiceHelper_14", (String)"odc-homs-business", (Object[])new Object[0]));
            termRemain.put("adminorgType", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b", (String)"OrgBaseDataCheck_1", (String)"odc-homs-business", (Object[])new Object[0]));
            termRemain.put("collaboration", ResManager.loadKDString((String)"\u6c47\u62a5\u53ca\u534f\u4f5c\u5173\u7cfb", (String)"OrgChartServiceHelper_11", (String)"odc-homs-business", (Object[])new Object[0]));
            termRemain.put("schemaName", ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0", (String)"OrgChartServiceHelper_15", (String)"odc-homs-business", (Object[])new Object[0]));
            termRemain.put("queryNode", ResManager.loadKDString((String)"\u67e5\u8be2\u7ec4\u7ec7", (String)"OrgChartServiceHelper_9", (String)"odc-homs-business", (Object[])new Object[0]));
            termRemain.put("queryPosition", ResManager.loadKDString((String)"\u67e5\u8be2\u5c97\u4f4d", (String)"OrgChartServiceHelper_21", (String)"odc-homs-business", (Object[])new Object[0]));
            termRemain.put("levelTips", ResManager.loadKDString((String)"\u6570\u636e\u7684\u5c42\u7ea7\u5c0f\u4e8e\u663e\u793a\u5c42\u7ea7\u65f6\uff0c\u5c06\u4ee5\u5b9e\u9645\u6570\u636e\u7684\u5c42\u7ea7\u8fdb\u884c\u5c55\u793a\u3002", (String)"OrgChartServiceHelper_17", (String)"odc-homs-business", (Object[])new Object[0]));
            termRemain.put("adminorgTypeTips", ResManager.loadKDString((String)"\u4ec5\u8fc7\u6ee4\u53f3\u4fa7\u7ed3\u6784\u56fe\u7684\u6570\u636e", (String)"OrgChartServiceHelper_18", (String)"odc-homs-business", (Object[])new Object[0]));
            termRemain.put("customizeButtonTips", ResManager.loadKDString((String)"\u6253\u5f00\u4e2a\u6027\u5316\u5f00\u5173", (String)"OrgChartServiceHelper_19", (String)"odc-homs-business", (Object[])new Object[0]));
            termRemain.put("queryOrgTips", ResManager.loadKDString((String)"\u67e5\u8be2\u7ec4\u7ec7\u7531\u5de6\u6811\u9009\u5b9a\u7684\u7ec4\u7ec7\u5e26\u5165\u3002\u67e5\u770b\u65b9\u6848\u65f6\uff0c\u7ed3\u6784\u56fe\u7684\u9876\u70b9\u4e3a\u67e5\u8be2\u7ec4\u7ec7\uff0c\u5982\u9700\u4fee\u6539\u65b9\u6848\u7684\u67e5\u8be2\u7ec4\u7ec7\uff0c\u53ef\u66f4\u6362\u5de6\u6811\u9009\u5b9a\u7684\u7ec4\u7ec7\u540e\u70b9\u51fb\u201c\u4fdd\u5b58\u201d\u6309\u94ae\u3002", (String)"OrgChartServiceHelper_20", (String)"odc-homs-business", (Object[])new Object[0]));
            currentQueryShowParams.put("termRemain", termRemain);
        }
    }
}

