/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgchart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.domain.repository.OrgCardStyleNewRepository;
import kd.hr.homs.business.service.orgchart.ColorSchemaRuleServiceHelper;
import kd.hr.homs.business.service.orgchart.OrgChartPolicyService;
import kd.hr.homs.business.service.utils.RulePreviewUtil;
import kd.hr.homs.common.model.ChartFilterConfig;
import kd.hr.homs.common.model.OrgChartColorMatchBo;
import kd.hr.homs.common.model.OrgChartColorSchemaCallRuleEngineParamBo;
import kd.hr.homs.common.model.OrgChartLegendBO;
import kd.hr.homs.common.model.OrgChartTreeNode;
import kd.hr.homs.common.model.RuleCheckBo;
import kd.hr.homs.common.model.SearchChartData;

public class OrgChartNewServiceHelper {
    private static final HRBaseServiceHelper CHART_STYLE = new HRBaseServiceHelper("homs_chartstyle");
    private static final HRBaseServiceHelper ODC_CONFIG = new HRBaseServiceHelper("haos_odcconfigparam");
    private static final HRBaseServiceHelper CARD_STYLE_NEW = new HRBaseServiceHelper("homs_cardstyle_new");
    public static final String DEFAULT_CARD_STYLE = "{\"id\":\"10001\",\"name\":\"\u6837\u5f0f\u4e00\",\"card\":{\"border\":[1,\"#d9d9d9\",\"\",0],\"background\":\"#fff\",\"cardSize\":{\"w\":180,\"xSpace\":20,\"ySpace\":66,\"xSpace2r\":36,\"ySpace2v\": 36},\"mark\":{\"tag\":\"rect\",\"x\":0,\"y\":0,\"w\":\"1\",\"h\":28,\"rx\":0,\"fill\":\"#276FF5\",\"stroke\":\"#276FF5\"}},\"sortValues\":[\"0\",\"1\",\"3\",\"2\"],\"fieldGroupMap\":{\"0\":{\"toggleIcon\":false,\"groupStyle\":{\"color\":\"#212121\",\"fontSize\":14,\"endLine\":false},\"fieldRender\":{\"1\":{\"tag\":\"text\",\"w\":\"1\",\"h\":28,\"fontSize\":14,\"fontWeight\":600,\"color\":\"#fff\",\"valign\":\"center\",\"textAnchor\":\"middle\"}}},\"1\":{\"toggleIcon\":false,\"groupStyle\":{\"color\":\"#212121\",\"fontSize\":14,\"endLine\":true,\"dy\":4},\"fieldRender\":{\"1\":{\"tag\":\"text\",\"w\":\"2/3\",\"h\":18,\"dx\":4,\"fontSize\":12,\"color\":\"#212121\",\"valign\":\"center\",\"textAnchor\":\"start\",\"valueRule\":{\"onlyOne\":true,\"sort\":\"time\"}},\"2\":{\"tag\":\"img\",\"dy\":0,\"dx\":16,\"w\":36,\"h\":36,\"rx\":18}}},\"2\":{\"toggleIcon\":true,\"groupStyle\":{\"color\":\"#212121\",\"fontSize\":14,\"endLine\":true},\"fieldRender\":{\"1\":{\"tag\":\"text\",\"w\":\"1/2\",\"h\":18,\"fontSize\":12,\"color\":\"#212121\",\"valign\":\"center\",\"textAnchor\":\"start\"}}},\"3\":{\"toggleIcon\":false,\"groupStyle\":{\"color\":\"#212121\",\"fontSize\":14,\"endLine\":true},\"fieldRender\":{\"1\":{\"tag\":\"text\",\"w\":\"1\",\"h\":18,\"fontSize\":12,\"color\":\"#212121\",\"valign\":\"center\",\"textAnchor\":\"start\"}}}},\"defaultData\":{\"presetFields\":[\"name\",\"personname\",\"personavtor\",\"positionname\",\"personcount\"],\"showIcon\":1}}";
    private static final String ODC_HOMS_BUSINESS = "odc-homs-business";

    public static HRBaseServiceHelper getChartStyleHelper() {
        return CHART_STYLE;
    }

    public static HRBaseServiceHelper getCardStyleNewHelper() {
        return CARD_STYLE_NEW;
    }

    public static DynamicObject[] getNewChartStyleById(Set<Long> ids) {
        return CARD_STYLE_NEW.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", ids)});
    }

    public static String saveChartStyleFromChartCard(DynamicObject chartCard) {
        DynamicObject dynamicObject = CHART_STYLE.generateEmptyDynamicObject();
        dynamicObject.set("name", chartCard.get("name"));
        dynamicObject.set("number", chartCard.get("number"));
        dynamicObject.set("orgteam", chartCard.get("adminorg"));
        dynamicObject.set("carddimensionid", chartCard.get("carddimension"));
        dynamicObject.set("enable", chartCard.get("enable"));
        dynamicObject.set("status", chartCard.get("status"));
        dynamicObject.set("issyspreset", chartCard.get("issyspreset"));
        DynamicObjectCollection orgentryentity = chartCard.getDynamicObjectCollection("orgentryentity");
        if (!orgentryentity.isEmpty()) {
            DynamicObjectCollection chastyorgentry = dynamicObject.getDynamicObjectCollection("chastyorgentry");
            for (DynamicObject dyn : orgentryentity) {
                DynamicObject dynObj = chastyorgentry.addNew();
                dynObj.set("adminorg", dyn.get("adminorgid"));
                dynObj.set("iscontainslower", dyn.get("iscontainslower"));
            }
        }
        DynamicObjectCollection chartstyleentry = dynamicObject.getDynamicObjectCollection("chartstyleentry");
        DynamicObject chartStyle = chartstyleentry.addNew();
        chartStyle.set("cardstyle", (Object)chartCard);
        chartStyle.set("carddimension", chartCard.get("carddimension"));
        boolean useNumberRule = CodeRuleServiceHelper.isExist((String)"homs_chartstyle", (DynamicObject)dynamicObject, null);
        if (useNumberRule) {
            String number = CodeRuleServiceHelper.getNumber((String)"homs_chartstyle", (DynamicObject)dynamicObject, null);
            dynamicObject.set("number", (Object)number);
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"homs_chartstyle", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)operateOption);
        return null;
    }

    public static String checkChartStyle(DynamicObject chartCard, boolean enable, boolean audit) {
        if (!"1".equals(chartCard.getString("enable")) || HRBaseDataConfigUtil.getAudit((String)"homs_cardstyle_new") && !audit) {
            return "";
        }
        long charCardId = chartCard.getLong("id");
        DynamicObject[] cardstyles = CHART_STYLE.query(new QFilter[]{new QFilter("chartstyleentry.cardstyle", "=", (Object)charCardId)});
        if (enable) {
            if (cardstyles != null && cardstyles.length >= 1) {
                return ResManager.loadKDString((String)"%s\uff1a\u5361\u7247\u6837\u5f0f\u542f\u7528\u6210\u529f\u3002\u5f53\u524d\u5361\u7247\u6837\u5f0f\u5df2\u88ab\u7ed3\u6784\u56fe\u6837\u5f0f\u5f15\u7528\uff0c\u672a\u4e3a\u60a8\u81ea\u52a8\u751f\u6210\u7ed3\u6784\u56fe\u6837\u5f0f\uff0c\u5982\u6709\u9700\u8981\uff0c\u8bf7\u624b\u52a8\u65b0\u589e\u7ed3\u6784\u56fe\u6837\u5f0f\u3002", (String)"OrgChartNewServiceHelper_3", (String)ODC_HOMS_BUSINESS, (Object[])new Object[]{chartCard.getString("number")});
            }
            cardstyles = CHART_STYLE.query(new QFilter[]{new QFilter("number", "=", (Object)chartCard.getString("number"))});
            if (cardstyles != null && cardstyles.length >= 1) {
                return ResManager.loadKDString((String)"%s\uff1a\u5361\u7247\u6837\u5f0f\u542f\u7528\u6210\u529f\u3002\u672a\u4e3a\u60a8\u81ea\u52a8\u751f\u6210\u7ed3\u6784\u56fe\u6837\u5f0f\uff0c\u539f\u56e0\u662f\uff1a\u7f16\u7801\u4e0e\u5df2\u6709\u6570\u636e\u91cd\u590d\u3002\u5982\u6709\u9700\u8981\uff0c\u8bf7\u624b\u52a8\u65b0\u589e\u7ed3\u6784\u56fe\u6837\u5f0f\u3002", (String)"OrgChartNewServiceHelper_4", (String)ODC_HOMS_BUSINESS, (Object[])new Object[]{chartCard.getString("number")});
            }
            cardstyles = CHART_STYLE.query(new QFilter[]{new QFilter("name", "=", (Object)chartCard.getString("name"))});
            if (cardstyles != null && cardstyles.length >= 1) {
                return ResManager.loadKDString((String)"%s\uff1a\u5361\u7247\u6837\u5f0f\u542f\u7528\u6210\u529f\u3002\u672a\u4e3a\u60a8\u81ea\u52a8\u751f\u6210\u7ed3\u6784\u56fe\u6837\u5f0f\uff0c\u539f\u56e0\u662f\uff1a\u540d\u79f0\u4e0e\u5df2\u6709\u6570\u636e\u91cd\u590d\u3002\u5982\u6709\u9700\u8981\uff0c\u8bf7\u624b\u52a8\u65b0\u589e\u7ed3\u6784\u56fe\u6837\u5f0f\u3002", (String)"OrgChartNewServiceHelper_5", (String)ODC_HOMS_BUSINESS, (Object[])new Object[]{chartCard.getString("number")});
            }
        } else {
            if (cardstyles != null && cardstyles.length >= 1) {
                return ResManager.loadKDString((String)"%s\uff1a\u5361\u7247\u6837\u5f0f\u65b0\u589e\u6210\u529f\u3002\u5f53\u524d\u5361\u7247\u6837\u5f0f\u5df2\u88ab\u7ed3\u6784\u56fe\u6837\u5f0f\u5f15\u7528\uff0c\u672a\u4e3a\u60a8\u81ea\u52a8\u751f\u6210\u7ed3\u6784\u56fe\u6837\u5f0f\uff0c\u5982\u6709\u9700\u8981\uff0c\u8bf7\u624b\u52a8\u65b0\u589e\u7ed3\u6784\u56fe\u6837\u5f0f\u3002", (String)"OrgChartNewServiceHelper_0", (String)ODC_HOMS_BUSINESS, (Object[])new Object[]{chartCard.getString("number")});
            }
            cardstyles = CHART_STYLE.query(new QFilter[]{new QFilter("number", "=", (Object)chartCard.getString("number"))});
            if (cardstyles != null && cardstyles.length >= 1) {
                return ResManager.loadKDString((String)"%s\uff1a\u5361\u7247\u6837\u5f0f\u65b0\u589e\u6210\u529f\u3002\u672a\u4e3a\u60a8\u81ea\u52a8\u751f\u6210\u7ed3\u6784\u56fe\u6837\u5f0f\uff0c\u539f\u56e0\u662f\uff1a\u7f16\u7801\u4e0e\u5df2\u6709\u6570\u636e\u91cd\u590d\u3002\u5982\u6709\u9700\u8981\uff0c\u8bf7\u624b\u52a8\u65b0\u589e\u7ed3\u6784\u56fe\u6837\u5f0f\u3002", (String)"OrgChartNewServiceHelper_1", (String)ODC_HOMS_BUSINESS, (Object[])new Object[]{chartCard.getString("number")});
            }
            cardstyles = CHART_STYLE.query(new QFilter[]{new QFilter("name", "=", (Object)chartCard.getString("name"))});
            if (cardstyles != null && cardstyles.length >= 1) {
                return ResManager.loadKDString((String)"%s\uff1a\u5361\u7247\u6837\u5f0f\u65b0\u589e\u6210\u529f\u3002\u672a\u4e3a\u60a8\u81ea\u52a8\u751f\u6210\u7ed3\u6784\u56fe\u6837\u5f0f\uff0c\u539f\u56e0\u662f\uff1a\u540d\u79f0\u4e0e\u5df2\u6709\u6570\u636e\u91cd\u590d\u3002\u5982\u6709\u9700\u8981\uff0c\u8bf7\u624b\u52a8\u65b0\u589e\u7ed3\u6784\u56fe\u6837\u5f0f\u3002", (String)"OrgChartNewServiceHelper_2", (String)ODC_HOMS_BUSINESS, (Object[])new Object[]{chartCard.getString("number")});
            }
        }
        return null;
    }

    public static boolean isUseNewStructureChart() {
        DynamicObject dynamicObject = ODC_CONFIG.loadDynamicObject(new QFilter[]{new QFilter("number", "=", (Object)"isUseNewStructureChart")});
        if (dynamicObject == null) {
            return false;
        }
        String value = dynamicObject.getString("value");
        if ("0".equals(value)) {
            return false;
        }
        return "1".equals(value);
    }

    public static DynamicObject getCardStyleById(String cardStyleId) {
        return CARD_STYLE_NEW.loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(cardStyleId))});
    }

    public static DynamicObject[] getCardStyleById(List<String> cardStyleIds) {
        List collect = cardStyleIds.stream().map(card -> Long.parseLong(card)).collect(Collectors.toList());
        return CARD_STYLE_NEW.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", collect)});
    }

    public static Map<String, List<OrgChartLegendBO>> getLegendByCardStyle(List<String> cardStyleIdList) {
        DynamicObject[] cardStyles = OrgCardStyleNewRepository.getInstance().queryByPks("id, colorschemaentry.colorcode, colorschemaentry.conditions_tag", cardStyleIdList.stream().map(Long::valueOf).collect(Collectors.toList()));
        return Arrays.stream(cardStyles).collect(Collectors.toMap(cardStyle -> cardStyle.getString("id"), cardStyle -> {
            DynamicObjectCollection colorEntry = cardStyle.getDynamicObjectCollection("colorschemaentry");
            return colorEntry.stream().map(row -> {
                OrgChartLegendBO orgChartLegendBO = new OrgChartLegendBO();
                orgChartLegendBO.setColor(row.getString("colorcode"));
                String conditionTag = row.getString("conditions_tag");
                orgChartLegendBO.setDesc(ColorSchemaRuleServiceHelper.getConditionDescription(conditionTag));
                return orgChartLegendBO;
            }).collect(Collectors.toList());
        }));
    }

    public static Map<String, String> getColorMap1(OrgChartColorMatchBo orgChartColorMatchBo) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("#e65e67", "100000");
        return result;
    }

    @Deprecated
    public static Map<String, String> getColorMap(OrgChartColorMatchBo orgChartColorMatchBo) {
        List adminOrgIdList = orgChartColorMatchBo.getAdminOrgIdList();
        if (CollectionUtils.isEmpty((Collection)adminOrgIdList)) {
            return new HashMap<String, String>();
        }
        DynamicObject cardStyle = OrgCardStyleNewRepository.getInstance().queryByPk("id, colorschemaentry.colorcode, colorschemaentry.policy", Long.valueOf(orgChartColorMatchBo.getCardStyleId()));
        if (cardStyle == null) {
            return new HashMap<String, String>();
        }
        DynamicObjectCollection colorEntry = cardStyle.getDynamicObjectCollection("colorschemaentry");
        if (colorEntry.size() == 0) {
            return new HashMap<String, String>();
        }
        DynamicObject[] adminOrgs = AdOrgRepository.getInstance().queryByPks("id, adminorgtype, adminorglayer", (Collection)adminOrgIdList.stream().map(Long::valueOf).collect(Collectors.toList()));
        if (adminOrgs.length == 0) {
            return new HashMap<String, String>();
        }
        Map colorVsPolicyIdList = colorEntry.stream().filter(OrgChartNewServiceHelper.validEntryValue()).collect(Collectors.groupingBy(colorRow -> colorRow.getString("colorcode"), Collectors.mapping(colorRow -> colorRow.getLong("policy.id"), Collectors.toList())));
        return colorVsPolicyIdList.entrySet().stream().map(entry -> {
            String color = (String)entry.getKey();
            List policyIdList = (List)entry.getValue();
            List<String> matchedSerialNumberList = OrgChartNewServiceHelper.callRuleEngine(adminOrgs, policyIdList);
            return matchedSerialNumberList.stream().collect(Collectors.toMap(adminOrgId -> adminOrgId, xx -> color));
        }).reduce(new HashMap(), (map, map2) -> {
            map.putAll(map2);
            return map;
        });
    }

    private static List<String> callRuleEngine(DynamicObject[] adminOrgs, List<Long> policyIdList) {
        DynamicObject buDy = new HRBaseServiceHelper("bos_org").loadSingle((Object)OrgChartPolicyService.BU);
        List<OrgChartColorSchemaCallRuleEngineParamBo> orgChartColorSchemaCallRuleEngineParamBoList = Arrays.stream(adminOrgs).map(adminOrg -> {
            OrgChartColorSchemaCallRuleEngineParamBo orgChartColorSchemaCallRuleEngineParamBo = new OrgChartColorSchemaCallRuleEngineParamBo();
            orgChartColorSchemaCallRuleEngineParamBo.setBuNumber(buDy.getString("number"));
            orgChartColorSchemaCallRuleEngineParamBo.setExecutePolicyIds(policyIdList);
            orgChartColorSchemaCallRuleEngineParamBo.setSerialNumber(adminOrg.getString("id"));
            HashMap<String, Object> inputMap = new HashMap<String, Object>();
            inputMap.put("type", adminOrg.get("adminorgtype"));
            inputMap.put("layer", adminOrg.get("adminorglayer"));
            orgChartColorSchemaCallRuleEngineParamBo.setInputParams(inputMap);
            return orgChartColorSchemaCallRuleEngineParamBo;
        }).collect(Collectors.toList());
        return new OrgChartPolicyService().batchCallRuleEngine(orgChartColorSchemaCallRuleEngineParamBoList);
    }

    public static Predicate<DynamicObject> validEntryValue() {
        return colorRow -> {
            long policyId = colorRow.getLong("policy.id");
            if (policyId == 0L) {
                return false;
            }
            String colorCode = colorRow.getString("colorcode");
            return !HRStringUtils.isBlank((CharSequence)colorCode);
        };
    }

    public static List<String> validRule(Map<String, List<String>> colorVsRuleControlJsonList) {
        List ruleCheckBoList = colorVsRuleControlJsonList.entrySet().stream().map(entry -> {
            String color = (String)entry.getKey();
            List ruleControlJsonList = (List)entry.getValue();
            List ruleConditionInfoList = ruleControlJsonList.stream().map(conditionJson -> (RuleConditionInfo)SerializationUtils.fromJsonString((String)conditionJson, RuleConditionInfo.class)).collect(Collectors.toList());
            return ruleConditionInfoList.stream().filter(ruleConditionInfo -> "2".equals(((ConditionInfo)ruleConditionInfo.getConditionList().get(0)).getValueType())).map(ruleConditionInfo -> {
                ConditionInfo condition = (ConditionInfo)ruleConditionInfo.getConditionList().get(0);
                RuleCheckBo ruleCheckBo = new RuleCheckBo();
                ruleCheckBo.setRuleControlJson(SerializationUtils.toJsonString((Object)ruleConditionInfo));
                ruleCheckBo.setColor(color);
                ruleCheckBo.setCp(condition.getOperators());
                ruleCheckBo.setParam(condition.getParam());
                String value = condition.getValue();
                ruleCheckBo.setValue(value);
                return ruleCheckBo;
            }).collect(Collectors.toList());
        }).flatMap(Collection::stream).collect(Collectors.toList());
        ArrayList<String> result = new ArrayList<String>();
        block0: for (RuleCheckBo ruleCheckBo : ruleCheckBoList) {
            String color = ruleCheckBo.getColor();
            for (RuleCheckBo nestRuleCheckBo : ruleCheckBoList) {
                boolean isFail;
                if (ruleCheckBo == nestRuleCheckBo || color.equals(nestRuleCheckBo.getColor()) || !(isFail = OrgChartNewServiceHelper.check(ruleCheckBo, nestRuleCheckBo))) continue;
                result.add(OrgChartNewServiceHelper.buildMessage(ruleCheckBo, nestRuleCheckBo, color));
                break block0;
            }
        }
        return result;
    }

    private static String buildMessage(RuleCheckBo aRuleCheckBo, RuleCheckBo anoRuleCheckBo, String color) {
        String aDesc = RulePreviewUtil.getConditionPreviewStr(aRuleCheckBo.getRuleControlJson());
        String anoDesc = RulePreviewUtil.getConditionPreviewStr(anoRuleCheckBo.getRuleControlJson());
        String multiDesc = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u914d\u8272\u65b9\u6848\u4e2d\u6761\u4ef6\u8bbe\u7f6e\u5b58\u5728\u51b2\u7a81\uff1a\u201c%1$s\u201d\u4e0e\u201c%2$s\u201d\u3002", (String)"OrgChartNewServiceHelper_6", (String)ODC_HOMS_BUSINESS, (Object[])new Object[0]);
        return String.format(multiDesc, aDesc, anoDesc);
    }

    private static boolean check(RuleCheckBo aRuleCheckBo, RuleCheckBo anoRuleCheckBo) {
        String aCp = aRuleCheckBo.getCp();
        String anoCp = anoRuleCheckBo.getCp();
        String aValue = aRuleCheckBo.getValue();
        String anoValue = anoRuleCheckBo.getValue();
        String aParam = aRuleCheckBo.getParam();
        String anoParam = anoRuleCheckBo.getParam();
        Set<Long> aIdSet = OrgChartNewServiceHelper.query(aParam, aCp, aValue);
        Set<Long> anoIdSet = OrgChartNewServiceHelper.query(anoParam, anoCp, anoValue);
        for (Long id : aIdSet) {
            if (!anoIdSet.contains(id)) continue;
            return true;
        }
        return false;
    }

    private static Set<Long> query(String aParam, String aCp, String aValue) {
        String cp;
        String param;
        Set<Long> value = null;
        if ("type.haos_adminorgtype.id".equals(aParam)) {
            param = "adminorgtype";
        } else if ("layer.haos_adminorglayer.id".equals(aParam)) {
            param = "adminorglayer";
        } else {
            return new HashSet<Long>();
        }
        if ("==".equals(aCp)) {
            cp = "=";
            value = Long.valueOf(aValue);
        } else if ("!=".equals(aCp)) {
            cp = "!=";
            value = Long.valueOf(aValue);
        } else if ("in".equals(aCp)) {
            cp = "in";
            value = OrgChartNewServiceHelper.toSet(aValue);
        } else if ("not_in".equals(aCp)) {
            cp = "not in";
            value = OrgChartNewServiceHelper.toSet(aValue);
        } else if ("is_null".equals(aCp)) {
            cp = "is null";
        } else if ("is_not_null".equals(aCp)) {
            cp = "is not null";
        } else {
            return new HashSet<Long>();
        }
        QFilter filter = new QFilter(param, cp, (Object)value);
        DynamicObject[] dynamicObjects = new HRBaseServiceHelper("haos_adminorgdetail").queryOriginalArray("id", new QFilter[]{filter, QFilterHelper.createValidHisCurrentDataFilter()});
        return Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
    }

    private static Set<Long> toSet(String value) {
        value = String.format("[%s]", value);
        List idStrList = SerializationUtils.fromJsonStringToList((String)value, String.class);
        return idStrList.stream().map(Long::valueOf).collect(Collectors.toSet());
    }

    public static Boolean isMatchConditionNew(OrgChartTreeNode currentNode, SearchChartData searchChartData) {
        List chartFilterConfigs;
        if (currentNode != null && Boolean.TRUE.equals(currentNode.getVirtualOrgFlag())) {
            return true;
        }
        AtomicBoolean result = new AtomicBoolean(true);
        if (currentNode != null && !searchChartData.getAdminOrgTypes().contains(currentNode.getOrgType())) {
            result.set(false);
        }
        if (currentNode != null && (chartFilterConfigs = searchChartData.getChartFilterConfigs()) != null) {
            chartFilterConfigs.stream().filter(filterConfig -> !ChartFilterConfig.DEFAULT_FILTER_NUMBERS.contains(filterConfig.getNumber())).forEach(config -> {
                Map extSearchData = searchChartData.getExtSearchData();
                if (extSearchData != null) {
                    String value;
                    List strings = (List)extSearchData.get(config.getNumber());
                    Map otherInfo = currentNode.getOtherInfo();
                    if (strings != null && otherInfo != null && (value = (String)otherInfo.get(config.getIdentifier())) != null && !strings.contains(value)) {
                        result.set(false);
                    }
                }
            });
        }
        return result.get();
    }
}

