/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgchart;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.common.model.OrgChartColorSchemaCallRuleEngineParamBo;

public class OrgChartPolicyService {
    private static Log LOG = LogFactory.getLog(OrgChartPolicyService.class);
    public static final Long BU = 100000L;

    public void delPolicy(Long policyId) {
        if (policyId == null || policyId == 0L) {
            return;
        }
        LOG.info("del_policy_start");
        try {
            HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMPolicyService", (String)"deletePolicy", (Object[])new Object[]{Collections.singletonList(policyId)});
        }
        catch (Exception e) {
            LOG.error("del_policy_error");
        }
        LOG.info("del_policy_over");
    }

    public Long addPolicy(String ruleMapString) {
        long id = ORM.create().genLongId("homs_orgchart_new");
        String number = "ORGCHART" + id;
        String name = "card_color_schema" + id;
        long org = BU;
        String results = "{\"resultList\":[{\"index\":0,\"displayParam\":\" \",\"param\":\"ismatch\",\"paramType\":\"boolean\",\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\" \",\"value\":\"false\",\"dateFormat\":\"\"}]}";
        HashMap rule = Maps.newHashMapWithExpectedSize((int)8);
        rule.put("rulename", name);
        rule.put("rulenumber", number);
        rule.put("ruleorder", 1);
        rule.put("filtercondition", ruleMapString);
        String filterresult = "{\"resultList\":[{\"index\":0,\"displayParam\":\" \",\"param\":\"ismatch\",\"paramType\":\"boolean\",\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\" \",\"value\":\"true\",\"dateFormat\":\"\"}]}";
        rule.put("filterresult", filterresult);
        List<HashMap> entryrulelist = Collections.singletonList(rule);
        HashMap entrybu = Maps.newHashMapWithExpectedSize((int)8);
        entrybu.put("entitybu", org);
        entrybu.put("containssub", false);
        List<HashMap> entrybulist = Collections.singletonList(entrybu);
        HashMap policyMap = Maps.newHashMapWithExpectedSize((int)16);
        policyMap.put("name", name);
        policyMap.put("number", number);
        policyMap.put("createbu", org);
        policyMap.put("bizappid", "217WYC/L9U7E");
        policyMap.put("scene", 1891380309275109376L);
        policyMap.put("results", results);
        policyMap.put("entryrulelist", entryrulelist);
        policyMap.put("entrybulist", entrybulist);
        LOG.info("add_policy_start");
        Map responseMap = (Map)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMPolicyService", (String)"addPolicy", (Object[])new Object[]{policyMap});
        LOG.info("add_policy_end, responseMap{}", (Object)responseMap);
        if (responseMap != null && HRStringUtils.equals((String)responseMap.get("resultCode").toString(), (String)"200")) {
            return Long.valueOf(responseMap.get("policyId").toString());
        }
        LOG.info("add_policy_over");
        return 0L;
    }

    private <T> List getMatchRuleResult(List<Map<String, Object>> sceneResultList, Map<String, T> serialNumberToSmMap) {
        LOG.info("batchCallRuleEngineForOriginal_result ={}", sceneResultList);
        if (CollectionUtils.isEmpty(sceneResultList)) {
            this.throwCallRuleException();
        }
        ArrayList matchData = Lists.newArrayListWithExpectedSize((int)sceneResultList.size());
        for (Map<String, Object> sceneResult : sceneResultList) {
            if (!this.sceneResultIsMatch(sceneResult)) continue;
            String serialNumber = sceneResult.get("serialNumber").toString();
            matchData.add(serialNumberToSmMap.get(serialNumber));
        }
        return matchData;
    }

    private boolean sceneResultIsMatch(Map<String, Object> sceneResult) {
        List policyResultList;
        if (sceneResult == null || !HRStringUtils.equals((String)sceneResult.get("responseCode").toString(), (String)"200")) {
            this.throwCallRuleException();
        }
        if (CollectionUtils.isEmpty((Collection)(policyResultList = (List)sceneResult.get("policyResults")))) {
            return false;
        }
        Map policyResultMap = (Map)policyResultList.get(0);
        return policyResultMap.containsKey("ruleResults");
    }

    private void throwCallRuleException() {
        throw new KDException(new ErrorCode("kd.hr.homs.business.service.orgchart.OrgChartPolicyService", ResManager.loadKDString((String)"\u8c03\u7528\u89c4\u5219\u5f15\u64ce\u5931\u8d25\u3002", (String)"OrgChartPolicyService_0", (String)"odc-homs-business", (Object[])new Object[0])), new Object[0]);
    }

    public List<String> batchCallRuleEngine(List<OrgChartColorSchemaCallRuleEngineParamBo> paramBoList) {
        ArrayList paramList = Lists.newArrayListWithExpectedSize((int)paramBoList.size());
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)paramBoList.size());
        for (OrgChartColorSchemaCallRuleEngineParamBo paramBo : paramBoList) {
            paramList.add(paramBo.toParamMap());
            resultMap.put(paramBo.getSerialNumber(), paramBo.getSerialNumber());
        }
        List paramListList = Lists.partition((List)paramList, (int)500);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)paramBoList.size());
        for (List param : paramListList) {
            List sceneResult = (List)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"batchCallRuleEngineForOriginal", (Object[])new Object[]{param});
            result.addAll(this.getMatchRuleResult(sceneResult, resultMap));
        }
        return result;
    }
}

