/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgchart;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.pktemptable.service.AbstractPKTempTable;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.tree.TreeNodeLabel;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.filter.FilterContainer;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.query.SchemeQuery;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListFilterModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.haos.business.rpc.HRPIRPCServiceHelper;
import kd.hr.haos.business.service.staff.occupy.impl.StaffOccupyServiceImpl;
import kd.hr.haos.business.servicehelper.AdminOrgQueryServiceHelper;
import kd.hr.haos.business.util.BaseDataHelper;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.haos.common.util.PlatformRootUtils;
import kd.hr.hbp.business.dao.IHRBaseDao;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.OrgSubInfo;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.orgchart.CommonOrgChartServiceHelper;
import kd.hr.homs.business.service.orgchart.OrgChartNewServiceHelper;
import kd.hr.homs.business.service.proxy.ProxyUtils;
import kd.hr.homs.common.constants.orgchart.OrgChartConstants;
import kd.hr.homs.common.model.CardStyle;
import kd.hr.homs.common.model.CardStyleField;
import kd.hr.homs.common.model.ChartFilterConfig;
import kd.hr.homs.common.model.ChartOrgInfo;
import kd.hr.homs.common.model.ChartStyle;
import kd.hr.homs.common.model.OrgChartQueryParam;
import kd.hr.homs.common.model.OrgChartTreeNode;
import kd.hr.homs.common.model.PersonalStyleData;
import kd.hr.homs.common.model.SearchChartData;

public class OrgChartServiceHelper {
    private static final Log LOG = LogFactory.getLog(OrgChartServiceHelper.class);
    private static final String IHBPM_POSITION_SERVICE = "IPositionService";
    private static final String IHBPM_PERSON_COUNT_SERVICE = "IHRPIDepempService";
    private static final String HBPM = "hbpm";
    private static final String HRPI = "hrpi";
    public static final String VIRTUALORG_CHARTSTYLE = "1004";
    public static final String VIRTUALORG_STYLE = "virtualorg_style";
    public static final Map<String, JSONObject> CARDDIMENSION_ID_DEFAULT_COLOR = new HashMap<String, JSONObject>();

    public static ListShowParameter getListShowParameter(String billFormId, String formId, QFilter qFilter, String orderBy) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (!StringUtils.isEmpty((CharSequence)formId)) {
            showParameter.setFormId(formId);
        }
        showParameter.setBillFormId(billFormId);
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("960px");
        cssValue.setHeight("620px");
        showParameter.getOpenStyle().setInlineStyleCss(cssValue);
        showParameter.setLookUp(true);
        showParameter.setShowTitle(false);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        showParameter.setListFilterParameter(listFilterParameter);
        if (qFilter != null) {
            listFilterParameter.setFilter(qFilter);
        }
        listFilterParameter.setOrderBy(orderBy);
        showParameter.setMultiSelect(false);
        return showParameter;
    }

    public static void findTreeNode(TreeNode currentNode, SearchChartData searchChartData, boolean isUseNewChart) {
        BiFunction<OrgChartTreeNode, SearchChartData, Boolean> isMatchCondition = isUseNewChart ? OrgChartNewServiceHelper::isMatchConditionNew : OrgChartServiceHelper::isMatchCondition;
        List children = currentNode.getChildren();
        if (!CollectionUtils.isEmpty((Collection)children)) {
            ArrayList<TreeNode> afterChildren = new ArrayList<TreeNode>();
            for (TreeNode treeNode : children) {
                if (!isMatchCondition.apply((OrgChartTreeNode)treeNode, searchChartData).booleanValue()) continue;
                afterChildren.add(treeNode);
            }
            currentNode.setChildren(afterChildren);
            if (!CollectionUtils.isEmpty(afterChildren)) {
                for (TreeNode treeNode : afterChildren) {
                    OrgChartServiceHelper.findTreeNode(treeNode, searchChartData, isUseNewChart);
                }
            }
        }
    }

    public static void addChildNodes(TreeNode rootNode, List<? extends TreeNode> childNodeList) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        HashMap<String, TreeNode> dctItems = new HashMap<String, TreeNode>(childNodeList.size());
        for (TreeNode treeNode : childNodeList) {
            if (rootNode.getId().equals(treeNode.getId())) continue;
            dctItems.put(treeNode.getId(), treeNode);
        }
        HashSet<TreeNode> parentNodes = new HashSet<TreeNode>();
        parentNodes.add(rootNode);
        for (TreeNode treeNode : childNodeList) {
            treeNode.setLeaf(true);
            TreeNode parentNode = (TreeNode)dctItems.get(treeNode.getParentid());
            if (parentNode != null) {
                if (parentNode.getChildren() == null) {
                    parentNode.addChildren(new ArrayList());
                }
                parentNode.getChildren().add(treeNode);
                parentNode.setLeaf(false);
                if (parentNode.getChildren().size() <= 1) continue;
                parentNodes.add(parentNode);
                continue;
            }
            String parentId = treeNode.getParentid();
            if (!rootNode.getId().equals(parentId)) continue;
            list.add(treeNode);
        }
        for (TreeNode treeNode : list) {
            boolean isLeaf = treeNode.getChildren() == null || treeNode.getChildren().isEmpty();
            treeNode.setLeaf(isLeaf);
        }
        rootNode.addChildren(list);
        for (TreeNode treeNode : parentNodes) {
            if (CollectionUtils.isEmpty((Collection)treeNode.getChildren())) continue;
            List<TreeNode> treeNodes = OrgChartServiceHelper.sortOrgChartTreeNodes(treeNode.getChildren());
            treeNode.setChildren(treeNodes);
        }
    }

    public static List<TreeNode> sortOrgChartTreeNodes(List<TreeNode> childrenTreeNodes) {
        return childrenTreeNodes.stream().filter(node -> node instanceof OrgChartTreeNode).map(x -> (OrgChartTreeNode)x).sorted(Comparator.comparingLong(OrgChartTreeNode::getIndex)).collect(Collectors.toList());
    }

    public static List<TreeNode> sortTreeNodes(List<OrgChartTreeNode> childrenTreeNodes) {
        return childrenTreeNodes.stream().sorted(Comparator.comparingLong(OrgChartTreeNode::getIndex)).map(dy -> dy).collect(Collectors.toList());
    }

    public static void setShowFieldInfoToTreeNodes(List<OrgChartTreeNode> chartTreeNodeList, ChartStyle matchChartStyle, OrgChartTreeNode treeNode, SearchChartData searchChartData, String structProjectId, List<Long> permOrgResultWithSub) {
        LOG.info("setShowFieldInfoToTreeNodes begin.");
        Map cardStyleIdCardStyleMap = matchChartStyle.getCardStyles().stream().collect(Collectors.toMap(CardStyle::getCarddimensionId, Function.identity()));
        Map<String, List<OrgChartTreeNode>> otclassifyTreeNodesMap = chartTreeNodeList.stream().collect(Collectors.groupingBy(OrgChartTreeNode::getOtclassify));
        otclassifyTreeNodesMap.forEach((key, value) -> {
            CardStyle cardStyle = (CardStyle)cardStyleIdCardStyleMap.get(key);
            if (cardStyle != null) {
                List cardStyleFields = cardStyle.getCardStyleFields();
                OrgChartServiceHelper.setTreeNodeShowFields(cardStyleFields, value, treeNode, searchChartData, structProjectId, permOrgResultWithSub);
            }
        });
    }

    private static void setTreeNodeShowFields(List<CardStyleField> cardStyleFields, List<OrgChartTreeNode> chartTreeNodeList, OrgChartTreeNode rootNode, SearchChartData searchChartData, String structProjectId, List<Long> permOrgResultWithSub) {
        LOG.info("setTreeNodeShowFields begin.");
        Map formIdFieldsMap = cardStyleFields.stream().collect(Collectors.groupingBy(CardStyleField::getEntityidentifier, Collectors.mapping(CardStyleField::getFieldidentifier, Collectors.toSet())));
        Set<Long> orgIds = chartTreeNodeList.stream().map(dy -> Long.parseLong(dy.getBoid())).collect(Collectors.toSet());
        HashMap orgIdShowFieldInfos = new HashMap();
        formIdFieldsMap.forEach((formId, fieldNames) -> OrgChartServiceHelper.getOrgTeamShowFields(orgIds, formId, fieldNames, orgIdShowFieldInfos, searchChartData.getDateField() == null ? new Date() : searchChartData.getDateField(), structProjectId));
        Set fieldNames2 = formIdFieldsMap.get("calculate_api");
        Map<Object, Object> parentIdChildCountMap = Maps.newHashMapWithExpectedSize((int)chartTreeNodeList.size());
        if (!CollectionUtils.isEmpty(fieldNames2) && fieldNames2.contains("orgcount")) {
            LOG.info("setTreeNodeShowFields invoke queryOrgChildCountWithPerm.");
            parentIdChildCountMap = OrgChartServiceHelper.queryOrgChildCountWithPerm(searchChartData.getDateField(), orgIds, Collections.singletonList(OrgChartConstants.DEFAULT_OTCCLASSIFY_ID), structProjectId, permOrgResultWithSub);
        }
        for (OrgChartTreeNode treeNode : chartTreeNodeList) {
            Map showFieldInfos = (Map)orgIdShowFieldInfos.get(treeNode.getBoid());
            if (!CollectionUtils.isEmpty(fieldNames2) && fieldNames2.contains("orgcount")) {
                showFieldInfos.put("orgcount", parentIdChildCountMap.getOrDefault(treeNode.getBoid(), 0L));
            }
            treeNode.setShowFields(showFieldInfos);
        }
        Set personFieldNames = formIdFieldsMap.get("person_api");
        if (!CollectionUtils.isEmpty(personFieldNames) && personFieldNames.contains("totalpersoncount")) {
            OrgChartServiceHelper.calculateOrgAllPersonCount(rootNode);
        }
    }

    private static int calculateOrgAllPersonCount(OrgChartTreeNode rootNode) {
        List children = rootNode.getChildren();
        int count = Integer.parseInt(rootNode.getShowFields().get("totalpersoncount") != null ? rootNode.getShowFields().get("totalpersoncount").toString() : "0");
        if (!CollectionUtils.isEmpty((Collection)children)) {
            for (TreeNode chartTreeNode : children) {
                count += OrgChartServiceHelper.calculateOrgAllPersonCount((OrgChartTreeNode)chartTreeNode);
            }
            Map showFields = rootNode.getShowFields();
            showFields.put("totalpersoncount", count);
        }
        return count;
    }

    public static void getOrgTeamShowFields(Set<Long> orgIds, String formId, Set<String> fieldNames, Map<String, Map<String, Object>> orgIdShowFieldInfos, Date queryDate, String structProjectId) {
        switch (formId) {
            case "haos_adminorgdetail": {
                OrgChartServiceHelper.getMainAdminOrgData(orgIds, fieldNames, orgIdShowFieldInfos, queryDate);
                break;
            }
            case "haos_adminorgstructure": {
                OrgChartServiceHelper.getOrgStructure(orgIds, fieldNames, orgIdShowFieldInfos, queryDate, structProjectId);
                break;
            }
            case "position_api": {
                OrgChartServiceHelper.getPositionDataInfo(orgIds, orgIdShowFieldInfos, queryDate);
                break;
            }
            case "person_api": {
                OrgChartServiceHelper.getPersonDataInfo(orgIds, orgIdShowFieldInfos, queryDate);
                OrgChartServiceHelper.getPersonCountInfo(orgIds, orgIdShowFieldInfos, queryDate);
                break;
            }
            case "staff_api": {
                OrgChartServiceHelper.getStaffDataInfo(orgIds, orgIdShowFieldInfos, queryDate);
                break;
            }
        }
    }

    private static void getStaffDataInfo(Set<Long> orgIds, Map<String, Map<String, Object>> orgIdShowFieldInfos, Date queryDate) {
        StaffOccupyServiceImpl staffOccupyService = new StaffOccupyServiceImpl();
        try {
            HashMap orgIdStaffInfoMap = staffOccupyService.queryUseStaffInfo(queryDate, new ArrayList<Long>(orgIds));
            LOG.info("\u7f16\u5236\u6570\u636e\u67e5\u8be2\u7ed3\u679c: {}, \u7ec4\u7ec7ids: {}, \u65e5\u671f {}", new Object[]{JSONObject.toJSONString((Object)orgIdStaffInfoMap), JSONObject.toJSONString(orgIds), JSONObject.toJSONString((Object)queryDate)});
            if (orgIdStaffInfoMap == null) {
                orgIdStaffInfoMap = new HashMap();
            }
            HashMap finalOrgIdStaffInfoMap = orgIdStaffInfoMap;
            orgIds.forEach(orgId -> {
                Map staffInfoMaps = (Map)finalOrgIdStaffInfoMap.get(String.valueOf(orgId));
                HashMap<String, Integer> fieldInfoMap = new HashMap<String, Integer>();
                if (!CollectionUtils.isEmpty((Map)staffInfoMaps)) {
                    fieldInfoMap.put("staffcount", staffInfoMaps.getOrDefault("staffNum", 0));
                    fieldInfoMap.put("avaliablestaffcount", staffInfoMaps.getOrDefault("remainStaffNum", 0));
                    fieldInfoMap.put("holdstaff", (Integer)fieldInfoMap.get("staffcount") - (Integer)fieldInfoMap.get("avaliablestaffcount"));
                } else {
                    fieldInfoMap.put("staffcount", 0);
                    fieldInfoMap.put("avaliablestaffcount", 0);
                    fieldInfoMap.put("holdstaff", 0);
                }
                Map showFieldInfos = orgIdShowFieldInfos.getOrDefault(orgId.toString(), new HashMap());
                showFieldInfos.putAll(fieldInfoMap);
                orgIdShowFieldInfos.put(orgId.toString(), showFieldInfos);
            });
        }
        catch (Exception e) {
            LOG.error("getStaffDataInfo error ", (Throwable)e);
        }
    }

    private static void getPersonCountInfo(Set<Long> orgIds, Map<String, Map<String, Object>> orgIdShowFieldInfos, Date queryDate) {
        HashMap<String, Serializable> requestMap = new HashMap<String, Serializable>();
        requestMap.put("orgIds", new ArrayList<Long>(orgIds));
        requestMap.put("includeSubOrg", Boolean.valueOf(false));
        requestMap.put("dateTime", OrgChartServiceHelper.isToday(queryDate) ? HRDateTimeUtils.truncateDate((Date)new Date()) : queryDate);
        requestMap.put("jumpFilterBusinessStatus", Boolean.TRUE);
        requestMap.put("customFilter", (Serializable)new QFilter("isprimary", "=", (Object)"1"));
        Map personResult = (Map)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)IHBPM_PERSON_COUNT_SERVICE, (String)"listMainEmpOrgRelByAdminOrg", (Object[])new Object[]{requestMap});
        LOG.info("listMainEmpOrgRelByAdminOrg: {}, orgIds: {}, queryDate: {}", new Object[]{JSONObject.toJSONString((Object)personResult), JSONObject.toJSONString(orgIds), JSONObject.toJSONString((Object)queryDate)});
        if (((Boolean)personResult.get("success")).booleanValue()) {
            Map orgIdPersonInfoMap = (Map)personResult.get("data");
            orgIds.forEach(orgId -> {
                Map personInfoMap = (Map)orgIdPersonInfoMap.get(orgId);
                HashMap<String, Integer> fieldInfoMap = new HashMap<String, Integer>();
                if (!CollectionUtils.isEmpty((Map)personInfoMap)) {
                    fieldInfoMap.put("personcount", personInfoMap.get("count") == null ? Integer.valueOf(0) : personInfoMap.get("count"));
                    fieldInfoMap.put("totalpersoncount", personInfoMap.get("count") == null ? Integer.valueOf(0) : personInfoMap.get("count"));
                } else {
                    fieldInfoMap.put("personcount", 0);
                    fieldInfoMap.put("totalpersoncount", 0);
                }
                Map showFieldInfos = orgIdShowFieldInfos.getOrDefault(orgId.toString(), new HashMap());
                showFieldInfos.putAll(fieldInfoMap);
                orgIdShowFieldInfos.put(orgId.toString(), showFieldInfos);
            });
        }
    }

    private static void getPersonDataInfo(Set<Long> orgIds, Map<String, Map<String, Object>> orgIdShowFieldInfos, Date queryDate) {
        LOG.info("getPersonCountAndChangeInfo start time: {}", (Object)System.currentTimeMillis());
        Map orgIdPersonInfoMap = HRPIRPCServiceHelper.getPersonCountAndChangeInfo(orgIds, (Date)queryDate);
        LOG.info("getPersonCountAndChangeInfo end time: {}", (Object)System.currentTimeMillis());
        orgIds.forEach(orgId -> {
            List personInfoMaps = (List)orgIdPersonInfoMap.get(orgId);
            HashMap<String, Object> fieldInfoMap = new HashMap<String, Object>();
            int hasMorePrimaryPerson = 0;
            if (!CollectionUtils.isEmpty((Collection)personInfoMaps)) {
                Map personInfoMap = (Map)personInfoMaps.get(0);
                String headSculpture = HRImageUrlUtil.getImageFullUrl((String)(personInfoMap.get("headsculpture") == null ? "" : personInfoMap.get("headsculpture").toString()));
                fieldInfoMap.put("personavtor", personInfoMaps.size() > 1 ? "" : headSculpture);
                HashSet personNames = Sets.newHashSetWithExpectedSize((int)personInfoMaps.size());
                for (Map info : personInfoMaps) {
                    if (info == null || info.get("name") == null) continue;
                    personNames.add(info.get("name").toString());
                }
                String originalValue = String.join((CharSequence)";", personNames);
                if (!StringUtils.isEmpty((CharSequence)originalValue)) {
                    Object resultValue = PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_person", (String)"name", (String)Lang.get().toString(), (String)"LIST", null, (Object)originalValue);
                    fieldInfoMap.put("personname", resultValue);
                } else {
                    fieldInfoMap.put("personname", originalValue);
                }
                hasMorePrimaryPerson = personInfoMaps.size() > 1 ? 1 : 0;
            } else {
                fieldInfoMap.put("personname", "");
                fieldInfoMap.put("personavtor", "");
                fieldInfoMap.put("totalpersoncount", 0);
            }
            fieldInfoMap.put("hasMorePrimaryPerson", hasMorePrimaryPerson);
            Map showFieldInfos = orgIdShowFieldInfos.getOrDefault(orgId.toString(), new HashMap());
            showFieldInfos.putAll(fieldInfoMap);
            orgIdShowFieldInfos.put(orgId.toString(), showFieldInfos);
        });
        LOG.info("for each end time: {}", (Object)System.currentTimeMillis());
    }

    public static Object getPersonDesensitizeValue(String currentNodeId, String personName, int isDesensitize, Date queryDate) {
        Object resultValue = "";
        if (isDesensitize == 1) {
            resultValue = PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_person", (String)"name", (String)Lang.get().toString(), (String)"LIST", null, (Object)personName);
        } else {
            Map orgIdPersonInfoMap = HRPIRPCServiceHelper.getPersonCountAndChangeInfo(Collections.singleton(Long.parseLong(currentNodeId)), (Date)queryDate);
            try {
                long orgId = Long.parseLong(currentNodeId);
                List personInfoMaps = (List)orgIdPersonInfoMap.get(orgId);
                if (!CollectionUtils.isEmpty((Collection)personInfoMaps)) {
                    HashSet personnames = new HashSet();
                    personInfoMaps.forEach(info -> personnames.add(info.get("name").toString()));
                    resultValue = String.join((CharSequence)";", personnames);
                }
            }
            catch (Exception exception) {
                LOG.error("getPersonDesensitizeValue error  ", (Throwable)exception);
            }
        }
        return resultValue;
    }

    private static void getPositionDataInfo(Set<Long> orgIds, Map<String, Map<String, Object>> orgIdShowFieldInfos, Date queryDate) {
        Map params = (Map)HRMServiceHelper.invokeHRMPService((String)HBPM, (String)IHBPM_POSITION_SERVICE, (String)"queryPositionHisByOrgIds", (Object[])new Object[]{new ArrayList<Long>(orgIds), queryDate});
        LOG.info("\u5c97\u4f4d\u67e5\u8be2\u7ed3\u679c: {}, \u7ec4\u7ec7ids: {}, \u65e5\u671f {}", new Object[]{JSONObject.toJSONString((Object)params), JSONObject.toJSONString(orgIds), JSONObject.toJSONString((Object)queryDate)});
        if (!CollectionUtils.isEmpty((Map)params) && "200".equals(params.get("code").toString())) {
            List positionList = (List)params.get("data");
            HashMap orgIdPositionInfoMap = new HashMap();
            positionList.forEach(positionInfoMap -> {
                List orgPersonInfos = orgIdPositionInfoMap.getOrDefault(positionInfoMap.get("adminorg").toString(), new ArrayList());
                orgPersonInfos.add(positionInfoMap);
                orgIdPositionInfoMap.put(positionInfoMap.get("adminorg").toString(), orgPersonInfos);
            });
            orgIds.forEach(orgId -> {
                Map showFieldInfos = orgIdShowFieldInfos.getOrDefault(orgId.toString(), new HashMap());
                HashMap<String, Object> fieldInfoMap = new HashMap<String, Object>();
                List positionInfoMaps = (List)orgIdPositionInfoMap.get(orgId.toString());
                if (!CollectionUtils.isEmpty((Collection)positionInfoMaps)) {
                    HashSet positionNames = new HashSet();
                    positionInfoMaps.forEach(info -> {
                        if ("1".equals(info.get("isleader"))) {
                            positionNames.add(info.get("name").toString());
                        }
                    });
                    fieldInfoMap.put("positionname", String.join((CharSequence)";", positionNames));
                    fieldInfoMap.put("positioncount", positionInfoMaps.size());
                } else {
                    fieldInfoMap.put("positionname", "");
                    fieldInfoMap.put("positioncount", 0);
                }
                showFieldInfos.putAll(fieldInfoMap);
                orgIdShowFieldInfos.put(orgId.toString(), showFieldInfos);
            });
        }
    }

    private static void getMainAdminOrgData(Set<Long> orgIds, Set<String> fieldNames, Map<String, Map<String, Object>> orgIdShowFieldInfos, Date datefield) {
        QFilter orgIdFilter = new QFilter("boid", "in", orgIds);
        QFilter[] filters = new QFilter[]{orgIdFilter, OrgChartServiceHelper.getBaseCommonWithoutEnableFilter(datefield)};
        OrgChartServiceHelper.setFieldInfos("haos_adminorgdetail", filters, "boid", fieldNames, orgIdShowFieldInfos);
    }

    private static void getOrgStructure(Set<Long> orgIds, Set<String> fieldNames, Map<String, Map<String, Object>> orgIdShowFieldInfos, Date datefield, String structProjectId) {
        QFilter orgTeamFilter = new QFilter("orgteam", "in", orgIds);
        QFilter structProjectFilter = new QFilter("structproject", "=", (Object)Long.parseLong(structProjectId));
        QFilter[] filters = new QFilter[]{orgTeamFilter, structProjectFilter, OrgChartServiceHelper.getBaseCommonFilterWithDate(datefield)};
        OrgChartServiceHelper.setFieldInfos("haos_adminorgstructure", filters, "orgteam.id", fieldNames, orgIdShowFieldInfos);
    }

    private static void setFieldInfos(String entityName, QFilter[] filters, String key, Set<String> fieldNames, Map<String, Map<String, Object>> orgIdShowFieldInfos) {
        DynamicObject[] queryInfos;
        fieldNames.add(key);
        HashSet completeFieldNames = new HashSet(fieldNames.size());
        fieldNames.forEach(fieldName -> {
            completeFieldNames.add(fieldName);
            if (fieldName.contains(".")) {
                String idFieldName = String.format("%s.id", fieldName.substring(0, fieldName.lastIndexOf(".")));
                completeFieldNames.add(idFieldName);
            }
        });
        String selectProperties = String.join((CharSequence)",", completeFieldNames);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        for (DynamicObject queryInfo : queryInfos = serviceHelper.query(selectProperties, filters)) {
            HashMap fieldInfoMap = new HashMap();
            completeFieldNames.forEach(fieldName -> {
                if (!HRStringUtils.equals((String)key, (String)fieldName)) {
                    if ("isvirtualorg".equals(fieldName)) {
                        fieldInfoMap.put(fieldName, queryInfo.getBoolean(fieldName) ? ResManager.loadKDString((String)"\u662f", (String)"OrgChartServiceHelper_24", (String)"odc-homs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"OrgChartServiceHelper_25", (String)"odc-homs-business", (Object[])new Object[0]));
                    } else {
                        fieldInfoMap.put(fieldName, queryInfo.getString(fieldName));
                    }
                    if ("establishmentdate".equals(fieldName)) {
                        fieldInfoMap.put(fieldName, HRDateTimeUtils.format((Date)queryInfo.getDate(fieldName), (String)"yyyy-MM-dd"));
                    }
                }
            });
            String orgId = queryInfo.getString(key);
            Map showFieldInfos = orgIdShowFieldInfos.getOrDefault(orgId, new HashMap());
            showFieldInfos.putAll(fieldInfoMap);
            orgIdShowFieldInfos.put(orgId, showFieldInfos);
        }
    }

    public static boolean isToday(Date date) {
        return OrgChartServiceHelper.isEquals(new Date(), date);
    }

    public static boolean isEquals(Date date, Date date2) {
        if (date == null || date2 == null) {
            return false;
        }
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = sf.format(date);
        String date2Str = sf.format(date2);
        return dateStr.equals(date2Str);
    }

    public static OrgChartTreeNode wrapTreeNode(DynamicObject dynamicObject, Map<Long, ChartOrgInfo> orgTeamIdOrgTypeMap) {
        OrgChartTreeNode rootNode = new OrgChartTreeNode();
        rootNode.setId(dynamicObject.getString("orgteam.id"));
        rootNode.setBoid(dynamicObject.getString("orgteam.boid"));
        rootNode.setOrg(dynamicObject.getString("orgteam.org"));
        rootNode.setText(dynamicObject.getString("name"));
        rootNode.setParentid(dynamicObject.get("parentorgteam").toString());
        rootNode.setLevel(Integer.valueOf(dynamicObject.getInt("level")));
        rootNode.setLeaf(dynamicObject.getBoolean("isleaf"));
        if (!rootNode.isLeaf()) {
            rootNode.setChildren(new ArrayList());
        }
        rootNode.setIsOpened(false);
        ChartOrgInfo orgTypeInfo = orgTeamIdOrgTypeMap.get(Long.parseLong(rootNode.getId()));
        if (orgTypeInfo != null) {
            rootNode.setData((Object)orgTypeInfo.getOrgType());
            rootNode.setOrgType(orgTypeInfo.getOrgType());
            rootNode.setText(orgTypeInfo.getName());
            rootNode.setNumber(orgTypeInfo.getNumber());
            rootNode.setIndex(Long.valueOf(orgTypeInfo.getIndex() != null ? orgTypeInfo.getIndex() : 0L));
            orgTypeInfo.getOtherInfo().forEach((key, value) -> rootNode.getOtherInfo().put(key, value));
            OrgChartServiceHelper.setIsvirtualorgLable(rootNode, orgTypeInfo);
        } else {
            rootNode.setData((Object)"1010");
            rootNode.setOrgType("1010");
            String oldNumber = dynamicObject.getString("number");
            rootNode.setNumber(oldNumber.length() > 4 ? oldNumber.substring(4) : oldNumber);
            rootNode.setIndex(Long.valueOf(0L));
        }
        rootNode.setOtclassify(dynamicObject.getString("orgteam.otclassify"));
        return rootNode;
    }

    public static OrgChartTreeNode getRootTreeNode(DynamicObject rootNodeDynamicObj, Map<Long, ChartOrgInfo> orgTeamIdOrgTypeMap, boolean isParent) {
        OrgChartTreeNode treeNode = new OrgChartTreeNode(null, rootNodeDynamicObj.getString("orgteam.id"), rootNodeDynamicObj.getString("name"), isParent);
        ChartOrgInfo orgTypeInfo = orgTeamIdOrgTypeMap.get(Long.parseLong(treeNode.getId()));
        if (orgTypeInfo != null) {
            treeNode.setData((Object)orgTypeInfo.getOrgType());
            treeNode.setOrgType(orgTypeInfo.getOrgType());
            treeNode.setText(orgTypeInfo.getName());
            treeNode.setNumber(orgTypeInfo.getNumber());
            treeNode.setIndex(Long.valueOf(orgTypeInfo.getIndex() != null ? orgTypeInfo.getIndex() : 0L));
            orgTypeInfo.getOtherInfo().forEach((key, value) -> treeNode.getOtherInfo().put(key, value));
            OrgChartServiceHelper.setIsvirtualorgLable(treeNode, orgTypeInfo);
        } else {
            treeNode.setData((Object)"1010");
            treeNode.setOrgType("1010");
            String oldNumber = rootNodeDynamicObj.getString("number");
            treeNode.setNumber(oldNumber.length() > 4 ? oldNumber.substring(4) : oldNumber);
            treeNode.setIndex(Long.valueOf(0L));
        }
        treeNode.setOtclassify(rootNodeDynamicObj.getString("orgteam.otclassify"));
        treeNode.setIsOpened(true);
        treeNode.setBoid(rootNodeDynamicObj.getString("orgteam.boid"));
        treeNode.setParentid("0".equals(rootNodeDynamicObj.getString("parentorgteam")) ? null : rootNodeDynamicObj.getString("parentorgteam"));
        treeNode.setOrg(rootNodeDynamicObj.getString("orgteam.org"));
        return treeNode;
    }

    public static SearchChartData getDefaultSearchChartData(Date queryDate) {
        SearchChartData searchChartData = new SearchChartData();
        searchChartData.setAdminOrgTypes(OrgChartServiceHelper.getAdminOrgTypeIds(OrgChartServiceHelper.getDefaultOrg()));
        searchChartData.setCoopRelTypes(Collections.singletonList("1010"));
        searchChartData.setShowLevel("3");
        searchChartData.setOrgChartDirection("1");
        searchChartData.setDateField(queryDate);
        searchChartData.setTeamOtClassify(Collections.singletonList(OrgChartConstants.DEFAULT_OTCCLASSIFY_ID + ""));
        List<Long> defaultOrgIds = OrgChartServiceHelper.getDefaultOrg();
        List<Object> orgIds = new ArrayList();
        if (!CollectionUtils.isEmpty(defaultOrgIds)) {
            orgIds = OrgChartServiceHelper.getDefaultOrg().stream().map(String::valueOf).collect(Collectors.toList());
        }
        searchChartData.setOrgs(orgIds);
        return searchChartData;
    }

    public static SearchChartData getNewDefaultSearchChartData(Date queryDate, List<ChartFilterConfig> chartFilterConfigs) {
        SearchChartData searchChartData = new SearchChartData();
        searchChartData.setAdminOrgTypes(OrgChartServiceHelper.getAdminOrgTypeIds(OrgChartServiceHelper.getDefaultOrg()));
        searchChartData.setCoopRelTypes(Collections.singletonList("1010"));
        searchChartData.setShowLevel("3");
        searchChartData.setOrgChartDirection("1");
        searchChartData.setDateField(queryDate);
        searchChartData.setTeamOtClassify(Collections.singletonList(OrgChartConstants.DEFAULT_OTCCLASSIFY_ID + ""));
        List<Long> defaultOrgIds = OrgChartServiceHelper.getDefaultOrg();
        List<Object> orgIds = new ArrayList();
        if (!CollectionUtils.isEmpty(defaultOrgIds)) {
            orgIds = OrgChartServiceHelper.getDefaultOrg().stream().map(String::valueOf).collect(Collectors.toList());
        }
        searchChartData.setOrgs(orgIds);
        for (ChartFilterConfig chartFilterConfig : chartFilterConfigs) {
            if (ChartFilterConfig.DEFAULT_FILTER_NUMBERS.contains(chartFilterConfig.getNumber()) || !"1".equals(chartFilterConfig.getType()) || "0".equals(chartFilterConfig.getMustInput())) continue;
            searchChartData.getExtSearchData().put(chartFilterConfig.getNumber(), OrgChartServiceHelper.getValues(chartFilterConfig.getMetaDataNumber()));
        }
        return searchChartData;
    }

    public static List<String> getValues(String entityNumber) {
        ArrayList<String> result = new ArrayList<String>();
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "in", Arrays.asList("1", "0"));
        Object[] dynamicObjects = helper.queryOriginalArray("id", new QFilter[]{statusFilter, enableFilter});
        if (!ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            for (Object dyn : dynamicObjects) {
                result.add(dyn.getString("id"));
            }
        }
        return result;
    }

    public static List<Long> getDefaultOrg() {
        return OrgChartServiceHelper.getDefaultOrg("homs_orgchart");
    }

    public static List<Long> getDefaultOrg(String entityName) {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        HasPermOrgResult permOrg = OrgPermHelper.getHRPermOrg((String)entityName);
        if (permOrg.hasAllOrgPerm()) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_org_structure");
            QFilter viewFilter = new QFilter("view.number", "=", (Object)"21");
            Object[] orgStructures = helper.query("org.id", new QFilter[]{viewFilter});
            if (!ArrayUtils.isEmpty((Object[])orgStructures)) {
                Stream.of(orgStructures).forEach(dy -> orgIds.add(dy.getLong("org.id")));
            }
        } else {
            orgIds.addAll(permOrg.getHasPermOrgs());
        }
        return orgIds;
    }

    public static SearchChartData getSchemeSearchChartData(OrgChartQueryParam orgChartQueryParam) {
        if (orgChartQueryParam == null) {
            return OrgChartServiceHelper.getDefaultSearchChartData(new Date());
        }
        SearchChartData searchChartData = new SearchChartData();
        searchChartData.setAdminOrgTypes(orgChartQueryParam.getAdminOrgTypes());
        searchChartData.setCoopRelTypes(orgChartQueryParam.getCoopRelTypes());
        searchChartData.setShowLevel(orgChartQueryParam.getShowLevel());
        searchChartData.setOrgChartDirection(orgChartQueryParam.getOrgChartDirection());
        Date queryDate = OrgChartServiceHelper.getQueryDate(orgChartQueryParam);
        searchChartData.setDateField(queryDate);
        searchChartData.setTeamOtClassify(orgChartQueryParam.getTeamotclassify());
        searchChartData.setCurrentOrgChartRootNodeId(orgChartQueryParam.getCurrentOrgChartRootNodeId());
        searchChartData.setChartStyleId(orgChartQueryParam.getChartStyleId());
        searchChartData.setPersonalStyleId(orgChartQueryParam.getPersonalStyleId());
        searchChartData.setOpenPersonalStyle(Boolean.valueOf(orgChartQueryParam.isOpenPersonalStyle()));
        searchChartData.setOrgs(orgChartQueryParam.getOrgs());
        searchChartData.setPositionId(orgChartQueryParam.getPositionId());
        searchChartData.setExtSearchData(orgChartQueryParam.getExtSearchData());
        return searchChartData;
    }

    public static Date getQueryDate(OrgChartQueryParam orgChartQueryParam) {
        Date queryDate = new Date();
        if (!"today".equals(orgChartQueryParam.getQueryDate())) {
            try {
                queryDate = HRDateTimeUtils.parseDate((String)orgChartQueryParam.getQueryDate(), (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                LOG.error(MessageFormat.format("date:{0}", orgChartQueryParam.getQueryDate()));
            }
        }
        return queryDate;
    }

    public static PersonalStyleData getPersonalStyleById(String personalStyleId) {
        if (StringUtils.isEmpty((CharSequence)personalStyleId)) {
            return null;
        }
        HRBaseServiceHelper personalStyleHelper = new HRBaseServiceHelper("homs_personalstyle");
        QFilter idFilter = new QFilter("id", "=", (Object)Long.parseLong(personalStyleId));
        DynamicObject personalStyle = personalStyleHelper.loadDynamicObject(new QFilter[]{idFilter});
        if (personalStyle != null) {
            String content = personalStyle.getString("content_tag");
            PersonalStyleData personalStyleData = (PersonalStyleData)JSONObject.parseObject((String)content, PersonalStyleData.class);
            personalStyleData.setId(personalStyle.getString("id"));
            return personalStyleData;
        }
        return null;
    }

    public static QFilter getDefaultFilter(Date queryDate) {
        QFilter teamOtClassifyFilter = new QFilter("orgteam.otclassify", "=", (Object)OrgChartConstants.DEFAULT_OTCCLASSIFY_ID);
        return teamOtClassifyFilter.and(OrgChartServiceHelper.getBaseCommonFilterWithDate(queryDate));
    }

    public static QFilter getSchemeFilter(OrgChartQueryParam orgChartQueryParam) {
        return OrgChartServiceHelper.getSchemeFilter(orgChartQueryParam, null);
    }

    public static QFilter getSchemeFilter(OrgChartQueryParam orgChartQueryParam, Date queryDate) {
        if (orgChartQueryParam == null) {
            return OrgChartServiceHelper.getDefaultFilter(new Date());
        }
        queryDate = queryDate != null ? queryDate : OrgChartServiceHelper.getQueryDate(orgChartQueryParam);
        QFilter teamOtClassifyFilter = new QFilter("orgteam.otclassify", "=", (Object)Long.parseLong((String)orgChartQueryParam.getTeamotclassify().get(0)));
        return teamOtClassifyFilter.and(OrgChartServiceHelper.getBaseCommonFilterWithDate(queryDate));
    }

    public static QFilter getPermOrgQFilter(AuthorizedOrgResultWithSub permOrgResultWithSub, Date queryDate, String structProjectId) {
        ArrayList<String> structLongNumberList = new ArrayList<String>(16);
        ArrayList<Long> orgIdWithOutSub = new ArrayList<Long>(16);
        OrgChartServiceHelper.getHisPermStructLongNumberLikeAndOutSub(permOrgResultWithSub, orgIdWithOutSub, structLongNumberList, queryDate, structProjectId);
        if (!CollectionUtils.isEmpty(structLongNumberList) && !CollectionUtils.isEmpty(orgIdWithOutSub)) {
            QFilter structLongNumberFilter = QFilter.ftlike((boolean)true, (String[])structLongNumberList.toArray(new String[0]), (String[])new String[]{"structlongnumber"});
            QFilter permOrgsFilter = new QFilter("orgteam.boid", "in", orgIdWithOutSub);
            structLongNumberFilter.or(permOrgsFilter);
            return structLongNumberFilter;
        }
        if (CollectionUtils.isEmpty(structLongNumberList) && !CollectionUtils.isEmpty(orgIdWithOutSub)) {
            return new QFilter("orgteam.boid", "in", orgIdWithOutSub);
        }
        if (!CollectionUtils.isEmpty(structLongNumberList) && CollectionUtils.isEmpty(orgIdWithOutSub)) {
            return QFilter.ftlike((boolean)true, (String[])structLongNumberList.toArray(new String[0]), (String[])new String[]{"structlongnumber"});
        }
        return null;
    }

    public static QFilter getOrgFilter(List<String> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return null;
        }
        ArrayList orgs = Lists.newArrayListWithExpectedSize((int)orgIds.size());
        orgIds.forEach(orgId -> orgs.add(Long.parseLong(orgId)));
        return new QFilter("orgteam.org", "in", (Object)orgs);
    }

    public static Boolean isMatchCondition(OrgChartTreeNode currentNode, SearchChartData searchChartData) {
        if (currentNode != null && Boolean.TRUE.equals(currentNode.getVirtualOrgFlag())) {
            return true;
        }
        AtomicBoolean result = new AtomicBoolean(true);
        if (currentNode != null && !searchChartData.getAdminOrgTypes().contains(currentNode.getOrgType())) {
            result.set(false);
        }
        return result.get();
    }

    public static QFilter getBaseCommonFilterWithDate(Date queryDate) {
        QFilter queryDateFilter = new QFilter("bsled", ">=", (Object)(queryDate == null ? new Date() : queryDate));
        queryDateFilter.and(new QFilter("bsed", "<=", (Object)(queryDate == null ? new Date() : queryDate)));
        return queryDateFilter.and(OrgChartServiceHelper.getBaseCommonFilter());
    }

    public static QFilter getBaseCommonWithoutEnableFilter(Date queryDate) {
        QFilter queryDateFilter = new QFilter("bsled", ">=", (Object)(queryDate == null ? new Date() : queryDate));
        queryDateFilter.and(new QFilter("bsed", "<=", (Object)(queryDate == null ? new Date() : queryDate)));
        return queryDateFilter.and(OrgChartServiceHelper.getBaseCommonWithoutEnableFilter());
    }

    public static QFilter getBaseCommonFilter() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        enableFilter.and(OrgChartServiceHelper.getBaseCommonWithoutEnableFilter());
        return enableFilter;
    }

    public static QFilter getBaseCommonWithoutEnableFilter() {
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2", "0"));
        currentVersionFilter.and(dataStatusFilter);
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        currentVersionFilter.and(initStatusFilter);
        return currentVersionFilter;
    }

    public static QFilter getRealRootOrgStructLongNumberQFilter(String realRootOrgStructLongNumber) {
        if (StringUtils.isEmpty((CharSequence)realRootOrgStructLongNumber)) {
            return null;
        }
        return new QFilter("structlongnumber", "like", (Object)(realRootOrgStructLongNumber + "%"));
    }

    public static Set<String> getChartStyleIds(AuthorizedOrgResultWithSub permOrgResultWithSub, Long crtsStyDimensionId) {
        if (permOrgResultWithSub.isHasAllOrgPerm()) {
            Set<String> chartStyleIds = CommonOrgChartServiceHelper.getChartStyleIdsByCardDimensionId(crtsStyDimensionId);
            if (OrgChartConstants.ORG_CARDDISSION.equals(crtsStyDimensionId) && !OrgChartNewServiceHelper.isUseNewStructureChart() && !chartStyleIds.isEmpty()) {
                QFilter cardIdFilter = new QFilter("cardstyleflag", "!=", (Object)"1");
                List collect = chartStyleIds.stream().map(Long::parseLong).collect(Collectors.toList());
                DynamicObject[] chartStyles = OrgChartNewServiceHelper.getChartStyleHelper().query("id,chartstyleentry,chartstyleentry.cardstyle", new QFilter[]{new QFilter("id", "in", collect)});
                HashMap idToCardStyleIds = Maps.newHashMapWithExpectedSize((int)16);
                for (DynamicObject dyn2 : chartStyles) {
                    Set cardStyleIds = dyn2.getDynamicObjectCollection("chartstyleentry").stream().map(dynObj -> dynObj.getLong("cardstyle.id")).collect(Collectors.toSet());
                    idToCardStyleIds.put(dyn2.getString("id"), cardStyleIds);
                }
                DynamicObject[] query = OrgChartNewServiceHelper.getCardStyleNewHelper().query("id", new QFilter[]{cardIdFilter});
                List idList = Arrays.stream(query).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
                if (!idList.isEmpty()) {
                    return Arrays.stream(chartStyles).filter(chartStyle -> {
                        Set idSet = (Set)idToCardStyleIds.get(chartStyle.getString("id"));
                        return idList.containsAll(idSet);
                    }).map(chartStyle -> String.valueOf(chartStyle.getLong("id"))).collect(Collectors.toSet());
                }
            }
            return chartStyleIds;
        }
        List orgWithSubs = permOrgResultWithSub.getHasPermOrgsWithSub();
        HashSet<String> orgWithSubLongStructNumbers = new HashSet<String>();
        HashSet<Long> orgNotSubIds = new HashSet<Long>();
        orgWithSubs.forEach(orgSubInfo -> {
            if (orgSubInfo.isContainsSub()) {
                orgWithSubLongStructNumbers.add(orgSubInfo.getLongStructNumber());
            } else {
                orgNotSubIds.add(orgSubInfo.getOrgId());
            }
            if (orgSubInfo.getStructProjectId() != null && orgSubInfo.getStructProjectId().equals(1010L)) {
                orgWithSubLongStructNumbers.add(orgSubInfo.getLongStructNumber());
            }
        });
        Set<String> chartStyleIds = OrgChartServiceHelper.getChartStyleIdsByTeamOrgWithSubIds(orgWithSubLongStructNumbers, Collections.singletonList(crtsStyDimensionId));
        Set<String> chartStyleIdsByTeamOrgIds = OrgChartServiceHelper.getChartStyleIdsByTeamOrgIds(orgNotSubIds, Collections.singletonList(crtsStyDimensionId));
        chartStyleIds.addAll(chartStyleIdsByTeamOrgIds);
        if (OrgChartConstants.ORG_CARDDISSION.equals(crtsStyDimensionId) && !OrgChartNewServiceHelper.isUseNewStructureChart() && !chartStyleIds.isEmpty()) {
            QFilter cardIdFilter = new QFilter("cardstyleflag", "!=", (Object)"1");
            List collect = chartStyleIds.stream().map(Long::parseLong).collect(Collectors.toList());
            DynamicObject[] chartStyles = OrgChartNewServiceHelper.getChartStyleHelper().query("id,chartstyleentry.cardstyle", new QFilter[]{new QFilter("id", "in", collect)});
            HashMap idToCardStyleIds = Maps.newHashMapWithExpectedSize((int)16);
            for (DynamicObject dyn3 : chartStyles) {
                Set cardStyleIds = dyn3.getDynamicObjectCollection("chartstyleentry").stream().map(dynObj -> dynObj.getLong("cardstyle_id")).collect(Collectors.toSet());
                idToCardStyleIds.put(dyn3.getString("id"), cardStyleIds);
            }
            DynamicObject[] query = OrgChartNewServiceHelper.getCardStyleNewHelper().query("id", new QFilter[]{cardIdFilter});
            List idList = Arrays.stream(query).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
            if (!idList.isEmpty()) {
                return Arrays.stream(chartStyles).filter(chartStyle -> {
                    Set idSet = (Set)idToCardStyleIds.get(chartStyle.getString("id"));
                    return idList.containsAll(idSet);
                }).map(chartStyle -> String.valueOf(chartStyle.getLong("id"))).collect(Collectors.toSet());
            }
        }
        return chartStyleIds;
    }

    public static Set<Long> getCardStyleIds(AuthorizedOrgResultWithSub permOrgResultWithSub) {
        LOG.info("kd.hr.homs.business.service.orgchart.OrgChartServiceHelper.getCardStyleIds,permOrgResultWithSub:" + JSONObject.toJSONString((Object)permOrgResultWithSub));
        if (permOrgResultWithSub.isHasAllOrgPerm()) {
            return OrgChartServiceHelper.getAllCardStyleIds(null);
        }
        List orgWithSubs = permOrgResultWithSub.getHasPermOrgsWithSub();
        HashSet<Long> orgNotSubIds = new HashSet<Long>();
        HashSet<String> orgWithSubLongStructNumbers = new HashSet<String>();
        orgWithSubs.forEach(orgSubInfo -> {
            if (orgSubInfo.isContainsSub()) {
                orgWithSubLongStructNumbers.add(orgSubInfo.getLongStructNumber());
            } else {
                orgNotSubIds.add(orgSubInfo.getOrgId());
            }
        });
        Set<Long> cardStyleIds = OrgChartServiceHelper.getCardStyleIdsByTeamOrgWithSubIds(orgWithSubLongStructNumbers);
        LOG.info("kd.hr.homs.business.service.orgchart.OrgChartServiceHelper.getCardStyleIds,cardStyleIds:" + JSONObject.toJSONString(cardStyleIds));
        Set<Long> cardStyleIdsByTeamOrgIds = OrgChartServiceHelper.getCardStyleIdsByTeamOrgIds(orgNotSubIds);
        LOG.info("kd.hr.homs.business.service.orgchart.OrgChartServiceHelper.getCardStyleIds,cardStyleIdsByTeamOrgIds:" + JSONObject.toJSONString(cardStyleIdsByTeamOrgIds));
        cardStyleIds.addAll(cardStyleIdsByTeamOrgIds);
        return cardStyleIds;
    }

    public static Set<Long> getAllCardStyleIds(QFilter filter) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_cardstyle");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        enableFilter.and(new QFilter("status", "=", (Object)"C"));
        if (filter != null) {
            enableFilter.and(filter);
        }
        DynamicObject[] cardStyles = serviceHelper.query(enableFilter.toArray());
        HashSet<Long> cardStyleIds = new HashSet<Long>();
        Stream.of(cardStyles).forEach(dy -> cardStyleIds.add(dy.getLong("id")));
        return cardStyleIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Integer> calculateQueryLevelsByRootOrg(int rootOrgLevel, String rootOrgStructLongNumber, Date date, List<Long> permOrgIds, List<String> structLongNumberList, List<Long> otClassifyIds, boolean isLeftTree, List<String> orgIds, String structProjectId) {
        TreeSet<Integer> orgLevels = new TreeSet<Integer>();
        if (isLeftTree) {
            orgLevels.add(rootOrgLevel + 1);
        }
        long count = 0L;
        try (AbstractPKTempTable pkTempTable = null;){
            ArrayList<Object> params = new ArrayList<Object>(permOrgIds.size() + structLongNumberList.size());
            params.add(date);
            params.add(date);
            if (permOrgIds.size() < HugeInConfig.inThreshold()) {
                params.addAll(permOrgIds);
            } else {
                pkTempTable = CommonOrgChartServiceHelper.getPKTempTable(1);
            }
            params.addAll(structLongNumberList);
            String sql = OrgChartServiceHelper.getQueryLevelsSql2(rootOrgLevel, rootOrgStructLongNumber, date, permOrgIds, structLongNumberList, otClassifyIds, orgIds, pkTempTable, structProjectId);
            try (DataSet rs = HRDBUtil.queryDataSet((String)"calculateQueryLevelsByRootOrg", (DBRoute)new DBRoute("haos"), (String)sql, CollectionUtils.isEmpty(params) ? null : params.toArray(new Object[0]));){
                Row data;
                Long orgCount;
                long tempCount;
                while (rs.hasNext() && (tempCount = count + (orgCount = (data = rs.next()).getLong("orgcount"))) <= 3000L) {
                    count = tempCount;
                    orgLevels.add(data.getInteger("flevel"));
                }
            }
        }
        return orgLevels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, Long> getLevelAndOrgCountByRootOrg(int rootOrgLevel, String rootOrgStructLongNumber, Date date, List<Long> permOrgIds, List<String> structLongNumberList, List<Long> otClassifyIds, List<String> orgIds, String structProjectId) {
        ArrayList<Object> params = new ArrayList<Object>(permOrgIds.size() + structLongNumberList.size());
        params.add(date);
        params.add(date);
        HashMap<Integer, Long> levelAndCountMap = new HashMap<Integer, Long>();
        try (AbstractPKTempTable pkTempTable = null;){
            if (permOrgIds.size() < HugeInConfig.inThreshold()) {
                params.addAll(permOrgIds);
            } else {
                pkTempTable = CommonOrgChartServiceHelper.getPKTempTable(1);
            }
            params.addAll(structLongNumberList);
            String sql = OrgChartServiceHelper.getQueryLevelsSql2(rootOrgLevel, rootOrgStructLongNumber, date, permOrgIds, structLongNumberList, otClassifyIds, orgIds, pkTempTable, structProjectId);
            try (DataSet rs = HRDBUtil.queryDataSet((String)"calculateQueryLevelsByRootOrg", (DBRoute)new DBRoute("haos"), (String)sql, CollectionUtils.isEmpty(params) ? null : params.toArray(new Object[0]));){
                while (rs.hasNext()) {
                    Row data = rs.next();
                    levelAndCountMap.put(data.getInteger("flevel"), data.getLong("orgcount"));
                }
            }
        }
        return levelAndCountMap;
    }

    public static void getHisPermStructLongNumberLikeAndOutSub(AuthorizedOrgResultWithSub permOrgResultWithSub, List<Long> orgIdWithOutSub, List<String> structLongNumberList, Date queryDate, String structProjectId) {
        List permOrgWithSub = permOrgResultWithSub.getHasPermOrgsWithSub();
        ArrayList<Long> orgWithSub = new ArrayList<Long>(permOrgWithSub.size());
        for (OrgSubInfo subInfo : permOrgWithSub) {
            if (subInfo.isContainsSub()) {
                orgWithSub.add(subInfo.getOrgId());
                continue;
            }
            orgIdWithOutSub.add(subInfo.getOrgId());
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        QFilter filter = new QFilter("orgteam.boid", "in", orgWithSub);
        filter.and(OrgChartServiceHelper.getDefaultFilter(queryDate));
        filter.and(new QFilter("structproject", "=", (Object)Long.parseLong(structProjectId)));
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("structlongnumber", filter.toArray());
        Arrays.stream(dynamicObjects).forEach(dynamicObject -> structLongNumberList.add(dynamicObject.getString("structlongnumber")));
        LOG.info("getHisPermStructLongNumberLikeAndOutSub:{}", structLongNumberList);
    }

    private static String getQueryLevelsSql2(int rootOrgLevel, String rootOrgStructLongNumber, Date date, List<Long> permOrgIdWithOutSubs, List<String> structLongNumberList, List<Long> otClassifyIds, List<String> orgIds, AbstractPKTempTable pkTempTable, String structProjectId) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("select t1.flevel,count(*) orgcount   from T_HAOS_ORGTEAMSTRUCT t1 \nLEFT JOIN T_HAOS_ORGTEAM t2 on t1.forgteamid=t2.fid where t1.finitstatus='2' AND t1.fiscurrentversion = '0' and t1.fenable='1' and t1.fdatastatus in ('1','2') ");
        sb.append(" and t1.flevel>").append(rootOrgLevel);
        if (HRStringUtils.isNotEmpty((String)structProjectId)) {
            sb.append(" and t1.fstructprojectid = ").append(structProjectId);
        }
        sb.append(" and t1.flevel>").append(rootOrgLevel);
        if (!CollectionUtils.isEmpty(orgIds)) {
            sb.append(" and t2.forgid in (");
            for (i = 0; i < orgIds.size(); ++i) {
                sb.append(orgIds.get(i));
                if (i >= orgIds.size() - 1) continue;
                sb.append(',');
            }
            sb.append(')');
        }
        sb.append(" and t1.fstructlongnumber like '").append(rootOrgStructLongNumber).append("%'");
        sb.append(" and t1.fbsed <= ? ").append("and   t1.fbsled >= ? ");
        if (!CollectionUtils.isEmpty(otClassifyIds)) {
            sb.append(" and t2.fotclassify in (");
            for (i = 0; i < otClassifyIds.size(); ++i) {
                sb.append(otClassifyIds.get(i));
                if (i >= otClassifyIds.size() - 1) continue;
                sb.append(',');
            }
            sb.append(')');
        }
        sb.append(OrgChartServiceHelper.getPermOrgQuerySql(permOrgIdWithOutSubs, structLongNumberList, pkTempTable));
        sb.append(" GROUP BY t1.flevel ORDER BY t1.flevel");
        return sb.toString();
    }

    public static String getPermOrgQuerySql(List<Long> permOrgIdWithOutSubs, List<String> structLongNumberList, AbstractPKTempTable pkTempTable) {
        int i;
        if (CollectionUtils.isEmpty(permOrgIdWithOutSubs) && CollectionUtils.isEmpty(structLongNumberList)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (!CollectionUtils.isEmpty(permOrgIdWithOutSubs) && !CollectionUtils.isEmpty(structLongNumberList)) {
            sb.append(" and (");
            sb.append(" t2.fboid in (");
            sb.append(CommonOrgChartServiceHelper.buildSourceSql(permOrgIdWithOutSubs, pkTempTable));
            sb.append(")");
            sb.append(" or ");
            for (i = 0; i < structLongNumberList.size(); ++i) {
                sb.append(" t1.fstructlongnumber  LIKE ?");
                if (i >= structLongNumberList.size() - 1) continue;
                sb.append(" OR ");
            }
            sb.append(" )");
        }
        if (!CollectionUtils.isEmpty(permOrgIdWithOutSubs) && CollectionUtils.isEmpty(structLongNumberList)) {
            sb.append(" and ");
            sb.append(" t2.fboid in (");
            sb.append(CommonOrgChartServiceHelper.buildSourceSql(permOrgIdWithOutSubs, pkTempTable));
            sb.append(")");
        }
        if (CollectionUtils.isEmpty(permOrgIdWithOutSubs) && !CollectionUtils.isEmpty(structLongNumberList)) {
            sb.append(" and (");
            for (i = 0; i < structLongNumberList.size(); ++i) {
                sb.append(" t1.fstructlongnumber  LIKE ?");
                if (i >= structLongNumberList.size() - 1) continue;
                sb.append(" OR ");
            }
            sb.append(" )");
        }
        return sb.toString();
    }

    public static Set<Long> getCardStyleIdsByTeamOrgWithSubIds(Set<String> orgWithSubLongStructNumbers) {
        HashMap<Long, Set> cardStyleIdStructLongNumbersMap = new HashMap<Long, Set>();
        String sb = "select t1.fid,t2.fboid,t3.forgteamid,t3.fstructlongnumber from   t_homs_cardstyleorgentry t1 LEFT JOIN T_HAOS_ORGTEAM t2 on t1.fadminorgid = t2.fid LEFT JOIN T_HAOS_ORGTEAMSTRUCT t3 on t2.fid = t3.forgteamid where t3.fiscurrentversion='1' and t1.fiscontainslower='1'";
        try (DataSet rs = HRDBUtil.queryDataSet((String)"t_homs_cardstyleorgentry", (DBRoute)new DBRoute("haos"), (String)sb, null);){
            for (Row data : rs) {
                Long cardStyleId2 = data.getLong("fid");
                Set structLongNumbers2 = cardStyleIdStructLongNumbersMap.getOrDefault(cardStyleId2, new TreeSet((o1, o2) -> {
                    int n1 = o2.length() - o1.length();
                    int n2 = o1.compareTo((String)o2);
                    return n1 == 0 ? n2 : n1;
                }));
                structLongNumbers2.add(data.getString("fstructlongnumber"));
                cardStyleIdStructLongNumbersMap.put(cardStyleId2, structLongNumbers2);
            }
        }
        HashSet<Long> cardStyleIds = new HashSet<Long>();
        LOG.info("kd.hr.homs.business.service.orgchart.OrgChartServiceHelper.getCardStyleIdsByTeamOrgWithSubIds,cardStyleIdStructLongNumbersMap:" + JSONObject.toJSONString(cardStyleIdStructLongNumbersMap));
        cardStyleIdStructLongNumbersMap.forEach((cardStyleId, structLongNumbers) -> {
            for (String structLongNumber : structLongNumbers) {
                if (orgWithSubLongStructNumbers.contains(structLongNumber)) {
                    cardStyleIds.add((Long)cardStyleId);
                    break;
                }
                if (!OrgChartServiceHelper.findInStrStartInSet(structLongNumber, orgWithSubLongStructNumbers)) continue;
                cardStyleIds.add((Long)cardStyleId);
                break;
            }
        });
        return cardStyleIds;
    }

    public static Set<String> getChartStyleIdsByTeamOrgWithSubIds(Set<String> orgWithSubLongStructNumbers, List<Long> cardDimensionIds) {
        HashSet<String> chartStyleIds = new HashSet<String>();
        if (CollectionUtils.isEmpty(orgWithSubLongStructNumbers)) {
            return chartStyleIds;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select t1.fid,t2.fboid,t3.forgteamid,t3.fstructlongnumber from   t_homs_chastyorgentry t1 LEFT JOIN T_HAOS_ORGTEAM t2 on t1.fadminorgid = t2.fid LEFT JOIN T_HAOS_ORGTEAMSTRUCT t3 on t2.fid = t3.forgteamid LEFT JOIN T_HOMS_CHARTSTYLE t5 on  t5.fid=t1.fid  where t3.fiscurrentversion='1' and t1.fiscontainslower='1' and t5.fenable='1' and t5.fstatus='C'");
        if (!CollectionUtils.isEmpty(cardDimensionIds)) {
            sb.append(" and t5.fcarddimensionid in (");
            for (int i = 0; i < cardDimensionIds.size(); ++i) {
                sb.append(cardDimensionIds.get(i));
                if (i >= cardDimensionIds.size() - 1) continue;
                sb.append(',');
            }
            sb.append(')');
        }
        HashMap<String, Set> chartStyleIdStructLongNumbersMap = new HashMap<String, Set>();
        try (DataSet rs = HRDBUtil.queryDataSet((String)"t_homs_chastyorgentry", (DBRoute)new DBRoute("haos"), (String)sb.toString(), null);){
            for (Row data : rs) {
                String chartStyleId2 = data.getString("fid");
                Set structLongNumbers2 = chartStyleIdStructLongNumbersMap.getOrDefault(chartStyleId2, new TreeSet((o1, o2) -> {
                    int n1 = o2.length() - o1.length();
                    int n2 = o1.compareTo((String)o2);
                    return n1 == 0 ? n2 : n1;
                }));
                structLongNumbers2.add(data.getString("fstructlongnumber"));
                chartStyleIdStructLongNumbersMap.put(chartStyleId2, structLongNumbers2);
            }
        }
        chartStyleIdStructLongNumbersMap.forEach((chartStyleId, structLongNumbers) -> {
            for (String structLongNumber : structLongNumbers) {
                if (orgWithSubLongStructNumbers.contains(structLongNumber)) {
                    chartStyleIds.add((String)chartStyleId);
                    break;
                }
                if (!OrgChartServiceHelper.findInStrStartInSet(structLongNumber, orgWithSubLongStructNumbers)) continue;
                chartStyleIds.add((String)chartStyleId);
                break;
            }
        });
        return chartStyleIds;
    }

    public static boolean findInStrStartInSet(String structLongNumber, Set<String> orgWithSubLongStructNumbers) {
        for (String orgWithSubLongStructNumber : orgWithSubLongStructNumbers) {
            if (structLongNumber.length() < orgWithSubLongStructNumber.length() && orgWithSubLongStructNumber.startsWith(structLongNumber)) {
                return true;
            }
            if (structLongNumber.length() < orgWithSubLongStructNumber.length() || !structLongNumber.startsWith(orgWithSubLongStructNumber)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getChartStyleIdsByTeamOrgIds(Collection<Long> teamOrgIds, List<Long> cardDimensionIds) {
        HashSet<String> chartStyleIds = new HashSet<String>();
        if (!CollectionUtils.isEmpty(teamOrgIds)) {
            int i;
            StringBuilder sb = new StringBuilder();
            sb.append("select DISTINCT a.fid,a.fadminorgid,b.fname  from t_homs_chastyorgentry a LEFT JOIN t_homs_chartstyle b on  a.fid=b.fid  left JOIN t_haos_orgteam c on a.fadminorgid=c.fid where b.fenable='1' and b.fstatus='C' ");
            if (!CollectionUtils.isEmpty(cardDimensionIds)) {
                sb.append(" and b.fcarddimensionid in (");
                for (i = 0; i < cardDimensionIds.size(); ++i) {
                    sb.append(cardDimensionIds.get(i));
                    if (i >= cardDimensionIds.size() - 1) continue;
                    sb.append(',');
                }
                sb.append(')');
            }
            sb.append("and c.fboid in(");
            for (i = 0; i < teamOrgIds.size(); ++i) {
                sb.append('?');
                if (i >= teamOrgIds.size() - 1) continue;
                sb.append(',');
            }
            sb.append(')');
            try (DataSet rs = HRDBUtil.queryDataSet((String)"t_homs_chastyorgentry", (DBRoute)new DBRoute("haos"), (String)sb.toString(), (Object[])teamOrgIds.toArray());){
                rs.forEach(data -> chartStyleIds.add(data.getString("fid")));
            }
        }
        return chartStyleIds;
    }

    public static Set<Long> getCardStyleIdsByTeamOrgIds(Collection<Long> teamOrgIds) {
        HashSet<Long> cardStyleIds = new HashSet<Long>();
        if (!CollectionUtils.isEmpty(teamOrgIds)) {
            StringBuilder sb = new StringBuilder();
            sb.append("select DISTINCT a.fid,a.fadminorgid,b.fname  from t_homs_cardstyleorgentry a LEFT JOIN t_homs_cardstyle b on  a.fid=b.fid  left JOIN t_haos_orgteam c on a.fadminorgid=c.fid where b.fenable='1' and b.fstatus='C' and b.fusage='1' and c.fboid in(");
            for (int i = 0; i < teamOrgIds.size(); ++i) {
                sb.append('?');
                if (i >= teamOrgIds.size() - 1) continue;
                sb.append(',');
            }
            sb.append(')');
            try (DataSet rs = HRDBUtil.queryDataSet((String)"t_homs_cardstyleorgentry", (DBRoute)new DBRoute("haos"), (String)sb.toString(), (Object[])teamOrgIds.toArray());){
                rs.forEach(data -> cardStyleIds.add(data.getLong("fid")));
            }
        }
        return cardStyleIds;
    }

    public static ChartStyle getChartStyleById(String chartStyleId) {
        if (StringUtils.isEmpty((CharSequence)chartStyleId)) {
            return null;
        }
        return OrgChartServiceHelper.getChartStyles(Collections.singleton(chartStyleId)).get(chartStyleId);
    }

    public static Map<String, ChartStyle> getChartStyleByIds(String chartStyleId) {
        ArrayList<String> chartStyleIds = new ArrayList<String>();
        chartStyleIds.add(chartStyleId);
        chartStyleIds.add(VIRTUALORG_CHARTSTYLE);
        return OrgChartServiceHelper.getChartStyles(chartStyleIds);
    }

    public static Map<String, Object> getQueryShowParamsByScheme(OrgChartQueryParam orgChartQueryParam, FilterScheme defaultScheme) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("queryDate", OrgChartServiceHelper.getQueryDate(orgChartQueryParam));
        Map<String, ChartStyle> chartStyleMap = OrgChartServiceHelper.getChartStyleByIds(orgChartQueryParam.getChartStyleId());
        ChartStyle chartStyle = chartStyleMap.get(orgChartQueryParam.getChartStyleId());
        result.put("MATCH_CHART_STYLE_KEY", chartStyle);
        result.put(VIRTUALORG_STYLE, chartStyleMap.get(VIRTUALORG_CHARTSTYLE));
        result.put("isShowEye", OrgChartServiceHelper.getIsShowEye(chartStyle, OrgChartServiceHelper.getDesensitizeFields(OrgChartConstants.ORG_CARDDISSION)));
        result.put("isOpenPersonalStyle", orgChartQueryParam.isOpenPersonalStyle() ? 1 : 0);
        result.put("hasPersonalStyle", !StringUtils.isEmpty((CharSequence)orgChartQueryParam.getPersonalStyleId()) ? 1 : 0);
        result.put("personalStyle", OrgChartServiceHelper.getPersonalStyleById(orgChartQueryParam.getPersonalStyleId()));
        result.put("showLevel", orgChartQueryParam.getShowLevel());
        if (!CollectionUtils.isEmpty((Collection)orgChartQueryParam.getTeamotclassify())) {
            List<Long> otclassifyIds = orgChartQueryParam.getTeamotclassify().stream().map(Long::parseLong).collect(Collectors.toList());
            result.put("showOtclassifys", OrgChartServiceHelper.getOtClassifys(otclassifyIds));
        } else {
            result.put("showOtclassifys", new ArrayList());
        }
        if (!CollectionUtils.isEmpty((Collection)orgChartQueryParam.getAdminOrgTypes())) {
            List<Long> adminOrgTypeIds = orgChartQueryParam.getAdminOrgTypes().stream().map(Long::parseLong).collect(Collectors.toList());
            result.put("showAdminOrgTypes", OrgChartServiceHelper.getAdminOrgTypes(adminOrgTypeIds));
        } else {
            result.put("showAdminOrgTypes", new ArrayList());
        }
        if (!CollectionUtils.isEmpty((Collection)orgChartQueryParam.getCoopRelTypes())) {
            List<Long> cooprelTypeIds = orgChartQueryParam.getCoopRelTypes().stream().map(Long::parseLong).collect(Collectors.toList());
            result.put("showCooprelTypes", OrgChartServiceHelper.getCoopRelTypes(cooprelTypeIds));
        } else {
            result.put("showCooprelTypes", new ArrayList());
        }
        result.put("orgchartdirection", orgChartQueryParam.getOrgChartDirection());
        result.put("orgs", OrgChartServiceHelper.getOrgInfo(orgChartQueryParam.getOrgs()));
        result.put("showScheme", defaultScheme);
        return result;
    }

    public static List<JSONObject> getOrgInfo(List<String> orgs) {
        if (!CollectionUtils.isEmpty(orgs)) {
            ArrayList orgIds = Lists.newArrayListWithExpectedSize((int)orgs.size());
            orgs.forEach(org -> orgIds.add(Long.valueOf(org)));
            HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_org_structure");
            QFilter viewFilter = new QFilter("view.number", "=", (Object)"21");
            QFilter orgFilter = new QFilter("org.id", "in", (Object)orgIds);
            Object[] dys = helper.query("org", new QFilter[]{viewFilter, orgFilter});
            if (ArrayUtils.isEmpty((Object[])dys)) {
                return new ArrayList<JSONObject>();
            }
            ArrayList orgInfos = Lists.newArrayListWithExpectedSize((int)dys.length);
            Stream.of(dys).forEach(dy -> {
                JSONObject orgInfo = new JSONObject();
                orgInfo.put("id", (Object)dy.getString("org.id"));
                orgInfo.put("name", (Object)dy.getString("org.name"));
                orgInfo.put("number", (Object)dy.getString("org.number"));
                orgInfos.add(orgInfo);
            });
            return orgInfos;
        }
        return new ArrayList<JSONObject>();
    }

    public static Map<String, ChartStyle> getChartStyles(Collection<String> chartStyleIds) {
        if (CollectionUtils.isEmpty(chartStyleIds)) {
            return new HashMap<String, ChartStyle>();
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_chartstyle");
        List chartStyleIdList = chartStyleIds.stream().filter(Objects::nonNull).map(Long::parseLong).collect(Collectors.toList());
        QFilter chartStyleIdFilter = new QFilter("id", "in", chartStyleIdList);
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{chartStyleIdFilter});
        return OrgChartServiceHelper.getChartStyleMap(dynamicObjects);
    }

    public static DynamicObject[] queryBaseData(String formId, QFilter[] qFilters) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(formId);
        return serviceHelper.query(qFilters);
    }

    public static Map<String, ChartStyle> getChartStyleMap(DynamicObject[] dynamicObjects) {
        ArrayList<String> cardStyleIdList = new ArrayList<String>();
        ArrayList chartStyles = new ArrayList();
        HashMap<String, ChartStyle> chartStyleIdChartStyleMap = new HashMap<String, ChartStyle>();
        if (!ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            Stream.of(dynamicObjects).forEach(dy -> {
                ChartStyle chartStyle = OrgChartServiceHelper.getChartStyle(dy);
                chartStyles.add(chartStyle);
                cardStyleIdList.addAll(chartStyle.getCardStyleIds());
            });
            Map<String, CardStyle> cardStyleMap = OrgChartServiceHelper.toCardStyle(cardStyleIdList);
            chartStyles.forEach(chartStyle -> {
                ArrayList cardStyles = new ArrayList();
                HashMap carddimensionIdCardStyleMap = new HashMap();
                chartStyle.getCardStyleIds().forEach(cardStyleId -> {
                    CardStyle cardStyle = (CardStyle)cardStyleMap.get(cardStyleId);
                    if (cardStyle != null) {
                        cardStyles.add(cardStyle);
                        carddimensionIdCardStyleMap.put(cardStyle.getCarddimensionId(), cardStyle);
                    }
                });
                chartStyle.setCardStyles(cardStyles);
                chartStyle.setCarddimensionIdCardStyleMap(carddimensionIdCardStyleMap);
                chartStyleIdChartStyleMap.put(chartStyle.getId(), (ChartStyle)chartStyle);
            });
        }
        return chartStyleIdChartStyleMap;
    }

    private static ChartStyle getChartStyle(DynamicObject dy) {
        ChartStyle chartStyle = new ChartStyle();
        chartStyle.setId(dy.getString("id"));
        chartStyle.setName(dy.getString("name"));
        chartStyle.setNumber(dy.getString("number"));
        DynamicObjectCollection chartstyleentry = dy.getDynamicObjectCollection("chartstyleentry");
        ArrayList cardStyleIds = new ArrayList();
        chartstyleentry.forEach(entry -> cardStyleIds.add(entry.getString("cardstyle.id")));
        chartStyle.setCardStyleIds(cardStyleIds);
        ArrayList matchOrgIds = new ArrayList();
        DynamicObjectCollection chastyorgentry = dy.getDynamicObjectCollection("chastyorgentry");
        chastyorgentry.forEach(entry2 -> matchOrgIds.add(entry2.getLong("adminorg.id")));
        chartStyle.setMatchOrgIds(matchOrgIds);
        return chartStyle;
    }

    public static Map<String, CardStyle> toCardStyle(List<String> cardStyleIdList) {
        HashMap<String, CardStyle> cardStyleIdCardStyleMap = new HashMap<String, CardStyle>();
        if (!CollectionUtils.isEmpty(cardStyleIdList)) {
            List cardStyleIds = cardStyleIdList.stream().filter(Objects::nonNull).map(Long::parseLong).collect(Collectors.toList());
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_cardstyle");
            QFilter cardStyleIdFilter = new QFilter("id", "in", cardStyleIds);
            DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{cardStyleIdFilter});
            Stream.of(dynamicObjects).forEach(dy -> {
                CardStyle cardStyle = OrgChartServiceHelper.getCardStyle(dy);
                cardStyleIdCardStyleMap.put(cardStyle.getId(), cardStyle);
            });
        }
        return cardStyleIdCardStyleMap;
    }

    private static CardStyle getCardStyle(DynamicObject dy) {
        CardStyle cardStyle = new CardStyle();
        cardStyle.setId(dy.getString("id"));
        cardStyle.setName(dy.getString("name"));
        cardStyle.setNumber(dy.getString("number"));
        cardStyle.setCarddimensionId(dy.getString("carddimension.id"));
        cardStyle.setCarddimensionName(dy.getString("carddimension.name"));
        cardStyle.setBackgroundcolor(dy.getString("backgroundcolor"));
        cardStyle.setBordercolor(dy.getString("bordercolor"));
        cardStyle.setTopbordercolor(dy.getString("topbordercolor"));
        DynamicObjectCollection cardEntryEntity = dy.getDynamicObjectCollection("cardentryentity");
        ArrayList cardStyleFields = new ArrayList();
        ArrayList cardStyleFieldNames = new ArrayList();
        int contentAdaptation = dy.getBoolean("contentadaptation") ? 1 : 0;
        cardEntryEntity.forEach(entry -> {
            CardStyleField cardStyleField = OrgChartServiceHelper.getCardStyleField(contentAdaptation, entry);
            cardStyleFieldNames.add(cardStyleField.getFieldidentifier());
            cardStyleFields.add(cardStyleField);
        });
        cardStyle.setCardStyleFieldNames(cardStyleFieldNames);
        cardStyle.setCardStyleFields(cardStyleFields);
        return cardStyle;
    }

    public static CardStyleField getCardStyleField(int contentAdaptation, DynamicObject entry) {
        CardStyleField cardStyleField = new CardStyleField();
        cardStyleField.setId(entry.getString("id"));
        cardStyleField.setCardcontentid(entry.getString("cardcontentid.id"));
        cardStyleField.setFieldidentifier(entry.getString("cardcontentid.fieldidentifier"));
        cardStyleField.setEntityidentifier(entry.getString("cardcontentid.entityidentifier"));
        cardStyleField.setBeforecontent(entry.getLocaleString("beforecontent").getLocaleValue());
        cardStyleField.setAftercontent(entry.getLocaleString("aftercontent").getLocaleValue());
        cardStyleField.setRows(entry.getString("rows"));
        cardStyleField.setWordsize(entry.getString("wordsize"));
        cardStyleField.setBold(Integer.valueOf(entry.getBoolean("bold") ? 1 : 0));
        cardStyleField.setXcoordinate(Integer.valueOf(entry.getInt("xcoordinate")));
        cardStyleField.setYcoordinate(Integer.valueOf(entry.getInt("ycoordinate")));
        cardStyleField.setWide(Integer.valueOf(entry.getInt("wide")));
        cardStyleField.setHigh(Integer.valueOf(entry.getInt("high")));
        cardStyleField.setFontjustification(entry.getString("fontjustification"));
        cardStyleField.setContentadaptation(Integer.valueOf(contentAdaptation));
        cardStyleField.setName(entry.getDynamicObject("cardcontentid").getLocaleString("name").getLocaleValue());
        cardStyleField.setSampledate(entry.getString("cardcontentid.sampledate"));
        if (!StringUtils.isEmpty((CharSequence)cardStyleField.getSampledate())) {
            cardStyleField.setSampledates(cardStyleField.getSampledate().split("!"));
        }
        return cardStyleField;
    }

    public static ChartStyle findBestMatchChartStyle(Map<String, ChartStyle> chartStyleIdChartStyleMap, String ignoreChartStyleId) {
        List chartStyles = chartStyleIdChartStyleMap.values().stream().filter(s -> !ignoreChartStyleId.equals(s.getId())).sorted(Comparator.comparing(ChartStyle::getNumber)).collect(Collectors.toList());
        return CollectionUtils.isEmpty(chartStyles) ? null : (ChartStyle)chartStyles.get(0);
    }

    public static List<JSONObject> getOtClassifys(Collection<Long> otClassifyIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_otclassify");
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        if (!CollectionUtils.isEmpty(otClassifyIds)) {
            QFilter idFilter = new QFilter("id", "in", otClassifyIds);
            filter.and(idFilter);
        }
        DynamicObject[] dynamicObjects = helper.query(filter.toArray());
        ArrayList<JSONObject> otClassifies = new ArrayList<JSONObject>();
        Stream.of(dynamicObjects).forEach(dy -> {
            JSONObject otClassify = new JSONObject();
            otClassify.put("id", (Object)dy.getString("id"));
            otClassify.put("name", (Object)dy.getString("name"));
            otClassify.put("number", (Object)dy.getString("number"));
            otClassifies.add(otClassify);
        });
        return otClassifies;
    }

    public static List<JSONObject> getAdminOrgTypes(Collection<Long> adminOrgTypeIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgtype");
        QFilter filter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "in", Arrays.asList("1", "0"));
        filter.and(enableFilter);
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        if (!CollectionUtils.isEmpty(adminOrgTypeIds)) {
            QFilter idFilter = new QFilter("id", "in", adminOrgTypeIds);
            filter.and(idFilter);
            DynamicObject[] objects = helper.query(new QFilter[]{filter});
            dynamicObjects.addAll(Arrays.asList(objects));
        } else {
            HasPermOrgResult permOrg = OrgPermHelper.getHRPermOrg((String)"homs_orgchart");
            if (!permOrg.hasAllOrgPerm()) {
                List<Long> defaultOrg = OrgChartServiceHelper.getDefaultOrg();
                if (!CollectionUtils.isEmpty(defaultOrg)) {
                    QFilter orgFilter = BaseDataHelper.getBaseDataFilter((String)"haos_adminorgtype", defaultOrg);
                    Object[] allAdminOrgType = helper.query(new QFilter[]{filter, orgFilter});
                    dynamicObjects.addAll(Lists.newArrayList((Object[])allAdminOrgType));
                }
            } else {
                DynamicObject[] objects = helper.query(new QFilter[]{filter});
                dynamicObjects.addAll(Arrays.asList(objects));
            }
        }
        ArrayList<JSONObject> adminOrgTypes = new ArrayList<JSONObject>();
        dynamicObjects.forEach(dy -> {
            JSONObject adminOrgType = new JSONObject();
            adminOrgType.put("id", (Object)dy.getString("id"));
            adminOrgType.put("name", (Object)dy.getString("name"));
            adminOrgType.put("number", (Object)dy.getString("number"));
            adminOrgTypes.add(adminOrgType);
        });
        return adminOrgTypes;
    }

    public static List<JSONObject> getCoopRelTypes(Collection<Long> coopRelTypeIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_teamcoopreltype");
        QFilter filter = new QFilter("enable", "in", Arrays.asList("1", "0"));
        if (!CollectionUtils.isEmpty(coopRelTypeIds)) {
            QFilter idFilter = new QFilter("id", "in", coopRelTypeIds);
            filter.and(idFilter);
        }
        DynamicObject[] dynamicObjects = helper.query(filter.toArray());
        ArrayList<JSONObject> coopRelTypes = new ArrayList<JSONObject>();
        Stream.of(dynamicObjects).forEach(dy -> {
            JSONObject adminOrgType = new JSONObject();
            adminOrgType.put("id", (Object)dy.getString("id"));
            adminOrgType.put("name", (Object)dy.getString("name"));
            adminOrgType.put("number", (Object)dy.getString("number"));
            coopRelTypes.add(adminOrgType);
        });
        return coopRelTypes;
    }

    public static List<JSONObject> getStructProjectTypes(boolean showAllArea) {
        DynamicObject[] queryResult = StructProjectRepository.getInstance().getUserStructProject(showAllArea);
        ArrayList<JSONObject> structProjectTypes = new ArrayList<JSONObject>();
        Stream.of(queryResult).forEach(dy -> structProjectTypes.add(OrgChartServiceHelper.convertProjectTypeToJson(dy)));
        return structProjectTypes;
    }

    public static JSONObject getStructProjectTypeById(long structProjectId) {
        DynamicObject queryResult = StructProjectRepository.getInstance().queryOneByStructProjectId("name, number", structProjectId);
        return OrgChartServiceHelper.convertProjectTypeToJson(queryResult);
    }

    private static JSONObject convertProjectTypeToJson(DynamicObject structProjectType) {
        JSONObject structProjectTypeJson = new JSONObject();
        structProjectTypeJson.put("id", (Object)structProjectType.getString("id"));
        structProjectTypeJson.put("name", (Object)structProjectType.getString("name"));
        structProjectTypeJson.put("number", (Object)structProjectType.getString("number"));
        return structProjectTypeJson;
    }

    public static List<String> getAdminOrgTypeIds(List<Long> orgIds) {
        return OrgChartServiceHelper.getAdminOrgTypes(null).stream().map(dy -> dy.getString("id")).collect(Collectors.toList());
    }

    public static Map<Long, ChartOrgInfo> getOrgTeamOrgType(DynamicObjectCollection treeViewCollection, Date queryDate) {
        HashMap<Long, ChartOrgInfo> orgTeamIdOrgTypeMap = new HashMap<Long, ChartOrgInfo>();
        HashMap<Long, Long> orgTeamIdOrgIdMap = new HashMap<Long, Long>();
        for (DynamicObject dynamicObject : treeViewCollection) {
            orgTeamIdOrgIdMap.put(dynamicObject.getLong("orgteam.id"), dynamicObject.getLong("orgteam.boid"));
        }
        Map otClassifyIdBoIds = treeViewCollection.stream().collect(Collectors.groupingBy(dy -> dy.getString("orgteam.otclassify"), Collectors.mapping(dy2 -> dy2.getLong("orgteam.boid"), Collectors.toSet())));
        otClassifyIdBoIds.forEach((otClassifyId, orgBoIds) -> {
            if ("1010".equals(otClassifyId)) {
                Map<Long, ChartOrgInfo> adminOrgInfo = OrgChartServiceHelper.getAdminOrgInfo(queryDate, orgTeamIdOrgIdMap, orgBoIds);
                orgTeamIdOrgTypeMap.putAll(adminOrgInfo);
            }
        });
        return orgTeamIdOrgTypeMap;
    }

    private static Map<Long, ChartOrgInfo> getAdminOrgInfo(Date queryDate, Map<Long, Long> orgTeamIdOrgIdMap, Set<Long> orgBoIds) {
        QFilter queryDateFilter = OrgChartServiceHelper.getBaseCommonWithoutEnableFilter(queryDate);
        List<Object> chartFilterConfigList = null;
        if (OrgChartNewServiceHelper.isUseNewStructureChart()) {
            chartFilterConfigList = OrgChartServiceHelper.getChartFilterConfigList(1010L);
            chartFilterConfigList = chartFilterConfigList.stream().filter(chartConfig -> !ChartFilterConfig.DEFAULT_FILTER_NUMBERS.contains(chartConfig.getNumber())).collect(Collectors.toList());
        }
        Map<Long, DynamicObject> orgIdOrgTypeMap = OrgChartServiceHelper.getAdminOrgBaseInfo(orgBoIds, queryDateFilter, chartFilterConfigList);
        Map<Long, DynamicObject> orgIdOrgSortCodeMap = OrgChartServiceHelper.getAdminOrgSortInfo(orgBoIds, queryDateFilter);
        HashMap<Long, ChartOrgInfo> orgTeamIdOrgTypeMap = new HashMap<Long, ChartOrgInfo>();
        List<Object> finalChartFilterConfigList = chartFilterConfigList;
        orgTeamIdOrgIdMap.forEach((orgTeamId, orgId) -> {
            DynamicObject orgType = (DynamicObject)orgIdOrgTypeMap.get(orgId);
            ChartOrgInfo chartOrgInfo = new ChartOrgInfo();
            if (orgType != null) {
                chartOrgInfo.setId(orgId + "");
                chartOrgInfo.setName(orgType.getString("name"));
                chartOrgInfo.setNumber(orgType.getString("number"));
                chartOrgInfo.setOrgType(orgType.getString("adminorgtype"));
                chartOrgInfo.setIsvirtualorg(orgType.getString("isvirtualorg"));
                DynamicObject orgSortCode = (DynamicObject)orgIdOrgSortCodeMap.get(orgId);
                if (orgSortCode != null) {
                    chartOrgInfo.setIndex(Long.valueOf(orgSortCode.getLong("index")));
                }
                if (finalChartFilterConfigList != null) {
                    finalChartFilterConfigList.stream().filter(chartConfig -> !ChartFilterConfig.DEFAULT_FILTER_NUMBERS.contains(chartConfig.getNumber())).forEach(config -> chartOrgInfo.getOtherInfo().put(config.getIdentifier(), orgType.getString(config.getIdentifier())));
                }
                orgTeamIdOrgTypeMap.put((Long)orgTeamId, chartOrgInfo);
            }
        });
        return orgTeamIdOrgTypeMap;
    }

    private static Map<Long, DynamicObject> getAdminOrgSortInfo(Set<Long> orgBoIds, QFilter queryDateFilter) {
        if (CollectionUtils.isEmpty(orgBoIds)) {
            return new HashMap<Long, DynamicObject>();
        }
        String orgSortCodeFields = "id,index,adminorg";
        QFilter adminOrgIdFilter = new QFilter("adminorg.id", "in", orgBoIds);
        DynamicObjectCollection orgSortCodes = HRBaseDaoFactory.getInstance((String)"haos_orgsortcode").queryColl(orgSortCodeFields, new QFilter[]{adminOrgIdFilter, queryDateFilter}, null);
        HashMap<Long, DynamicObject> orgIdOrgSortCodeMap = new HashMap<Long, DynamicObject>();
        if (!CollectionUtils.isEmpty((Collection)orgSortCodes)) {
            for (DynamicObject orgSortCode : orgSortCodes) {
                orgIdOrgSortCodeMap.put(orgSortCode.getLong("adminorg"), orgSortCode);
            }
        }
        return orgIdOrgSortCodeMap;
    }

    private static Map<Long, DynamicObject> getAdminOrgBaseInfo(Set<Long> orgBoIds, QFilter queryDateFilter, List<ChartFilterConfig> chartFilterConfigList) {
        if (CollectionUtils.isEmpty(orgBoIds)) {
            return new HashMap<Long, DynamicObject>();
        }
        StringBuilder sb = new StringBuilder();
        String selectFields = "id,boid,name,number,adminorgtype,isvirtualorg";
        sb.append(selectFields);
        if (chartFilterConfigList != null) {
            chartFilterConfigList.stream().filter(chartConfig -> !ChartFilterConfig.DEFAULT_FILTER_NUMBERS.contains(chartConfig.getNumber())).forEach(config -> sb.append(",").append(config.getIdentifier()));
        }
        QFilter orgIdFilter = new QFilter("boid", "in", orgBoIds);
        DynamicObjectCollection dynamicObjects = HRBaseDaoFactory.getInstance((String)"haos_adminorgdetail").queryColl(sb.toString(), new QFilter[]{orgIdFilter, queryDateFilter}, null);
        HashMap<Long, DynamicObject> orgIdOrgTypeMap = new HashMap<Long, DynamicObject>();
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                orgIdOrgTypeMap.put(dynamicObject.getLong("boid"), dynamicObject);
            }
        }
        return orgIdOrgTypeMap;
    }

    public static List<ChartFilterConfig> getChartFilterConfigList(Long cardDimensionId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("homs_chartfilterconfig");
        QFilter qFilter = new QFilter("carddimension", "=", (Object)cardDimensionId);
        DynamicObject[] dynamicObjects = helper.loadDynamicObjectArray(new QFilter[]{qFilter});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return new ArrayList<ChartFilterConfig>();
        }
        ArrayList<ChartFilterConfig> result = new ArrayList<ChartFilterConfig>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            ChartFilterConfig chartFilterConfig = new ChartFilterConfig();
            chartFilterConfig.setNumber(dynamicObject.getString("number"));
            chartFilterConfig.setName(dynamicObject.getString("name"));
            chartFilterConfig.setType(dynamicObject.getString("columntype"));
            chartFilterConfig.setMetaDataNumber(dynamicObject.getString("metadatakey"));
            chartFilterConfig.setIdentifier(dynamicObject.getString("identifier"));
            chartFilterConfig.setMustInput(dynamicObject.getString("mustinput"));
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                chartFilterConfig.getEnumKey().put(entry.getString("enumname"), entry.getString("enumvalue"));
            }
            result.add(chartFilterConfig);
        }
        return result;
    }

    public static OrgChartTreeNode findFirstPermOrgNode(OrgChartTreeNode rootNode, List<Long> permOrgIds, List<String> orgIds, boolean hasAllOrgPerm) {
        if (rootNode == null) {
            return null;
        }
        if (hasAllOrgPerm ? orgIds.contains(rootNode.getOrg()) : permOrgIds.contains(Long.parseLong(rootNode.getBoid())) && orgIds.contains(rootNode.getOrg())) {
            return rootNode;
        }
        if (!CollectionUtils.isEmpty((Collection)rootNode.getChildren())) {
            OrgChartTreeNode treeNode;
            for (TreeNode node : rootNode.getChildren()) {
                treeNode = (OrgChartTreeNode)node;
                if (!(hasAllOrgPerm ? orgIds.contains(treeNode.getOrg()) : permOrgIds.contains(Long.parseLong(treeNode.getBoid())) && orgIds.contains(treeNode.getOrg()))) continue;
                return treeNode;
            }
            for (TreeNode node : rootNode.getChildren()) {
                treeNode = (OrgChartTreeNode)node;
                OrgChartTreeNode permOrgNode = OrgChartServiceHelper.findFirstPermOrgNode(treeNode, permOrgIds, orgIds, hasAllOrgPerm);
                if (permOrgNode == null) continue;
                return permOrgNode;
            }
        }
        return null;
    }

    public static void addOperateLog(DynamicObject dynamicObject, int operateType) {
        String formId = dynamicObject.getDynamicObjectType().getName();
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)formId);
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        appLogInfo.setBizAppID(appId);
        appLogInfo.setBizObjID(formId);
        if (1 == operateType) {
            appLogInfo.setOpName("savePersonalStyle", new MultiLangEnumBridge("\u4fdd\u5b58", "OrgChartServiceHelper_1", "odc-homs-business"));
            appLogInfo.setOpDesc(new MultiLangEnumBridge("\u4fdd\u5b58\u4e2a\u6027\u5316\u6837\u5f0f", "OrgChartServiceHelper_3", "odc-homs-business"), new String[0]);
        } else {
            appLogInfo.setOpName("updatePersonalStyle", new MultiLangEnumBridge("\u66f4\u65b0", "OrgChartServiceHelper_2", "odc-homs-business"));
            appLogInfo.setOpDesc(new MultiLangEnumBridge("\u66f4\u65b0\u4e2a\u6027\u5316\u6837\u5f0f", "OrgChartServiceHelper_4", "odc-homs-business"), new String[0]);
        }
        service.addLog((AppLogInfo)appLogInfo);
    }

    public static OrgChartTreeNode getNotInitOrgNode() {
        QFilter orgIdFilter = new QFilter("id", "=", (Object)PlatformRootUtils.getLongRootIdOfPlatform());
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        DynamicObject dynamicObject = HRBaseDaoFactory.getInstance((String)"haos_adminorgdetail").queryOne(new QFilter[]{orgIdFilter, initStatusFilter}, null);
        if (dynamicObject == null) {
            return new OrgChartTreeNode("", "notInit100000", ResManager.loadKDString((String)"\u672a\u521d\u59cb\u5316\u6839\u7ec4\u7ec7\u3002", (String)"OrgChartServiceHelper_5", (String)"odc-homs-business", (Object[])new Object[0]), false);
        }
        return null;
    }

    public static List<FilterScheme> getSchemeWithFilter(String formId, String userId, boolean isDecode, String structProjectId) {
        if (StringUtils.isEmpty((CharSequence)formId) || StringUtils.isEmpty((CharSequence)userId)) {
            return new ArrayList<FilterScheme>();
        }
        List<FilterScheme> schemes = OrgChartServiceHelper.getScheme(formId, userId, isDecode);
        if (HRStringUtils.isEmpty((String)structProjectId)) {
            return schemes;
        }
        Set<String> schemeIds = OrgChartServiceHelper.getSchemesWithFilter(structProjectId);
        return schemes.stream().filter(scheme -> schemeIds.contains(scheme.getId())).collect(Collectors.toList());
    }

    public static FilterScheme getDefaultSchemeWithFilter(String formId, String userId, String structProjectId) {
        FilterScheme defaultScheme = OrgChartServiceHelper.getDefaultScheme(formId, userId);
        if (defaultScheme == null) {
            return null;
        }
        Set<String> schemeIds = OrgChartServiceHelper.getSchemesWithFilter(structProjectId);
        if (schemeIds.contains(defaultScheme.getId())) {
            return defaultScheme;
        }
        return null;
    }

    private static Set<String> getSchemesWithFilter(String structProjectId) {
        HRBaseServiceHelper structureSchemeHelper = new HRBaseServiceHelper("homs_strprotofilter");
        DynamicObject[] structureSchemes = structureSchemeHelper.query("scheme", new QFilter[]{new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId()), new QFilter("structproject", "=", (Object)Long.parseLong(structProjectId))});
        return Stream.of(structureSchemes).map(structureScheme -> structureScheme.getString("scheme")).collect(Collectors.toSet());
    }

    public static List<FilterScheme> getScheme(String formId, String userId, boolean isDecode) {
        if (StringUtils.isEmpty((CharSequence)formId) || StringUtils.isEmpty((CharSequence)userId)) {
            return new ArrayList<FilterScheme>();
        }
        SchemeQuery schemeQuery = new SchemeQuery();
        List filterSchemes = schemeQuery.getScheme(formId, userId);
        if (isDecode) {
            filterSchemes.forEach(filterScheme -> {
                List rows = (List)SerializationUtils.deSerializeFromBase64((String)filterScheme.getScheme());
                filterScheme.setScheme(((List)((Map)rows.get(0)).get("FieldName")).get(0).toString());
            });
        }
        Collections.reverse(filterSchemes);
        return filterSchemes;
    }

    public static FilterScheme getDefaultScheme(String formId, String userId) {
        if (StringUtils.isEmpty((CharSequence)formId) || StringUtils.isEmpty((CharSequence)userId)) {
            return null;
        }
        List<FilterScheme> schemes = OrgChartServiceHelper.getScheme(formId, userId, false);
        if (!CollectionUtils.isEmpty(schemes)) {
            for (FilterScheme filterScheme : schemes) {
                if (!filterScheme.isDefault()) continue;
                return filterScheme;
            }
        }
        return null;
    }

    public static OrgChartQueryParam analyzeScheme(FilterScheme filterScheme) {
        if (filterScheme == null) {
            return null;
        }
        String scheme = filterScheme.getScheme();
        List rows = (List)SerializationUtils.deSerializeFromBase64((String)scheme);
        scheme = ((List)((Map)rows.get(0)).get("FieldName")).get(0).toString();
        return (OrgChartQueryParam)JSONObject.parseObject((String)scheme, OrgChartQueryParam.class);
    }

    public static DynamicObject getRootDynByRootId(QFilter qFilter, Long rootId) {
        String selectFields = "id,orgteam.id,orgteam.number number, orgteam.boid ,orgteam.org,orgteam.name name,orgteam.otclassify,structlongnumber,parentorgteam,isleaf,level";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        QFilter[] filters = new QFilter[]{new QFilter("orgteam.boid", "=", (Object)rootId), qFilter};
        return serviceHelper.queryOriginalOne(selectFields, filters);
    }

    public static String checkScheme(SearchChartData schemeSearchChartData, String rootId, AuthorizedOrgResultWithSub permOrgResultWithSub, HasPermOrgResult permOrg, String structProjectId) {
        String tips;
        HRBaseServiceHelper helper;
        boolean exists;
        String personalStyleId;
        String tips2;
        QFilter defaultFilter = OrgChartServiceHelper.getDefaultFilter(schemeSearchChartData.getDateField());
        DynamicObject rootDyn = null;
        LOG.info("rootId:{}", (Object)rootId);
        defaultFilter.and(new QFilter("structproject", "=", (Object)Long.parseLong(structProjectId)));
        if (!StringUtils.isEmpty((CharSequence)rootId)) {
            rootDyn = OrgChartServiceHelper.getRootDynByRootId(defaultFilter, Long.parseLong(rootId));
        }
        StringBuilder sb = new StringBuilder();
        Set<String> chartStyleIds = OrgChartServiceHelper.getChartStyleIds(permOrgResultWithSub, OrgChartConstants.ORG_CARDDISSION);
        chartStyleIds.add("1001");
        QFilter chartStyleIdFilter = new QFilter("id", "in", (Object)(StringUtils.isEmpty((CharSequence)schemeSearchChartData.getChartStyleId()) ? 0L : Long.parseLong(schemeSearchChartData.getChartStyleId())));
        Object[] dynamicObjects = OrgChartServiceHelper.queryBaseData("homs_chartstyle", new QFilter[]{chartStyleIdFilter});
        if (ArrayUtils.isEmpty((Object[])dynamicObjects) || !chartStyleIds.contains(schemeSearchChartData.getChartStyleId())) {
            tips2 = ResManager.loadKDString((String)"\u7ed3\u6784\u56fe\u6837\u5f0f", (String)"OrgChartServiceHelper_8", (String)"odc-homs-business", (Object[])new Object[0]);
            sb.append(tips2);
            sb.append("\u3001");
        }
        if (rootDyn == null || !OrgChartServiceHelper.checkRootDynPerm(permOrg, rootDyn, permOrgResultWithSub, schemeSearchChartData.getDateField(), structProjectId)) {
            tips2 = ResManager.loadKDString((String)"\u67e5\u8be2\u7ec4\u7ec7", (String)"OrgChartServiceHelper_9", (String)"odc-homs-business", (Object[])new Object[0]);
            sb.append(tips2);
            sb.append("\u3001");
        }
        if (HRStringUtils.isNotEmpty((String)(personalStyleId = schemeSearchChartData.getPersonalStyleId())) && Long.parseLong(personalStyleId) != 0L && !(exists = (helper = new HRBaseServiceHelper("homs_personalstyle")).isExists((Object)personalStyleId))) {
            String tips3 = ResManager.loadKDString((String)"\u4e2a\u6027\u5316\u6837\u5f0f", (String)"OrgChartServiceHelper_6", (String)"odc-homs-business", (Object[])new Object[0]);
            sb.append(tips3);
            sb.append("\u3001");
        }
        if (!OrgChartServiceHelper.adminOrgTypeIsExist(schemeSearchChartData.getAdminOrgTypes())) {
            tips = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b", (String)"OrgChartServiceHelper_7", (String)"odc-homs-business", (Object[])new Object[0]);
            sb.append(tips);
            sb.append("\u3001");
        }
        if (!OrgChartServiceHelper.orgIsExist(schemeSearchChartData.getOrgs(), permOrg)) {
            tips = ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7", (String)"OrgChartServiceHelper_10", (String)"odc-homs-business", (Object[])new Object[0]);
            sb.append(tips);
            sb.append("\u3001");
        }
        if (!OrgChartServiceHelper.teamCoopRelTypeIsExist(schemeSearchChartData.getCoopRelTypes())) {
            tips = ResManager.loadKDString((String)"\u6c47\u62a5\u53ca\u534f\u4f5c\u5173\u7cfb", (String)"OrgChartServiceHelper_11", (String)"odc-homs-business", (Object[])new Object[0]);
            sb.append(tips);
            sb.append("\u3001");
        }
        return sb.toString();
    }

    private static boolean teamCoopRelTypeIsExist(List<String> coopRelTypes) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_teamcoopreltype");
        QFilter teamCoopRelTypeFilters = OrgChartServiceHelper.getTeamCoopRelTypeFilters(Collections.singleton(OrgChartConstants.DEFAULT_OTCCLASSIFY_ID));
        DynamicObject[] query = helper.query(teamCoopRelTypeFilters.toArray());
        Set ids = Arrays.stream(query).map(dy -> dy.getString("id")).collect(Collectors.toSet());
        return ids.size() >= coopRelTypes.size() && ids.containsAll(coopRelTypes);
    }

    private static boolean checkRootDynPerm(HasPermOrgResult permOrg, DynamicObject rootDyn, AuthorizedOrgResultWithSub permOrgResultWithSub, Date queryDate, String structProjectId) {
        long orgTeamOrgId;
        if (permOrgResultWithSub.isHasAllOrgPerm() || permOrg.hasAllOrgPerm()) {
            return true;
        }
        List hasPermOrgs = permOrg.getHasPermOrgs();
        if (!hasPermOrgs.contains(orgTeamOrgId = rootDyn.getLong("orgteam.org"))) {
            LOG.warn("hasPermOrgs:{},org:{}", (Object)hasPermOrgs, (Object)orgTeamOrgId);
            return false;
        }
        String structlongnumber = rootDyn.getString("structlongnumber");
        LOG.info("structlongnumber:{}", (Object)structlongnumber);
        ArrayList<String> structLongNumberList = new ArrayList<String>(16);
        ArrayList<Long> orgIdWithOutSub = new ArrayList<Long>(16);
        OrgChartServiceHelper.getHisPermStructLongNumberLikeAndOutSub(permOrgResultWithSub, orgIdWithOutSub, structLongNumberList, queryDate, structProjectId);
        if (orgIdWithOutSub.stream().anyMatch(id -> id.longValue() == rootDyn.getLong("orgteam.boid"))) {
            return true;
        }
        for (String sln : structLongNumberList) {
            if (!structlongnumber.startsWith(sln)) continue;
            return true;
        }
        LOG.warn("checkRootDynPerm return false");
        return false;
    }

    public static boolean orgIsExist(List<String> orgIdList, HasPermOrgResult permOrg) {
        if (!CollectionUtils.isEmpty(orgIdList)) {
            if (permOrg.hasAllOrgPerm()) {
                return true;
            }
            HashSet orgIds = Sets.newHashSetWithExpectedSize((int)orgIdList.size());
            orgIdList.forEach(org -> orgIds.add(Long.valueOf(org)));
            return orgIds.size() <= permOrg.getHasPermOrgs().size() && permOrg.getHasPermOrgs().containsAll(orgIds);
        }
        return false;
    }

    private static boolean adminOrgTypeIsExist(List<String> adminOrgTypes) {
        if (CollectionUtils.isEmpty(adminOrgTypes)) {
            return false;
        }
        List adminOrgTypeIds = adminOrgTypes.stream().map(Long::parseLong).collect(Collectors.toList());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgtype");
        QFilter adminOrgTypeFilter = OrgChartServiceHelper.getAdminOrgTypeFilter();
        DynamicObject[] dynamicObjects = helper.query(adminOrgTypeFilter.toArray());
        List permAdminOrgTypes = Arrays.stream(dynamicObjects).map(dy -> dy.getString("id")).distinct().collect(Collectors.toList());
        return adminOrgTypeIds.size() <= permAdminOrgTypes.size() && permAdminOrgTypes.containsAll(adminOrgTypes);
    }

    public static Set<String> getChildStructNumbers(Set<String> childStructLongNumbers) {
        HashSet<String> childStructNumbers = new HashSet<String>();
        if (CollectionUtils.isEmpty(childStructLongNumbers)) {
            return childStructNumbers;
        }
        childStructLongNumbers.forEach(childStructLongNumber -> {
            String childStructNumber = childStructLongNumber.substring(childStructLongNumber.lastIndexOf(33) + 1);
            if (!StringUtils.isEmpty((CharSequence)childStructNumber)) {
                childStructNumbers.add(childStructNumber);
            }
        });
        return childStructNumbers;
    }

    public static FilterContainer getFilterContainer(IFormView view, String formId) {
        FilterContainer filterContainer = new FilterContainer();
        filterContainer.setFilterModelClassName(ListFilterModel.class.getName());
        filterContainer.setBillFormId(formId);
        filterContainer.setView(view);
        return filterContainer;
    }

    public static Map<String, Object> getInitQueryParams(boolean isQueryPerm, String structProjectId, boolean showAllArea) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (isQueryPerm) {
            OrgChartServiceHelper.orgChartPermQuery(result);
        }
        List<FilterScheme> schemes = OrgChartServiceHelper.getSchemeWithFilter("homs_adminorgchart", RequestContext.get().getUserId(), true, structProjectId);
        result.put("schemes", schemes);
        result.put("structProjectTypes", OrgChartServiceHelper.getStructProjectTypes(showAllArea));
        result.put("otclassifys", OrgChartServiceHelper.getOtClassifys(Collections.singleton(OrgChartConstants.DEFAULT_OTCCLASSIFY_ID)));
        result.put("adminOrgTypes", OrgChartServiceHelper.getAdminOrgTypes(null));
        result.put("desensitizeFields", OrgChartServiceHelper.getDesensitizeFields(OrgChartConstants.ORG_CARDDISSION));
        return result;
    }

    public static List<String> getDesensitizeFields(long cardContentId) {
        ArrayList<String> myFieldNames = new ArrayList<String>();
        HashMap<String, String> myFieldNameFieldNameMap = new HashMap<String, String>();
        if (OrgChartConstants.ORG_CARDDISSION == cardContentId || OrgChartConstants.PROJECT_CARDDISSION == cardContentId || OrgChartConstants.POSITION_CARDDISSION == cardContentId) {
            myFieldNameFieldNameMap.put("personname", "name");
        }
        myFieldNameFieldNameMap.forEach((myFieldName, fieldName) -> {
            boolean flag = PrivacyCenterServiceHelper.isDesensitizeField((String)"hrpi_person", (String)fieldName, (String)Lang.get().toString(), (String)"LIST", null);
            if (flag) {
                myFieldNames.add((String)myFieldName);
            }
        });
        return myFieldNames;
    }

    public static String getIsShowEye(ChartStyle chartStyle, List<String> desensitizeFields) {
        String isShowEye = "0";
        if (!CollectionUtils.isEmpty(desensitizeFields) && chartStyle != null && !CollectionUtils.isEmpty((Collection)chartStyle.getCardStyles())) {
            for (CardStyle cardStyle : chartStyle.getCardStyles()) {
                if (CollectionUtils.isEmpty((Collection)cardStyle.getCardStyleFieldNames())) continue;
                List commonFieldNames = cardStyle.getCardStyleFieldNames().stream().filter(desensitizeFields::contains).collect(Collectors.toList());
                boolean hasPersonNameClickView = AdminOrgQueryServiceHelper.checkClickView((String)"hrpi_person", (String)"name");
                if (CollectionUtils.isEmpty(commonFieldNames) || !hasPersonNameClickView) continue;
                isShowEye = "1";
                break;
            }
        }
        return isShowEye;
    }

    public static void orgChartPermQuery(Map<String, Object> result) {
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)"homs_orgchart");
        boolean hasCardEditPerm = PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"11", (String)appId, (String)"homs_orgchart", (String)"0AQ3YJ2LET+U");
        boolean hasChartExportPerm = PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"11", (String)appId, (String)"homs_orgchart", (String)"4730fc9f000004ae");
        boolean hasAdminOrgDetailsPerm = PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"11", (String)appId, (String)"homs_orgchart", (String)"2IGF5UN0V4EG");
        result.put("hasCardEditPerm", hasCardEditPerm ? 1 : 0);
        result.put("hasChartExportPerm", hasChartExportPerm ? 1 : 0);
        result.put("hasAdminOrgDetailsPerm", hasAdminOrgDetailsPerm ? 1 : 0);
    }

    public static DynamicObjectCollection getAllCoopRelInfos(List<String> coopRelTypes, Date queryDate) {
        HRBaseServiceHelper coopRelHelper = new HRBaseServiceHelper("haos_orgteamcooprel");
        QFilter baseCommonFilter = OrgChartServiceHelper.getBaseCommonFilterWithDate(queryDate);
        baseCommonFilter.and(new QFilter("coopreltype", "in", (Object)Long.parseLong(coopRelTypes.get(0))));
        return coopRelHelper.queryOriginalCollection("id,org.id,org.org,coopreltype.id,cooporgteam.id,cooporgteam.org", new QFilter[]{baseCommonFilter});
    }

    public static DynamicObjectCollection getOrgTeamCoopRelInfos(List<String> coopRelTypes, Date queryDate, Long orgTeamId) {
        HRBaseServiceHelper coopRelHelper = new HRBaseServiceHelper("haos_orgteamcooprel");
        QFilter baseCommonFilter = OrgChartServiceHelper.getBaseCommonFilterWithDate(queryDate);
        QFilter orgTeamIdFilter = new QFilter("org.id", "=", (Object)orgTeamId);
        baseCommonFilter.and(orgTeamIdFilter);
        baseCommonFilter.and(new QFilter("coopreltype", "in", (Object)Long.parseLong(coopRelTypes.get(0))));
        return coopRelHelper.queryOriginalCollection("id,org.id,org.org,coopreltype.id,cooporgteam.id,cooporgteam.org", new QFilter[]{baseCommonFilter});
    }

    public static void findCoopOrgIds(Map<Long, Set<Long>> orgIdCoopOrgIdsAllMap, Map<Long, Set<Long>> orgIdCoopOrgIdsMap, List<Long> coopRelNodeIds, long startNodeId) {
        Set<Long> coopOrgIds = orgIdCoopOrgIdsAllMap.get(startNodeId);
        coopRelNodeIds.add(startNodeId);
        if (!CollectionUtils.isEmpty(coopOrgIds)) {
            coopRelNodeIds.addAll((Collection<Long>)orgIdCoopOrgIdsAllMap.get(startNodeId));
            orgIdCoopOrgIdsMap.put(startNodeId, coopOrgIds);
            for (Long coopRelNodeId : coopOrgIds) {
                OrgChartServiceHelper.findCoopOrgIds(orgIdCoopOrgIdsAllMap, orgIdCoopOrgIdsMap, coopRelNodeIds, coopRelNodeId);
            }
        }
    }

    public static void buildCoopRelOrgTreeNode(Map<Long, Set<Long>> orgIdCoopOrgIdsMap, Map<Long, ChartOrgInfo> orgTeamIdOrgTypeMap, Map<Long, DynamicObject> orgIdOrgMap, OrgChartTreeNode rootNode, List<OrgChartTreeNode> orgChartTreeNodes) {
        Set<Long> coopOrgIds = orgIdCoopOrgIdsMap.get(Long.parseLong(rootNode.getId()));
        if (!CollectionUtils.isEmpty(coopOrgIds)) {
            ArrayList<OrgChartTreeNode> children = new ArrayList<OrgChartTreeNode>();
            for (Long coopOrgId : coopOrgIds) {
                DynamicObject dynamicObject = orgIdOrgMap.get(coopOrgId);
                if (dynamicObject == null) continue;
                OrgChartTreeNode treeNode = OrgChartServiceHelper.wrapTreeNode(dynamicObject, orgTeamIdOrgTypeMap);
                treeNode.setParentid(rootNode.getId() + "");
                orgChartTreeNodes.add(treeNode);
                children.add(treeNode);
                OrgChartServiceHelper.buildCoopRelOrgTreeNode(orgIdCoopOrgIdsMap, orgTeamIdOrgTypeMap, orgIdOrgMap, treeNode, orgChartTreeNodes);
            }
            rootNode.setChildren(children);
        }
    }

    public static int calculateLevel(OrgChartTreeNode rootNode) {
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.offer(rootNode);
        int level = 0;
        while (!queue.isEmpty()) {
            int count = queue.size();
            while (count-- > 0) {
                TreeNode poll = (TreeNode)queue.poll();
                assert (poll != null);
                if (CollectionUtils.isEmpty((Collection)poll.getChildren())) continue;
                for (TreeNode child : poll.getChildren()) {
                    if (child == null) continue;
                    queue.offer(child);
                }
            }
            ++level;
        }
        return level;
    }

    public static List<Long> getOrgIds() {
        List<Long> orgIds = new ArrayList<Long>();
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_org_structure");
        QFilter viewFilter = new QFilter("view.number", "=", (Object)"21");
        DynamicObject[] dys = helper.query("id,org", new QFilter[]{viewFilter});
        if (dys != null && dys.length > 0) {
            orgIds = Arrays.stream(dys).map(dy -> dy.getLong("org.id")).collect(Collectors.toList());
        }
        return orgIds;
    }

    public static String findTopParentStructLongNumber(String targetStructLongNumber, ITreeModel treeModel, QFilter qFilter) {
        List<String> allParentStructLongNumbers = OrgChartServiceHelper.getAllParentStructLongNumbers(targetStructLongNumber);
        String selectStructFields = "id,orgteam.id,orgteam.number,orgteam.boid ,orgteam.org, structlongnumber, parentorgteam,orgteam.name name,orgteam.otclassify, isleaf,level";
        IHRBaseDao structInstance = HRBaseDaoFactory.getInstance((String)"haos_adminorgstructure");
        QFilter orgTeamIdFilter = new QFilter("structlongnumber", "in", allParentStructLongNumbers);
        DynamicObjectCollection belongAdminOrgStructCollection = structInstance.queryColl(selectStructFields, new QFilter[]{orgTeamIdFilter, qFilter}, null);
        HashMap structLongNumberOrgMap = new HashMap();
        belongAdminOrgStructCollection.forEach(dy -> structLongNumberOrgMap.put(dy.getString("structlongnumber"), dy));
        for (String structLongNumber : allParentStructLongNumbers) {
            DynamicObject dy2 = (DynamicObject)structLongNumberOrgMap.get(structLongNumber);
            if (dy2 == null) continue;
            String orgId = dy2.getString("orgteam.boid");
            TreeNode treeNode = treeModel.getRoot().getTreeNode(orgId);
            if (treeNode == null) continue;
            return structLongNumber;
        }
        return null;
    }

    public static List<String> getAllParentStructLongNumbers(String structLongNumber) {
        ArrayList allParentStructLongNumbers = Lists.newArrayListWithCapacity((int)15);
        while (structLongNumber.indexOf("!") > 0) {
            int lastIndex = structLongNumber.lastIndexOf("!");
            structLongNumber = structLongNumber.substring(0, lastIndex);
            allParentStructLongNumbers.add(structLongNumber);
        }
        return allParentStructLongNumbers;
    }

    public static String getOrgChildCountSql(Date queryDate, Set<Long> parentIds, List<Long> otClassifyIds) {
        return OrgChartServiceHelper.getOrgChildCountSql(queryDate, parentIds, otClassifyIds, null);
    }

    public static String getOrgChildCountSql(Date queryDate, Set<Long> parentIds, List<Long> otClassifyIds, String structProjectId) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT  t1.fparentid,count(*)as orgcount from t_haos_orgteamstruct t1  \nLEFT JOIN t_haos_orgteam t2 on t1.forgteamid=t2.fboid where  t1.fiscurrentversion='0' and t1.finitstatus='2' and t1.fenable='1' and t1.fdatastatus in ('1','2') ");
        sb.append(" and t1.fbsed <= ? ").append(" and   t1.fbsled >= ? ");
        sb.append(" and t2.fiscurrentversion='0' and t2.finitstatus='2' and t2.fenable='1' and t2.fdatastatus in ('1','2') ");
        sb.append(" and t2.fbsed <= ? ").append(" and   t2.fbsled >= ? ");
        if (HRStringUtils.isNotEmpty((String)structProjectId)) {
            sb.append(" and t1.fstructprojectid = ").append(structProjectId);
        }
        if (!CollectionUtils.isEmpty(otClassifyIds)) {
            sb.append(" and t2.fotclassify in (");
            for (i = 0; i < otClassifyIds.size(); ++i) {
                sb.append(otClassifyIds.get(i));
                if (i >= otClassifyIds.size() - 1) continue;
                sb.append(',');
            }
            sb.append(')');
        }
        if (!CollectionUtils.isEmpty(parentIds)) {
            sb.append(" and t1.fparentid in (");
            for (i = 0; i < parentIds.size(); ++i) {
                sb.append('?');
                if (i >= parentIds.size() - 1) continue;
                sb.append(',');
            }
            sb.append(')');
        }
        sb.append(" GROUP BY t1.fparentid");
        return sb.toString();
    }

    public static SqlBuilder getOrgChildCountSqlWithPerm(Date queryDate, Set<Long> parentIds, List<Long> otClassifyIds, String structProjectId, List<Long> permOrgResultWithSub) {
        LOG.info("otClassifyIds = {},permOrgResultWithSub = {}", (Object)otClassifyIds.size(), (Object)permOrgResultWithSub.size());
        SqlBuilder sb = new SqlBuilder();
        sb.append("SELECT  t1.fparentid,count(*)as orgcount from t_haos_orgteamstruct t1  \nLEFT JOIN t_haos_orgteam t2 on t1.forgteamid=t2.fboid where  t1.fiscurrentversion='0' and t1.finitstatus='2' and t1.fenable='1' and t1.fdatastatus in ('1','2') ", new Object[0]);
        sb.append(" and t1.fbsed <= ? ", new Object[]{queryDate}).append(" and   t1.fbsled >= ? ", new Object[]{queryDate});
        sb.append(" and t2.fiscurrentversion='0' and t2.finitstatus='2' and t2.fenable='1' and t2.fdatastatus in ('1','2') ", new Object[0]);
        sb.append(" and t2.fbsed <= ? ", new Object[]{queryDate}).append(" and   t2.fbsled >= ? ", new Object[]{queryDate});
        if (HRStringUtils.isNotEmpty((String)structProjectId)) {
            sb.append(" and t1.fstructprojectid = ".concat(structProjectId), new Object[0]);
        }
        if (!CollectionUtils.isEmpty(otClassifyIds)) {
            sb.appendIn("and t2.fotclassify", (List)Lists.newArrayList(otClassifyIds));
        }
        if (!CollectionUtils.isEmpty(parentIds)) {
            sb.appendIn("and t1.fparentid", (List)Lists.newArrayList(parentIds));
        }
        if (!permOrgResultWithSub.isEmpty()) {
            sb.appendIn("and t2.fboid ", (List)Lists.newArrayList(permOrgResultWithSub));
        }
        sb.append(" GROUP BY t1.fparentid", new Object[0]);
        return sb;
    }

    public static Map<String, Long> queryOrgChildCount(Date queryDate, Set<Long> parentIds, List<Long> otClassifyIds) {
        return OrgChartServiceHelper.queryOrgChildCount(queryDate, parentIds, otClassifyIds, null);
    }

    public static Map<String, Long> queryOrgChildCount(Date queryDate, Set<Long> parentIds, List<Long> otClassifyIds, String structProjectId) {
        ArrayList<Comparable<Date>> params = new ArrayList<Comparable<Date>>(16);
        params.add(queryDate);
        params.add(queryDate);
        params.add(queryDate);
        params.add(queryDate);
        params.addAll(parentIds);
        String sql = OrgChartServiceHelper.getOrgChildCountSql(queryDate, parentIds, otClassifyIds, structProjectId);
        HashMap parentIdChildCountMap = Maps.newHashMapWithExpectedSize((int)parentIds.size());
        try (DataSet rs = HRDBUtil.queryDataSet((String)"queryOrgChildCount", (DBRoute)new DBRoute("haos"), (String)sql, (Object[])params.toArray(new Object[0]));){
            while (rs.hasNext()) {
                Row data = rs.next();
                Long orgCount = data.getLong("orgcount");
                Long parentId = data.getLong("fparentid");
                parentIdChildCountMap.put(String.valueOf(parentId), orgCount);
            }
        }
        return parentIdChildCountMap;
    }

    public static Map<String, Long> queryOrgChildCountWithPerm(Date queryDate, Set<Long> parentIds, List<Long> otClassifyIds, String structProjectId, List<Long> permOrgResultWithSub) {
        SqlBuilder sql = OrgChartServiceHelper.getOrgChildCountSqlWithPerm(queryDate, parentIds, otClassifyIds, structProjectId, permOrgResultWithSub);
        HashMap parentIdChildCountMap = Maps.newHashMapWithExpectedSize((int)parentIds.size());
        try (DataSet rs = DB.queryDataSet((String)"queryOrgChildCountWithPerm", (DBRoute)new DBRoute("haos"), (SqlBuilder)sql);){
            while (rs.hasNext()) {
                Row data = rs.next();
                Long orgCount = data.getLong("orgcount");
                Long parentId = data.getLong("fparentid");
                parentIdChildCountMap.put(String.valueOf(parentId), orgCount);
            }
        }
        return parentIdChildCountMap;
    }

    public static void setSimpleDataForCustomControl(String dataFlag, Map<String, Object> data, CustomControl customcontrol) {
        OrgChartServiceHelper.setSimpleDataForCustomControl(dataFlag, data, customcontrol, "200", "");
    }

    public static void setSimpleDataForSearchCustomControl(String dataFlag, Map<String, Object> data, CustomControl customcontrol) {
        DateFormat dateFormat = KDDateFormatUtils.getUserZoneDateFormat();
        data.put("today", dateFormat.format(new Date()));
        data.put("dateFormat", InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
        OrgChartServiceHelper.setSimpleDataForCustomControl(dataFlag, data, customcontrol, "200", "");
    }

    public static void setErrorDataForSearchCustomControl(String dataFlag, Map<String, Object> data, CustomControl customcontrol, String errorMessage) {
        DateFormat dateFormat = KDDateFormatUtils.getUserZoneDateFormat();
        data.put("today", dateFormat.format(new Date()));
        data.put("dateformat", InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
        OrgChartServiceHelper.setSimpleDataForCustomControl(dataFlag, data, customcontrol, "500", errorMessage);
    }

    public static void setSimpleDataForCustomControl(String dataFlag, Map<String, Object> data, CustomControl customcontrol, String code, String errorMessage) {
        data.put("orgChart", dataFlag);
        data.put("code", code);
        data.put("errorMessage", errorMessage);
        data.put("time", System.currentTimeMillis());
        customcontrol.setData(data);
    }

    public static boolean coreQueryConditionIsChange(Date newDate, Date oldDate, List<String> newOrgIds, List<String> oldOrgIds) {
        boolean flag1 = !OrgChartServiceHelper.isEquals(newDate, oldDate);
        boolean flag2 = CollectionUtils.isEmpty(newOrgIds) || !newOrgIds.containsAll(oldOrgIds) || newOrgIds.size() != oldOrgIds.size();
        return flag1 || flag2;
    }

    public static void setNodeIsUphole(OrgChartTreeNode orgChartRootNode, AuthorizedOrgResultWithSub permOrgResultWithSub, List<Long> permOrgIds, String currentRootParentOrg, SearchChartData searchChartData) {
        if (orgChartRootNode != null) {
            if (!searchChartData.getCoopRelTypes().contains("1010")) {
                Long orgTeamCoopOregTeamId = OrgChartServiceHelper.getOrgTeamCoopOregTeamId(Long.parseLong(orgChartRootNode.getBoid()), permOrgResultWithSub, permOrgIds, searchChartData);
                LOG.info("other CoopRelType orgTeamCoopOregTeamId={}", (Object)orgTeamCoopOregTeamId);
                orgChartRootNode.setIsUphole(orgTeamCoopOregTeamId == null ? "0" : "1");
            } else if (StringUtils.isEmpty((CharSequence)orgChartRootNode.getParentid()) || "0".equals(orgChartRootNode.getParentid()) || StringUtils.isEmpty((CharSequence)currentRootParentOrg)) {
                LOG.info("no Parentid or  no currentRootParentOrg ,so no Uphole");
                orgChartRootNode.setIsUphole("0");
            } else if (permOrgResultWithSub.isHasAllOrgPerm() && searchChartData.getOrgs().contains(currentRootParentOrg)) {
                LOG.info("AllOrgPerm  contains currentRootParentOrg ,so\u3000Uphole");
                orgChartRootNode.setIsUphole("1");
            } else if (!permOrgResultWithSub.isHasAllOrgPerm() && permOrgIds.contains(Long.parseLong(orgChartRootNode.getParentid())) && searchChartData.getOrgs().contains(currentRootParentOrg)) {
                LOG.info("no\u3000AllOrgPerm  contains currentRootParentOrg ,so\u3000Uphole");
                orgChartRootNode.setIsUphole("1");
            } else {
                orgChartRootNode.setIsUphole("0");
            }
        }
    }

    public static Long getOrgTeamCoopOregTeamId(Long currentOrgId, AuthorizedOrgResultWithSub permOrgResultWithSub, List<Long> permOrgIds, SearchChartData searchChartData) {
        Long coopOrgTeamId;
        block4: {
            DynamicObjectCollection orgTeamCoopRelInfos = OrgChartServiceHelper.getOrgTeamCoopRelInfos(searchChartData.getCoopRelTypes(), searchChartData.getDateField(), currentOrgId);
            coopOrgTeamId = null;
            if (CollectionUtils.isEmpty((Collection)orgTeamCoopRelInfos)) break block4;
            if (permOrgResultWithSub.isHasAllOrgPerm()) {
                for (DynamicObject dObject : orgTeamCoopRelInfos) {
                    if (!searchChartData.getOrgs().contains(dObject.getString("cooporgteam.org"))) continue;
                    coopOrgTeamId = dObject.getLong("cooporgteam.id");
                    break;
                }
            } else {
                for (DynamicObject dObject : orgTeamCoopRelInfos) {
                    if (!permOrgIds.contains(dObject.getLong("cooporgteam.id")) || !searchChartData.getOrgs().contains(dObject.getString("cooporgteam.org"))) continue;
                    coopOrgTeamId = dObject.getLong("cooporgteam.id");
                    break;
                }
            }
        }
        return coopOrgTeamId;
    }

    public static String getAdminOrgOrg(QFilter qFilter, String orgBoId) {
        DynamicObject adminOrgDyn;
        String adminOrgOrg = "";
        if (!StringUtils.isEmpty((CharSequence)orgBoId) && (adminOrgDyn = OrgChartServiceHelper.getRootDynByRootId(qFilter, Long.parseLong(orgBoId))) != null) {
            adminOrgOrg = adminOrgDyn.getString("orgteam.org");
        }
        return adminOrgOrg;
    }

    public static ListSelectedRowCollection getListSelectedRowCollection(JSONArray orgList) {
        ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
        orgList.forEach(object -> {
            JSONObject org = (JSONObject)object;
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue((Object)Long.parseLong(org.getString("id")));
            row.setNumber(org.getString("number"));
            row.setName(org.getString("name"));
            listSelectedRows.add((Object)row);
        });
        return listSelectedRows;
    }

    public static QFilter getAdminOrgTypeFilter() {
        HasPermOrgResult permOrg = OrgPermHelper.getHRPermOrg((String)"homs_orgchart");
        QFilter filter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "in", Arrays.asList("1", "0"));
        filter.and(enableFilter);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        filter.and(statusFilter);
        if (!permOrg.hasAllOrgPerm() && !CollectionUtils.isEmpty((Collection)permOrg.getHasPermOrgs())) {
            List hasPermOrgs = permOrg.getHasPermOrgs();
            HashSet adminOrgTypeIdSet = new HashSet();
            HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgtype");
            hasPermOrgs.forEach(orgId -> {
                QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"haos_adminorgtype", (Long)orgId);
                DynamicObject[] query = helper.query(new QFilter[]{filter, orgFilter});
                Stream.of(query).forEach(dy -> adminOrgTypeIdSet.add(dy.getLong("id")));
            });
            QFilter idFilter = new QFilter("id", "in", adminOrgTypeIdSet);
            filter.and(idFilter);
        }
        return filter;
    }

    public static QFilter getTeamCoopRelTypeFilters(Collection<Long> otclassifyIds) {
        HasPermOrgResult permOrg;
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_teamcoopreltype");
        QFilter filter = new QFilter("enable", "in", Arrays.asList("1", "0"));
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        filter.and(statusFilter);
        DynamicObject[] dynamicObjects = helper.loadDynamicObjectArray(filter.toArray());
        HashSet teamCoopRelTypeIds = new HashSet();
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("orgteamtype");
            dynamicObjectCollection.forEach(dy -> {
                if (otclassifyIds.contains(dy.getLong("fbasedataid.id"))) {
                    teamCoopRelTypeIds.add(dynamicObject.getLong("id"));
                }
            });
        }
        if (!CollectionUtils.isEmpty(teamCoopRelTypeIds)) {
            QFilter idFilter = new QFilter("id", "in", teamCoopRelTypeIds);
            filter.and(idFilter);
        }
        if (!(permOrg = OrgPermHelper.getHRPermOrg((String)"homs_orgchart")).hasAllOrgPerm() && !CollectionUtils.isEmpty((Collection)permOrg.getHasPermOrgs())) {
            QFilter baseDataFilter = BaseDataHelper.getBaseDataFilter((String)"haos_teamcoopreltype", (List)permOrg.getHasPermOrgs());
            filter.and(baseDataFilter);
        }
        return filter;
    }

    public static OrgChartTreeNode getVirtualNode() {
        return new OrgChartTreeNode("", "virtual100000", ResManager.loadKDString((String)"\u67e5\u8be2\u65e5\u671f\u65e0\u7236\u8282\u70b9\u3002", (String)"OrgChartServiceHelper_22", (String)"odc-homs-business", (Object[])new Object[0]), true);
    }

    public static void calculateName(List<OrgChartTreeNode> chartTreeNodeList, Date datefield, String structProjectId, boolean showCompanyName) {
        DynamicObject structProject = StructProjectRepository.getInstance().queryOneByStructProjectId("issyspreset", Long.parseLong(structProjectId));
        if (structProject != null && structProject.getBoolean("issyspreset")) {
            return;
        }
        if (showCompanyName) {
            Set<Long> orgIds = chartTreeNodeList.stream().map(dy -> Long.parseLong(dy.getBoid())).collect(Collectors.toSet());
            Map<Long, String> proxyResult = ProxyUtils.getLeftTreeNodeNames(orgIds, datefield, structProjectId);
            for (OrgChartTreeNode orgChartTreeNode : chartTreeNodeList) {
                Long boId = Optional.ofNullable(orgChartTreeNode.getBoid()).map(Long::parseLong).orElse(0L);
                String belongCompanyName = proxyResult.get(boId);
                if (HRObjectUtils.isEmpty((Object)belongCompanyName)) continue;
                String name = String.format(Locale.ROOT, "%s\uff08%s\uff09", orgChartTreeNode.getText(), belongCompanyName);
                orgChartTreeNode.setText(name);
            }
        }
    }

    private static void setIsvirtualorgLable(OrgChartTreeNode treeNode, ChartOrgInfo orgTypeInfo) {
        treeNode.setIsvirtualorg(orgTypeInfo.getIsvirtualorg());
        if ("true".equals(orgTypeInfo.getIsvirtualorg())) {
            ArrayList<TreeNodeLabel> labelParaList = new ArrayList<TreeNodeLabel>(8);
            TreeNodeLabel searchDateLabel = new TreeNodeLabel(ResManager.loadKDString((String)"\u865a\u62df\u7ec4\u7ec7", (String)"OrgChartServiceHelper_23", (String)"odc-homs-business", (Object[])new Object[0]), "#5582F3");
            labelParaList.add(searchDateLabel);
            treeNode.setLabelShowType(1);
            treeNode.setLabelPara(labelParaList);
        }
    }

    public static void setTreeNodeShowFieldsNew(Map<String, Set<String>> formIdFieldsMap, List<OrgChartTreeNode> chartTreeNodeList, OrgChartTreeNode rootNode, SearchChartData searchChartData, String structProjectId) {
        Set<Long> orgIds = chartTreeNodeList.stream().map(dy -> Long.parseLong(dy.getBoid())).collect(Collectors.toSet());
        HashMap orgIdShowFieldInfos = new HashMap();
        formIdFieldsMap.forEach((formId, fieldNames) -> OrgChartServiceHelper.getOrgTeamShowFields(orgIds, formId, fieldNames, orgIdShowFieldInfos, searchChartData.getDateField() == null ? new Date() : searchChartData.getDateField(), structProjectId));
        Set<String> fieldNames2 = formIdFieldsMap.get("calculate_api");
        Map<Object, Object> parentIdChildCountMap = Maps.newHashMapWithExpectedSize((int)chartTreeNodeList.size());
        if (!CollectionUtils.isEmpty(fieldNames2) && fieldNames2.contains("orgcount")) {
            parentIdChildCountMap = OrgChartServiceHelper.queryOrgChildCount(searchChartData.getDateField(), orgIds, Collections.singletonList(OrgChartConstants.DEFAULT_OTCCLASSIFY_ID), structProjectId);
        }
        for (OrgChartTreeNode treeNode : chartTreeNodeList) {
            Map showFieldInfos = (Map)orgIdShowFieldInfos.get(treeNode.getBoid());
            if (!CollectionUtils.isEmpty(fieldNames2) && fieldNames2.contains("orgcount")) {
                showFieldInfos.put("orgcount", parentIdChildCountMap.getOrDefault(treeNode.getBoid(), 0L));
            }
            treeNode.setShowFields(showFieldInfos);
        }
        Set<String> personFieldNames = formIdFieldsMap.get("person_api");
        if (!CollectionUtils.isEmpty(personFieldNames) && personFieldNames.contains("totalpersoncount")) {
            OrgChartServiceHelper.calculateOrgAllPersonCount(rootNode);
        }
    }

    public static String checkSchemeNew(SearchChartData schemeSearchChartData, String rootId, AuthorizedOrgResultWithSub permOrgResultWithSub, HasPermOrgResult permOrg, String structProjectId) {
        QFilter defaultFilter = OrgChartServiceHelper.getDefaultFilter(schemeSearchChartData.getDateField());
        DynamicObject rootDyn = null;
        if (!StringUtils.isEmpty((CharSequence)rootId)) {
            defaultFilter.and(new QFilter("structproject", "=", (Object)Long.parseLong(structProjectId)));
            rootDyn = OrgChartServiceHelper.getRootDynByRootId(defaultFilter, Long.parseLong(rootId));
        }
        StringBuilder sb = new StringBuilder();
        Set<String> chartStyleIds = OrgChartServiceHelper.getChartStyleIds(permOrgResultWithSub, OrgChartConstants.ORG_CARDDISSION);
        chartStyleIds.add("1001");
        QFilter chartStyleIdFilter = new QFilter("id", "in", (Object)(StringUtils.isEmpty((CharSequence)schemeSearchChartData.getChartStyleId()) ? 0L : Long.parseLong(schemeSearchChartData.getChartStyleId())));
        if (rootDyn == null || !OrgChartServiceHelper.checkRootDynPerm(permOrg, rootDyn, permOrgResultWithSub, schemeSearchChartData.getDateField(), structProjectId)) {
            sb.append(OrgChartServiceHelper.getString1());
            sb.append("\u3001");
        }
        if (!OrgChartServiceHelper.adminOrgTypeIsExist(schemeSearchChartData.getAdminOrgTypes())) {
            sb.append(OrgChartServiceHelper.getString2());
            sb.append("\u3001");
        }
        if (!OrgChartServiceHelper.orgIsExist(schemeSearchChartData.getOrgs(), permOrg)) {
            sb.append(OrgChartServiceHelper.getString3());
            sb.append("\u3001");
        }
        if (!OrgChartServiceHelper.teamCoopRelTypeIsExist(schemeSearchChartData.getCoopRelTypes())) {
            sb.append(OrgChartServiceHelper.getString4());
            sb.append("\u3001");
        }
        return sb.toString();
    }

    private static String getString1() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u7ec4\u7ec7", (String)"OrgChartServiceHelper_9", (String)"odc-homs-business", (Object[])new Object[0]);
    }

    private static String getString2() {
        return ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b", (String)"OrgChartServiceHelper_7", (String)"odc-homs-business", (Object[])new Object[0]);
    }

    private static String getString3() {
        return ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7", (String)"OrgChartServiceHelper_10", (String)"odc-homs-business", (Object[])new Object[0]);
    }

    private static String getString4() {
        return ResManager.loadKDString((String)"\u6c47\u62a5\u53ca\u534f\u4f5c\u5173\u7cfb", (String)"OrgChartServiceHelper_11", (String)"odc-homs-business", (Object[])new Object[0]);
    }

    static {
        JSONObject orgDefaultColor = new JSONObject();
        orgDefaultColor.put("backgroundcolor", (Object)"#FFFFFF");
        orgDefaultColor.put("bordercolor", (Object)"#CCCCCC");
        orgDefaultColor.put("topbordercolor", (Object)"#276FF5");
        CARDDIMENSION_ID_DEFAULT_COLOR.put("1010", orgDefaultColor);
        JSONObject projectDefaultColor = new JSONObject();
        projectDefaultColor.put("backgroundcolor", (Object)"#FFFFFF");
        projectDefaultColor.put("bordercolor", (Object)"#CCCCCC");
        projectDefaultColor.put("topbordercolor", (Object)"#1BA854");
        CARDDIMENSION_ID_DEFAULT_COLOR.put("1020", projectDefaultColor);
        JSONObject positionDefaultColor = new JSONObject();
        positionDefaultColor.put("backgroundcolor", (Object)"#F4F8FE");
        positionDefaultColor.put("bordercolor", (Object)"#276FF5");
        positionDefaultColor.put("topbordercolor", (Object)"");
        CARDDIMENSION_ID_DEFAULT_COLOR.put("1110", positionDefaultColor);
    }
}

