/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgchart;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.haos.business.service.staff.occupy.impl.StaffOccupyServiceImpl;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.orgchart.OrgChartServiceHelper;
import kd.hr.homs.common.model.CardStyle;
import kd.hr.homs.common.model.CardStyleField;
import kd.hr.homs.common.model.ChartStyle;
import kd.hr.homs.common.model.OrgChartQueryParam;
import kd.hr.homs.common.model.OrgChartTreeNode;
import kd.hr.homs.common.model.SearchChartData;
import kd.hrmp.hbpm.business.application.impl.position.PositionJobServiceApplicationImpl;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;

public class PositionRelationServiceHelper {
    private static final Log LOG = LogFactory.getLog(PositionRelationServiceHelper.class);
    private static final String IHBPM_EMPLOYEE_SERVICE = "IHRPIEmployeeService";
    private static final String HRPI = "hrpi";
    private static final String POSITION_FIELD = "id,boid,name,number,parent,workrole,isleader,org, adminorg";
    private static final String PERSONNAME = "personname";

    public static SearchChartData getPositionSchemeSearchChartData(OrgChartQueryParam orgChartQueryParam) {
        if (orgChartQueryParam == null) {
            return PositionRelationServiceHelper.getDefaultPositionSearchChartData(new Date());
        }
        SearchChartData searchChartData = new SearchChartData();
        searchChartData.setOrgs(orgChartQueryParam.getOrgs());
        searchChartData.setDateField(OrgChartServiceHelper.getQueryDate(orgChartQueryParam));
        searchChartData.setPositionId(orgChartQueryParam.getPositionId());
        searchChartData.setCoopRelTypes(orgChartQueryParam.getCoopRelTypes());
        searchChartData.setChartStyleId(orgChartQueryParam.getChartStyleId());
        searchChartData.setShowLevel(orgChartQueryParam.getShowLevel());
        searchChartData.setOrgChartDirection(orgChartQueryParam.getOrgChartDirection());
        searchChartData.setOrgChartDirection(orgChartQueryParam.getOrgChartDirection());
        return searchChartData;
    }

    private static SearchChartData getDefaultPositionSearchChartData(Date date) {
        SearchChartData searchChartData = new SearchChartData();
        searchChartData.setOrgs(OrgChartServiceHelper.getDefaultOrg("homs_positionrelation").stream().map(dy -> String.valueOf(dy)).collect(Collectors.toList()));
        searchChartData.setDateField(date);
        searchChartData.setCoopRelTypes(Collections.singletonList("1010"));
        searchChartData.setShowLevel("3");
        searchChartData.setOrgChartDirection("1");
        searchChartData.setSchemeId(null);
        return searchChartData;
    }

    public static QFilter getDateFilterWithDate(Date queryDate) {
        QFilter queryDateFilter = new QFilter("bsled", ">=", (Object)(queryDate == null ? new Date() : queryDate));
        queryDateFilter.and(new QFilter("bsed", "<=", (Object)(queryDate == null ? new Date() : queryDate)));
        return queryDateFilter;
    }

    public static OrgChartTreeNode getRootTreeNode(DynamicObject rootDy, SearchChartData searchChartData, AuthorizedOrgResult authorizedOrgResult) {
        OrgChartTreeNode treeNode = new OrgChartTreeNode(null, rootDy.getString("boid"), rootDy.getString("name"), true);
        treeNode.setNumber(rootDy.getString("number"));
        treeNode.setOtclassify("1110");
        treeNode.setBoid(rootDy.getString("boid"));
        List orgsIdList = searchChartData.getOrgs().stream().map(Long::parseLong).collect(Collectors.toList());
        QFilter orgsFilter = new QFilter("org", "in", orgsIdList);
        QFilter dateFilter = OrgChartServiceHelper.getBaseCommonFilterWithDate(searchChartData.getDateField());
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        orgsFilter.and(dateFilter);
        orgsFilter.and(currentFilter);
        if (!authorizedOrgResult.isHasAllOrgPerm()) {
            List hasPermOrgs = authorizedOrgResult.getHasPermOrgs();
            orgsFilter.and(new QFilter("adminorg", "in", (Object)hasPermOrgs));
        }
        DynamicObjectCollection levelToDy = PositionRelationServiceHelper.getAllPositionCollection(orgsFilter, rootDy, searchChartData.getShowLevel());
        List<OrgChartTreeNode> treeNodes = PositionRelationServiceHelper.getPositionTreeNodes(levelToDy);
        treeNodes.add(treeNode);
        Map<String, List<OrgChartTreeNode>> parentIdChildMap = treeNodes.stream().filter(node -> HRStringUtils.isNotEmpty((String)node.getParentid())).collect(Collectors.groupingBy(TreeNode::getParentid));
        PositionRelationServiceHelper.addChildNodes(treeNode, parentIdChildMap);
        PositionRelationServiceHelper.setShowFieldInfos(treeNodes, searchChartData);
        PositionRelationServiceHelper.setIsUphole(treeNode, rootDy, searchChartData, authorizedOrgResult);
        return treeNode;
    }

    public static void setIsUphole(OrgChartTreeNode treeNode, DynamicObject rootDy, SearchChartData searchChartData, AuthorizedOrgResult authorizedOrgResult) {
        Long parentPositionId;
        DynamicObject parentPosition;
        List cooprelTypes = searchChartData.getCoopRelTypes();
        String cooprelTypeId = "";
        if (!CollectionUtils.isEmpty((Collection)cooprelTypes)) {
            cooprelTypeId = (String)cooprelTypes.get(0);
        }
        if (PositionRelationServiceHelper.checkPositionPerm(parentPosition = PositionRelationServiceHelper.getParentPosition(cooprelTypeId, parentPositionId = Long.valueOf(rootDy.getLong("parent.id")), rootDy.getLong("workrole.id")), authorizedOrgResult)) {
            treeNode.setIsUphole("1");
            treeNode.setParentNodeId(parentPosition.getString("boid"));
        } else {
            treeNode.setIsUphole("0");
            treeNode.setParentNodeId("");
        }
    }

    public static DynamicObject getParentPosition(String cooprelTypeId, Long parentPositionId, Long workroleId) {
        HRBaseServiceHelper positionHepler = new HRBaseServiceHelper("hbpm_positionhr");
        DynamicObject parentPosition = null;
        if ("1010".equals(cooprelTypeId)) {
            parentPosition = positionHepler.queryOne("boid, org, adminorg.boid", new QFilter("id", "=", (Object)parentPositionId));
        } else {
            HRBaseServiceHelper relationHelper = new HRBaseServiceHelper("hbpm_reportingrelation");
            QFilter filter = new QFilter("role", "=", (Object)workroleId);
            filter.and(new QFilter("reportingtype", "=", (Object)Long.parseLong(cooprelTypeId)));
            DynamicObject parentRole = relationHelper.queryOne("parent", filter.toArray());
            if (parentRole == null) {
                return null;
            }
            parentPosition = positionHepler.queryOne("boid, org, adminorg.boid", new QFilter("workrole", "=", (Object)parentRole.getLong("parent.id")));
        }
        return parentPosition;
    }

    public static boolean checkPositionPerm(DynamicObject parentPosition, AuthorizedOrgResult authorizedOrgResult) {
        if (parentPosition == null) {
            return false;
        }
        long adminorg = parentPosition.getLong("adminorg.id");
        if (authorizedOrgResult.isHasAllOrgPerm()) {
            return true;
        }
        List hasPermAdminorgs = authorizedOrgResult.getHasPermOrgs();
        if (!new HashSet(hasPermAdminorgs).contains(adminorg)) {
            return false;
        }
        long org = parentPosition.getLong("org.id");
        HasPermOrgResult permOrgResult = OrgPermHelper.getHRPermOrg((String)"homs_positionrelation");
        if (permOrgResult.hasAllOrgPerm()) {
            return true;
        }
        List hasPermOrgs = permOrgResult.getHasPermOrgs();
        return new HashSet(hasPermOrgs).contains(org);
    }

    public static OrgChartTreeNode getRootTreeNodeByCooperationType(DynamicObject rootDy, SearchChartData searchChartData, AuthorizedOrgResult authorizedOrgResult, Map<Long, Boolean> positionCooppermMap) {
        OrgChartTreeNode treeNode = new OrgChartTreeNode(null, rootDy.getString("boid"), rootDy.getString("name"), true);
        treeNode.setNumber(rootDy.getString("number"));
        treeNode.setOtclassify("1110");
        treeNode.setBoid(rootDy.getString("boid"));
        treeNode.setData((Object)rootDy.getLong("workrole.id"));
        QFilter filter = OrgChartServiceHelper.getBaseCommonFilterWithDate(searchChartData.getDateField());
        HashMap<String, Set<String>> parentToRoles = new HashMap<String, Set<String>>();
        DynamicObjectCollection positionCollection = PositionRelationServiceHelper.getAllPositionCollectionByCooperationType(filter, rootDy, searchChartData, authorizedOrgResult, parentToRoles, positionCooppermMap);
        List<OrgChartTreeNode> treeNodes = PositionRelationServiceHelper.getPositionTreeNodes(positionCollection);
        treeNodes.add(treeNode);
        Map<String, List<OrgChartTreeNode>> roleIdToPositionInfo = treeNodes.stream().filter(node -> !HRObjectUtils.isEmpty((Object)node.getData())).collect(Collectors.groupingBy(node -> node.getData().toString()));
        if (!CollectionUtils.isEmpty(parentToRoles)) {
            PositionRelationServiceHelper.addCooperationChildNodes(treeNode, roleIdToPositionInfo, parentToRoles);
        }
        PositionRelationServiceHelper.setShowFieldInfos(treeNodes, searchChartData);
        PositionRelationServiceHelper.setIsUphole(treeNode, rootDy, searchChartData, authorizedOrgResult);
        return treeNode;
    }

    private static void addCooperationChildNodes(OrgChartTreeNode rootNode, Map<String, List<OrgChartTreeNode>> roleIdToPositionInfo, Map<String, Set<String>> parentToRoles) {
        Set<String> roleIds = parentToRoles.get(rootNode.getData().toString());
        if (!CollectionUtils.isEmpty(roleIds)) {
            roleIds.forEach(roleId -> {
                List treeNodes = (List)roleIdToPositionInfo.get(roleId);
                if (!CollectionUtils.isEmpty((Collection)treeNodes)) {
                    ArrayList childrenTreeNodes = new ArrayList(treeNodes);
                    List children = rootNode.getChildren();
                    if (children == null) {
                        rootNode.setChildren(childrenTreeNodes);
                    } else {
                        children.addAll(childrenTreeNodes);
                        rootNode.setChildren(children);
                    }
                    treeNodes.forEach(treeNode -> PositionRelationServiceHelper.addCooperationChildNodes(treeNode, roleIdToPositionInfo, parentToRoles));
                    rootNode.setLeaf(false);
                }
            });
        }
    }

    private static DynamicObjectCollection getAllPositionCollectionByCooperationType(QFilter filter, DynamicObject rootDy, SearchChartData searchChartData, AuthorizedOrgResult authorizedOrgResult, Map<String, Set<String>> parentToRoles, Map<Long, Boolean> positionCooppermMap) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbpm_reportingrelation");
        HRBaseServiceHelper positionHelper = new HRBaseServiceHelper("hbpm_positionhr");
        int level = Integer.parseInt(searchChartData.getShowLevel());
        DynamicObjectCollection dyCollection = new DynamicObjectCollection();
        HashMap<Integer, DynamicObjectCollection> levelToDy = new HashMap<Integer, DynamicObjectCollection>();
        DynamicObjectCollection firstCollection = new DynamicObjectCollection();
        firstCollection.add((Object)rootDy);
        levelToDy.put(1, firstCollection);
        for (int index = 2; index <= level; ++index) {
            Set workRoleSet;
            DynamicObjectCollection collection = (DynamicObjectCollection)levelToDy.get(index - 1);
            if (collection == null || CollectionUtils.isEmpty(workRoleSet = index == 2 ? collection.stream().filter(dy -> dy.getLong("workrole.id") != 0L).map(dy -> dy.getLong("workrole.id")).collect(Collectors.toSet()) : collection.stream().filter(dy -> dy.getLong("workrole") != 0L).map(dy -> dy.getLong("workrole")).collect(Collectors.toSet()))) continue;
            QFilter parentFilter = new QFilter("parent", "in", workRoleSet);
            QFilter typeFilter = new QFilter("reportingtype", "=", (Object)Long.parseLong((String)searchChartData.getCoopRelTypes().get(0)));
            LOG.info("workRoleInfo : {}, coopreltypeInfo: {}", (Object)workRoleSet.toString(), searchChartData.getCoopRelTypes().get(0));
            DynamicObjectCollection dyColl = helper.queryOriginalCollection("id,boid,role,parent,reportingtype", new QFilter[]{filter, parentFilter, typeFilter});
            if (dyColl == null || dyColl.size() <= 0) continue;
            LOG.info("getAllPositionCollectionByCooperationType getCooperation : {}", (Object)dyColl.toString());
            Map collect = dyColl.stream().filter(dy -> HRStringUtils.isNotEmpty((String)dy.getString("parent"))).collect(Collectors.groupingBy(dy -> dy.getString("parent"), Collectors.mapping(dy -> dy.getString("role"), Collectors.toSet())));
            parentToRoles.putAll(collect);
            Set rolesIds = dyColl.stream().map(dy -> dy.getLong("role")).collect(Collectors.toSet());
            QFilter roleFilter = new QFilter("workrole", "in", rolesIds);
            DynamicObjectCollection positonDys = positionHelper.queryOriginalCollection(POSITION_FIELD, new QFilter[]{filter, roleFilter});
            if (positonDys == null || positonDys.size() <= 0) continue;
            DynamicObjectCollection levelCollection = PositionRelationServiceHelper.filterBUAndAdminorgPerm(searchChartData, authorizedOrgResult, positionCooppermMap, positonDys);
            levelToDy.put(index, levelCollection);
            dyCollection.addAll((Collection)levelCollection);
        }
        return dyCollection;
    }

    private static DynamicObjectCollection filterBUAndAdminorgPerm(SearchChartData searchChartData, AuthorizedOrgResult authorizedOrgResult, Map<Long, Boolean> positionCooppermMap, DynamicObjectCollection positonDys) {
        DynamicObjectCollection levelCollection = new DynamicObjectCollection();
        Set orgsIdList = searchChartData.getOrgs().stream().map(Long::parseLong).collect(Collectors.toSet());
        if (positionCooppermMap == null || positionCooppermMap.isEmpty()) {
            List list;
            if (authorizedOrgResult.isHasAllOrgPerm()) {
                list = positonDys.stream().filter(dy -> orgsIdList.contains(dy.getLong("org"))).collect(Collectors.toList());
            } else {
                List hasPermOrgs = authorizedOrgResult.getHasPermOrgs();
                list = positonDys.stream().filter(dy -> orgsIdList.contains(dy.getLong("org")) && hasPermOrgs.contains(dy.getLong("adminorg"))).collect(Collectors.toList());
            }
            levelCollection.addAll(list);
        } else {
            positonDys.forEach(dy -> {
                long buid = dy.getLong("org");
                if (positionCooppermMap.containsKey(buid) || positionCooppermMap.containsKey(String.valueOf(buid))) {
                    levelCollection.add(dy);
                } else if (orgsIdList.contains(buid) && authorizedOrgResult.isHasAllOrgPerm()) {
                    levelCollection.add(dy);
                } else if (orgsIdList.contains(buid) && authorizedOrgResult.getHasPermOrgs().contains(dy.getLong("adminorg"))) {
                    levelCollection.add(dy);
                }
            });
        }
        return levelCollection;
    }

    private static void setShowFieldInfos(List<OrgChartTreeNode> treeNodes, SearchChartData searchChartData) {
        String chartStyleId = searchChartData.getChartStyleId();
        if (HRStringUtils.isNotEmpty((String)chartStyleId)) {
            HashSet<String> chartStyleIds = new HashSet<String>();
            chartStyleIds.add(chartStyleId);
            chartStyleIds.add("1002");
            Map<String, ChartStyle> chartStyleIdChartStyleMap = OrgChartServiceHelper.getChartStyles(chartStyleIds);
            ChartStyle matchChartStyle = chartStyleIdChartStyleMap.get(chartStyleId);
            if (matchChartStyle != null) {
                List cardStyles = matchChartStyle.getCardStyles();
                List cardStyleFields = ((CardStyle)cardStyles.get(0)).getCardStyleFields();
                Map formIdFieldsMap = cardStyleFields.stream().collect(Collectors.groupingBy(CardStyleField::getEntityidentifier, Collectors.mapping(CardStyleField::getFieldidentifier, Collectors.toSet())));
                Set positionIds = treeNodes.stream().map(dy -> Long.parseLong(dy.getBoid())).collect(Collectors.toSet());
                HashMap orgIdShowFieldInfos = new HashMap();
                formIdFieldsMap.forEach((formId, fieldNames) -> PositionRelationServiceHelper.getPositionShowFields(positionIds, formId, fieldNames, orgIdShowFieldInfos, searchChartData.getDateField() == null ? new Date() : searchChartData.getDateField()));
                treeNodes.forEach(treeNode -> {
                    Map showFieldInfos = (Map)orgIdShowFieldInfos.get(treeNode.getBoid());
                    treeNode.setShowFields(showFieldInfos);
                });
            }
        }
    }

    private static List<OrgChartTreeNode> getPositionTreeNodes(DynamicObjectCollection treeViewCollection) {
        List<OrgChartTreeNode> treeNodeList = treeViewCollection.stream().map(dy -> {
            OrgChartTreeNode orgChartTreeNode = PositionRelationServiceHelper.wrapTreeNode(dy);
            return orgChartTreeNode;
        }).collect(Collectors.toList());
        return treeNodeList;
    }

    public static OrgChartTreeNode wrapTreeNode(DynamicObject dy) {
        OrgChartTreeNode rootNode = new OrgChartTreeNode();
        rootNode.setId(dy.getString("boid"));
        rootNode.setBoid(dy.getString("boid"));
        rootNode.setText(dy.getString("name"));
        if (dy.get("parent") != null) {
            rootNode.setParentid(dy.get("parent").toString());
        }
        rootNode.setIndex(Long.valueOf(0L));
        rootNode.setOtclassify("1110");
        rootNode.setData((Object)dy.getLong("workrole"));
        return rootNode;
    }

    private static DynamicObjectCollection getAllPositionCollection(QFilter filter, DynamicObject rootDy, String showlevel) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbpm_positionhr");
        int level = Integer.parseInt(showlevel);
        DynamicObjectCollection dyCollection = new DynamicObjectCollection();
        HashMap<Integer, DynamicObjectCollection> levelToDy = new HashMap<Integer, DynamicObjectCollection>();
        DynamicObjectCollection firstCollection = new DynamicObjectCollection();
        firstCollection.add((Object)rootDy);
        levelToDy.put(1, firstCollection);
        for (int index = 2; index <= level; ++index) {
            List idList;
            QFilter parentFilter;
            DynamicObjectCollection dyColl;
            DynamicObjectCollection collection = (DynamicObjectCollection)levelToDy.get(index - 1);
            if (collection == null || (dyColl = helper.queryOriginalCollection(POSITION_FIELD, new QFilter[]{filter, parentFilter = new QFilter("parent", "in", idList = collection.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toList()))})) == null || dyColl.size() <= 0) continue;
            levelToDy.put(index, dyColl);
            dyCollection.addAll((Collection)dyColl);
        }
        return dyCollection;
    }

    public static JSONObject getPositionInfo(String positionId, Date date) {
        if (HRStringUtils.isNotEmpty((String)positionId)) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hbpm_positionhr");
            QFilter filter = OrgChartServiceHelper.getBaseCommonFilterWithDate(date);
            filter.and(new QFilter("boid", "=", (Object)Long.parseLong(positionId)));
            DynamicObject dy = helper.queryOne("id,boid,name,number,parent.id,workrole.id", filter);
            if (dy != null) {
                JSONObject positionInfo = new JSONObject();
                positionInfo.put("id", (Object)dy.getString("boid"));
                positionInfo.put("name", (Object)dy.getString("name"));
                positionInfo.put("number", (Object)dy.getString("number"));
                positionInfo.put("parent", (Object)dy.getString("parent.id"));
                positionInfo.put("workrole", (Object)dy.getString("workrole.id"));
                return positionInfo;
            }
        }
        return new JSONObject();
    }

    public static void positionPermQuery(Map<String, Object> result) {
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)"homs_positionrelation");
        boolean hasPositionExportPerm = PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)"11", (String)appId, (String)"homs_positionrelation", (String)"4730fc9f000004ae");
        boolean hasPositionDetailsPerm = PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)"11", (String)appId, (String)"homs_positionrelation", (String)"2O23NJWUF=WK");
        result.put("hasPositionExportPerm", hasPositionExportPerm ? 1 : 0);
        result.put("hasPositionDetailsPerm", hasPositionDetailsPerm ? 1 : 0);
    }

    public static void getPositionShowFields(Set<Long> positionIds, String formId, Set<String> fieldNames, Map<String, Map<String, Object>> orgIdShowFieldInfos, Date queryDate) {
        switch (formId) {
            case "person_api": {
                PositionRelationServiceHelper.getPersonDataInfo(positionIds, orgIdShowFieldInfos, queryDate);
                break;
            }
            case "homs_position": {
                PositionRelationServiceHelper.getPositionData(positionIds, fieldNames, orgIdShowFieldInfos, queryDate);
                break;
            }
            case "position_helper": {
                PositionRelationServiceHelper.getPositionHelperData(positionIds, orgIdShowFieldInfos, queryDate);
                break;
            }
            case "staff_api": {
                PositionRelationServiceHelper.getPositionStaffInfo(positionIds, orgIdShowFieldInfos, queryDate);
                break;
            }
            case "hjm_jobhr": {
                PositionRelationServiceHelper.getPositionHisInfo(positionIds, orgIdShowFieldInfos, queryDate);
                break;
            }
        }
    }

    private static void getPositionHisInfo(Set<Long> positionIds, Map<String, Map<String, Object>> orgIdShowFieldInfos, Date queryDate) {
        PositionJobServiceApplicationImpl application = new PositionJobServiceApplicationImpl();
        try {
            Map positionMap = application.queryPositionRefJobHisInfo(new ArrayList<Long>(positionIds), queryDate);
            LOG.info("{} \u67e5\u8be2\u804c\u4f4d\u804c\u7ea7\u804c\u7b49\u7b49\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c\u4e3a:{}", (Object)JSONObject.toJSONString(positionIds), (Object)JSONObject.toJSONString((Object)positionMap));
            if (positionMap == null) {
                return;
            }
            positionMap.forEach((positionBoid, map) -> {
                String positionId = String.valueOf(positionBoid);
                Map showFieldInfos = orgIdShowFieldInfos.getOrDefault(positionId, new HashMap());
                if (map.get("jobinfo") != null) {
                    showFieldInfos.put("jobname", ((OrmLocaleValue)((HashMap)map.get("jobinfo")).get("name")).getLocaleValue());
                }
                if (map.get("jobseq") != null) {
                    showFieldInfos.put("jobseq", ((OrmLocaleValue)((HashMap)map.get("jobseq")).get("name")).getLocaleValue());
                }
                if (map.get("jobfamily") != null) {
                    showFieldInfos.put("jobfamily.name", ((OrmLocaleValue)((HashMap)map.get("jobfamily")).get("name")).getLocaleValue());
                }
                if (map.get("jobclass") != null) {
                    showFieldInfos.put("jobclass.name", ((OrmLocaleValue)((HashMap)map.get("jobclass")).get("name")).getLocaleValue());
                }
                if (map.get("lowjobgrade") != null && map.get("highjobgrade") != null) {
                    String lowjobgrade = (String)((HashMap)map.get("lowjobgrade")).get("name");
                    String highjobgrade = (String)((HashMap)map.get("highjobgrade")).get("name");
                    showFieldInfos.put("jobgraderang", lowjobgrade + "~" + highjobgrade);
                }
                if (map.get("lowjoblevel") != null && map.get("highjoblevel") != null) {
                    String lowjoblevel = (String)((HashMap)map.get("lowjoblevel")).get("name");
                    String highjoblevel = (String)((HashMap)map.get("highjoblevel")).get("name");
                    showFieldInfos.put("joblevelrang", lowjoblevel + "~" + highjoblevel);
                }
                orgIdShowFieldInfos.put(positionId, showFieldInfos);
            });
        }
        catch (Exception e) {
            LOG.error("\u67e5\u8be2\u804c\u4f4d\u804c\u7ea7\u804c\u7b49\u7b49\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c\u4e3a error", (Throwable)e);
        }
    }

    private static void getPositionStaffInfo(Set<Long> positionIds, Map<String, Map<String, Object>> orgIdShowFieldInfos, Date queryDate) {
        StaffOccupyServiceImpl staffOccupyService = new StaffOccupyServiceImpl();
        try {
            HashMap positionStaffInfo = staffOccupyService.queryPositionStaffInfo(queryDate, new ArrayList<Long>(positionIds));
            LOG.info("\u7f16\u5236\u6570\u636e\u67e5\u8be2\u7ed3\u679c: {}, \u5c97\u4f4dids: {}, \u65e5\u671f {}", new Object[]{JSONObject.toJSONString((Object)positionStaffInfo), JSONObject.toJSONString(positionIds), JSONObject.toJSONString((Object)queryDate)});
            if (positionStaffInfo == null) {
                positionStaffInfo = new HashMap();
            }
            HashMap finalPositionStaffInfo = positionStaffInfo;
            positionIds.forEach(positionId -> {
                Map staffInfoMap = (Map)finalPositionStaffInfo.get(String.valueOf(positionId));
                HashMap<String, Integer> fieldInfoMap = new HashMap<String, Integer>();
                if (!CollectionUtils.isEmpty((Map)staffInfoMap)) {
                    fieldInfoMap.put("astaffcount", staffInfoMap.getOrDefault("staffNum", 0));
                    fieldInfoMap.put("avaliableastaffcount", staffInfoMap.getOrDefault("remainStaffNum", 0));
                    int holdStaff = (Integer)fieldInfoMap.get("astaffcount") - (Integer)fieldInfoMap.get("avaliableastaffcount");
                    fieldInfoMap.put("holdstaff", holdStaff);
                } else {
                    fieldInfoMap.put("astaffcount", 0);
                    fieldInfoMap.put("avaliableastaffcount", 0);
                    fieldInfoMap.put("holdstaff", 0);
                }
                Map showFieldInfos = orgIdShowFieldInfos.getOrDefault(positionId.toString(), new HashMap());
                showFieldInfos.putAll(fieldInfoMap);
                orgIdShowFieldInfos.put(positionId.toString(), showFieldInfos);
            });
        }
        catch (Exception e) {
            LOG.error("getPositionStaffInfo error", (Throwable)e);
        }
    }

    private static void getPositionHelperData(Set<Long> positionIds, Map<String, Map<String, Object>> orgIdShowFieldInfos, Date queryDate) {
        try {
            ArrayList<Long> positionIdsList = new ArrayList<Long>(positionIds);
            Map positionIdToCount = PositionQueryRepository.getInstance().queryLowPositionCount(positionIdsList, queryDate);
            LOG.info("\u4e0b\u5c5e\u5c97\u4f4d\u6570\u63a5\u53e3\u67e5\u8be2\u7ed3\u679c: {}", (Object)JSONObject.toJSONString((Object)positionIdToCount));
            positionIds.forEach(positionId -> {
                Map showFieldInfos = orgIdShowFieldInfos.getOrDefault(positionId.toString(), new HashMap());
                showFieldInfos.put("positioncount", positionIdToCount.getOrDefault(positionId, 0));
                orgIdShowFieldInfos.put(positionId.toString(), showFieldInfos);
            });
        }
        catch (Exception e) {
            LOG.error("\u4e0b\u5c5e\u5c97\u4f4d\u6570\u63a5\u53e3\u67e5\u8be2\u7ed3\u679c error", (Throwable)e);
        }
    }

    private static void getPositionData(Set<Long> orgIds, Set<String> fieldNames, Map<String, Map<String, Object>> orgIdShowFieldInfos, Date queryDate) {
        fieldNames.add("boid");
        String selectProperties = String.join((CharSequence)",", fieldNames);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_positionhr");
        QFilter orgIdFilter = new QFilter("boid", "in", orgIds);
        DynamicObject[] orgInfo = serviceHelper.query(selectProperties, new QFilter[]{orgIdFilter, OrgChartServiceHelper.getBaseCommonFilterWithDate(queryDate)});
        Stream.of(orgInfo).forEach(dy -> {
            HashMap fieldInfoMap = new HashMap();
            fieldNames.forEach(fieldName -> {
                if (!"boid".equals(fieldName)) {
                    fieldInfoMap.put(fieldName, dy.getString(fieldName));
                }
            });
            Map showFieldInfos = orgIdShowFieldInfos.getOrDefault(dy.getString("boid"), new HashMap());
            showFieldInfos.putAll(fieldInfoMap);
            orgIdShowFieldInfos.put(dy.getString("boid"), showFieldInfos);
        });
    }

    private static void getPersonDataInfo(Set<Long> positionIds, Map<String, Map<String, Object>> orgIdShowFieldInfos, Date queryDate) {
        if (CollectionUtils.isEmpty(positionIds)) {
            LOG.info("getPersonDataInfo positionIds is null");
        }
        LOG.info("getPersonDataInfo positionIds : {}", (Object)positionIds.toString());
        try {
            List personResult = (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)IHBPM_EMPLOYEE_SERVICE, (String)"getOrgHisPerson", (Object[])new Object[]{queryDate, new ArrayList<Long>(positionIds)});
            LOG.info("\u5c97\u4f4dids: {}, \u65e5\u671f {}", (Object)positionIds.toString(), (Object)queryDate.toString());
            if (CollectionUtils.isEmpty((Collection)personResult)) {
                LOG.info("\u4eba\u5458\u63a5\u53e3\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
                positionIds.forEach(positionId -> {
                    Map showFieldInfos = orgIdShowFieldInfos.getOrDefault(positionId.toString(), new HashMap());
                    showFieldInfos.put("personcount", 0L);
                    showFieldInfos.put("personavtor", "");
                    showFieldInfos.put(PERSONNAME, "");
                    orgIdShowFieldInfos.put(positionId.toString(), showFieldInfos);
                });
            } else {
                LOG.info("\u4eba\u5458\u63a5\u53e3\u67e5\u8be2\u7ed3\u679c: {}", (Object)personResult.toString());
                Map<String, List<Map>> positionPersonMap = personResult.stream().collect(Collectors.groupingBy(map -> map.get("positionId").toString()));
                positionPersonMap.forEach((positionId, list) -> {
                    Map showFieldInfos = orgIdShowFieldInfos.getOrDefault(positionId, new HashMap());
                    showFieldInfos.put("personcount", list.size());
                    showFieldInfos.put("hasMorePrimaryPerson", 1);
                    String personname = list.stream().filter(map -> !StringUtils.isEmpty((CharSequence)((String)map.get("name")))).map(map -> (String)map.get("name")).collect(Collectors.joining(";"));
                    LOG.info("positionId= {}, personname ={}", positionId, (Object)personname);
                    if (!StringUtils.isEmpty((CharSequence)personname)) {
                        Object resultValue = PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_person", (String)"name", (String)Lang.get().toString(), (String)"LIST", (DynamicObject)null, (Object)personname);
                        showFieldInfos.put(PERSONNAME, resultValue);
                    } else {
                        showFieldInfos.put(PERSONNAME, "");
                    }
                    String personavtor = "";
                    if (list.size() == 1) {
                        personavtor = HRImageUrlUtil.getImageFullUrl((String)((Map)list.get(0)).getOrDefault("headsculpture", ""));
                        showFieldInfos.put("hasMorePrimaryPerson", 0);
                    }
                    showFieldInfos.put("personavtor", personavtor);
                    orgIdShowFieldInfos.put((String)positionId, showFieldInfos);
                });
            }
        }
        catch (Exception e) {
            LOG.error("getOrgHisPerson error:", (Throwable)e);
        }
    }

    public static List<JSONObject> getCoopRelTypes(Collection<Long> coopRelTypeIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbpm_reportcoreltype");
        QFilter filter = new QFilter("enable", "in", (Object)new String[]{"1", "0"});
        if (!CollectionUtils.isEmpty(coopRelTypeIds)) {
            QFilter idFilter = new QFilter("id", "in", coopRelTypeIds);
            filter.and(idFilter);
        }
        DynamicObject[] dynamicObjects = helper.query(filter.toArray());
        ArrayList<JSONObject> cooprelTypes = new ArrayList<JSONObject>();
        Stream.of(dynamicObjects).forEach(dy -> {
            JSONObject adminOrgType = new JSONObject();
            adminOrgType.put("id", (Object)dy.getString("id"));
            adminOrgType.put("name", (Object)dy.getString("name"));
            adminOrgType.put("number", (Object)dy.getString("number"));
            cooprelTypes.add(adminOrgType);
        });
        return cooprelTypes;
    }

    public static void addChildNodes(OrgChartTreeNode rootNode, Map<String, List<OrgChartTreeNode>> parentIdChildMap) {
        List<OrgChartTreeNode> childrenOrgChartTreeNodes = parentIdChildMap.get(rootNode.getBoid());
        if (!CollectionUtils.isEmpty(childrenOrgChartTreeNodes)) {
            parentIdChildMap.remove(rootNode.getBoid());
            ArrayList<OrgChartTreeNode> childrenTreeNodes = new ArrayList<OrgChartTreeNode>(childrenOrgChartTreeNodes);
            rootNode.setChildren(childrenTreeNodes);
            childrenOrgChartTreeNodes.forEach(treeNode -> PositionRelationServiceHelper.addChildNodes(treeNode, parentIdChildMap));
            rootNode.setLeaf(false);
        }
    }

    public static Object getPersonDesensitizeValue(String positionId, String personname, int isDesensitize, Date queryDate) {
        Object resultValue = "";
        if (isDesensitize == 1) {
            resultValue = PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_person", (String)"name", (String)Lang.get().toString(), (String)"LIST", (DynamicObject)null, (Object)personname);
        } else {
            ArrayList<Long> positionIds = new ArrayList<Long>();
            positionIds.add(Long.parseLong(positionId));
            List personResult = (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)IHBPM_EMPLOYEE_SERVICE, (String)"getOrgHisPerson", (Object[])new Object[]{queryDate, positionIds});
            LOG.info("\u5c97\u4f4dids: {}, \u65e5\u671f {}", (Object)positionId, (Object)queryDate.toString());
            resultValue = personResult.stream().map(map -> (String)map.get("name")).collect(Collectors.joining(";"));
        }
        return resultValue;
    }
}

