/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgchart;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.tree.TreeNode;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.homs.business.service.orgchart.CommonOrgChartServiceHelper;
import kd.hr.homs.business.service.orgchart.OrgChartServiceHelper;
import kd.hr.homs.common.constants.orgchart.OrgChartConstants;
import kd.hr.homs.common.constants.orgchart.ProjectChartConstants;
import kd.hr.homs.common.model.CardStyle;
import kd.hr.homs.common.model.CardStyleField;
import kd.hr.homs.common.model.ChartOrgInfo;
import kd.hr.homs.common.model.ChartStyle;
import kd.hr.homs.common.model.OrgChartTreeNode;
import kd.hr.homs.common.model.ProjectChartQueryParam;
import kd.hr.homs.common.model.ProjectSearchChartData;

public class ProjectChartServiceHelper {
    private static final Log LOG = LogFactory.getLog(ProjectChartServiceHelper.class);
    private static final String IHBPM_PROJECT_ROLE_SERVICE = "IProjectRoleService";
    private static final String IPTMM_QUERY_MEMBER_SERVICE = "IPTMMQueryMemberService";
    private static final String HBPM = "hbpm";
    private static final String PTMM = "ptmm";

    public static QFilter getOtClassifyFilter() {
        return new QFilter("orgteam.otclassify", "=", (Object)ProjectChartConstants.DEFAULT_OTCCLASSIFY_ID);
    }

    public static ProjectChartQueryParam analyzeScheme(FilterScheme filterScheme) {
        if (filterScheme == null) {
            return null;
        }
        String scheme = filterScheme.getScheme();
        List rows = (List)SerializationUtils.deSerializeFromBase64((String)scheme);
        scheme = ((List)((Map)rows.get(0)).get("FieldName")).get(0).toString();
        return (ProjectChartQueryParam)JSONObject.parseObject((String)scheme, ProjectChartQueryParam.class);
    }

    public static QFilter getSchemeFilter(ProjectChartQueryParam orgChartQueryParam) {
        if (orgChartQueryParam == null) {
            return OrgChartServiceHelper.getBaseCommonFilterWithDate(new Date());
        }
        Date queryDate = ProjectChartServiceHelper.getQueryDate(orgChartQueryParam);
        return OrgChartServiceHelper.getBaseCommonFilterWithDate(queryDate);
    }

    public static Date getQueryDate(ProjectChartQueryParam projectChartQueryParam) {
        Date queryDate = new Date();
        if (!"today".equals(projectChartQueryParam.getQueryDate())) {
            try {
                queryDate = HRDateTimeUtils.parseDate((String)projectChartQueryParam.getQueryDate(), (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                LOG.error(MessageFormat.format("date:{0}", projectChartQueryParam.getQueryDate()));
            }
        }
        return queryDate;
    }

    public static ProjectSearchChartData getDefaultSearchChartData(Date queryDate, AuthorizedOrgResultWithSub permOrgResultWithSub, List<Long> permProjectOrgIds) {
        ProjectSearchChartData searchChartData = new ProjectSearchChartData();
        searchChartData.setShowLevel("3");
        searchChartData.setOrgChartDirection("1");
        searchChartData.setDateField(queryDate);
        List<Long> defaultOrgs = OrgChartServiceHelper.getDefaultOrg("homs_projectchart");
        List<Object> orgIds = new ArrayList();
        if (!CollectionUtils.isEmpty(defaultOrgs)) {
            orgIds = defaultOrgs.stream().map(String::valueOf).collect(Collectors.toList());
        }
        searchChartData.setOrgs(orgIds);
        searchChartData.setChartStyleId(ProjectChartServiceHelper.getMatchChartStyleId(permOrgResultWithSub, permProjectOrgIds));
        return searchChartData;
    }

    public static String getMatchChartStyleId(AuthorizedOrgResultWithSub permOrgResultWithSub, List<Long> permProjectOrgIds) {
        Set<String> chartStyleIds = ProjectChartServiceHelper.getChartStyleIds(permOrgResultWithSub, permProjectOrgIds, ProjectChartConstants.DEFAULT_CARD_DIMENSION_ID);
        chartStyleIds.add("1003");
        Map<String, ChartStyle> chartStyleIdChartStyleMap = OrgChartServiceHelper.getChartStyles(chartStyleIds);
        ChartStyle matchChartStyle = OrgChartServiceHelper.findBestMatchChartStyle(chartStyleIdChartStyleMap, "1003");
        if (matchChartStyle == null) {
            return "1003";
        }
        return matchChartStyle.getId();
    }

    public static ProjectSearchChartData getSchemeSearchChartData(ProjectChartQueryParam projectChartQueryParam, AuthorizedOrgResultWithSub permOrgResultWithSub, List<Long> permProjectOrgIds) {
        if (projectChartQueryParam == null) {
            return ProjectChartServiceHelper.getDefaultSearchChartData(new Date(), permOrgResultWithSub, permProjectOrgIds);
        }
        ProjectSearchChartData searchChartData = new ProjectSearchChartData();
        searchChartData.setShowLevel(projectChartQueryParam.getShowLevel());
        searchChartData.setOrgChartDirection(projectChartQueryParam.getOrgChartDirection());
        Date queryDate = ProjectChartServiceHelper.getQueryDate(projectChartQueryParam);
        searchChartData.setDateField(queryDate);
        searchChartData.setCurrentOrgChartRootNodeId(projectChartQueryParam.getCurrentOrgChartRootNodeId());
        searchChartData.setChartStyleId(projectChartQueryParam.getChartStyleId());
        searchChartData.setOrgs(projectChartQueryParam.getOrgs());
        return searchChartData;
    }

    public static String checkScheme(ProjectSearchChartData schemeSearchChartData, String rootId, AuthorizedOrgResultWithSub permOrgResultWithSub, List<Long> permProjectOrgIds, List<String> orgIds) {
        String tips;
        QFilter defaultFilter = OrgChartServiceHelper.getBaseCommonFilterWithDate(schemeSearchChartData.getDateField());
        DynamicObject rootDyn = null;
        if (!StringUtils.isEmpty((CharSequence)rootId)) {
            rootDyn = OrgChartServiceHelper.getRootDynByRootId(defaultFilter, Long.parseLong(rootId));
        }
        StringBuilder sb = new StringBuilder();
        Set<String> chartStyleIds = ProjectChartServiceHelper.getChartStyleIds(permOrgResultWithSub, permProjectOrgIds, ProjectChartConstants.DEFAULT_CARD_DIMENSION_ID);
        chartStyleIds.add("1003");
        QFilter chartStyleIdFilter = new QFilter("id", "in", (Object)(StringUtils.isEmpty((CharSequence)schemeSearchChartData.getChartStyleId()) ? 0L : Long.parseLong(schemeSearchChartData.getChartStyleId())));
        Object[] dynamicObjects = OrgChartServiceHelper.queryBaseData("homs_chartstyle", new QFilter[]{chartStyleIdFilter});
        if (ArrayUtils.isEmpty((Object[])dynamicObjects) || !chartStyleIds.contains(schemeSearchChartData.getChartStyleId())) {
            tips = ResManager.loadKDString((String)"\u7ed3\u6784\u56fe\u6837\u5f0f", (String)"ProjectChartServiceHelper_0", (String)"odc-homs-business", (Object[])new Object[0]);
            sb.append(tips);
            sb.append("\u3001");
        }
        if (rootDyn == null || !orgIds.contains(rootDyn.getString("orgteam.org")) || !permOrgResultWithSub.isHasAllOrgPerm() && !permProjectOrgIds.contains(Long.parseLong(rootId))) {
            tips = ResManager.loadKDString((String)"\u67e5\u8be2\u7ec4\u7ec7", (String)"ProjectChartServiceHelper_1", (String)"odc-homs-business", (Object[])new Object[0]);
            sb.append(tips);
            sb.append("\u3001");
        }
        return sb.toString();
    }

    public static OrgChartTreeNode findFirstPermOrgNode(OrgChartTreeNode rootNode, List<Long> permOrgIds, List<String> orgIds, boolean hasAllOrgPerm) {
        if (rootNode == null) {
            return null;
        }
        if (hasAllOrgPerm ? "1020".equals(rootNode.getOtclassify()) : permOrgIds.contains(Long.parseLong(rootNode.getBoid())) && orgIds.contains(rootNode.getOrg())) {
            return rootNode;
        }
        if (!CollectionUtils.isEmpty((Collection)rootNode.getChildren())) {
            OrgChartTreeNode treeNode;
            for (TreeNode node : rootNode.getChildren()) {
                treeNode = (OrgChartTreeNode)node;
                if (!(hasAllOrgPerm ? "1020".equals(treeNode.getOtclassify()) : permOrgIds.contains(Long.parseLong(treeNode.getBoid())) && orgIds.contains(treeNode.getOrg()))) continue;
                return treeNode;
            }
            for (TreeNode node : rootNode.getChildren()) {
                treeNode = (OrgChartTreeNode)node;
                OrgChartTreeNode permOrgNode = ProjectChartServiceHelper.findFirstPermOrgNode(treeNode, permOrgIds, orgIds, hasAllOrgPerm);
                if (permOrgNode == null) continue;
                return permOrgNode;
            }
        }
        return null;
    }

    public static void setShowFieldInfoToTreeNodes(List<OrgChartTreeNode> chartTreeNodeList, ChartStyle matchChartStyle, ProjectSearchChartData searchChartData) {
        Map cardStyleIdCardStyleMap = matchChartStyle.getCardStyles().stream().collect(Collectors.toMap(CardStyle::getCarddimensionId, Function.identity()));
        Map<String, List<OrgChartTreeNode>> otClassifyTreeNodesMap = chartTreeNodeList.stream().collect(Collectors.groupingBy(OrgChartTreeNode::getOtclassify));
        otClassifyTreeNodesMap.forEach((key, value) -> {
            CardStyle cardStyle = (CardStyle)cardStyleIdCardStyleMap.get(key);
            if (cardStyle != null) {
                List cardStyleFields = cardStyle.getCardStyleFields();
                ProjectChartServiceHelper.setTreeNodeShowFields(cardStyleFields, value, searchChartData);
            }
        });
    }

    private static void setTreeNodeShowFields(List<CardStyleField> cardStyleFields, List<OrgChartTreeNode> chartTreeNodeList, ProjectSearchChartData searchChartData) {
        Map formIdFieldsMap = cardStyleFields.stream().collect(Collectors.groupingBy(CardStyleField::getEntityidentifier, Collectors.mapping(CardStyleField::getFieldidentifier, Collectors.toSet())));
        Set<Long> orgIds = chartTreeNodeList.stream().map(dy -> Long.parseLong(dy.getBoid())).collect(Collectors.toSet());
        HashMap orgIdShowFieldInfos = new HashMap();
        formIdFieldsMap.forEach((formId, fieldNames) -> ProjectChartServiceHelper.getOrgTeamShowFields(orgIds, formId, fieldNames, orgIdShowFieldInfos, searchChartData.getDateField() == null ? new Date() : searchChartData.getDateField()));
        Set fieldNames2 = formIdFieldsMap.get("calculate_api");
        Map<Object, Object> parentIdChildCountMap = Maps.newHashMapWithExpectedSize((int)chartTreeNodeList.size());
        if (!CollectionUtils.isEmpty(fieldNames2) && fieldNames2.contains("projectcount")) {
            parentIdChildCountMap = OrgChartServiceHelper.queryOrgChildCount(searchChartData.getDateField(), orgIds, Collections.singletonList(ProjectChartConstants.DEFAULT_OTCCLASSIFY_ID), null);
        }
        for (OrgChartTreeNode treeNode : chartTreeNodeList) {
            Map showFieldInfos = (Map)orgIdShowFieldInfos.get(treeNode.getBoid());
            if (!CollectionUtils.isEmpty(fieldNames2) && fieldNames2.contains("projectcount")) {
                showFieldInfos.put("projectcount", parentIdChildCountMap.getOrDefault(treeNode.getBoid(), 0L));
            }
            treeNode.setShowFields(showFieldInfos);
        }
    }

    public static void getOrgTeamShowFields(Set<Long> orgIds, String formId, Set<String> fieldNames, Map<String, Map<String, Object>> orgIdShowFieldInfos, Date queryDate) {
        switch (formId) {
            case "haos_projteambaseinfo": {
                ProjectChartServiceHelper.getMainProjectGroupData(orgIds, fieldNames, orgIdShowFieldInfos, queryDate);
                break;
            }
            case "projectgroup_api": {
                ProjectChartServiceHelper.getProjectApiDataInfo(orgIds, orgIdShowFieldInfos, queryDate);
                break;
            }
            case "person_api": {
                ProjectChartServiceHelper.getPersonDataInfo(orgIds, orgIdShowFieldInfos, queryDate);
                break;
            }
        }
    }

    private static void getProjectApiDataInfo(Set<Long> orgIds, Map<String, Map<String, Object>> orgIdShowFieldInfos, Date queryDate) {
        List projectGroupInfos = (List)HRMServiceHelper.invokeHRMPService((String)HBPM, (String)IHBPM_PROJECT_ROLE_SERVICE, (String)"getCountByProjectId", (Object[])new Object[]{new ArrayList<Long>(orgIds), queryDate});
        LOG.info("getProjectApiDataInfo: {}, projectTeamIds: {}, date: {}", new Object[]{JSONObject.toJSONString((Object)projectGroupInfos), JSONObject.toJSONString(orgIds), JSONObject.toJSONString((Object)queryDate)});
        if (!CollectionUtils.isEmpty((Collection)projectGroupInfos)) {
            HashMap projectIdProjectInfoMap = new HashMap();
            projectGroupInfos.forEach(projectGroupInfo -> projectIdProjectInfoMap.put(projectGroupInfo.get("projectGroupId"), projectGroupInfo));
            orgIds.forEach(orgId -> {
                Map showFieldInfos = orgIdShowFieldInfos.getOrDefault(orgId.toString(), new HashMap());
                HashMap fieldInfoMap = new HashMap();
                Map projectInfoMaps = (Map)projectIdProjectInfoMap.get(orgId.toString());
                if (!CollectionUtils.isEmpty((Map)projectInfoMaps)) {
                    fieldInfoMap.put("personprojectrole", projectInfoMaps.get("mainHeadRole"));
                    fieldInfoMap.put("projectrolecount", projectInfoMaps.get("roleCount"));
                } else {
                    fieldInfoMap.put("personprojectrole", "");
                    fieldInfoMap.put("projectrolecount", 0);
                }
                showFieldInfos.putAll(fieldInfoMap);
                orgIdShowFieldInfos.put(orgId.toString(), showFieldInfos);
            });
        }
    }

    private static void getMainProjectGroupData(Set<Long> orgIds, Set<String> fieldNames, Map<String, Map<String, Object>> orgIdShowFieldInfos, Date queryDate) {
        fieldNames.add("boid");
        String selectProperties = String.join((CharSequence)",", fieldNames);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_projteambaseinfo");
        QFilter orgIdFilter = new QFilter("boid", "in", orgIds);
        DynamicObject[] orgInfo = serviceHelper.query(selectProperties, new QFilter[]{orgIdFilter, OrgChartServiceHelper.getBaseCommonFilterWithDate(queryDate)});
        Stream.of(orgInfo).forEach(dy -> {
            HashMap fieldInfoMap = new HashMap();
            fieldNames.forEach(fieldName -> {
                if (!"boid".equals(fieldName)) {
                    fieldInfoMap.put(fieldName, dy.getString(fieldName));
                }
            });
            Map showFieldInfos = orgIdShowFieldInfos.getOrDefault(dy.getString("boid"), new HashMap());
            showFieldInfos.putAll(fieldInfoMap);
            orgIdShowFieldInfos.put(dy.getString("boid"), showFieldInfos);
        });
    }

    private static void getPersonDataInfo(Set<Long> orgIds, Map<String, Map<String, Object>> orgIdShowFieldInfos, Date queryDate) {
        Map<String, List<Map<String, Object>>> orgIdPersonInfoMap = ProjectChartServiceHelper.getPersonMemberInfo(orgIds, queryDate);
        for (Long orgId : orgIds) {
            List<Map<String, Object>> personInfoMaps = orgIdPersonInfoMap.get(orgId.toString());
            HashMap<String, Object> fieldInfoMap = new HashMap<String, Object>();
            int hasMorePrimaryPerson = 0;
            if (!CollectionUtils.isEmpty(personInfoMaps)) {
                Map<String, Object> personInfoMap = personInfoMaps.get(0);
                fieldInfoMap.put("personcount", personInfoMap.get("subordinateNum") == null ? Integer.valueOf(0) : personInfoMap.get("subordinateNum"));
                String headSculpture = HRImageUrlUtil.getImageFullUrl((String)(personInfoMap.get("headPicutre") == null ? "" : personInfoMap.get("headPicutre").toString()));
                fieldInfoMap.put("personavtor", personInfoMaps.size() > 1 ? "" : headSculpture);
                HashSet personNames = new HashSet();
                personInfoMaps.forEach(info -> personNames.add(info.get("name").toString()));
                String originalValue = String.join((CharSequence)";", personNames);
                if (!StringUtils.isEmpty((CharSequence)originalValue)) {
                    Object resultValue = PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_person", (String)"name", (String)Lang.get().toString(), (String)"LIST", null, (Object)originalValue);
                    fieldInfoMap.put("personname", resultValue);
                } else {
                    fieldInfoMap.put("personname", originalValue);
                }
                fieldInfoMap.put("totalpersoncount", personInfoMap.get("count") == null ? Integer.valueOf(0) : personInfoMap.get("count"));
                hasMorePrimaryPerson = personInfoMaps.size() > 1 ? 1 : 0;
            } else {
                fieldInfoMap.put("personcount", 0);
                fieldInfoMap.put("personname", "");
                fieldInfoMap.put("personavtor", "");
                fieldInfoMap.put("totalpersoncount", 0);
            }
            fieldInfoMap.put("hasMorePrimaryPerson", hasMorePrimaryPerson);
            Map showFieldInfos = orgIdShowFieldInfos.getOrDefault(orgId.toString(), new HashMap());
            showFieldInfos.putAll(fieldInfoMap);
            orgIdShowFieldInfos.put(orgId.toString(), showFieldInfos);
        }
    }

    private static Map<String, List<Map<String, Object>>> getPersonMemberInfo(Set<Long> projectTeamIds, Date queryDate) {
        List personResult = (List)HRMServiceHelper.invokeHRService((String)PTMM, (String)IPTMM_QUERY_MEMBER_SERVICE, (String)"getMemberHis", (Object[])new Object[]{new ArrayList<Long>(projectTeamIds), OrgChartServiceHelper.isToday(queryDate) ? null : queryDate});
        LOG.info("getPersonMemberInfo: {}, projectTeamIds: {}, date {}", new Object[]{JSONObject.toJSONString((Object)personResult), new ArrayList<Long>(projectTeamIds), JSONObject.toJSONString((Object)queryDate)});
        HashMap<String, List<Map<String, Object>>> orgIdPersonInfoMap = new HashMap<String, List<Map<String, Object>>>();
        personResult.forEach(personMap -> {
            List orgPersonInfos = orgIdPersonInfoMap.getOrDefault(personMap.get("projectTeamId").toString(), new ArrayList());
            orgPersonInfos.add(personMap);
            orgIdPersonInfoMap.put(personMap.get("projectTeamId").toString(), orgPersonInfos);
        });
        return orgIdPersonInfoMap;
    }

    public static Object getPersonDesensitizeValue(String currentNodeId, String personname, int isDesensitize, Date queryDate) {
        Object resultValue = "";
        if (isDesensitize == 1) {
            resultValue = PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_person", (String)"name", (String)Lang.get().toString(), (String)"LIST", null, (Object)personname);
        } else {
            Map<String, List<Map<String, Object>>> orgIdPersonInfoMap = ProjectChartServiceHelper.getPersonMemberInfo(Collections.singleton(Long.parseLong(currentNodeId)), queryDate);
            List<Map<String, Object>> personInfoMaps = orgIdPersonInfoMap.get(currentNodeId);
            if (!CollectionUtils.isEmpty(personInfoMaps)) {
                HashSet personNames = new HashSet();
                personInfoMaps.forEach(info -> personNames.add(info.get("name").toString()));
                resultValue = String.join((CharSequence)";", personNames);
            }
        }
        return resultValue;
    }

    public static Map<String, Object> getQueryShowParamsByScheme(ProjectChartQueryParam orgChartQueryParam, FilterScheme defaultScheme) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("queryDate", ProjectChartServiceHelper.getQueryDate(orgChartQueryParam));
        ChartStyle chartStyle = OrgChartServiceHelper.getChartStyleById(orgChartQueryParam.getChartStyleId());
        result.put("MATCH_CHART_STYLE_KEY", OrgChartServiceHelper.getChartStyleById(orgChartQueryParam.getChartStyleId()));
        result.put("isShowEye", OrgChartServiceHelper.getIsShowEye(chartStyle, OrgChartServiceHelper.getDesensitizeFields(OrgChartConstants.PROJECT_CARDDISSION)));
        result.put("showLevel", orgChartQueryParam.getShowLevel());
        result.put("orgchartdirection", orgChartQueryParam.getOrgChartDirection());
        result.put("orgs", OrgChartServiceHelper.getOrgInfo(orgChartQueryParam.getOrgs()));
        result.put("showScheme", defaultScheme);
        return result;
    }

    public static OrgChartTreeNode wrapTreeNode(DynamicObject dynamicObject, Map<Long, ChartOrgInfo> orgTeamIdOrgTypeMap) {
        OrgChartTreeNode rootNode = new OrgChartTreeNode();
        rootNode.setId(dynamicObject.getString("orgteam.id"));
        rootNode.setBoid(dynamicObject.getString("orgteam.boid"));
        rootNode.setOrg(dynamicObject.getString("orgteam.org"));
        rootNode.setText(dynamicObject.getString("name"));
        rootNode.setParentid(dynamicObject.get("parentorgteam").toString());
        rootNode.setLevel(Integer.valueOf(dynamicObject.getInt("level")));
        rootNode.setLeaf(dynamicObject.getBoolean("isleaf"));
        if (!rootNode.isLeaf()) {
            rootNode.setChildren(new ArrayList());
        }
        rootNode.setIsOpened(false);
        ChartOrgInfo orgTypeInfo = orgTeamIdOrgTypeMap.get(Long.parseLong(rootNode.getId()));
        if (orgTypeInfo != null) {
            rootNode.setText(orgTypeInfo.getName());
            rootNode.setNumber(orgTypeInfo.getNumber());
            rootNode.setIndex(Long.valueOf(orgTypeInfo.getIndex() != null ? orgTypeInfo.getIndex() : 0L));
        } else {
            String oldNumber = dynamicObject.getString("number");
            rootNode.setNumber(oldNumber.length() > 4 ? oldNumber.substring(4) : oldNumber);
            rootNode.setIndex(Long.valueOf(0L));
        }
        rootNode.setOtclassify(dynamicObject.getString("orgteam.otclassify"));
        rootNode.setData((Object)dynamicObject.getString("orgteam.otclassify"));
        ProjectChartServiceHelper.setIconForNode(rootNode);
        return rootNode;
    }

    public static Map<Long, ChartOrgInfo> getOrgTeamOrgType(DynamicObjectCollection treeViewCollection, Date queryDate) {
        HashMap<Long, ChartOrgInfo> orgTeamIdOrgTypeMap = new HashMap<Long, ChartOrgInfo>();
        HashMap<Long, Long> orgTeamIdOrgIdMap = new HashMap<Long, Long>();
        for (DynamicObject dynamicObject : treeViewCollection) {
            orgTeamIdOrgIdMap.put(dynamicObject.getLong("orgteam.id"), dynamicObject.getLong("orgteam.boid"));
        }
        Map otClassifyIdBoIds = treeViewCollection.stream().collect(Collectors.groupingBy(dy -> dy.getString("orgteam.otclassify"), Collectors.mapping(dy2 -> dy2.getLong("orgteam.boid"), Collectors.toSet())));
        otClassifyIdBoIds.forEach((otClassifyId, orgBoIds) -> {
            if ("1020".equals(otClassifyId)) {
                Map<Long, ChartOrgInfo> projectInfo = ProjectChartServiceHelper.getProjectInfo(queryDate, orgTeamIdOrgIdMap, orgBoIds);
                orgTeamIdOrgTypeMap.putAll(projectInfo);
            }
        });
        return orgTeamIdOrgTypeMap;
    }

    public static OrgChartTreeNode getRootTreeNode(DynamicObject rootNodeDynamicObj, Map<Long, ChartOrgInfo> orgTeamIdOrgTypeMap, boolean isParent) {
        OrgChartTreeNode treeNode = new OrgChartTreeNode(null, rootNodeDynamicObj.getString("orgteam.id"), rootNodeDynamicObj.getString("name"), isParent);
        ChartOrgInfo orgTypeInfo = orgTeamIdOrgTypeMap.get(Long.parseLong(treeNode.getId()));
        if (orgTypeInfo != null) {
            treeNode.setText(orgTypeInfo.getName());
            treeNode.setNumber(orgTypeInfo.getNumber());
            treeNode.setIndex(Long.valueOf(orgTypeInfo.getIndex() != null ? orgTypeInfo.getIndex() : 0L));
        } else {
            String oldNumber = rootNodeDynamicObj.getString("number");
            treeNode.setNumber(oldNumber.length() > 4 ? oldNumber.substring(4) : oldNumber);
            treeNode.setIndex(Long.valueOf(0L));
        }
        treeNode.setOtclassify(rootNodeDynamicObj.getString("orgteam.otclassify"));
        treeNode.setData((Object)rootNodeDynamicObj.getString("orgteam.otclassify"));
        ProjectChartServiceHelper.setIconForNode(treeNode);
        treeNode.setIsOpened(true);
        treeNode.setBoid(rootNodeDynamicObj.getString("orgteam.boid"));
        treeNode.setParentid("0".equals(rootNodeDynamicObj.getString("parentorgteam")) ? null : rootNodeDynamicObj.getString("parentorgteam"));
        treeNode.setOrg(rootNodeDynamicObj.getString("orgteam.org"));
        return treeNode;
    }

    private static void setIconForNode(OrgChartTreeNode node) {
        switch (node.getOtclassify()) {
            case "1010": {
                node.setIcon("kdfont kdfont-shitizuzhi");
                break;
            }
            case "1020": {
                node.setIcon("kdfont kdfont-xiangmutuandui4");
                break;
            }
        }
    }

    public static Map<String, Object> getInitQueryParams(boolean isQueryPerm) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (isQueryPerm) {
            ProjectChartServiceHelper.projectChartPermQuery(result);
        }
        List<FilterScheme> schemes = OrgChartServiceHelper.getScheme("homs_projectchart", RequestContext.get().getUserId(), true);
        result.put("schemes", schemes);
        return result;
    }

    public static void projectChartPermQuery(Map<String, Object> result) {
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)"homs_projectchart");
        boolean hasChartExportPerm = PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"11", (String)appId, (String)"homs_projectchart", (String)"4730fc9f000004ae");
        boolean hasAdminOrgDetailsPerm = PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"11", (String)appId, (String)"homs_projectchart", (String)"2O23MLUIT2BS");
        result.put("hasChartExportPerm", hasChartExportPerm ? 1 : 0);
        result.put("hasProjectDetailsPerm", hasAdminOrgDetailsPerm ? 1 : 0);
    }

    public static Map<Long, ChartOrgInfo> getProjectInfo(Date queryDate, Map<Long, Long> orgTeamIdOrgIdMap, Set<Long> orgBoIds) {
        QFilter queryDateFilter = OrgChartServiceHelper.getBaseCommonFilterWithDate(queryDate);
        Map<Long, DynamicObject> orgIdOrgTypeMap = ProjectChartServiceHelper.getProjectBaseInfo(orgBoIds, queryDateFilter);
        HashMap<Long, ChartOrgInfo> orgTeamIdOrgTypeMap = new HashMap<Long, ChartOrgInfo>();
        orgTeamIdOrgIdMap.forEach((orgTeamId, orgId) -> {
            DynamicObject orgType = (DynamicObject)orgIdOrgTypeMap.get(orgId);
            ChartOrgInfo chartOrgInfo = new ChartOrgInfo();
            if (orgType != null) {
                chartOrgInfo.setId(orgId + "");
                chartOrgInfo.setName(orgType.getString("name"));
                chartOrgInfo.setNumber(orgType.getString("number"));
                chartOrgInfo.setIndex(Long.valueOf(orgType.getLong("index")));
                orgTeamIdOrgTypeMap.put((Long)orgTeamId, chartOrgInfo);
            }
        });
        return orgTeamIdOrgTypeMap;
    }

    public static Map<Long, DynamicObject> getProjectBaseInfo(Set<Long> orgBoIds, QFilter queryDateFilter) {
        if (CollectionUtils.isEmpty(orgBoIds)) {
            return new HashMap<Long, DynamicObject>(16);
        }
        QFilter orgIdFilter = new QFilter("boid", "in", orgBoIds);
        String selectFields = "id,boid,name,number,index";
        DynamicObjectCollection dynamicObjects = HRBaseDaoFactory.getInstance((String)"haos_projteambaseinfo").queryColl(selectFields, new QFilter[]{orgIdFilter, queryDateFilter}, null);
        HashMap<Long, DynamicObject> orgIdOrgTypeMap = new HashMap<Long, DynamicObject>(16);
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                orgIdOrgTypeMap.put(dynamicObject.getLong("boid"), dynamicObject);
            }
        }
        return orgIdOrgTypeMap;
    }

    public static Map<String, String> getShowErrorInfo(String type, String text) {
        HashMap<String, String> showErrorMap = new HashMap<String, String>();
        showErrorMap.put("type", type);
        showErrorMap.put("text", text);
        return showErrorMap;
    }

    public static Set<String> getChartStyleIds(AuthorizedOrgResultWithSub permOrgResultWithSub, List<Long> permProjectOrgIds, Long crtsStyDimensionId) {
        if (permOrgResultWithSub.isHasAllOrgPerm()) {
            return CommonOrgChartServiceHelper.getChartStyleIdsByCardDimensionId(crtsStyDimensionId);
        }
        Set<String> orgWithSubLongStructNumbers = CommonOrgChartServiceHelper.getOrgTeamStructLongNumber(permProjectOrgIds);
        Set<String> chartStyleIds = OrgChartServiceHelper.getChartStyleIdsByTeamOrgWithSubIds(orgWithSubLongStructNumbers, Collections.singletonList(crtsStyDimensionId));
        Set<String> chartStyleIdsByTeamOrgIds = OrgChartServiceHelper.getChartStyleIdsByTeamOrgIds(permProjectOrgIds, Collections.singletonList(crtsStyDimensionId));
        chartStyleIds.addAll(chartStyleIdsByTeamOrgIds);
        return chartStyleIds;
    }
}

