/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgdifftemp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AnchorItems;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.AnchorControl;
import kd.bos.form.IFormView;
import kd.bos.form.TipsSupport;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.rpc.HRCSRPCServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.homs.business.service.validcommon.CycleOrgBean;
import kd.hr.homs.common.constants.orgdifftemp.OrgDiffTempConstants;

public class OrgDiffTempHelper
implements OrgDiffTempConstants {
    private static final String PAGE_CACHE_KEY_ISNEWORG = "orgTypeOld";
    private static final String STR_IS_CHANGE_TRUE = "1";

    public static void setAdminorgType(IFormView iFormView) {
        long adminorgTypeId = iFormView.getModel().getDataEntity().getLong("adminorgtype.id");
        if (adminorgTypeId == 0L) {
            iFormView.getPageCache().put(PAGE_CACHE_KEY_ISNEWORG, "true");
            iFormView.getModel().setValue("adminorgtype", (Object)ADMINORG_TYPE_GROUP);
        } else {
            iFormView.getPageCache().put(PAGE_CACHE_KEY_ISNEWORG, "false");
        }
    }

    public static void setOrgInfoViewByType(Long adminOrgTypeStd, IFormView iFormView) {
        iFormView.getPageCache().put("orgTypeStd", String.valueOf(adminOrgTypeStd));
        iFormView.setVisible(Boolean.TRUE, new String[]{"group_flex", "company_flex", "dept_flex"});
        if (adminOrgTypeStd.equals(ADMINORG_TYPE_GROUP)) {
            iFormView.setVisible(Boolean.valueOf(false), new String[]{"dept_flex"});
        } else if (adminOrgTypeStd.equals(ADMINORG_TYPE_CONPANEY)) {
            iFormView.setVisible(Boolean.valueOf(false), new String[]{"dept_flex", "group_flex"});
        } else if (adminOrgTypeStd.equals(ADMINORG_TYPE_AREA)) {
            iFormView.setVisible(Boolean.valueOf(false), new String[]{"dept_flex", "group_flex", "company_flex"});
        } else if (adminOrgTypeStd.equals(ADMINORG_TYPE_DEPARTMENT)) {
            iFormView.setVisible(Boolean.valueOf(false), new String[]{"group_flex", "company_flex"});
        }
    }

    public static void anchorCtlByType(int orgTypeId, IFormView iFormView) {
        AnchorControl anchorCtl = (AnchorControl)iFormView.getControl("anchorcontrolap");
        ArrayList<AnchorItems> anchorItems = new ArrayList<AnchorItems>();
        String baseCaption = ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"orgBatch_anchor_12", (String)"odc-homs-business", (Object[])new Object[0]);
        AnchorItems baseItem = new AnchorItems("info_flex", baseCaption, null);
        anchorItems.add(baseItem);
        String companyCaption = ResManager.loadKDString((String)"\u516c\u53f8\u4fe1\u606f", (String)"orgBatch_anchor_2", (String)"odc-homs-business", (Object[])new Object[0]);
        AnchorItems companyItem = new AnchorItems("company_flex", companyCaption, null);
        switch (orgTypeId) {
            case 1010: {
                String groupCaption = ResManager.loadKDString((String)"\u96c6\u56e2\u4fe1\u606f", (String)"orgBatch_anchor_3", (String)"odc-homs-business", (Object[])new Object[0]);
                AnchorItems groupItem = new AnchorItems("group_flex", groupCaption, null);
                anchorItems.add(companyItem);
                anchorItems.add(groupItem);
                iFormView.setVisible(Boolean.valueOf(false), new String[]{"dept_flex"});
                break;
            }
            case 1020: {
                anchorItems.add(companyItem);
                iFormView.setVisible(Boolean.valueOf(false), new String[]{"dept_flex", "group_flex"});
                break;
            }
            case 1030: {
                iFormView.setVisible(Boolean.valueOf(false), new String[]{"dept_flex", "group_flex", "company_flex"});
                break;
            }
            case 1040: {
                String deptCaption = ResManager.loadKDString((String)"\u90e8\u95e8\u4fe1\u606f", (String)"orgBatch_anchor_4", (String)"odc-homs-business", (Object[])new Object[0]);
                AnchorItems deptItem = new AnchorItems("dept_flex", deptCaption, null);
                anchorItems.add(deptItem);
                iFormView.setVisible(Boolean.valueOf(false), new String[]{"group_flex", "company_flex"});
                break;
            }
        }
        String orgDutyCaption = ResManager.loadKDString((String)"\u7ec4\u7ec7\u804c\u8d23", (String)"orgBatch_anchor_5", (String)"odc-homs-business", (Object[])new Object[0]);
        AnchorItems orgDutyItem = new AnchorItems("duty_flex", orgDutyCaption, null);
        String safeCaption = ResManager.loadKDString((String)"\u4fdd\u5bc6\u4fe1\u606f", (String)"orgBatch_anchor_7", (String)"odc-homs-business", (Object[])new Object[0]);
        AnchorItems safeItem = new AnchorItems("safe_flex", safeCaption, null);
        anchorItems.add(orgDutyItem);
        anchorItems.add(safeItem);
        anchorCtl.addItems(anchorItems);
        anchorCtl.setHighlight(true);
    }

    public static void setIndexBefore(IFormView iFormView) {
        DynamicObject[] orgDiffTempDyns;
        IDataModel model = iFormView.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        String isChangeStr = dataEntity.getString("ischange");
        int maxIndex = 0;
        DynamicObject parentOrgDyn = dataEntity.getDynamicObject("parentorg");
        if (Objects.isNull(parentOrgDyn) || STR_IS_CHANGE_TRUE.equals(isChangeStr)) {
            return;
        }
        String parentOrgStauts = parentOrgDyn.getString("status");
        String parentOrgEnable = parentOrgDyn.getString("enable");
        long parentOrgId = parentOrgDyn.getLong("id");
        HRBaseServiceHelper orgDiffTempHelper = new HRBaseServiceHelper("homs_orgdifftemp");
        QFilter parentIdFilter = new QFilter("parentorg", "=", (Object)parentOrgId);
        for (DynamicObject orgDiffTempDyn : orgDiffTempDyns = orgDiffTempHelper.query("id, index", new QFilter[]{parentIdFilter})) {
            int index = orgDiffTempDyn.getInt("index");
            maxIndex = Math.max(maxIndex, index);
        }
        if ("E".equals(parentOrgStauts) || parentOrgEnable.equals(STR_IS_CHANGE_TRUE)) {
            DynamicObject[] adminOrgDyns;
            HRBaseServiceHelper adminOrgDetailHelper = new HRBaseServiceHelper("haos_adminorgdetail");
            QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)STR_IS_CHANGE_TRUE);
            for (DynamicObject adminOrgDyn : adminOrgDyns = adminOrgDetailHelper.query("id, index", new QFilter[]{parentIdFilter, isCurrentVersionFilter})) {
                int index = adminOrgDyn.getInt("index");
                maxIndex = Math.max(maxIndex, index);
            }
        }
        if (maxIndex >= 99999) {
            iFormView.getModel().setValue("index", (Object)99999);
        } else {
            iFormView.getModel().setValue("index", (Object)(maxIndex + 1));
        }
    }

    public static void setToBeDisableDateEnable(IFormView iFormView) {
        IDataModel model = iFormView.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        boolean toBeDisableFlag = dataEntity.getBoolean("tobedisableflag");
        if (toBeDisableFlag) {
            iFormView.setEnable(Boolean.TRUE, new String[]{"tobedisabledate"});
        } else {
            iFormView.setEnable(Boolean.FALSE, new String[]{"tobedisabledate"});
        }
    }

    public static void setCityF7Filter(BeforeF7SelectEvent beforeF7SelectEvent, IDataModel model) {
        beforeF7SelectEvent.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6240\u5728\u57ce\u5e02", (String)"AdminorgFastChgPlugin_10", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        DynamicObject compantArea = model.getDataEntity().getDynamicObject("companyarea");
        if (compantArea != null && compantArea.getLong("id") != 0L) {
            QFilter countryFilter = new QFilter("country", "=", (Object)compantArea.getLong("id"));
            beforeF7SelectEvent.getCustomQFilters().add(countryFilter);
        }
    }

    public static void propChgForCountryArea(PropertyChangedArgs e, IDataModel model) {
        if (Objects.nonNull(e.getChangeSet()[0].getOldValue())) {
            model.setValue("city", null);
        }
        DynamicObject compantarea = (DynamicObject)e.getChangeSet()[0].getNewValue();
        DynamicObject workplace = model.getDataEntity().getDynamicObject("workplace");
        if (Objects.isNull(workplace) && Objects.nonNull(compantarea)) {
            OrgDiffTempHelper.setWorkplace(model, compantarea.getLong("id"), null);
        }
    }

    public static void propChgForCity(PropertyChangedArgs e, IDataModel model) {
        DynamicObject city = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (Objects.isNull(city)) {
            return;
        }
        model.setValue("companyarea", (Object)city.getLong("country.id"));
        DynamicObject workplace = model.getDataEntity().getDynamicObject("workplace");
        if (Objects.isNull(workplace)) {
            DynamicObject countryObj = city.getDynamicObject("country");
            List<Long> curCityAndChildCityIds = OrgDiffTempHelper.queryCityIdList(city.getLong("id"));
            OrgDiffTempHelper.setWorkplace(model, countryObj.getLong("id"), curCityAndChildCityIds);
        }
    }

    private static List<Long> queryCityIdList(Long id) {
        HRBaseServiceHelper adminDivisionHelper = new HRBaseServiceHelper("bd_admindivision");
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        DynamicObject longnumberObj = adminDivisionHelper.queryOriginalOne("longnumber", idFilter);
        QFilter qFilter = new QFilter("longnumber", "ftlike", (Object)longnumberObj.getString("longnumber")).and(new QFilter("enable", "=", (Object)STR_IS_CHANGE_TRUE));
        DynamicObjectCollection collection = adminDivisionHelper.queryOriginalCollection("id", new QFilter[]{qFilter});
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            return collection.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }
        return Lists.newArrayList((Object[])new Long[]{id});
    }

    private static void setWorkplace(IDataModel model, long countryId, List<Long> cityIds) {
        HRBaseServiceHelper helper;
        DynamicObjectCollection cityColl;
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)STR_IS_CHANGE_TRUE);
        QFilter countryFilter = new QFilter("country", "=", (Object)countryId);
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(statusFilter);
        list.add(enableFilter);
        list.add(countryFilter);
        if (!CollectionUtils.isEmpty(cityIds)) {
            list.add(new QFilter("city", "in", cityIds));
        }
        if (!CollectionUtils.isEmpty((Collection)(cityColl = (helper = new HRBaseServiceHelper("hbss_workplace")).queryOriginalCollection("id", list.toArray(new QFilter[list.size()])))) && cityColl.size() == 1) {
            model.setValue("workplace", ((DynamicObject)cityColl.get(0)).get("id"));
        }
    }

    public static void propChgForToBeDiableFlag(PropertyChangedArgs e, IFormView view) {
        Boolean toBeDiableFlag = (Boolean)e.getChangeSet()[0].getNewValue();
        if (toBeDiableFlag.booleanValue()) {
            view.setEnable(Boolean.TRUE, new String[]{"tobedisabledate"});
        } else {
            view.getModel().setValue("tobedisabledate", null);
            view.setEnable(Boolean.FALSE, new String[]{"tobedisabledate"});
        }
    }

    public static void propChgForParentOrg(PropertyChangedArgs e, IFormView view) {
        DynamicObject[] orgDiffTempDyns;
        DynamicObject parentOrgNewValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (Objects.isNull(parentOrgNewValue)) {
            view.getModel().setValue("index", (Object)1);
            return;
        }
        int maxIndex = 0;
        String parentOrgStauts = parentOrgNewValue.getString("status");
        String parentOrgEnable = parentOrgNewValue.getString("enable");
        long parentOrgId = parentOrgNewValue.getLong("id");
        HRBaseServiceHelper orgDiffTempHelper = new HRBaseServiceHelper("homs_orgdifftemp");
        QFilter parentIdFilter = new QFilter("parentorg", "=", (Object)parentOrgId);
        for (DynamicObject orgDiffTempDyn : orgDiffTempDyns = orgDiffTempHelper.query("id, index", new QFilter[]{parentIdFilter})) {
            int index = orgDiffTempDyn.getInt("index");
            maxIndex = Math.max(maxIndex, index);
        }
        if ("E".equals(parentOrgStauts) || parentOrgEnable.equals(STR_IS_CHANGE_TRUE)) {
            DynamicObject[] adminOrgDyns;
            HRBaseServiceHelper adminOrgDetailHelper = new HRBaseServiceHelper("haos_adminorgdetail");
            QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)STR_IS_CHANGE_TRUE);
            for (DynamicObject adminOrgDyn : adminOrgDyns = adminOrgDetailHelper.query("id, index", new QFilter[]{parentIdFilter, isCurrentVersionFilter})) {
                int index = adminOrgDyn.getInt("index");
                maxIndex = Math.max(maxIndex, index);
            }
        }
        if (maxIndex >= 99999) {
            view.getModel().setValue("index", (Object)99999);
        } else {
            view.getModel().setValue("index", (Object)(maxIndex + 1));
        }
    }

    public static Map<Long, Long> getId4ParentOrgTypeStdIdMap(ExtendedDataEntity[] extendedDataEntities) {
        Map<Long, Long> id4ParentOrgTypeMap = Arrays.stream(extendedDataEntities).filter(ex -> Objects.nonNull(ex.getDataEntity().getDynamicObject("parentorg"))).filter(ex -> Objects.nonNull(ex.getDataEntity().getDynamicObject("parentorg.adminorgtype"))).collect(Collectors.toMap(ex -> ex.getDataEntity().getLong("id"), ex -> ex.getDataEntity().getLong("parentorg.adminorgtype.id")));
        Collection<Long> orgTypeId = id4ParentOrgTypeMap.values();
        HRBaseServiceHelper adminOrgTypeHelper = new HRBaseServiceHelper("haos_adminorgtype");
        QFilter orgTypeFilter = new QFilter("id", "in", orgTypeId);
        DynamicObject[] adminOrgTypeDyn = adminOrgTypeHelper.query("id, adminorgtypestd", new QFilter[]{orgTypeFilter});
        Map<Long, Long> orgType4StdIdMap = Arrays.stream(adminOrgTypeDyn).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getLong("adminorgtypestd.id")));
        HashMap id4ParentOrgTypeStdIdMap = Maps.newHashMapWithExpectedSize((int)extendedDataEntities.length);
        for (Map.Entry<Long, Long> id4ParentOrgTypeEntry : id4ParentOrgTypeMap.entrySet()) {
            Long parentOrgTypeStdId = id4ParentOrgTypeEntry.getValue();
            Long id = id4ParentOrgTypeEntry.getKey();
            Long adminOrgTypeStdId = orgType4StdIdMap.get(parentOrgTypeStdId);
            id4ParentOrgTypeStdIdMap.put(id, adminOrgTypeStdId);
        }
        return id4ParentOrgTypeStdIdMap;
    }

    public static Map<Long, Long> getId4AdminOrgTypeStdIdMap(ExtendedDataEntity[] extendedDataEntities) {
        Set parentOrgIdSet = Arrays.stream(extendedDataEntities).map(ex -> ex.getDataEntity().getLong("parentorg.id")).collect(Collectors.toSet());
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter idFilter = new QFilter("id", "in", parentOrgIdSet);
        DynamicObject[] adminOrgDyn = adminOrgHelper.query("id, adminorgtype", new QFilter[]{idFilter});
        Map<Long, Long> id4AdminOrgTypeStdIdMap = Arrays.stream(adminOrgDyn).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getLong("adminorgtype.adminorgtypestd.id")));
        return id4AdminOrgTypeStdIdMap;
    }

    public static Map<Long, Long> getId4ParentOrgTypeStdIdFromMasterMap(ExtendedDataEntity[] extendedDataEntities) {
        Set parentOrgIdSet = Arrays.stream(extendedDataEntities).filter(dyn -> Objects.nonNull(dyn.getDataEntity().getDynamicObject("parentorg"))).map(ex -> ex.getDataEntity().getLong("parentorg.id")).collect(Collectors.toSet());
        HRBaseServiceHelper adminOrgDetailHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter idFilter = new QFilter("id", "in", parentOrgIdSet);
        DynamicObject[] adminOrgDyns = adminOrgDetailHelper.query("id, adminorgtype", new QFilter[]{idFilter});
        Map<Long, Long> id4adminOrgStdIdFromMasterMap = Arrays.stream(adminOrgDyns).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getLong("adminorgtype.adminorgtypestd.id")));
        return id4adminOrgStdIdFromMasterMap;
    }

    public static Map<Long, List<CycleOrgBean>> getOrgId4NodesMap(ExtendedDataEntity[] extendedDataEntities) {
        HRBaseServiceHelper orgDiffTempHelper = new HRBaseServiceHelper("homs_orgdifftemp");
        DynamicObject[] orgDiffTempDyns = orgDiffTempHelper.query("id, parentorg", new QFilter[]{new QFilter(STR_IS_CHANGE_TRUE, "=", (Object)1)});
        ArrayList allOrgList = Lists.newArrayListWithCapacity((int)extendedDataEntities.length);
        Arrays.stream(orgDiffTempDyns).forEach(dy -> allOrgList.add(new CycleOrgBean(dy.getLong("id"), dy.getLong("parentorg.id"))));
        Map<Long, List<CycleOrgBean>> allCyCleMap = allOrgList.stream().collect(Collectors.groupingBy(CycleOrgBean::getOrgId, Collectors.toList()));
        return allCyCleMap;
    }

    public static CycleOrgBean assembleCurrentCycleOrg(Long orgId, Long parentOrgId) {
        CycleOrgBean cycleOrg = new CycleOrgBean();
        cycleOrg.setOrgId(orgId);
        cycleOrg.setCoopOrgId(parentOrgId);
        return cycleOrg;
    }

    public static Set<Long> getParentOrgExistFromMasterIdSet(Set<Long> parentOrgIdSet) {
        HRBaseServiceHelper adminOrgDetailHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter idFilter = new QFilter("id", "in", parentOrgIdSet);
        DynamicObject[] adminOrgDyns = adminOrgDetailHelper.query("id", new QFilter[]{idFilter});
        Set<Long> orgExistFromMasterIdSet = Arrays.stream(adminOrgDyns).map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
        return orgExistFromMasterIdSet;
    }

    public static Map<Long, List<String>> getParentId4NameListFromApplyingMap(Set<Long> parentOrgExistFromMasterIdSet) {
        HRBaseServiceHelper orgBatchChgBillHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
        QFilter auditStatusFilter = new QFilter("auditstatus", "in", Arrays.asList("B", "D"));
        DynamicObject[] orgBatchChgBillDyns = orgBatchChgBillHelper.query("id", new QFilter[]{auditStatusFilter});
        Set applyingBillIdSet = Arrays.stream(orgBatchChgBillDyns).map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
        HRBaseServiceHelper batchOrgEntityHelper = new HRBaseServiceHelper("homs_batchorgentity");
        QFilter applyingBillFilter = new QFilter("billid", "in", applyingBillIdSet);
        QFilter parentIdFilter = new QFilter("parentorg.boid", "in", parentOrgExistFromMasterIdSet);
        DynamicObject[] batchOrgEntityDyns = batchOrgEntityHelper.query("id, name, parentorg.boid", new QFilter[]{applyingBillFilter, parentIdFilter});
        HashMap parentId4NameListFromApplyingMap = Maps.newHashMapWithExpectedSize((int)batchOrgEntityDyns.length);
        Arrays.stream(batchOrgEntityDyns).forEach(dyn -> {
            String name = dyn.getString("name");
            long parentBoId = dyn.getLong("parentorg.boid");
            List nameListFromApplying = parentId4NameListFromApplyingMap.getOrDefault(parentBoId, new ArrayList());
            nameListFromApplying.add(name);
            parentId4NameListFromApplyingMap.put(parentBoId, nameListFromApplying);
        });
        return parentId4NameListFromApplyingMap;
    }

    public static Map<Long, List<DynamicObject>> getParentBoId4AdminOrgFromMasterListMap(ExtendedDataEntity[] extendedDataEntities, Set<Long> parentOrgIdSet) {
        Set nameSet = Arrays.stream(extendedDataEntities).map(ex -> ex.getDataEntity().getString("name")).collect(Collectors.toSet());
        HRBaseServiceHelper adminOrgDetailHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter enableFilter = new QFilter("enable", "=", (Object)STR_IS_CHANGE_TRUE);
        QFilter nameFilter = new QFilter("name", "in", nameSet);
        QFilter parentOrgFilter = new QFilter("parentorg.boid", "in", parentOrgIdSet);
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"0", STR_IS_CHANGE_TRUE, "2"});
        DynamicObject[] adminOrgDyns = adminOrgDetailHelper.query("id, name, parentorg, bsled", new QFilter[]{enableFilter, nameFilter, parentOrgFilter, isCurrentVersionFilter, dataStatusFilter});
        return Arrays.stream(adminOrgDyns).filter(dyn -> dyn.getLong("parentorg.boid") != 0L).collect(Collectors.groupingBy(dyn -> dyn.getLong("parentorg.boid")));
    }

    public static Map<Long, List<String>> getParentId4NameListFromCurMap(ExtendedDataEntity[] extendedDataEntities, Set<Long> parentOrgIdSet) {
        Set idSet = Arrays.stream(extendedDataEntities).map(ex -> ex.getDataEntity().getLong("id")).collect(Collectors.toSet());
        HRBaseServiceHelper orgDiffTempHelper = new HRBaseServiceHelper("homs_orgdifftemp");
        QFilter parentOrgIdFilter = new QFilter("parentorg", "in", parentOrgIdSet);
        DynamicObject[] orgDiffTempDyns = orgDiffTempHelper.query("id, name, parentorg", new QFilter[]{parentOrgIdFilter});
        HashMap parentId4NameListFromCurMap = Maps.newHashMapWithExpectedSize((int)parentOrgIdSet.size());
        Arrays.stream(orgDiffTempDyns).filter(dyn -> !idSet.contains(dyn.getLong("id"))).forEach(dyn -> {
            long parentOrgId = dyn.getLong("parentorg.id");
            List nameList = parentId4NameListFromCurMap.getOrDefault(parentOrgId, new ArrayList());
            nameList.add(dyn.getString("name"));
            parentId4NameListFromCurMap.put(parentOrgId, nameList);
        });
        return parentId4NameListFromCurMap;
    }

    public static Map<Long, List<String>> getParentId4NameListFromTempMap(ExtendedDataEntity[] extendedDataEntities) {
        HashMap parentId4NameListFromTempMap = Maps.newHashMapWithExpectedSize((int)extendedDataEntities.length);
        Arrays.stream(extendedDataEntities).forEach(ex -> {
            DynamicObject dataEntity = ex.getDataEntity();
            DynamicObject parentOrgDyn = dataEntity.getDynamicObject("parentorg");
            if (Objects.nonNull(parentOrgDyn)) {
                long parentId = parentOrgDyn.getLong("id");
                String name = dataEntity.getString("name");
                List nameListFromTemp = parentId4NameListFromTempMap.getOrDefault(parentId, new ArrayList());
                nameListFromTemp.add(name);
                parentId4NameListFromTempMap.put(parentId, nameListFromTemp);
            }
        });
        return parentId4NameListFromTempMap;
    }

    public static void setTips(IFormView iFormView) {
        Tips tips = new Tips();
        List tipList = HRCSRPCServiceHelper.queryPromptForString((IFormView)iFormView, (String)"homs_orgdifftemp", (String)"index");
        if (!CollectionUtils.isEmpty((Collection)tipList)) {
            tips.setContent(new LocaleString((String)tipList.get(0)));
            tips.setType("text");
            tips.setTriggerType("hover");
            tips.setIsConfirm(false);
            tips.setShowIcon(true);
            TipsSupport control = (TipsSupport)iFormView.getControl("index");
            if (control != null) {
                control.addTips(tips);
            }
        }
    }
}

