/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgdifftemp;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgOpService;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.haos.common.util.PlatformRootUtils;
import kd.hr.haos.common.util.tree.TreeAssistUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.orgdifftemp.bean.OrgTempBean;
import kd.hr.homs.business.service.orgdifftemp.bean.OrgTempNode;
import org.apache.commons.collections4.trie.PatriciaTrie;

public class SynPlatform2HrHelper {
    private static final Log logger = LogFactory.getLog(SynPlatform2HrHelper.class);
    private static final String ENTITY_TRANSFER_ORG = "homs_orgdifftemp";
    private static final String ENTITY_ORG_STRUCT = "homs_orgdiffstruct";
    private static final HRBaseServiceHelper STRUCT_ORG = new HRBaseServiceHelper("homs_orgdiffstruct");
    private static final String ORG_ID = "org.id";
    private static final String ENTITY_HR_ORG = "haos_adminorgdetail";
    private static final String HOMS_ORGCHGBILLENTRY = "homs_batchorgentity";
    private static final String EXIST = "E";
    private static final String IS_CHANGE = "ischange";
    private static final String PARENT_ID = "parent.id";
    private static final String INTEGRATION_DATE = "integrationdate";
    private static final Map<String, String> COMPAREMAP = new HashMap<String, String>(8);

    public static void synTransfer(int beforeDays) {
        try (TXHandle required = TX.required();){
            Date integrationDate = SynPlatform2HrHelper.getIntegrationDate(beforeDays);
            DynamicObjectCollection bosOrgCol = SynPlatform2HrHelper.queryBosOrg(integrationDate);
            Date date = new Date();
            Set<Long> bosOrgIdSet = bosOrgCol.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
            if (integrationDate == null) {
                SynPlatform2HrHelper.addTempOrg(bosOrgIdSet, true, date);
                return;
            }
            try {
                Map<Long, DynamicObject> tempOrgMap = Arrays.stream(SynPlatform2HrHelper.loadTempOrgById(bosOrgIdSet)).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
                Set<Long> tempOrgIdSet = tempOrgMap.keySet();
                bosOrgIdSet.removeAll(tempOrgIdSet);
                SynPlatform2HrHelper.addTempOrg(bosOrgIdSet, false, date);
                SynPlatform2HrHelper.updateTempOrg(tempOrgIdSet, tempOrgMap, date);
            }
            catch (Exception ex) {
                required.markRollback();
                throw ex;
            }
        }
    }

    public static void updateTmp(Set<Long> idSet, DynamicObject[] tOrgDys) {
        DynamicObject[] structDyArr;
        for (DynamicObject tOrgDy : tOrgDys) {
            tOrgDy.set("enable", (Object)"1");
            tOrgDy.set("changedescription", null);
        }
        for (DynamicObject dy : structDyArr = SynPlatform2HrHelper.loadStruct(idSet)) {
            dy.set("enable", (Object)"1");
        }
        SaveServiceHelper.update((DynamicObject[])tOrgDys);
        SaveServiceHelper.update((DynamicObject[])structDyArr);
    }

    private static void fillParentAttribute(List<DynamicObject> parentList) {
        if (CollectionUtils.isEmpty(parentList)) {
            return;
        }
        List<Long> parentIdList = parentList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        DynamicObject[] parentArray = SynPlatform2HrHelper.loadAdminOrgList(parentIdList);
        Map<Long, DynamicObject> map = Arrays.stream(parentArray).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        if (CollectionUtils.isEmpty(map)) {
            return;
        }
        parentList.forEach(parent -> {
            DynamicObject adminOrg = (DynamicObject)map.get(parent.getLong("id"));
            if (adminOrg != null) {
                HRDynamicObjectUtils.copy((DynamicObject)adminOrg, (DynamicObject)parent);
                parent.set("id", (Object)adminOrg.getLong("id"));
            }
        });
    }

    public static DynamicObject[] buildEntityAndInsertAdminOrg(Set<Long> idSet, DynamicObject[] tOrgDys) {
        DynamicObjectCollection structList = STRUCT_ORG.queryOriginalCollection("adminorg.id", new QFilter[]{new QFilter("adminorg", "in", idSet)}, "level asc");
        Map<Long, DynamicObject> tempMap = Arrays.stream(tOrgDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        Date startDate = Date.from(ZonedDateTime.now().truncatedTo(ChronoUnit.DAYS).toInstant());
        DynamicObject changeSceneDy = SynPlatform2HrHelper.getBaseInfoDyById("id,number,orgchangetype,changeoperat", "haos_changescene", 1010L);
        DynamicObject changeTypeDy = SynPlatform2HrHelper.getBaseInfoDyById("id,number,name", "haos_orgchangetype", 1010L);
        DynamicObject[] dynArr = new DynamicObject[tOrgDys.length];
        DynamicObject[] entityArr = new DynamicObject[tOrgDys.length];
        ArrayList<DynamicObject> parentList = new ArrayList<DynamicObject>(tOrgDys.length);
        for (int index = 0; index < structList.size(); ++index) {
            DynamicObject tOrgDy = tempMap.get(((DynamicObject)structList.get(index)).getLong("adminorg.id"));
            tOrgDy.set("changedescription", null);
            DynamicObject parentDy = tOrgDy.getDynamicObject("parentorg");
            tOrgDy.set("bsed", tOrgDy.get("establishmentdate"));
            tOrgDy.set("bsled", (Object)OrgDateTimeUtil.BSLED);
            parentDy.set("boid", parentDy.get("id"));
            if (EXIST.equals(parentDy.getString("status"))) {
                parentList.add(parentDy);
            }
            DynamicObject entityDy = BusinessDataServiceHelper.newDynamicObject((String)HOMS_ORGCHGBILLENTRY);
            DynamicObject hrOrgDy = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_HR_ORG);
            HRDynamicObjectUtils.copy((DynamicObject)tOrgDy, (DynamicObject)entityDy);
            HRDynamicObjectUtils.copy((DynamicObject)tOrgDy, (DynamicObject)hrOrgDy);
            hrOrgDy.set("boid", tOrgDy.get("id"));
            hrOrgDy.set("id", tOrgDy.get("id"));
            hrOrgDy.set("enable", (Object)"1");
            dynArr[index] = hrOrgDy;
            entityDy.set("changescene", (Object)changeSceneDy);
            entityDy.set("changetype", (Object)changeTypeDy);
            entityDy.set("enable", (Object)"1");
            entityDy.set("adminorg", (Object)hrOrgDy);
            entityArr[index] = entityDy;
        }
        SynPlatform2HrHelper.fillParentAttribute(parentList);
        AdminOrgOpService.getInstance().saveTemporary(dynArr, Long.valueOf(0L), false);
        return entityArr;
    }

    private static DynamicObject getBaseInfoDyById(String selectProperties, String entityName, Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        return serviceHelper.queryOne(selectProperties, new QFilter[]{idFilter});
    }

    private static void addTempOrg(Set<Long> idSet, Boolean initFlag, Date date) {
        if (CollectionUtils.isEmpty(idSet)) {
            return;
        }
        Set adminOrgSet = SynPlatform2HrHelper.queryAdminOrgById(idSet).stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] bosOrgArray = SynPlatform2HrHelper.queryBosOrgById(idSet);
        HashMap<Long, String> parentStructNumberMap = new HashMap<Long, String>(bosOrgArray.length);
        DynamicObject[] parentStructDyArray = null;
        if (!initFlag.booleanValue()) {
            Set<Long> parentOrgId = Arrays.stream(bosOrgArray).map(dy -> dy.getLong(PARENT_ID)).collect(Collectors.toSet());
            parentStructDyArray = SynPlatform2HrHelper.loadStruct(parentOrgId);
            parentStructNumberMap.putAll(SynPlatform2HrHelper.getStructMapByParentId(parentStructDyArray));
        }
        ArrayList<DynamicObject> tempList = new ArrayList<DynamicObject>(bosOrgArray.length);
        ArrayList<DynamicObject> orgStructDyList = new ArrayList<DynamicObject>(bosOrgArray.length);
        int index = 0;
        String[] structNumbers = ORM.create().genStringIds(ENTITY_TRANSFER_ORG, bosOrgArray.length);
        for (DynamicObject dy2 : bosOrgArray) {
            DynamicObject tempOrgDy = SynPlatform2HrHelper.genTempOrgDy(dy2, date);
            tempOrgDy.set("status", (Object)"C");
            if (adminOrgSet.contains(tempOrgDy.getLong("id"))) {
                tempOrgDy.set("enable", (Object)"1");
                tempOrgDy.set("status", (Object)EXIST);
            } else {
                tempOrgDy.set("enable", (Object)"0");
            }
            tempOrgDy.set("org", (Object)PlatformRootUtils.getLongRootIdOfPlatform());
            tempOrgDy.set(IS_CHANGE, (Object)"0");
            tempOrgDy.set("structnumber", (Object)structNumbers[index++]);
            DynamicObject structDy = SynPlatform2HrHelper.genOrgStructDy(tempOrgDy, dy2, parentStructNumberMap);
            if (structDy == null) continue;
            tempList.add(tempOrgDy);
            orgStructDyList.add(structDy);
        }
        if (parentStructDyArray != null && parentStructDyArray.length > 0) {
            for (DynamicObject parentDy : parentStructDyArray) {
                if (!parentDy.getBoolean("isleaf")) continue;
                parentDy.set("isleaf", (Object)Boolean.FALSE);
                orgStructDyList.add(parentDy);
            }
        }
        SaveServiceHelper.save((DynamicObject[])tempList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])orgStructDyList.toArray(new DynamicObject[0]));
    }

    private static void updateTempOrg(Set<Long> tempOrgIdSet, Map<Long, DynamicObject> tempOrgMap, Date date) {
        if (CollectionUtils.isEmpty(tempOrgIdSet)) {
            return;
        }
        DynamicObject[] bosOrgArray = SynPlatform2HrHelper.queryBosOrgById(tempOrgIdSet);
        Set adminOrgSet = SynPlatform2HrHelper.queryAdminOrgById(tempOrgIdSet).stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        ArrayList<OrgTempBean> orgTempList = new ArrayList<OrgTempBean>(tempOrgIdSet.size());
        HashSet<Long> existsOrgSet = new HashSet<Long>(adminOrgSet.size());
        for (DynamicObject bosOrgDy : bosOrgArray) {
            Long orgId = bosOrgDy.getLong(ORG_ID);
            DynamicObject tempDy = tempOrgMap.get(orgId);
            if (adminOrgSet.contains(orgId) && "0".equals(tempDy.getString("enable"))) {
                tempDy.set("enable", (Object)"1");
                tempDy.set("status", (Object)EXIST);
                existsOrgSet.add(orgId);
            } else {
                if (!SynPlatform2HrHelper.isValueChanged(tempDy, bosOrgDy)) {
                    tempOrgMap.remove(orgId);
                    continue;
                }
                if ("1".equals(tempDy.getString(IS_CHANGE)) && "0".equals(tempDy.getString("enable")) && tempDy.getLong("parentorg.id") == bosOrgDy.getLong(COMPAREMAP.get("parentorg.id")) && tempDy.getString("isfreeze").equals(bosOrgDy.getString("isfreeze"))) {
                    tempOrgMap.remove(orgId);
                    continue;
                }
            }
            orgTempList.add(new OrgTempBean(orgId, tempDy.getLong("parentorg.id"), bosOrgDy.getLong(COMPAREMAP.get("parentorg.id"))));
            SynPlatform2HrHelper.synFields(bosOrgDy, tempDy, date);
        }
        DynamicObject[] structArrays = SynPlatform2HrHelper.getChangedStructs(orgTempList);
        if (structArrays != null && structArrays.length > 0) {
            SaveServiceHelper.update((DynamicObject[])structArrays);
        }
        SynPlatform2HrHelper.updateExistsOrgStruct(existsOrgSet);
        SaveServiceHelper.update((DynamicObject[])tempOrgMap.values().toArray(new DynamicObject[0]));
    }

    private static void updateExistsOrgStruct(Set<Long> set) {
        DynamicObject[] structDyArr;
        if (CollectionUtils.isEmpty(set)) {
            return;
        }
        for (DynamicObject dy : structDyArr = SynPlatform2HrHelper.loadStruct(set)) {
            dy.set("enable", (Object)"1");
            dy.set("status", (Object)EXIST);
        }
        SaveServiceHelper.update((DynamicObject[])structDyArr);
    }

    public static DynamicObject[] getChangedStructs(List<OrgTempBean> orgTempList) {
        Map<Long, OrgTempBean> orgTempBeanMap = orgTempList.stream().filter(OrgTempBean::getParentChangeFlag).collect(Collectors.toMap(OrgTempBean::getOrgId, tempBean -> tempBean));
        if (CollectionUtils.isEmpty(orgTempBeanMap)) {
            return null;
        }
        HashSet<Long> parentSet = new HashSet<Long>(orgTempBeanMap.size() * 2);
        HashSet<Long> orgSet = new HashSet<Long>(orgTempBeanMap.size());
        orgTempBeanMap.values().forEach(orgTemp -> {
            parentSet.add(orgTemp.getOldParentId());
            parentSet.add(orgTemp.getParentId());
            orgSet.add(orgTemp.getOrgId());
        });
        List<DynamicObject> structDyList = SynPlatform2HrHelper.getStructDyList(orgSet, parentSet);
        SynPlatform2HrHelper.setStructValues(structDyList, orgTempBeanMap);
        Map<Long, OrgTempNode> parentSubMap = structDyList.stream().collect(Collectors.toMap(dy -> dy.getLong("adminorg.id"), dy -> new OrgTempNode((DynamicObject)dy, dy.getLong("parentorg.id") == 0L ? dy.getLong("parentorg") : dy.getLong("parentorg.id"))));
        parentSubMap.values().forEach(orgNode -> {
            Long parentId = orgNode.getParentId();
            OrgTempNode orgTempNode = (OrgTempNode)parentSubMap.get(parentId);
            if (orgTempNode != null) {
                orgTempNode.getSubNodeList().add((OrgTempNode)orgNode);
            }
        });
        orgTempBeanMap.values().stream().filter(OrgTempBean::getParentChangeFlag).forEach(orgTempBean -> {
            OrgTempNode node = (OrgTempNode)parentSubMap.get(orgTempBean.getParentId());
            if (node != null) {
                node.changeValuesByParent();
            }
        });
        SynPlatform2HrHelper.changeIsLeaf(orgSet, parentSet, parentSubMap);
        return (DynamicObject[])parentSubMap.values().stream().filter(OrgTempNode::isChanged).map(OrgTempNode::getDy).toArray(DynamicObject[]::new);
    }

    private static void setStructValues(List<DynamicObject> structDyList, Map<Long, OrgTempBean> orgTempBeanMap) {
        structDyList.forEach(structDy -> {
            OrgTempBean tempBean = (OrgTempBean)orgTempBeanMap.get(structDy.getLong("adminorg.id"));
            if (tempBean != null) {
                structDy.set("parentorg", (Object)tempBean.getParentId());
            }
        });
    }

    private static List<DynamicObject> getStructDyList(Set<Long> orgSet, Set<Long> parentSet) {
        HashSet<Long> allSet = new HashSet<Long>(orgSet.size() + parentSet.size());
        allSet.addAll(orgSet);
        allSet.addAll(parentSet);
        DynamicObjectCollection dyCol = SynPlatform2HrHelper.queryStructByOrgId(allSet);
        Map orgStructLongNumberMap = dyCol.stream().collect(Collectors.groupingBy(structDy -> orgSet.contains(structDy.getLong("adminorg.id")), Collectors.mapping(dy -> dy.getString("structlongnumber"), Collectors.toList())));
        List<String> equalsStructLongNumberList = orgStructLongNumberMap.getOrDefault(Boolean.FALSE, Collections.emptyList());
        List<String> likeStructLongNumberList = orgStructLongNumberMap.getOrDefault(Boolean.TRUE, Collections.emptyList());
        return SynPlatform2HrHelper.loadStructByStructLongNumber(equalsStructLongNumberList, likeStructLongNumberList);
    }

    private static List<DynamicObject> loadStructByStructLongNumber(List<String> equalsStructLongNumberList, List<String> likeStructLongNumberList) {
        QFilter structLongNumberJoinFilter = new QFilter("structlongnumber", "in", equalsStructLongNumberList);
        String commonPrefixStructLongNumber = TreeAssistUtils.getCommonPrefixStructLongNumber(likeStructLongNumberList);
        QFilter structLongNumberLikeFilter = new QFilter("structlongnumber", "like", (Object)(commonPrefixStructLongNumber + "%"));
        DynamicObject[] structDyArr = STRUCT_ORG.loadDynamicObjectArray(new QFilter[]{structLongNumberLikeFilter.or(structLongNumberJoinFilter)});
        PatriciaTrie patriciaTrie = Arrays.stream(structDyArr).collect(Collectors.toMap(dyn -> dyn.getString("structlongnumber"), dyn -> dyn, (value, value2) -> value, PatriciaTrie::new));
        HashMap structLongNumberVsStructDy = new HashMap();
        likeStructLongNumberList.forEach(structLongNumber -> {
            SortedMap stringDynamicObjectSortedMap = patriciaTrie.prefixMap(structLongNumber);
            structLongNumberVsStructDy.putAll(stringDynamicObjectSortedMap);
        });
        equalsStructLongNumberList.forEach(structLongNumber -> {
            DynamicObject dynamicObject = (DynamicObject)patriciaTrie.get(structLongNumber);
            structLongNumberVsStructDy.put(dynamicObject.getString("structlongnumber"), dynamicObject);
        });
        return new ArrayList<DynamicObject>(structLongNumberVsStructDy.values());
    }

    private static void changeIsLeaf(Set<Long> orgSet, Set<Long> parentSet, Map<Long, OrgTempNode> parentSubMap) {
        HashSet<Long> memoryLeafOrgList = new HashSet<Long>();
        for (Long boId : parentSet) {
            OrgTempNode node = parentSubMap.get(boId);
            if (node == null) continue;
            if (node.getSubNodeList().size() == 0) {
                memoryLeafOrgList.add(boId);
                continue;
            }
            node.changeIsLeaf(Boolean.FALSE);
        }
        DynamicObjectCollection dyList = SynPlatform2HrHelper.queryStructByParentCountSub(memoryLeafOrgList, orgSet);
        Map<Long, List<DynamicObject>> idVsDbSubDy = dyList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("parentorg.id")));
        Iterator iterator = memoryLeafOrgList.iterator();
        while (iterator.hasNext()) {
            Long boId;
            parentSubMap.get(boId).changeIsLeaf(idVsDbSubDy.getOrDefault(boId = (Long)iterator.next(), Collections.emptyList()).size() == 0);
        }
    }

    private static boolean isValueChanged(DynamicObject tmpOrgDy, DynamicObject bosOrgDy) {
        boolean flag = false;
        for (Map.Entry<String, String> entry : COMPAREMAP.entrySet()) {
            Object value = tmpOrgDy.get(entry.getKey());
            if (value instanceof ILocaleString) {
                flag = SynPlatform2HrHelper.isLocaleStringChanged((ILocaleString)value, bosOrgDy.getLocaleString(entry.getValue()));
            } else if (value instanceof Long) {
                flag = tmpOrgDy.getLong(entry.getKey()) != bosOrgDy.getLong(entry.getValue());
            } else {
                boolean bl = flag = !HRStringUtils.equals((String)tmpOrgDy.getString(entry.getKey()), (String)bosOrgDy.getString(entry.getValue()));
            }
            if (!flag) continue;
            break;
        }
        return flag;
    }

    private static boolean isLocaleStringChanged(ILocaleString oldValue, ILocaleString value) {
        ILocaleString minString;
        ILocaleString maxString;
        if (CollectionUtils.isEmpty((Map)oldValue) && CollectionUtils.isEmpty((Map)value)) {
            return false;
        }
        if (CollectionUtils.isEmpty((Map)oldValue) || CollectionUtils.isEmpty((Map)value)) {
            return true;
        }
        if (oldValue.size() > value.size()) {
            maxString = oldValue;
            minString = value;
        } else {
            maxString = value;
            minString = oldValue;
        }
        for (Map.Entry entry : maxString.entrySet()) {
            if (HRStringUtils.equals((String)((String)entry.getValue()), (String)((String)minString.get(entry.getKey())))) continue;
            logger.info("SynPlatform2HRHelper is changed attribute local:" + (String)entry.getKey());
            return true;
        }
        return false;
    }

    private static DynamicObject genTempOrgDy(DynamicObject bosOrgDy, Date date) {
        DynamicObject tempOrgDy = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_TRANSFER_ORG);
        SynPlatform2HrHelper.synFields(bosOrgDy, tempOrgDy, date);
        return tempOrgDy;
    }

    private static DynamicObject genOrgStructDy(DynamicObject tempDy, DynamicObject bosOrgDy, Map<Long, String> map) {
        Long parentOrgId = tempDy.getLong("parentorg");
        Long orgId = tempDy.getLong("id");
        DynamicObject orgStructDy = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ORG_STRUCT);
        orgStructDy.set("id", bosOrgDy.get("id"));
        orgStructDy.set("adminorg", (Object)orgId);
        orgStructDy.set("parentorg", (Object)parentOrgId);
        orgStructDy.set("enable", tempDy.get("enable"));
        orgStructDy.set("status", tempDy.get("status"));
        orgStructDy.set("level", bosOrgDy.get("level"));
        orgStructDy.set("isleaf", bosOrgDy.get("isleaf"));
        String structLongNumber = tempDy.getString("structnumber");
        if (parentOrgId != 0L) {
            if (HRStringUtils.isEmpty((String)map.get(parentOrgId))) {
                return null;
            }
            structLongNumber = map.get(parentOrgId) + "!" + structLongNumber;
        }
        map.put(orgId, structLongNumber);
        orgStructDy.set("structlongnumber", (Object)structLongNumber);
        return orgStructDy;
    }

    private static void synFields(DynamicObject bosOrgDy, DynamicObject tempOrgDy, Date date) {
        tempOrgDy.set("id", bosOrgDy.get(ORG_ID));
        tempOrgDy.set("name", bosOrgDy.get(COMPAREMAP.get("name")));
        tempOrgDy.set("number", bosOrgDy.get(COMPAREMAP.get("number")));
        tempOrgDy.set("description", bosOrgDy.get(COMPAREMAP.get("description")));
        tempOrgDy.set("parentorg", bosOrgDy.get(PARENT_ID));
        tempOrgDy.set("isfreeze", bosOrgDy.get("isfreeze"));
        tempOrgDy.set("index", (Object)1);
        tempOrgDy.set(INTEGRATION_DATE, (Object)date);
    }

    private static DynamicObjectCollection queryBosOrg(Date integrationDate) {
        QFilter filter = new QFilter("structure.view.number", "=", (Object)"01").and("status", "=", (Object)"C");
        if (integrationDate != null) {
            filter.and("modifytime", ">=", (Object)integrationDate);
        } else {
            filter.and("structure.isfreeze", "=", (Object)"0");
        }
        return QueryServiceHelper.query((String)"bos_adminorg", (String)"id", (QFilter[])new QFilter[]{filter});
    }

    private static Date getIntegrationDate(int beforeDays) {
        String str = "select max(fintegrationdate) as integrationdate from t_homs_orgdifftemp";
        Date integrationDate = null;
        try (DataSet rs = HRDBUtil.queryDataSet((String)"t_homs_orgdifftemp", (DBRoute)new DBRoute("haos"), (String)str, null);){
            for (Row data : rs) {
                integrationDate = data.getDate(INTEGRATION_DATE);
            }
        }
        if (integrationDate != null) {
            integrationDate = KDDateUtils.addDays((Date)integrationDate, (int)(-(beforeDays + 1)));
        }
        return integrationDate;
    }

    private static DynamicObjectCollection queryAdminOrgById(Set<Long> idSet) {
        return QueryServiceHelper.query((String)ENTITY_HR_ORG, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet), new QFilter("initstatus", "=", (Object)"2"), new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'))});
    }

    private static DynamicObject[] queryBosOrgById(Set<Long> idSet) {
        return new HRBaseServiceHelper("bos_adminorg_structure").query("id,org.id,org.name,org.number,org.fcomment,isfreeze,parent.id,level,isleaf", new QFilter[]{new QFilter(ORG_ID, "in", idSet), SynPlatform2HrHelper.genViewFilter()}, "level asc");
    }

    private static Map<Long, String> getStructMapByParentId(DynamicObject[] parentStructDyArray) {
        return Arrays.stream(parentStructDyArray).collect(Collectors.toMap(dy -> dy.getLong("adminorg.id"), dy -> dy.getString("structlongnumber"), (key1, key2) -> key2));
    }

    private static DynamicObjectCollection queryStructByParentCountSub(Set<Long> parendIdList, Set<Long> orgIdList) {
        QFilter parentFilter = new QFilter("parentorg", "in", parendIdList);
        QFilter adminOrgFilter = new QFilter("adminorg", "not in", orgIdList);
        return STRUCT_ORG.queryOriginalCollection("adminorg as adminorg.id, parentorg as parentorg.id", new QFilter[]{parentFilter, adminOrgFilter});
    }

    private static DynamicObjectCollection queryStructByOrgId(Set<Long> orgIdSet) {
        return STRUCT_ORG.queryOriginalCollection("adminorg.id,structlongnumber", new QFilter[]{new QFilter("adminorg", "in", orgIdSet)});
    }

    private static DynamicObject[] loadStruct(Set<Long> orgIdSet) {
        return STRUCT_ORG.loadDynamicObjectArray(new QFilter[]{new QFilter("adminorg", "in", orgIdSet)});
    }

    private static DynamicObject[] loadAdminOrgList(List<Long> orgIdList) {
        return new HRBaseServiceHelper(ENTITY_HR_ORG).loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", orgIdList), new QFilter("initstatus", "=", (Object)"2"), new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'))});
    }

    public static DynamicObject[] loadTempOrgById(Set<Long> idSet) {
        return new HRBaseServiceHelper(ENTITY_TRANSFER_ORG).loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", idSet)});
    }

    private static QFilter genViewFilter() {
        return new QFilter("view.number", "=", (Object)"01");
    }

    static {
        COMPAREMAP.put("name", "org.name");
        COMPAREMAP.put("number", "org.number");
        COMPAREMAP.put("description", "org.fcomment");
        COMPAREMAP.put("parentorg.id", PARENT_ID);
        COMPAREMAP.put("isfreeze", "isfreeze");
    }
}

