/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgdifftemp.bean;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;

public class OrgTempNode {
    private final DynamicObject dy;
    private final Long parentId;
    private boolean isChanged;
    private final List<OrgTempNode> subNodeList;

    public OrgTempNode(DynamicObject dy, Long parentId) {
        this.dy = dy;
        this.parentId = parentId;
        this.subNodeList = new ArrayList<OrgTempNode>();
    }

    public void changeValuesByParent() {
        ArrayDeque<OrgTempNode> queue = new ArrayDeque<OrgTempNode>();
        queue.offer(this);
        while (!queue.isEmpty()) {
            OrgTempNode parentNode = (OrgTempNode)queue.poll();
            List<OrgTempNode> subNodeList = parentNode.getSubNodeList();
            subNodeList.forEach(subOrgNode -> subOrgNode.followParent(parentNode));
            subNodeList.forEach(queue::offer);
        }
    }

    public void changeIsLeaf(Object value) {
        this.setStructValue("isleaf", value);
    }

    private void followParent(OrgTempNode parentNode) {
        String structLongNumber = this.dy.getString("structlongnumber");
        String structNumber = structLongNumber.substring(structLongNumber.lastIndexOf("!") + 1);
        DynamicObject parentData = parentNode.dy;
        this.setStructValue("structlongnumber", parentData.getString("structlongnumber") + "!" + structNumber);
        this.setStructValue("level", parentData.getInt("level") + 1);
    }

    private void setStructValue(String key, Object newValue) {
        this.recordChanged(this.dy.get(key), newValue);
        this.dy.set(key, newValue);
    }

    private void recordChanged(Object oldValue, Object newValue) {
        if (this.isChanged) {
            return;
        }
        this.isChanged = oldValue != null && !oldValue.equals(newValue);
    }

    public DynamicObject getDy() {
        return this.dy;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public List<OrgTempNode> getSubNodeList() {
        return this.subNodeList;
    }

    public Long getParentId() {
        return this.parentId;
    }
}

