/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.validcommon.CycleOrgBean;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckConstants;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.CalibratorBean;

public class FastCoopOrgInfoCheckServiceImpl
implements IOrgBatchBillCheckService {
    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        ArrayList result = Lists.newArrayListWithCapacity((int)10);
        DynamicObjectCollection cooprelentryColl = targetObject.getDynamicObjectCollection("cooprelentryentity");
        if (CollectionUtils.isEmpty((Collection)cooprelentryColl)) {
            return result;
        }
        String changeType = cacheModel.getChangeType();
        Long orgBoId = targetObject.getLong("adminorg.boid");
        Date effectDate = targetObject.getDate("effdt");
        ArrayList adminAffiliationList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList adminCoopList = Lists.newArrayListWithExpectedSize((int)10);
        List<CycleOrgBean> adminCycleOrgList = FastCoopOrgInfoCheckServiceImpl.queryAdminCoopOrgColl(effectDate);
        adminCycleOrgList.forEach(coop -> {
            if (1010L == coop.getCoopTypeId()) {
                adminAffiliationList.add(coop);
            } else {
                adminCoopList.add(coop);
            }
        });
        ArrayList billAffiliationList = Lists.newArrayListWithExpectedSize((int)10);
        List<CycleOrgBean> billCoopList = FastCoopOrgInfoCheckServiceImpl.queryBillOrgCoopList(billAffiliationList);
        if (HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.parentEntry.getChangeType())) {
            FastCoopOrgInfoCheckServiceImpl.affiliationCheck(targetObject, adminAffiliationList, billAffiliationList, result);
        }
        Set<Long> cooporgBoIdSet = cooprelentryColl.stream().map(dy -> dy.getLong("cooporgteam.boid")).collect(Collectors.toSet());
        Set<Long> disableOrgBoIdSet = OrgBatchBillCheckHelper.queryDisableOrgBoIdSet(cooporgBoIdSet, effectDate);
        Map<Long, String> orgIdBillNoMap = cacheModel.getBillOrgList().stream().filter(dto -> OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE.equals(dto.getChangeTypeId())).collect(Collectors.toMap(OrgBatchCheckDto::getAdminOrgBoid, OrgBatchCheckDto::getBillNo, (v1, v2) -> v2));
        HashSet coopreltypIdSet = Sets.newHashSetWithExpectedSize((int)(cooprelentryColl.size() * 3));
        cooprelentryColl.forEach(dy -> {
            DynamicObject coopreltypDy = dy.getDynamicObject("coopreltyp");
            String coopreltypName = coopreltypDy.getString("name");
            DynamicObject cooporgteamDy = dy.getDynamicObject("cooporgteam");
            Long cooporgId = cooporgteamDy.getLong("id");
            String cooporgteamName = cooporgteamDy.getString("name");
            if (disableOrgBoIdSet.contains(cooporgId)) {
                result.add(new CalibratorBean("FastCoopOrgInfoCheckServiceImpl_3", ResManager.loadKDString((String)"\u201c%1$s\u201d\u5bf9\u5e94\u7684\u534f\u4f5c\u7ec4\u7ec7\u201c%2$s\u201d\u5df2\u505c\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastCoopOrgInfoCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{coopreltypName, cooporgteamName}));
            }
            if (orgIdBillNoMap.containsKey(cooporgteamDy.getLong("id"))) {
                result.add(new CalibratorBean("FastCoopOrgInfoCheckServiceImpl_4", ResManager.loadKDString((String)"\u201c%1$s\u201d\u5bf9\u5e94\u7684\u534f\u4f5c\u7ec4\u7ec7\u201c%2$s\u201d\u5728\u5728\u9014\u5355\u636e\u201c%3$s\u201d\u4e2d\u5df2\u505c\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastCoopOrgInfoCheckServiceImpl_4", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{coopreltypName, cooporgteamName, orgIdBillNoMap.get(cooporgId)}));
            }
            if (!coopreltypIdSet.add(coopreltypDy.getLong("id"))) {
                result.add(new CalibratorBean("FastCoopOrgInfoCheckServiceImpl_5", ResManager.loadKDString((String)"\u201c%s\u201d\u534f\u4f5c\u5173\u7cfb\u51fa\u73b0\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastCoopOrgInfoCheckServiceImpl_5", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{coopreltypName}));
            }
            CycleOrgBean cycleOrg = OrgBatchBillCheckHelper.assembleCycleOrg(orgBoId, cooporgId, effectDate);
            if (HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.parentEntry.getChangeType()) || HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.infoEntry.getChangeType())) {
                this.cooprelCheck(cycleOrg, (DynamicObject)dy, adminCoopList, billCoopList, result);
            }
        });
        return result;
    }

    public static void affiliationCheck(DynamicObject targetObject, List<CycleOrgBean> adminAffiliationList, List<CycleOrgBean> billAffiliationList, List<CalibratorBean> result) {
        Map<Long, List<CycleOrgBean>> billAffiliationMap;
        Long parentId;
        Long orgId;
        CycleOrgBean billBean;
        Deque<CycleOrgBean> billCycleOrgs;
        Map<Long, List<CycleOrgBean>> adminAffiliationMap;
        Date effectDate;
        Long parentBoId;
        Long orgBoId = targetObject.getLong("adminorg.boid");
        CycleOrgBean adminBean = OrgBatchBillCheckHelper.assembleCycleOrg(orgBoId, parentBoId = Long.valueOf(targetObject.getLong("parentorg.boid")), effectDate = targetObject.getDate("effdt"));
        Deque<CycleOrgBean> adminCycleOrgs = OrgBatchBillCheckHelper.containsCycle(adminBean, adminAffiliationMap = adminAffiliationList.stream().collect(Collectors.groupingBy(CycleOrgBean::getOrgId, Collectors.toList())), true);
        if (!CollectionUtils.isEmpty(adminCycleOrgs)) {
            result.add(new CalibratorBean("FastCoopOrgInfoCheckServiceImpl_1", ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u81ea\u5df1\u6216\u81ea\u5df1\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastCoopOrgInfoCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
        }
        if (!CollectionUtils.isEmpty(billCycleOrgs = OrgBatchBillCheckHelper.containsCycle(billBean = OrgBatchBillCheckHelper.assembleCycleOrg(orgId = Long.valueOf(targetObject.getLong("adminorg.id")), parentId = Long.valueOf(targetObject.getLong("parentorg.id")), effectDate), billAffiliationMap = billAffiliationList.stream().collect(Collectors.groupingBy(CycleOrgBean::getOrgId, Collectors.toList())), false)) && !HRStringUtils.isEmpty((String)billCycleOrgs.getFirst().getBillNo())) {
            Set billNoSet = billCycleOrgs.stream().map(CycleOrgBean::getBillNo).collect(Collectors.toSet());
            String billNoStr = String.join((CharSequence)",", billNoSet);
            result.add(new CalibratorBean("FastCoopOrgInfoCheckServiceImpl_2", ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u5728\u9014\u5355\u636e\u201c%s\u201d\u4e2d\u81ea\u5df1\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastCoopOrgInfoCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{billNoStr}));
        }
    }

    private void cooprelCheck(CycleOrgBean cycleOrg, DynamicObject coopOrgDy, List<CycleOrgBean> adminCoopList, List<CycleOrgBean> billCoopList, List<CalibratorBean> result) {
        Map<Long, List<CycleOrgBean>> billCoopMap;
        Deque<CycleOrgBean> billCycleOrgs;
        Map billCoopTypeIdBeanMap;
        List billCycleOrgList;
        Map<Long, List<CycleOrgBean>> adminCoopMap;
        Deque<CycleOrgBean> adminCycleOrgs;
        Long coopTypeId = coopOrgDy.getLong("coopreltyp.id");
        String coopreltypName = coopOrgDy.getString("coopreltyp.name");
        Map adminCoopTypeIdBeanMap = adminCoopList.stream().collect(Collectors.groupingBy(CycleOrgBean::getCoopTypeId, Collectors.toList()));
        List adminCycleOrgList = adminCoopTypeIdBeanMap.get(coopTypeId);
        if (!CollectionUtils.isEmpty(adminCycleOrgList) && !CollectionUtils.isEmpty(adminCycleOrgs = OrgBatchBillCheckHelper.containsCycle(cycleOrg, adminCoopMap = adminCoopList.stream().collect(Collectors.groupingBy(CycleOrgBean::getOrgId, Collectors.toList())), true))) {
            result.add(new CalibratorBean("FastCoopOrgInfoCheckServiceImpl_6", ResManager.loadKDString((String)"\u201c%s\u201d\u534f\u4f5c\u5173\u7cfb\u51fa\u73b0\u534f\u4f5c\u5faa\u73af\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastCoopOrgInfoCheckServiceImpl_6", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{coopreltypName}));
        }
        if (!(CollectionUtils.isEmpty(billCycleOrgList = (billCoopTypeIdBeanMap = billCoopList.stream().collect(Collectors.groupingBy(CycleOrgBean::getCoopTypeId, Collectors.toList()))).get(coopTypeId)) || CollectionUtils.isEmpty(billCycleOrgs = OrgBatchBillCheckHelper.containsCycle(cycleOrg, billCoopMap = billCycleOrgList.stream().collect(Collectors.groupingBy(CycleOrgBean::getOrgBoid, Collectors.toList())), false)) || HRStringUtils.isEmpty((String)billCycleOrgs.getFirst().getBillNo()))) {
            Set billNoSet = billCycleOrgs.stream().map(CycleOrgBean::getBillNo).collect(Collectors.toSet());
            String billNoStr = String.join((CharSequence)",", billNoSet);
            result.add(new CalibratorBean("FastCoopOrgInfoCheckServiceImpl_7", ResManager.loadKDString((String)"\u201c%1$s\u201d\u534f\u4f5c\u5173\u7cfb\u548c\u5728\u9014\u5355\u636e\u201c%2$s\u201d\u7684\u534f\u4f5c\u5173\u7cfb\u6784\u6210\u534f\u4f5c\u5faa\u73af\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastCoopOrgInfoCheckServiceImpl_7", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{coopreltypName, billNoStr}));
        }
    }

    public static List<CycleOrgBean> queryAdminCoopOrgColl(Date effectDate) {
        QFilter adminFilter = new QFilter("enable", "=", (Object)"1");
        adminFilter.and(new QFilter("datastatus", "in", OrgBatchCheckConstants.DATASTATUS_EFFECT_SET));
        adminFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        adminFilter.and(new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0')));
        adminFilter.and(new QFilter("bsled", ">=", (Object)effectDate));
        HRBaseServiceHelper adminHelper = new HRBaseServiceHelper("haos_orgteamcooprel");
        DynamicObjectCollection orgColl = adminHelper.queryOriginalCollection("org,coopreltype,cooporgteam,bsed,bsled", new QFilter[]{adminFilter});
        ArrayList result = Lists.newArrayListWithCapacity((int)orgColl.size());
        for (DynamicObject dy : orgColl) {
            Long orgId = dy.getLong("org");
            Long coopOrgId = dy.getLong("cooporgteam");
            Long coopTypeId = dy.getLong("coopreltype");
            if (OrgBatchBillCheckHelper.isValidateOrgId(orgId) || OrgBatchBillCheckHelper.isValidateOrgId(coopOrgId) || OrgBatchBillCheckHelper.isValidateOrgId(coopTypeId)) continue;
            CycleOrgBean cycleOrg = new CycleOrgBean();
            cycleOrg.setOrgId(orgId);
            cycleOrg.setCoopOrgId(coopOrgId);
            cycleOrg.setCoopTypeId(coopTypeId);
            cycleOrg.setBsed(dy.getDate("bsed"));
            cycleOrg.setBsled(dy.getDate("bsled"));
            result.add(cycleOrg);
        }
        return result;
    }

    public static List<CycleOrgBean> queryBillOrgCoopList(List<CycleOrgBean> affiliationList) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fbillno,b.fadminorgboid,b.fadminorgid,b.fparentid,c.fteamcoopreltypeid,c.forgteamid,d.fboid ").append(" from t_homs_orgchgbill a ").append(" left join t_homs_orgchgbillentry b on b.fid = a.fid ").append(" left join t_homs_orgchgbillcoop c on c.fentryid = b.fentryid ").append(" left join t_haos_orgteam d on  d.fid = c.forgteamid").append(" where a.fbillstatus in('B','D')");
        try (DataSet ds = HRDBUtil.queryDataSet((String)"queryBillOrgCoopList", (DBRoute)new DBRoute("haos"), (String)sb.toString(), null);){
            HashSet orgIdSet = Sets.newHashSetWithExpectedSize((int)10);
            for (Row data : ds) {
                CycleOrgBean cycleOrg = new CycleOrgBean();
                cycleOrg.setBillNo(data.getString("fbillno"));
                cycleOrg.setOrgId(data.getLong("fadminorgid"));
                cycleOrg.setOrgBoid(data.getLong("fadminorgboid"));
                cycleOrg.setCoopOrgId(data.getLong("fboid"));
                cycleOrg.setCoopTypeId(data.getLong("fteamcoopreltypeid"));
                result.add(cycleOrg);
                if (!orgIdSet.add(data.getLong("fadminorgid"))) continue;
                CycleOrgBean affiliationOrg = new CycleOrgBean();
                affiliationOrg.setBillNo(data.getString("fbillno"));
                affiliationOrg.setOrgId(data.getLong("fadminorgid"));
                affiliationOrg.setCoopOrgId(data.getLong("fparentid"));
                affiliationList.add(affiliationOrg);
            }
        }
        return result;
    }
}

