/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.validcommon.BillEntryHelperEnum;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.CalibratorBean;

public class FastOrgChgFeasibleCheckServiceImpl
implements IOrgBatchBillCheckService {
    private Map<Long, String> changeTypeIdNameMap;

    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        this.changeTypeIdNameMap = OrgBatchBillCheckHelper.queryBaseDataInfo("haos_orgchangetype", "id,name");
        ArrayList result = Lists.newArrayListWithCapacity((int)4);
        String changeType = cacheModel.getChangeType();
        if (HRStringUtils.equals((String)EntryEntityEnum.parentEntry.getChangeType(), (String)changeType) || HRStringUtils.equals((String)EntryEntityEnum.infoEntry.getChangeType(), (String)changeType)) {
            DynamicObject adminorg = targetObject.getDynamicObject("adminorg");
            Long orgId = adminorg.getLong("id");
            Long boId = adminorg.getLong("boid");
            String orgName = targetObject.getString("name");
            Set<Long> currentDisableOrgIdSet = OrgBatchBillCheckHelper.queryCurrentDisableOrgIdSet(Sets.newHashSet((Object[])new Long[]{boId}));
            if (!(!currentDisableOrgIdSet.contains(boId) && HRStringUtils.equals((String)"1", (String)adminorg.getString("enable")) || HRStringUtils.equals((String)cacheModel.getCheckType(), (String)"orgChangeEnabled"))) {
                result.add(new CalibratorBean("FastOrgChgFeasibleCheckServiceImpl_1", ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u505c\u7528\uff0c\u4e0d\u5141\u8bb8\u201c%2$s\u201d\u3002", (String)"FastOrgChgFeasibleCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, BillEntryHelperEnum.getEntryDescriptionByChangeName(changeType)}));
            }
            if (HRStringUtils.equals((String)EntryEntityEnum.infoEntry.getChangeType(), (String)changeType)) {
                Map<Long, DynamicObject> map = OrgBatchBillCheckHelper.batchQueryOrgDetailInfoById(Sets.newHashSet((Object[])new Long[]{boId}));
            }
            this.checkBillOrgColl(orgId, orgName, cacheModel.getBillOrgList(), changeType, result);
        }
        return result;
    }

    private void checkBillOrgColl(Long currentOrgId, String orgName, List<OrgBatchCheckDto> billOrgList, String changeType, List<CalibratorBean> result) {
        for (OrgBatchCheckDto dto : billOrgList) {
            List<Long> changeTypeList;
            long billOrgId = dto.getOrgId();
            if (billOrgId != currentOrgId) continue;
            String billNo = dto.getBillNo();
            long changeTypeId = dto.getChangeTypeId();
            if (changeTypeId == OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE) {
                result.add(new CalibratorBean("FastOrgChgFeasibleCheckServiceImpl_3", ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u5b58\u5728\u5355\u636e\u201c%2$s\u201d \u7684\u201c%3$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u201c%4$s\u201d\u3002", (String)"FastOrgChgFeasibleCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, billNo, this.changeTypeIdNameMap.get(changeTypeId), BillEntryHelperEnum.getEntryDescriptionByChangeName(changeType)}));
            }
            if (!(changeTypeList = Arrays.asList(OrgBatchChgBillConstants.CHANGE_TYPE_PARENT, OrgBatchChgBillConstants.CHANGE_TYPE_INFO, OrgBatchChgBillConstants.CHANGE_TYPE_MERGE, OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT)).contains(changeTypeId)) continue;
            result.add(new CalibratorBean("FastOrgChgFeasibleCheckServiceImpl_4", ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u5b58\u5728\u5355\u636e\u201c%2$s\u201d\u7684\u201c%3$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5bf9\u7ec4\u7ec7\u8fdb\u884c\u591a\u79cd\u53d8\u52a8\u64cd\u4f5c\u3002", (String)"FastOrgChgFeasibleCheckServiceImpl_4", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, billNo, this.changeTypeIdNameMap.get(changeTypeId)}));
        }
    }
}

