/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.AdminOrgFastChgHelper;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.model.CalibratorBean;

public class FastOrgEffectDateCheckServiceImpl
implements IOrgBatchBillCheckService {
    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        ArrayList result = Lists.newArrayListWithCapacity((int)3);
        String changeType = cacheModel.getChangeType();
        String openApiFlag = null;
        Date effdt = targetObject.getDate("effdt");
        this.checkEstablishmentStructdate(effdt, targetObject, result);
        if (HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.addEntry.getChangeType())) {
            return result;
        }
        if (HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.infoEntry.getChangeType()) || HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.parentEntry.getChangeType())) {
            openApiFlag = targetObject.getString("openapiflag");
        }
        Date effectDateOfParent = targetObject.getDate("parentorg.establishmentdate");
        if (HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.parentEntry.getChangeType()) && !Objects.isNull(effectDateOfParent) && effdt.before(effectDateOfParent)) {
            result.add(new CalibratorBean("FastOrgEffectDateCheckServiceImpl_1", ResManager.loadKDString((String)"\u7ec4\u7ec7\u8c03\u6574\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7684\u6210\u7acb\u65e5\u671f\u201c%s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastOrgEffectDateCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{DateUtils.formatDate((Date)effectDateOfParent, (Object[])new Object[0])}));
        }
        HashMap orgIdBsedMap = Maps.newHashMapWithExpectedSize((int)16);
        Long orgBoId = targetObject.getLong("adminorg.boid");
        orgIdBsedMap.put(orgBoId, targetObject.getDate("adminorg.bsed"));
        Map<Long, Date> orgInfoLatestBsedMap = OrgBatchBillCheckHelper.getOrgInfoLatestBsed(orgIdBsedMap, openApiFlag);
        Date lastEffect = orgInfoLatestBsedMap.get(orgBoId);
        if (!Objects.isNull(lastEffect) && effdt.before(lastEffect)) {
            result.add(new CalibratorBean("FastOrgEffectDateCheckServiceImpl_2", ResManager.loadKDString((String)"\u7ec4\u7ec7\u8c03\u6574\u7684\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u6240\u8c03\u6574\u5185\u5bb9\u5f53\u524d\u7684\u751f\u6548\u65e5\u671f\u201c%s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastOrgEffectDateCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{DateUtils.formatDate((Date)lastEffect, (Object[])new Object[0])}));
        }
        if (!"1".equals(openApiFlag)) {
            DynamicObjectCollection cooprelentryentity = targetObject.getDynamicObjectCollection("cooprelentryentity");
            List<Long> collect = cooprelentryentity.stream().map(coop -> coop.getLong("cooporgteam.id")).collect(Collectors.toList());
            DynamicObject[] coopInfoByIds = AdminOrgFastChgHelper.getCoopInfoByIds(collect);
            List<OrgBatchCheckDto> coopOrgInfo = FastOrgEffectDateCheckServiceImpl.getCoopOrgInfo(cooprelentryentity, coopInfoByIds, effdt);
            for (OrgBatchCheckDto dto : coopOrgInfo) {
                result.add(new CalibratorBean("FastOrgEffectDateCheckServiceImpl_3", ResManager.loadKDString((String)"\u7ec4\u7ec7\u8c03\u6574\u7684\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u534f\u4f5c\u7c7b\u578b\u4e3a\u201c%1$s\u201d\u7684\u534f\u4f5c\u7ec4\u7ec7\u201c%2$s\u201d\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\u201c%3$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastOrgEffectDateCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{dto.getOrgCoopTypeName(), dto.getOrgName(), DateUtils.formatDate((Date)dto.getOrgBsed(), (Object[])new Object[0])}));
            }
        }
        return result;
    }

    public static List<OrgBatchCheckDto> getCoopOrgInfo(DynamicObjectCollection cooprelentryentity, DynamicObject[] dynamicObjects, Date effdt) {
        HashMap itToCooprels = Maps.newHashMapWithExpectedSize((int)cooprelentryentity.size());
        for (DynamicObject dy : dynamicObjects) {
            for (DynamicObject dyc : cooprelentryentity) {
                if (dyc.getLong("cooporgteam.id") != dy.getLong("id")) continue;
                itToCooprels.put(dy.getLong("id"), dyc);
            }
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)10);
        for (DynamicObject dy : dynamicObjects) {
            Date coopBsed = dy.getDate("firstbsed");
            String coopOrgName = dy.getString("name");
            if (coopBsed == null || !effdt.before(coopBsed)) continue;
            OrgBatchCheckDto dto = new OrgBatchCheckDto();
            dto.setOrgBsed(coopBsed);
            dto.setOrgName(coopOrgName);
            dto.setOrgCoopTypeName(((DynamicObject)itToCooprels.get(dy.getLong("id"))).getString("coopreltyp.name"));
            result.add(dto);
        }
        return result;
    }

    private void checkEstablishmentStructdate(Date effdt, DynamicObject chgOrgDy, List<CalibratorBean> result) {
        if (chgOrgDy.containsProperty("struct_project_entry")) {
            DynamicObjectCollection structEntryCollection = chgOrgDy.getDynamicObjectCollection("struct_project_entry");
            if (CollectionUtils.isEmpty((Collection)structEntryCollection)) {
                return;
            }
            for (DynamicObject structEnteryDy : structEntryCollection) {
                DynamicObject structDy;
                Date structEffdt;
                if (structEnteryDy.getDynamicObject("struct_parent_org") == null || !(structEffdt = (structDy = structEnteryDy.getDynamicObject("struct_project")).getDate("effdt")).after(effdt)) continue;
                String localEstablishmentdate = DateUtils.formatDate((Date)structEffdt, (Object[])new Object[0]);
                result.add(new CalibratorBean("FastOrgEffectDateCheckServiceImpl_4", ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e[%1$s]\u7684\u751f\u6548\u65e5\u671f[%2$s]\uff0c\u8bf7\u4fee\u6539", (String)"FastOrgEffectDateCheckServiceImpl_4", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{structDy.getString("name"), localEstablishmentdate}));
            }
        }
    }
}

