/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.service.adminorg.bean.Pair;
import kd.hr.haos.common.constants.masterdata.AdminOrgType;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.orgbatch.OrgLevel4ModelCheckServiceImpl;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckConstants;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.model.CalibratorBean;

public class FastOrgLevel4ModelCheckServiceImpl
implements IOrgBatchBillCheckService {
    private Map<String, String> adminOrgTypeNameMap;

    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        this.adminOrgTypeNameMap = OrgBatchBillCheckHelper.queryAdminOrgTypeNameMap(targetObject.getLong("org.id"));
        ArrayList result = Lists.newArrayListWithCapacity((int)4);
        Map<Long, Long> orgTypeStdIdMap = OrgBatchBillCheckHelper.queryOrgTypeTypeStdIdMap();
        this.aboveLevel4ModelCheck(targetObject, cacheModel.getBillOrgList(), orgTypeStdIdMap, result);
        if (!HRStringUtils.equals((String)cacheModel.getChangeType(), (String)EntryEntityEnum.addEntry.getChangeType())) {
            this.lowerLevel4ModelCheck(targetObject, targetObject.getDate("effdt"), cacheModel.getBillOrgList(), orgTypeStdIdMap, result);
        }
        return result;
    }

    private void aboveLevel4ModelCheck(DynamicObject targetObject, List<OrgBatchCheckDto> billOrgList, Map<Long, Long> orgTypeStdIdMap, List<CalibratorBean> result) {
        DynamicObject orgtype = targetObject.getDynamicObject("adminorgtype");
        long orgtypeStdId = orgtype.getLong("adminorgtypestd.id");
        String orgTypeName = orgtype.getString("name");
        OrgLevel4ModelCheckServiceImpl.OrgAboveLevel4ModelParam adminorgtypeId = this.queryAboveAdminType(targetObject);
        if (adminorgtypeId != null) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgtype");
            QFilter idFilter = new QFilter("id", "=", (Object)adminorgtypeId.getType());
            DynamicObject parentAdminorgtypeDy = serviceHelper.loadDynamicObject(idFilter);
            if (parentAdminorgtypeDy == null) {
                return;
            }
            Long parentOrgtypeStdId = parentAdminorgtypeDy.getLong("adminorgtypestd.id");
            if (AdminOrgType.GROUP.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_ABOVE_GROUP.contains(parentOrgtypeStdId)) {
                result.add(new CalibratorBean("FastOrgLevel4ModelCheckServiceImpl_1", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u5728\u201c%3$s\u201d\u671f\u95f4\u4e0d\u6ee1\u8db3\u89c4\u5219\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastOrgLevel4ModelCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgTypeName, this.adminOrgTypeNameMap.get("level4_above_group"), OrgBatchBillCheckHelper.getTimeSpan(adminorgtypeId.getStartTime(), adminorgtypeId.getEndTime())}));
            } else if (AdminOrgType.COMPANY.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_ABOVE_COMPANY.contains(parentOrgtypeStdId)) {
                result.add(new CalibratorBean("FastOrgLevel4ModelCheckServiceImpl_1", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u5728\u201c%3$s\u201d\u671f\u95f4\u4e0d\u6ee1\u8db3\u89c4\u5219\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastOrgLevel4ModelCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgTypeName, this.adminOrgTypeNameMap.get("level4_above_company"), OrgBatchBillCheckHelper.getTimeSpan(adminorgtypeId.getStartTime(), adminorgtypeId.getEndTime())}));
            }
        }
        Long parentId = targetObject.getLong("parentorg.id");
        billOrgList.forEach(dto -> {
            Long parentStdId;
            if (parentId.equals(dto.getOrgId()) && !Objects.isNull(parentStdId = (Long)orgTypeStdIdMap.get(dto.getOrgTypeId()))) {
                if (AdminOrgType.GROUP.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_ABOVE_GROUP.contains(parentStdId)) {
                    result.add(new CalibratorBean("FastOrgLevel4ModelCheckServiceImpl_2", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u76ee\u524d\u6709\u5728\u9014\u5355\u201c%3$s\u201d\u6570\u636e\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastOrgLevel4ModelCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgTypeName, this.adminOrgTypeNameMap.get("level4_above_group"), dto.getBillNo()}));
                } else if (AdminOrgType.COMPANY.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_ABOVE_COMPANY.contains(parentStdId)) {
                    result.add(new CalibratorBean("FastOrgLevel4ModelCheckServiceImpl_2", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u76ee\u524d\u6709\u5728\u9014\u5355\u201c%3$s\u201d\u6570\u636e\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastOrgLevel4ModelCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgTypeName, this.adminOrgTypeNameMap.get("level4_above_company"), dto.getBillNo()}));
                }
            }
        });
    }

    private OrgLevel4ModelCheckServiceImpl.OrgAboveLevel4ModelParam queryAboveAdminType(DynamicObject targetObject) {
        DynamicObject[] dynamicObjects;
        Date effectDate = targetObject.getDate("effdt");
        long parentOrgBoid = targetObject.getLong("parentorg.boid");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter qFilter = new QFilter("boid", "=", (Object)parentOrgBoid);
        qFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        qFilter.and(new QFilter("datastatus", "in", OrgBatchCheckConstants.DATASTATUS_EFFECT_SET));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("bsled", ">=", (Object)effectDate));
        qFilter.and(new QFilter("bsed", "<=", (Object)effectDate));
        for (DynamicObject dy : dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter})) {
            boolean existsHisInterval = OrgBatchBillCheckHelper.isExistsHisInterval(effectDate, dy);
            if (!existsHisInterval) continue;
            Date returnEffectDate = null;
            returnEffectDate = effectDate.before(dy.getDate("bsed")) ? dy.getDate("bsed") : effectDate;
            return new OrgLevel4ModelCheckServiceImpl.OrgAboveLevel4ModelParam(false, dy.getDynamicObject("adminorgtype").getLong("id"), returnEffectDate, dy.getDate("bsled"));
        }
        return null;
    }

    private void lowerLevel4ModelCheck(DynamicObject targetObject, Date effectDate, List<OrgBatchCheckDto> billOrgList, Map<Long, Long> orgTypeStdIdMap, List<CalibratorBean> result) {
        DynamicObject orgtype = targetObject.getDynamicObject("adminorgtype");
        long orgtypeStdId = orgtype.getLong("adminorgtypestd.id");
        String orgTypeName = orgtype.getString("name");
        Long boId = targetObject.getLong("adminorg.boid");
        Map<Long, Pair<Date, Date>> lowerOrgtypeIds = this.getLowerOrgtypeId(boId, effectDate);
        String orgType = null;
        if (lowerOrgtypeIds != null) {
            if (AdminOrgType.COMPANY.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_LOWER_COMPANY.containsAll(lowerOrgtypeIds.keySet())) {
                orgType = this.adminOrgTypeNameMap.get("level4_lower_company");
            } else if (AdminOrgType.DEPARTMENT.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_LOWER_DEPT.containsAll(lowerOrgtypeIds.keySet())) {
                orgType = this.adminOrgTypeNameMap.get("level4_lower_dept");
            }
            if (HRStringUtils.isNotEmpty(orgType)) {
                Long key = null;
                key = AdminOrgType.COMPANY.getId() == orgtypeStdId ? Long.valueOf(1010L) : Long.valueOf(1020L);
                result.add(new CalibratorBean("FastOrgLevel4ModelCheckServiceImpl_3", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u5728\u201c%3$s\u201d\u671f\u95f4\u4e0d\u6ee1\u8db3\u89c4\u5219\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastOrgLevel4ModelCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgTypeName, orgType, OrgBatchBillCheckHelper.getTimeSpan(lowerOrgtypeIds.get(key) == null ? effectDate : (Date)lowerOrgtypeIds.get(key).getKey(), lowerOrgtypeIds.get(key) == null ? OrgBatchBillCheckHelper.lastDate : (Date)lowerOrgtypeIds.get(key).getValue())}));
            }
        }
        Long orgId = targetObject.getDynamicObject("adminorg").getLong("id");
        billOrgList.forEach(dto -> {
            Long childOrgStdId;
            if (dto.getParentOrgId().equals(orgId) && !Objects.isNull(childOrgStdId = (Long)orgTypeStdIdMap.get(dto.getOrgTypeId()))) {
                if (AdminOrgType.COMPANY.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_LOWER_COMPANY.contains(childOrgStdId)) {
                    result.add(new CalibratorBean("FastOrgLevel4ModelCheckServiceImpl_4", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u76ee\u524d\u6709\u5728\u9014\u5355\u201c%3$s\u201d\u6570\u636e\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastOrgLevel4ModelCheckServiceImpl_4", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgTypeName, this.adminOrgTypeNameMap.get("level4_lower_company"), dto.getBillNo()}));
                } else if (AdminOrgType.DEPARTMENT.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_LOWER_DEPT.contains(childOrgStdId)) {
                    result.add(new CalibratorBean("FastOrgLevel4ModelCheckServiceImpl_4", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u76ee\u524d\u6709\u5728\u9014\u5355\u201c%3$s\u201d\u6570\u636e\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastOrgLevel4ModelCheckServiceImpl_4", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgTypeName, this.adminOrgTypeNameMap.get("level4_lower_dept"), dto.getBillNo()}));
                }
            }
        });
    }

    private Map<Long, Pair<Date, Date>> getLowerOrgtypeId(Long boId, Date effectDate) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter qFilter = new QFilter("parentorg.id", "=", (Object)boId);
        qFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        qFilter.and(new QFilter("datastatus", "in", OrgBatchCheckConstants.DATASTATUS_EFFECT_SET));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("bsled", ">=", (Object)effectDate));
        qFilter.and(new QFilter("bsed", "<=", (Object)effectDate));
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        HashMap<Long, Pair<Date, Date>> orgTypeToTimeSpan = new HashMap<Long, Pair<Date, Date>>();
        try {
            for (DynamicObject dy : dynamicObjects) {
                Date bsled;
                long adminorgtype = dy.getLong("adminorgtype.adminorgtypestd.id");
                Pair<Date, Date> typeTimeSpan = orgTypeToTimeSpan.getOrDefault(adminorgtype, (Pair<Date, Date>)new Pair((Object)HRDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd"), (Object)new Date(0L)));
                Date bsed = dy.getDate("bsed");
                if (bsed.before((Date)typeTimeSpan.getKey())) {
                    typeTimeSpan.setKey((Object)bsed);
                }
                if ((bsled = dy.getDate("bsled")).after((Date)typeTimeSpan.getValue())) {
                    typeTimeSpan.setValue((Object)bsled);
                }
                typeTimeSpan.setKey((Object)effectDate);
                orgTypeToTimeSpan.put(adminorgtype, typeTimeSpan);
            }
            return orgTypeToTimeSpan;
        }
        catch (ParseException e) {
            return null;
        }
    }
}

