/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.login.utils.DateUtils;
import kd.hr.haos.business.util.NameSeparatorTipsUtil;
import kd.hr.haos.business.util.PatternUtil;
import kd.hr.haos.common.constants.MultiLangEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.model.CalibratorBean;

public class FastOrgNameCheckServiceImpl
implements IOrgBatchBillCheckService {
    private PatternUtil patternUtil = new PatternUtil();
    private NameSeparatorTipsUtil nameSeparatorTipsUtil = new NameSeparatorTipsUtil();

    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        ArrayList result = Lists.newArrayListWithCapacity((int)8);
        Long orgId = targetObject.getLong("adminorg.id");
        Long orgBoId = targetObject.getLong("adminorg.boid");
        DynamicObject parentOrg = targetObject.getDynamicObject("parentorg");
        if (parentOrg == null) {
            return result;
        }
        Long parentOrgId = parentOrg.getLong("id");
        Long parentBoId = parentOrg.getLong("boid");
        String parentOrgName = parentOrg.getString("name");
        Date effectDate = targetObject.getDate("effdt");
        List<OrgBatchCheckDto> adminOrgList = OrgBatchBillCheckHelper.queryAdminOrgLocaleNames(Sets.newHashSet((Object[])new Long[]{parentBoId}), effectDate, true);
        Map<String, List<OrgBatchCheckDto>> adminGroupMap = adminOrgList.stream().filter(dto -> !Objects.isNull(dto.getLocaleId())).filter(dto -> !dto.getOrgBoId().equals(orgBoId)).collect(Collectors.groupingBy(OrgBatchCheckDto::getLocaleId));
        List<OrgBatchCheckDto> billOrgList = OrgBatchBillCheckHelper.queryBillOrgLocaleNames(Sets.newHashSet((Object[])new Long[]{parentOrgId}));
        Map<String, List<OrgBatchCheckDto>> billGroupMap = billOrgList.stream().filter(dto -> !Objects.isNull(dto.getLocaleId())).filter(dto -> !dto.getOrgId().equals(orgId)).collect(Collectors.groupingBy(OrgBatchCheckDto::getLocaleId));
        ILocaleString orgNameLocale = targetObject.getLocaleString("name");
        orgNameLocale.forEach((code, nameVal) -> {
            if (HRStringUtils.equals((String)"GLang", (String)code) || HRStringUtils.isEmpty((String)nameVal)) {
                return;
            }
            List adminDtoList = adminGroupMap.getOrDefault(code, new ArrayList(48));
            for (OrgBatchCheckDto dto2 : adminDtoList) {
                if (!HRStringUtils.equals((String)nameVal, (String)dto2.getName())) continue;
                String checkDateStr = DateUtils.formatDate((Date)effectDate, (Object[])new Object[0]);
                result.add(new CalibratorBean("FastOrgNameCheckServiceImpl_1", ResManager.loadKDString((String)"%1$s\u81f3\u4eca\uff0c\u884c\u653f\u7ec4\u7ec7\u201c%2$s\u201d\u4e0b\u5df2\u5b58\u5728%3$s\u540d\u79f0\u4e3a\u201c%4$s\u201d\u7684\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastOrgNameCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{checkDateStr, parentOrgName, MultiLangEnum.getName((String)code), nameVal}));
                break;
            }
            List billDtoList = billGroupMap.getOrDefault(code, new ArrayList(48));
            billDtoList.forEach(dto -> {
                if (!HRStringUtils.isEmpty((String)dto.getBillNo()) && HRStringUtils.equals((String)nameVal, (String)dto.getName())) {
                    result.add(new CalibratorBean("FastOrgNameCheckServiceImpl_2", ResManager.loadKDString((String)"\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%1$s\uff09\u4e2d\u201c%2$s\u201d\u4e0b\u5df2\u5b58\u5728\u201c%3$s\u201d\u540d\u79f0\u201c%4$s\u201d\u7684\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastOrgNameCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{dto.getBillNo(), parentOrgName, MultiLangEnum.getName((String)code), nameVal}));
                }
            });
            if (this.patternUtil.validName4Config(nameVal)) {
                result.add(new CalibratorBean("FastOrgNameCheckServiceImpl_3", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u201c%1$s\u201d\u540d\u79f0\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\uff08%2$s\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastOrgNameCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{MultiLangEnum.getName((String)code), this.nameSeparatorTipsUtil.getAllSeparator()}));
            }
        });
        return result;
    }
}

