/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckConstants;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.model.CalibratorBean;

public class FastOrgNumberCheckServiceImpl
implements IOrgBatchBillCheckService {
    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        ArrayList result = Lists.newArrayListWithCapacity((int)4);
        Long orgId = targetObject.getLong("adminorg.id");
        Long orgBoId = targetObject.getLong("adminorg.boid");
        String number = targetObject.getString("number");
        if (StringUtils.isEmpty((CharSequence)number)) {
            DynamicObject adminorgHrDy = AdminOrgBatchChgHelper.getAdminorgHrDy(targetObject);
            boolean codeRuleExistFlag = CodeRuleServiceHelper.isExist((String)"haos_adminorghr", (DynamicObject)adminorgHrDy, (String)String.valueOf(targetObject.getString("org.id")));
            if (!EntryEntityEnum.addEntry.getChangeType().equals(cacheModel.getChangeType()) || !codeRuleExistFlag) {
                result.add(new CalibratorBean("FastOrgNumberCheckServiceImpl_1", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"FastOrgNumberCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
            }
        }
        if (!StringUtils.isEmpty((CharSequence)number)) {
            Map<String, String> numberBillNoMap;
            boolean isExists;
            Date checkDate = cacheModel.getEffectDate();
            if (HRStringUtils.equals((String)EntryEntityEnum.addEntry.getChangeType(), (String)cacheModel.getChangeType()) || HRStringUtils.equals((String)EntryEntityEnum.parentEntry.getChangeType(), (String)cacheModel.getChangeType()) || HRStringUtils.equals((String)EntryEntityEnum.infoEntry.getChangeType(), (String)cacheModel.getChangeType())) {
                checkDate = targetObject.getDate("effdt");
            }
            if (isExists = this.isExistsAdminNumber(checkDate, number, orgBoId)) {
                String checkDateStr = DateUtils.formatDate((Date)checkDate, (Object[])new Object[0]);
                result.add(new CalibratorBean("FastOrgNumberCheckServiceImpl_2", ResManager.loadKDString((String)"%1$s\u81f3\u4eca\uff0c\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u201c%2$s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastOrgNumberCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{checkDateStr, number}));
            }
            if ((numberBillNoMap = cacheModel.getBillOrgList().stream().filter(dto -> !dto.getOrgId().equals(orgId)).collect(Collectors.toMap(OrgBatchCheckDto::getNumber, OrgBatchCheckDto::getBillNo, (v1, v2) -> v2))).containsKey(number) && !HRStringUtils.isEmpty((String)numberBillNoMap.get(number))) {
                result.add(new CalibratorBean("FastOrgNumberCheckServiceImpl_3", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728\u5728\u9014\u5355\u636e\uff08\u5355\u636e\u7f16\u53f7\uff1a%s\uff09\u4e2d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastOrgNumberCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{numberBillNoMap.get(number)}));
            }
            QFilter bosOrgFilter = new QFilter("isfreeze", "=", (Object)"0");
            if (!OrgBatchBillCheckHelper.isValidateOrgId(orgBoId)) {
                bosOrgFilter.and("org.id", "<>", (Object)orgBoId);
            }
            bosOrgFilter.and("org.number", "=", (Object)number);
            HRBaseServiceHelper bosOrgHelper = new HRBaseServiceHelper("bos_org_structure");
            if (bosOrgHelper.isExists(bosOrgFilter)) {
                result.add(new CalibratorBean("FastOrgNumberCheckServiceImpl_4", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u4e0e\u201c\u57fa\u7840\u670d\u52a1\u4e91>\u4f01\u4e1a\u5efa\u6a21>\u7ec4\u7ec7\u7ba1\u7406>\u884c\u653f\u7ec4\u7ec7/\u4e1a\u52a1\u5355\u5143\u201d\u4e2d\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastOrgNumberCheckServiceImpl_4", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
            }
            if (number.contains("!") || number.contains("\uff01")) {
                result.add(new CalibratorBean("FastOrgNumberCheckServiceImpl_5", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u4e2d\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\u201c!\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastOrgNumberCheckServiceImpl_5", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
            }
        }
        return result;
    }

    private boolean isExistsAdminNumber(Date checkDate, String number, Long orgBoId) {
        QFilter adminFilter = new QFilter("number", "=", (Object)number);
        if (!OrgBatchBillCheckHelper.isValidateOrgId(orgBoId)) {
            adminFilter.and(new QFilter("boid", "<>", (Object)orgBoId));
        }
        adminFilter.and(new QFilter("datastatus", "in", OrgBatchCheckConstants.DATASTATUS_EFFECT_SET));
        adminFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        adminFilter.and(new QFilter("bsled", ">=", (Object)checkDate));
        HRBaseServiceHelper adminHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        return adminHelper.isExists(new QFilter[]{adminFilter});
    }
}

