/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.haos.business.service.adminorg.bean.Pair;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.AdminOrgFastChgHelper;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.helper.SystemParamHelper;
import kd.hr.homs.business.service.orgfast.FastCoopOrgInfoCheckServiceImpl;
import kd.hr.homs.business.service.validcommon.CycleOrgBean;
import kd.hr.homs.business.service.validcommon.IOrgBatchBillCheckService;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.CalibratorBean;

public class FastParentOrgCheckServiceImpl
implements IOrgBatchBillCheckService {
    private static final Log LOG = LogFactory.getLog(FastParentOrgCheckServiceImpl.class);

    @Override
    public List<CalibratorBean> check(DynamicObject targetObject, OrgBatchCheckCacheModel cacheModel) {
        ArrayList result = Lists.newArrayListWithCapacity((int)3);
        String changeType = cacheModel.getChangeType();
        if (HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.addEntry.getChangeType()) || HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.parentEntry.getChangeType())) {
            DynamicObject parentOrg = targetObject.getDynamicObject("parentorg");
            if (parentOrg == null) {
                LOG.info("can't find parent org");
                return result;
            }
            Long parentBoId = parentOrg.getLong("boid");
            Set<Long> boIdSet = OrgBatchBillCheckHelper.queryCurrentDisableOrgIdSet(Sets.newHashSet((Object[])new Long[]{parentBoId}));
            DynamicObject currentParentOrg = AdminOrgFastChgHelper.getOrgDyById(parentBoId);
            if (!"1".equals(parentOrg.get("enable")) || boIdSet.contains(parentBoId)) {
                result.add(new CalibratorBean("ParentOrgCheckServiceImpl_1", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5df2\u505c\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ParentOrgCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
            }
            if (currentParentOrg != null && currentParentOrg.getBoolean("tobedisableflag") && !SystemParamHelper.getAllowTobeDisableChg(targetObject.getLong("org.id"))) {
                if (HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.addEntry.getChangeType())) {
                    result.add(new CalibratorBean("ParentOrgCheckServiceImpl_6", ResManager.loadKDString((String)"\u201c%s\u201d \u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5728\u8be5\u7ec4\u7ec7\u4e0b\u65b0\u589e\u7ec4\u7ec7\u3002", (String)"ParentOrgCheckServiceImpl_6", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{currentParentOrg.getString("name")}));
                } else {
                    result.add(new CalibratorBean("ParentOrgCheckServiceImpl_5", ResManager.loadKDString((String)"\u201c%s\u201d \u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u8c03\u6574\u5230\u8be5\u7ec4\u7ec7\u4e0b\u3002", (String)"ParentOrgCheckServiceImpl_5", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{currentParentOrg.getString("name")}));
                }
            }
            Map<Long, String> orgIdBillNoMap = cacheModel.getBillOrgList().stream().filter(dto -> OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE.equals(dto.getChangeTypeId())).collect(Collectors.toMap(OrgBatchCheckDto::getOrgId, OrgBatchCheckDto::getBillNo, (v1, v2) -> v2));
            Map<Long, String> orgBoidBillNoMap = cacheModel.getBillOrgList().stream().filter(dto -> OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE.equals(dto.getChangeTypeId())).collect(Collectors.toMap(OrgBatchCheckDto::getAdminOrgBoid, OrgBatchCheckDto::getBillNo, (v1, v2) -> v2));
            Map<Long, Pair<String, String>> billTobeDisableOrgIdSet = cacheModel.getBillOrgList().stream().filter(dto -> !OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE.equals(dto.getChangeTypeId())).filter(dto -> dto.isTobeDisableFlag()).collect(Collectors.toMap(dto -> dto.getOrgId(), dto -> new Pair((Object)dto.getBillNo(), (Object)dto.getName()), (v1, v2) -> v2));
            Map<Long, Pair<String, String>> billTobeDisableOrgBoIdSet = cacheModel.getBillOrgList().stream().filter(dto -> !OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE.equals(dto.getChangeTypeId())).filter(dto -> dto.isTobeDisableFlag()).collect(Collectors.toMap(dto -> dto.getAdminOrgBoid(), dto -> new Pair((Object)dto.getBillNo(), (Object)dto.getName()), (v1, v2) -> v2));
            this.orgAddCheck(changeType, parentOrg.getLong("id"), orgIdBillNoMap, result, billTobeDisableOrgIdSet, !SystemParamHelper.getAllowTobeDisableChg(targetObject.getLong("org.id")));
            this.parentChgCheck(changeType, targetObject, orgBoidBillNoMap, result, billTobeDisableOrgBoIdSet, !SystemParamHelper.getAllowTobeDisableChg(targetObject.getLong("org.id")));
            ArrayList adminAffiliationList = Lists.newArrayListWithExpectedSize((int)10);
            ArrayList adminCoopList = Lists.newArrayListWithExpectedSize((int)10);
            List<CycleOrgBean> adminCycleOrgList = FastCoopOrgInfoCheckServiceImpl.queryAdminCoopOrgColl(targetObject.getDate("effdt"));
            adminCycleOrgList.forEach(coop -> {
                if (1010L == coop.getCoopTypeId()) {
                    adminAffiliationList.add(coop);
                } else {
                    adminCoopList.add(coop);
                }
            });
            ArrayList billAffiliationList = Lists.newArrayListWithExpectedSize((int)10);
            List<OrgBatchCheckDto> orgBatchCheckDtos = OrgBatchBillCheckHelper.queryBillOrgList();
            orgBatchCheckDtos.forEach(dto -> billAffiliationList.add(new CycleOrgBean(dto.getOrgId(), dto.getBillNo(), dto.getParentOrgId())));
            FastCoopOrgInfoCheckServiceImpl.affiliationCheck(targetObject, adminAffiliationList, billAffiliationList, result);
        }
        return result;
    }

    private void orgAddCheck(String changeType, Long parentOrgId, Map<Long, String> orgIdBillNoMap, List<CalibratorBean> result, Map<Long, Pair<String, String>> billTobeDisableOrgIdSet, boolean needCheck) {
        if (HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.addEntry.getChangeType()) && orgIdBillNoMap.containsKey(parentOrgId)) {
            result.add(new CalibratorBean("FastParentOrgCheckServiceImpl_1", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5728\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%s\uff09\u4e2d\u505a\u4e86\u201c\u505c\u7528\u201d\u64cd\u4f5c\uff0c\u4e0d\u80fd\u5728\u8be5\u7ec4\u7ec7\u4e0b\u65b0\u589e\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastParentOrgCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgIdBillNoMap.get(parentOrgId)}));
        }
        if (HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.addEntry.getChangeType()) && billTobeDisableOrgIdSet.containsKey(parentOrgId) && needCheck) {
            result.add(new CalibratorBean("FastParentOrgCheckServiceImpl_4", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5728\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%s\uff09\u4e2d\u505a\u4e86\u201c\u5f85\u505c\u7528\u201d\u64cd\u4f5c\uff0c\u4e0d\u80fd\u5728\u8be5\u7ec4\u7ec7\u4e0b\u65b0\u589e\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastParentOrgCheckServiceImpl_4", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{billTobeDisableOrgIdSet.get(parentOrgId).getKey()}));
        }
    }

    private void parentChgCheck(String changeType, DynamicObject targetObject, Map<Long, String> orgIdBillNoMap, List<CalibratorBean> result, Map<Long, Pair<String, String>> billTobeDisableOrgBoIdSet, boolean needCheck) {
        if (HRStringUtils.equals((String)changeType, (String)EntryEntityEnum.parentEntry.getChangeType())) {
            DynamicObject adminorg = targetObject.getDynamicObject("adminorg");
            long oriParentorgId = adminorg.getLong("parentorg.id");
            long parentBoId = targetObject.getLong("parentorg.boid");
            if (orgIdBillNoMap.containsKey(parentBoId)) {
                result.add(new CalibratorBean("FastParentOrgCheckServiceImpl_2", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5728\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%s\uff09\u4e2d\u505a\u4e86\u201c\u505c\u7528\u201d\u64cd\u4f5c\uff0c\u4e0d\u80fd\u8c03\u6574\u5230\u8be5\u7ec4\u7ec7\u4e0b\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastParentOrgCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgIdBillNoMap.get(parentBoId)}));
            }
            if (oriParentorgId == parentBoId) {
                result.add(new CalibratorBean("FastParentOrgCheckServiceImpl_3", ResManager.loadKDString((String)"\u8c03\u6574\u540e\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u672a\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastParentOrgCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
            }
            if (billTobeDisableOrgBoIdSet.containsKey(parentBoId) && needCheck) {
                result.add(new CalibratorBean("FastParentOrgCheckServiceImpl_5", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5728\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%s\uff09\u4e2d\u505a\u4e86\u201c\u5f85\u505c\u7528\u201d\u64cd\u4f5c\uff0c\u4e0d\u80fd\u8c03\u6574\u5230\u8be5\u7ec4\u7ec7\u4e0b\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastParentOrgCheckServiceImpl_5", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{billTobeDisableOrgBoIdSet.get(parentBoId).getKey()}));
            }
        }
    }
}

