/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.util.NameSeparatorTipsUtil;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.haos.business.util.PatternUtil;
import kd.hr.haos.common.constants.MultiLangEnum;
import kd.hr.haos.common.constants.masterdata.AdminOrgType;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.domain.repository.OrgOperateTaskRepository;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.helper.SystemParamHelper;
import kd.hr.homs.business.service.orgfast.FastCoopOrgInfoCheckServiceImpl;
import kd.hr.homs.business.service.validcommon.CycleOrgBean;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckConstants;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.CalibratorBean;

public class FastchgImportValidateHelper {
    private static final Log LOG = LogFactory.getLog(FastchgImportValidateHelper.class);
    private static Map<Long, String> changeTypeMap;
    private List<OrgBatchCheckDto> checkDtoList;
    private Map<Integer, List<String>> errorMap = new HashMap<Integer, List<String>>();
    private Map<Long, DynamicObject> changesceneMap;
    private Map<Long, DynamicObject> adminorgTypeMap;
    private Map<Long, Long> orgTypeStdIdMap;
    private Map<Long, Long> lawentityMap;
    private List<Long> buids;
    private List<Long> permOrgs;
    private Map<Date, List<ExtendedDataEntity>> bsedMap;
    private ExtendedDataEntity[] dataEntities;
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private static String[] iLocaleStrings;
    private static String[] basedatas;
    private PatternUtil patternUtil = new PatternUtil();
    private NameSeparatorTipsUtil nameSeparatorTipsUtil = new NameSeparatorTipsUtil();

    public FastchgImportValidateHelper(ExtendedDataEntity[] dataEntities) {
        DynamicObject[] changeTypes = this.getBaseData("haos_orgchangetype");
        changeTypeMap = Arrays.stream(changeTypes).collect(Collectors.toMap(dy -> dy.getLong("id"), changeType -> changeType.getString("name")));
        this.checkDtoList = OrgBatchBillCheckHelper.queryBillOrgList();
        DynamicObject[] changescenes = this.getBaseData("haos_changescene");
        this.changesceneMap = Arrays.stream(changescenes).collect(Collectors.toMap(scene -> scene.getLong("id"), Function.identity()));
        DynamicObject[] adminorgtypes = this.getBaseData("haos_adminorgtype");
        this.adminorgTypeMap = Arrays.stream(adminorgtypes).collect(Collectors.toMap(adminorgtype -> adminorgtype.getLong("id"), Function.identity()));
        this.orgTypeStdIdMap = Arrays.stream(adminorgtypes).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("adminorgtypestd.id")));
        DynamicObject[] lawentitys = this.getBaseData("hbss_lawentity");
        this.lawentityMap = Arrays.stream(lawentitys).filter(lawentity -> "1".equals(lawentity.getString("oprsts"))).collect(Collectors.toMap(lawentity -> lawentity.getLong("id"), lawentity -> lawentity.getLong("useorg.id")));
        this.buids = this.getDefaultOrg();
        this.permOrgs = this.getPermOrgs();
        this.dataEntities = dataEntities;
        this.bsedMap = Arrays.stream(dataEntities).filter(ex -> ex.getDataEntity().getDate("bsed") != null).collect(Collectors.groupingBy(extendedDataEntity -> extendedDataEntity.getDataEntity().getDate("bsed")));
    }

    private DynamicObject[] getBaseData(String entityName) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        return helper.loadDynamicObjectArray(new QFilter("enable", "=", (Object)"1").toArray());
    }

    public void checkOrgNameEffectiveness(String operateKey) {
        this.bsedMap.forEach((bsed, list) -> {
            List<Long> parentBoids = list.stream().map(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("parentorg.boid")).distinct().collect(Collectors.toList());
            Map<Long, List<OrgBatchCheckDto>> localeNames = this.queryAdminOrgLocaleNames(parentBoids, (Date)bsed);
            if (localeNames.isEmpty()) {
                return;
            }
            list.forEach(extendedDataEntity -> {
                int rowIndex = extendedDataEntity.getDataEntityIndex();
                DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                long boid = dataEntity.getLong("boid");
                DynamicObject parentorg = dataEntity.getDynamicObject("parentorg");
                if (parentorg == null) {
                    return;
                }
                long parentboid = dataEntity.getLong("parentorg.boid");
                String parentorgName = dataEntity.getLocaleString("parentorg.name").getLocaleValue();
                if (StringUtils.isEmpty((CharSequence)parentorgName)) {
                    parentorgName = "";
                }
                if (!localeNames.containsKey(parentboid)) {
                    return;
                }
                Map<String, List<OrgBatchCheckDto>> collect = ((List)localeNames.get(parentboid)).stream().filter(dy -> dy.getOrgBoId() != boid).collect(Collectors.groupingBy(dto -> dto.getLocaleId()));
                ILocaleString name = dataEntity.getLocaleString("name");
                this.validateLocaleName(rowIndex, name, collect, parentorgName, (Date)bsed);
                Integer maxIndex = Arrays.stream(this.dataEntities).map(dy -> dy.getDataEntity()).filter(dy -> dy.getLong("parentorg.boid") == parentboid).map(dy -> dy.getInt("index")).max(Integer::compare).get();
                this.setIndex(dataEntity, localeNames, parentboid, operateKey, maxIndex);
            });
        });
        HashMap<String, List<ExtendedDataEntity>> nameCNMap = new HashMap<String, List<ExtendedDataEntity>>();
        HashMap<String, List<ExtendedDataEntity>> nameUsMap = new HashMap<String, List<ExtendedDataEntity>>();
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            ILocaleString name = dataEntity.getLocaleString("name");
            if (!StringUtils.isEmpty((CharSequence)name.getLocaleValue_zh_CN())) {
                List nameCNList = nameCNMap.getOrDefault(name.getLocaleValue_zh_CN(), new ArrayList());
                nameCNList.add(extendedDataEntity);
                nameCNMap.put(name.getLocaleValue_zh_CN(), nameCNList);
            }
            if (StringUtils.isEmpty((CharSequence)name.getLocaleValue_en())) continue;
            List nameUSList = nameUsMap.getOrDefault(name.getLocaleValue_en(), new ArrayList());
            nameUSList.add(extendedDataEntity);
            nameUsMap.put(name.getLocaleValue_en(), nameUSList);
        }
        this.validateNameInThisImport(nameCNMap, "zh_CN");
        this.validateNameInThisImport(nameUsMap, "en_US");
        this.validateNameOnTheWay(this.dataEntities);
        this.validateNameSpecialChar(this.dataEntities);
    }

    private void setIndex(DynamicObject dataEntity, Map<Long, List<OrgBatchCheckDto>> localeNames, Long parentboid, String operateKey, Integer maxIndex) {
        if (dataEntity.getInt("index") != 0) {
            return;
        }
        if (operateKey.equals("confirmchangenoaudit")) {
            return;
        }
        List orgBatchCheckDtos = localeNames.getOrDefault(parentboid, new ArrayList());
        if (orgBatchCheckDtos.isEmpty()) {
            dataEntity.set("index", (Object)1);
            return;
        }
        int childMaxIndex = orgBatchCheckDtos.stream().map(dto -> dto.getIndex()).max(Integer::compare).get();
        if (childMaxIndex >= 99999 || maxIndex >= 99999) {
            dataEntity.set("index", (Object)99999);
            return;
        }
        if (maxIndex > childMaxIndex) {
            dataEntity.set("index", (Object)(maxIndex + 1));
            return;
        }
        dataEntity.set("index", (Object)(childMaxIndex + 1));
    }

    private void validateNameSpecialChar(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity exdataEntity : dataEntities) {
            ILocaleString name = exdataEntity.getDataEntity().getLocaleString("name");
            name.forEach((localeId, localeValue) -> {
                if ("GLang".equals(localeId)) {
                    return;
                }
                if (this.patternUtil.validName4Config(localeValue)) {
                    this.recordErrorMsgInMap(exdataEntity.getDataEntityIndex(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7[%1$s]\u540d\u79f0\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\uff08%2$s\uff09\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_3", (String)"odc-homs-business", (Object[])new Object[0]), localeValue, this.nameSeparatorTipsUtil.getAllSeparator()));
                }
            });
        }
    }

    private void validateNameOnTheWay(ExtendedDataEntity[] dataEntities) {
        Set<Long> parentOrgIds = Arrays.stream(dataEntities).map(dy -> dy.getDataEntity().getLong("parentorg.sourcevid")).collect(Collectors.toSet());
        List<OrgBatchCheckDto> orgBatchCheckDtos = OrgBatchBillCheckHelper.queryBillOrgLocaleNames(parentOrgIds);
        Map<Long, List<OrgBatchCheckDto>> parentMap = orgBatchCheckDtos.stream().collect(Collectors.groupingBy(dto -> dto.getParentOrgId()));
        for (ExtendedDataEntity exdataEntity : dataEntities) {
            DynamicObject dataEntity = exdataEntity.getDataEntity();
            String number = dataEntity.getString("number");
            long parentorgBoid = dataEntity.getLong("parentorg.sourcevid");
            if (!parentMap.containsKey(parentorgBoid)) continue;
            List<OrgBatchCheckDto> list = parentMap.get(parentorgBoid);
            ILocaleString name = dataEntity.getLocaleString("name");
            name.forEach((localeid, localValue) -> {
                if ("GLang".equals(localeid)) {
                    return;
                }
                list.forEach(dto -> {
                    String orgNumber = dto.getNumber();
                    if (!orgNumber.equals(number) && localeid.equals(dto.getLocaleId()) && localValue.equals(dto.getName())) {
                        this.recordErrorMsgInMap(exdataEntity.getDataEntityIndex(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5728\u9014\u5355\u636e[%1$s]\u4e2d %2$s \u4e0b\u5df2\u5b58\u5728 %3$s \u540d\u79f0[%4$s]\u7684\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_2", (String)"odc-homs-business", (Object[])new Object[0]), dto.getBillNo(), dataEntity.getString("parentorg.name"), MultiLangEnum.getName((String)localeid), localValue));
                    }
                });
            });
        }
    }

    private void recordErrorMsgInMap(int rowIndex, String errorMsg) {
        List errorList = this.errorMap.getOrDefault(rowIndex, new ArrayList());
        errorList.add(errorMsg);
        this.errorMap.put(rowIndex, errorList);
    }

    private void validateNameInThisImport(Map<String, List<ExtendedDataEntity>> nameMap, String localid) {
        nameMap.forEach((name, extendedDataEntites) -> {
            if (extendedDataEntites.size() >= 2) {
                Map<Long, List<ExtendedDataEntity>> parentorgMap = extendedDataEntites.stream().collect(Collectors.groupingBy(dy -> dy.getDataEntity().getLong("parentorg.boid")));
                parentorgMap.forEach((parentorgboid, list) -> {
                    if (list.size() >= 2) {
                        for (ExtendedDataEntity extendedDataEntity : list) {
                            String parentName = extendedDataEntity.getDataEntity().getString("parentorg.name");
                            int rowIndex = extendedDataEntity.getDataEntityIndex();
                            this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u4e2d\uff0c\u4e0a\u7ea7\u4e3a%1$s\u4e0b\u7684%3$s\u540d\u79f0%2$s\u91cd\u590d\u3002", (String)"FastchgImportValidateHelper_1", (String)"odc-homs-business", (Object[])new Object[0]), parentName, MultiLangEnum.getName((String)localid), name));
                        }
                    }
                });
            }
        });
    }

    private void validateLocaleName(int rowIndex, ILocaleString name, Map<String, List<OrgBatchCheckDto>> collect, String parentorgName, Date bsed) {
        if (collect.isEmpty()) {
            return;
        }
        name.forEach((localeid, localeValue) -> {
            if (HRStringUtils.equals((String)"GLang", (String)localeid) || HRStringUtils.isEmpty((String)localeValue)) {
                return;
            }
            List orgBatchCheckDtos = ((List)collect.getOrDefault(localeid, new ArrayList())).stream().filter(dto -> localeValue.equals(dto.getName())).sorted(Comparator.comparing(OrgBatchCheckDto::getOrgBsled)).collect(Collectors.toList());
            if (orgBatchCheckDtos == null || orgBatchCheckDtos.isEmpty()) {
                return;
            }
            Date bsled = ((OrgBatchCheckDto)orgBatchCheckDtos.get(orgBatchCheckDtos.size() - 1)).getOrgBsled();
            Date orgBsed = ((OrgBatchCheckDto)orgBatchCheckDtos.get(0)).getOrgBsed();
            Date earlistBsed = orgBsed.after(bsed) ? orgBsed : bsed;
            List errorList = this.errorMap.getOrDefault(rowIndex, new ArrayList());
            errorList.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5728[%1$s\u81f3%2$s]\u671f\u95f4\uff0c%3$s \u4e0b\u5df2\u5b58\u5728 [%4$s]\u540d\u79f0[%5$s]\u7684\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_0", (String)"odc-homs-business", (Object[])new Object[0]), HRDateTimeUtils.format((Date)earlistBsed, (String)YYYY_MM_DD), HRDateTimeUtils.format((Date)bsled, (String)YYYY_MM_DD), parentorgName, MultiLangEnum.getName((String)localeid), localeValue));
            this.errorMap.put(rowIndex, errorList);
        });
    }

    private Map<Long, List<OrgBatchCheckDto>> queryAdminOrgLocaleNames(List<Long> parentBoids, Date bsed) {
        HashMap<Long, List<OrgBatchCheckDto>> result = new HashMap<Long, List<OrgBatchCheckDto>>();
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fboid,a.fparentid,b.flocaleid,b.fname, a.fbsed, a.fbsled , a.findex ").append("from t_haos_adminorg a ").append("left join t_haos_adminorg_l b on b.fid = a.fid ").append("where a.fparentid in (");
        parentBoids.forEach(id -> sql.append("?").append(','));
        sql.deleteCharAt(sql.length() - 1);
        sql.append(')');
        sql.append(" and a.fdatastatus in ('1','2') ").append(" and a.fenable = '1' ").append(" and a.finitstatus = '2' ").append(" and a.fbsled >= ?");
        ArrayList params = Lists.newArrayListWithExpectedSize((int)(parentBoids.size() + 1));
        params.addAll(parentBoids);
        params.add(bsed);
        try (DataSet ds = HRDBUtil.queryDataSet((String)"queryAdminOrgLocaleNames", (DBRoute)new DBRoute("haos"), (String)sql.toString(), (Object[])params.toArray());){
            for (Row data : ds) {
                String flocaleid = data.getString("flocaleid");
                if (StringUtils.isEmpty((CharSequence)flocaleid)) continue;
                List list = result.getOrDefault(data.getLong("fparentid"), new ArrayList());
                OrgBatchCheckDto rowdata = new OrgBatchCheckDto();
                rowdata.setOrgBoId(data.getLong("fboid"));
                rowdata.setParentOrgBoId(data.getLong("fparentid"));
                rowdata.setLocaleId(data.getString("flocaleid"));
                rowdata.setName(data.getString("fname"));
                rowdata.setOrgBsed(data.getDate("fbsed"));
                rowdata.setOrgBsled(data.getDate("fbsled"));
                rowdata.setIndex(data.getInteger("findex"));
                list.add(rowdata);
                result.put(data.getLong("fparentid"), list);
            }
        }
        return result;
    }

    public Map<Integer, List<String>> checkOrgNumberEffectiveness(ExtendedDataEntity[] dataEntities, DynamicObject[] dysInDB, String operateKey) {
        Map<String, DynamicObject> existDys = Arrays.stream(dysInDB).filter(dy -> "1".equals(dy.getString("enable"))).collect(Collectors.toMap(dy -> dy.getString("number"), Function.identity(), (oldValue, newValue) -> newValue));
        DynamicObject[] companyareas = this.getCompanyareasAndCityAndworkPlace(dataEntities, "bd_country", "companyarea.id", "id");
        DynamicObject[] citys = this.getCompanyareasAndCityAndworkPlace(dataEntities, "bd_admindivision", "city.id", "id, country.id");
        DynamicObject[] workplaces = this.getCompanyareasAndCityAndworkPlace(dataEntities, "hbss_workplace", "workplace.id", "id");
        Map<Long, DynamicObject> companyareaIds = Arrays.stream(companyareas).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity(), (oldV, newV) -> newV));
        Map<Long, Long> cityMap = Arrays.stream(citys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("country.id")));
        List<Long> workplaceIds = Arrays.stream(workplaces).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        Map orgOntheways = this.checkDtoList.stream().filter(dto -> dto.getChangeTypeId() != 1010L).collect(Collectors.toMap(dto -> dto.getOrgBoId(), Function.identity(), (oldValue, newValue) -> newValue));
        DynamicObject[] operateTaskIngArr = OrgOperateTaskRepository.getInstance().getAllOrgTaskByIng();
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String number = dataEntity.getString("number");
            long boid = dataEntity.getLong("boid");
            int rowIndex = extendedDataEntity.getDataEntityIndex();
            List errorList = this.errorMap.getOrDefault(rowIndex, new ArrayList());
            DynamicObject originalOrg = (DynamicObject)existDys.get(number);
            if (!existDys.containsKey(number)) {
                errorList.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u5df2\u505c\u7528\u6216\u4e0d\u5b58\u5728, \u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_40", (String)"odc-homs-business", (Object[])new Object[0]));
            } else {
                dataEntity.set("adminorg", (Object)originalOrg);
                if (!this.permOrgs.contains(boid) || this.permOrgs.contains(boid) && !this.buids.contains(originalOrg.getLong("org.id"))) {
                    errorList.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_41", (String)"odc-homs-business", (Object[])new Object[0]));
                }
            }
            if (number.contains("!") || number.contains("\uff01")) {
                errorList.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u4e2d\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\u201c!\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastchgImportValidateHelper_63", (String)"odc-homs-business", (Object[])new Object[0]));
            }
            if (orgOntheways.containsKey(boid)) {
                OrgBatchCheckDto dto2 = (OrgBatchCheckDto)orgOntheways.get(boid);
                String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u5728\u5355\u636e[%1$s]\u7684 %2$s \u4e2d\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5bf9\u7ec4\u7ec7\u8fdb\u884c\u591a\u79cd\u53d8\u52a8\u64cd\u4f5c;", (String)"FastchgImportValidateHelper_42", (String)"odc-homs-business", (Object[])new Object[0]), dto2.getBillNo(), changeTypeMap.get(dto2.getChangeTypeId()));
                errorList.add(errorMsg);
            }
            this.errorMap.put(rowIndex, errorList);
            this.checkMustInput(rowIndex, dataEntity, operateKey);
            this.checkNUll(rowIndex, dataEntity, operateKey);
            this.checkOperateTaskIng(dataEntity, rowIndex, operateTaskIngArr);
            this.checkBasedataInBU(dataEntity, rowIndex, operateKey);
            this.checkTextOverLength(dataEntity, rowIndex);
            this.checkEstablishmentdate(dataEntity, rowIndex, existDys);
            this.checkBU(dataEntity, rowIndex);
            this.checkAdminorgtype(dataEntity, rowIndex);
            this.checkCompanyarea(dataEntity, rowIndex, companyareaIds, cityMap, workplaceIds);
        }
        return this.errorMap;
    }

    private void checkNUll(int rowIndex, DynamicObject dataEntity, String operateKey) {
        if ("save".equals(operateKey)) {
            return;
        }
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        StringBuilder errroStr = new StringBuilder();
        DynamicObject parentorg = dataEntity.getDynamicObject("parentorg");
        if (parentorg == null) {
            errroStr.append(((IDataEntityProperty)properties.get((Object)"parentorg")).getDisplayName().getLocaleValue()).append("\u3001");
        }
        if (dataEntity.getDynamicObject("adminorgtype") == null) {
            errroStr.append(((IDataEntityProperty)properties.get((Object)"adminorgtype")).getDisplayName().getLocaleValue()).append("\u3001");
        }
        if (dataEntity.getDynamicObject("org") == null) {
            errroStr.append(((IDataEntityProperty)properties.get((Object)"org")).getDisplayName().getLocaleValue()).append("\u3001");
        }
        if (dataEntity.getDate("establishmentdate") == null) {
            errroStr.append(((IDataEntityProperty)properties.get((Object)"establishmentdate")).getDisplayName().getLocaleValue()).append("\u3001");
        }
        if (StringUtils.isEmpty((CharSequence)dataEntity.getLocaleString("name").getLocaleValue())) {
            errroStr.append(((IDataEntityProperty)properties.get((Object)"name")).getDisplayName().getLocaleValue()).append("\u3001");
        }
        if (errroStr.length() == 0) {
            return;
        }
        StringBuilder replaceError = errroStr.deleteCharAt(errroStr.length() - 1);
        this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"FastchgImportValidateHelper_52", (String)"odc-homs-business", (Object[])new Object[0]), replaceError));
    }

    public DynamicObject[] getCompanyareasAndCityAndworkPlace(ExtendedDataEntity[] dataEntities, String entityName, String field, String selectFields) {
        List fieldIds = Arrays.stream(dataEntities).map(dy -> dy.getDataEntity().getLong(field)).collect(Collectors.toList());
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and(new QFilter("id", "in", fieldIds));
        DynamicObject[] companyareas = helper.queryOriginalArray(selectFields, filter.toArray());
        return companyareas;
    }

    public void checkCompanyarea(DynamicObject dataEntity, int rowIndex, Map<Long, DynamicObject> companyareas, Map<Long, Long> citys, List<Long> workplaces) {
        long countryId;
        long companyarea = dataEntity.getLong("companyarea.id");
        long city = dataEntity.getLong("city.id");
        long workplace = dataEntity.getLong("workplace.id");
        if (companyarea != 0L && !companyareas.containsKey(companyarea)) {
            this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"%s \u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528,\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_36", (String)"odc-homs-business", (Object[])new Object[0]), dataEntity.getLocaleString("companyarea.name").getLocaleValue()));
        }
        if (city != 0L && !citys.containsKey(city)) {
            this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"%s \u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528,\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_36", (String)"odc-homs-business", (Object[])new Object[0]), dataEntity.getLocaleString("city.name").getLocaleValue()));
        } else if (citys.containsKey(city)) {
            countryId = citys.get(city);
            if (companyarea != 0L && companyarea != countryId) {
                this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6240\u5728\u57ce\u5e02[%1$s]\u4e0d\u5c5e\u4e8e\u56fd\u5bb6\u5730\u533a[%2$s]\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_37", (String)"odc-homs-business", (Object[])new Object[0]), dataEntity.getLocaleString("city.name").getLocaleValue(), dataEntity.getLocaleString("companyarea.name").getLocaleValue()));
                dataEntity.set("city", null);
            }
        }
        if (companyarea == 0L && city != 0L) {
            countryId = citys.get(city);
            DynamicObject companyareaDy = BusinessDataServiceHelper.newDynamicObject((String)"bd_country");
            companyareaDy.set("id", (Object)countryId);
            dataEntity.set("companyarea", (Object)companyareaDy);
        }
        if (workplace != 0L && !workplaces.contains(workplace)) {
            this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"%s \u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528,\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_36", (String)"odc-homs-business", (Object[])new Object[0]), dataEntity.getLocaleString("workplace.name").getLocaleValue()));
        }
    }

    public void checkAdminorgtype(DynamicObject dataEntity, int rowIndex) {
        DynamicObject adminorgtype = dataEntity.getDynamicObject("adminorgtype");
        if (adminorgtype == null) {
            return;
        }
        long adminorgtypeId = adminorgtype.getLong("id");
        String adminorgtypeName = adminorgtype.getLocaleString("name").getLocaleValue();
        if (this.adminorgTypeMap.containsKey(adminorgtypeId)) {
            Long orgtypeStdId = adminorgtype.getLong("adminorgtypestd.id");
            DynamicObject departmenttype = dataEntity.getDynamicObject("departmenttype");
            Collection groupvision = dataEntity.getLocaleString("groupvision").values();
            List groupvisionNames = groupvision.stream().filter(vision -> !StringUtils.isEmpty((CharSequence)vision)).collect(Collectors.toList());
            Collection groupmission = dataEntity.getLocaleString("groupmission").values();
            List groupmissionNames = groupmission.stream().filter(mission -> !StringUtils.isEmpty((CharSequence)mission)).collect(Collectors.toList());
            DynamicObject companytype = dataEntity.getDynamicObject("companytype");
            DynamicObject industrytype = dataEntity.getDynamicObject("industrytype");
            if (AdminOrgType.GROUP.getId() == orgtypeStdId.longValue() && departmenttype != null) {
                this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"[%s]\u4e0d\u80fd\u586b\u5199\u90e8\u95e8\u4fe1\u606f\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_34", (String)"odc-homs-business", (Object[])new Object[0]), adminorgtypeName));
            } else if (!(AdminOrgType.COMPANY.getId() != orgtypeStdId.longValue() || departmenttype == null && groupmissionNames.isEmpty() && groupvisionNames.isEmpty())) {
                this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"[%s]\u4e0d\u80fd\u586b\u5199\u96c6\u56e2\u3001\u90e8\u95e8\u4fe1\u606f\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_35", (String)"odc-homs-business", (Object[])new Object[0]), adminorgtypeName));
            } else if (!(AdminOrgType.DEPARTMENT.getId() != orgtypeStdId.longValue() || companytype == null && industrytype == null && groupmissionNames.isEmpty() && groupvisionNames.isEmpty())) {
                this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"[%s]\u4e0d\u80fd\u586b\u5199\u96c6\u56e2\u3001\u516c\u53f8\u4fe1\u606f\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_60", (String)"odc-homs-business", (Object[])new Object[0]), adminorgtypeName));
            } else if (!(AdminOrgType.REGION.getId() != orgtypeStdId.longValue() || companytype == null && industrytype == null && groupmissionNames.isEmpty() && groupvisionNames.isEmpty() && departmenttype == null)) {
                this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"[%s]\u4e0d\u80fd\u586b\u5199\u96c6\u56e2\u3001\u516c\u53f8\u3001\u90e8\u95e8\u4fe1\u606f\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_61", (String)"odc-homs-business", (Object[])new Object[0]), adminorgtypeName));
            }
        }
    }

    private void checkEstablishmentdate(DynamicObject dataEntity, int rowIndex, Map<String, DynamicObject> existDys) {
        Date bsed;
        Date originalEstablishmentdate;
        String number = dataEntity.getString("number");
        DynamicObject dynamicObject = existDys.get(number);
        Date establishmentdate = dataEntity.getDate("establishmentdate");
        if (establishmentdate != null && existDys.containsKey(number) && !establishmentdate.equals(originalEstablishmentdate = dynamicObject.getDate("establishmentdate"))) {
            this.recordErrorMsgInMap(rowIndex, ResManager.loadKDString((String)"\u6210\u7acb\u65e5\u671f\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"FastchgImportValidateHelper_32", (String)"odc-homs-business", (Object[])new Object[0]));
        }
        if ((bsed = dataEntity.getDate("bsed")).after(new Date())) {
            this.recordErrorMsgInMap(rowIndex, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5f53\u524d\u65e5\u671f;", (String)"FastchgImportValidateHelper_46", (String)"odc-homs-business", (Object[])new Object[0]));
        }
    }

    private void checkBU(DynamicObject dataEntity, int rowIndex) {
        long curBu = dataEntity.getLong("org.id");
        if (!this.buids.contains(curBu)) {
            String msg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7[%s] \u7684\u6743\u9650\uff0c\u4e0d\u80fd\u66f4\u65b0;", (String)"FastchgImportValidateHelper_64", (String)"odc-homs-business", (Object[])new Object[0]);
            String curBuName = dataEntity.getString("org.name");
            this.recordErrorMsgInMap(rowIndex, String.format(msg, curBuName));
        }
    }

    public void checkTextOverLength(DynamicObject dataEntity, int rowIndex) {
        String changedescription = dataEntity.getString("changedescription");
        if (!StringUtils.isEmpty((CharSequence)changedescription) && changedescription.length() > 255) {
            this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u53d8\u52a8\u8bf4\u660e\u201d\uff08%s\uff09\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c255]\u3002", (String)"FastchgImportValidateHelper_20", (String)"odc-homs-business", (Object[])new Object[0]), MultiLangEnum.getName((String)"zh_CN")));
        }
        ILocaleString name = dataEntity.getLocaleString("name");
        String number = dataEntity.getString("number");
        ILocaleString simplename = dataEntity.getLocaleString("simplename");
        name.forEach((localId, value) -> {
            if (!StringUtils.isEmpty((CharSequence)value) && value.length() > 255) {
                this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u8c03\u6574\u540e\u884c\u653f\u7ec4\u7ec7\u540d\u79f0\u201d\uff08%s\uff09\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c255]\u3002", (String)"FastchgImportValidateHelper_21", (String)"odc-homs-business", (Object[])new Object[0]), MultiLangEnum.getName((String)localId)));
            }
        });
        if (!StringUtils.isEmpty((CharSequence)number) && number.length() > 60) {
            this.recordErrorMsgInMap(rowIndex, ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u8c03\u6574\u540e\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c60]\u3002", (String)"FastchgImportValidateHelper_22", (String)"odc-homs-business", (Object[])new Object[0]));
        }
        simplename.forEach((localId, value) -> {
            if (!StringUtils.isEmpty((CharSequence)value) && value.length() > 100) {
                this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u7b80\u79f0\u201d\uff08%s\uff09\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c100]\u3002", (String)"FastchgImportValidateHelper_23", (String)"odc-homs-business", (Object[])new Object[0]), MultiLangEnum.getName((String)localId)));
            }
        });
        ILocaleString description = dataEntity.getLocaleString("description");
        description.forEach((localId, value) -> {
            if (!StringUtils.isEmpty((CharSequence)value) && value.length() > 255) {
                this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u63cf\u8ff0\u201d\uff08%s\uff09\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c255]\u3002", (String)"FastchgImportValidateHelper_24", (String)"odc-homs-business", (Object[])new Object[0]), MultiLangEnum.getName((String)localId)));
            }
        });
        ILocaleString positioning = dataEntity.getLocaleString("positioning");
        positioning.forEach((localId, value) -> {
            if (!StringUtils.isEmpty((CharSequence)value) && value.length() > 2000) {
                this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u5b9a\u4f4d\u201d\uff08%s\uff09\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c200]\u3002", (String)"FastchgImportValidateHelper_25", (String)"odc-homs-business", (Object[])new Object[0]), MultiLangEnum.getName((String)localId)));
            }
        });
        ILocaleString mainduty = dataEntity.getLocaleString("mainduty");
        mainduty.forEach((localId, value) -> {
            if (!StringUtils.isEmpty((CharSequence)value) && value.length() > 2000) {
                this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u4e3b\u8981\u804c\u8d23\u201d\uff08%s\uff09\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c2000]\u3002", (String)"FastchgImportValidateHelper_26", (String)"odc-homs-business", (Object[])new Object[0]), MultiLangEnum.getName((String)localId)));
            }
        });
        ILocaleString safedescription = dataEntity.getLocaleString("safedescription");
        safedescription.forEach((localId, value) -> {
            if (!StringUtils.isEmpty((CharSequence)value) && value.length() > 255) {
                this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u4fdd\u5bc6\u63cf\u8ff0\u201d\uff08%s\uff09\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c255]", (String)"FastchgImportValidateHelper_30", (String)"odc-homs-business", (Object[])new Object[0]), MultiLangEnum.getName((String)localId)));
            }
        });
        ILocaleString detailaddress = dataEntity.getLocaleString("detailaddress");
        detailaddress.forEach((localId, value) -> {
            if (!StringUtils.isEmpty((CharSequence)value) && value.length() > 255) {
                this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u8be6\u7ec6\u5730\u5740\u201d\uff08%s\uff09\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c255]\u3002", (String)"FastchgImportValidateHelper_27", (String)"odc-homs-business", (Object[])new Object[0]), MultiLangEnum.getName((String)localId)));
            }
        });
        ILocaleString groupvision = dataEntity.getLocaleString("groupvision");
        groupvision.forEach((localId, value) -> {
            if (!StringUtils.isEmpty((CharSequence)value) && value.length() > 255) {
                this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u96c6\u56e2\u613f\u666f\u201d\uff08%s\uff09\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c255]\u3002", (String)"FastchgImportValidateHelper_28", (String)"odc-homs-business", (Object[])new Object[0]), MultiLangEnum.getName((String)localId)));
            }
        });
        ILocaleString groupmission = dataEntity.getLocaleString("groupmission");
        groupmission.forEach((localId, value) -> {
            if (!StringUtils.isEmpty((CharSequence)value) && value.length() > 255) {
                this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u96c6\u56e2\u4f7f\u547d\u201d\uff08%s\uff09\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c255]\u3002", (String)"FastchgImportValidateHelper_29", (String)"odc-homs-business", (Object[])new Object[0]), MultiLangEnum.getName((String)localId)));
            }
        });
    }

    private List<Long> getDefaultOrg() {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        HasPermOrgResult permOrg = OrgPermHelper.getHRPermOrg((String)"homs_adminorgdetail");
        if (permOrg.hasAllOrgPerm()) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_org_structure");
            QFilter viewFilter = new QFilter("view.number", "=", (Object)"21");
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            Object[] orgStructures = helper.query("org.id", new QFilter[]{viewFilter, enableFilter});
            if (!ArrayUtils.isEmpty((Object[])orgStructures)) {
                Stream.of(orgStructures).forEach(dy -> orgIds.add(dy.getLong("org.id")));
            }
        } else {
            orgIds.addAll(permOrg.getHasPermOrgs());
        }
        return orgIds;
    }

    private List<Long> getPermOrgs() {
        AuthorizedOrgResult permResult = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getUserAdminOrgs", (Object[])new Object[]{RequestContext.get().getCurrUserId(), "homs", "homs_adminorgdetail", "47150e89000000ac", "boid", null});
        List boidIds = !permResult.isHasAllOrgPerm() ? permResult.getHasPermOrgs() : (List)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAllAdminOrgs", (Object[])new Object[]{Boolean.FALSE});
        LOG.info("kd.hr.homs.opplugin.web.impo.AdmingorgImportValidator.getPermOrgs orgIds={}", (Object)JSONObject.toJSONString((Object)boidIds));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter filter = new QFilter("boid", "in", (Object)boidIds);
        QFilter orgIdFilter = new QFilter("org", "in", this.buids);
        QFilter dataStatusfilter = new QFilter("datastatus", "in", (Object)"1");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter iscurrentversionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter initstatusFilter = new QFilter("initstatus", "=", (Object)"2");
        DynamicObject[] query = helper.query("id, boid, org.id", new QFilter[]{filter, orgIdFilter, dataStatusfilter, enableFilter, iscurrentversionFilter, initstatusFilter});
        return boidIds;
    }

    public void checkParentOrgEffectiveness(DynamicObject[] dysInDB, String operateKey) {
        Map originalOrgMap = Arrays.stream(dysInDB).collect(Collectors.toMap(dy -> dy.getLong("boid"), Function.identity(), (oldV, newV) -> newV));
        Map orgIdBillNoMap = this.checkDtoList.stream().collect(Collectors.toMap(OrgBatchCheckDto::getOrgBoId, Function.identity(), (v1, v2) -> v2));
        List orgnumbers = Arrays.stream(this.dataEntities).map(dy -> dy.getDataEntity().getString("number")).collect(Collectors.toList());
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            long parentbuid;
            long originalParentboid;
            int rowIndex = extendedDataEntity.getDataEntityIndex();
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObject parentorg = dataEntity.getDynamicObject("parentorg");
            if (parentorg == null && operateKey.equals("save")) {
                return;
            }
            if (parentorg == null) {
                return;
            }
            String parentNumber = parentorg.getString("number");
            String parentName = parentorg.getLocaleString("name").getLocaleValue();
            long parentBoId = parentorg.getLong("boid");
            parentorg = (DynamicObject)originalOrgMap.get(parentBoId);
            long changesceneId = dataEntity.getLong("changescene.id");
            long orgchangetype = this.changesceneMap.get(changesceneId).getLong("orgchangetype.id");
            if (orgchangetype == OrgBatchChgBillConstants.CHANGE_TYPE_PARENT && "confirmchangenoaudit".equals(operateKey) && (originalParentboid = ((DynamicObject)originalOrgMap.get(dataEntity.getLong("boid"))).getLong("parentorg.id")) == parentBoId) {
                this.recordErrorMsgInMap(rowIndex, ResManager.loadKDString((String)"\u8c03\u6574\u540e\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u672a\u53d8\u5316\u3002", (String)"FastchgImportValidateHelper_7", (String)"odc-homs-business", (Object[])new Object[0]));
            }
            if (orgchangetype == OrgBatchChgBillConstants.CHANGE_TYPE_PARENT && "confirmchangenoaudit".equals(operateKey)) {
                Date establishmentdate = parentorg.getDate("establishmentdate");
                if (dataEntity.getDate("bsed").before(establishmentdate)) {
                    this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7684\u6210\u7acb\u65e5\u671f %s\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_10", (String)"odc-homs-business", (Object[])new Object[0]), HRDateTimeUtils.format((Date)establishmentdate, (String)YYYY_MM_DD)));
                }
            } else if (orgchangetype == OrgBatchChgBillConstants.CHANGE_TYPE_INFO && "confirmchangenoaudit".equals(operateKey) && (originalParentboid = ((DynamicObject)originalOrgMap.get(dataEntity.getLong("boid"))).getLong("parentorg.id")) != parentBoId) {
                this.recordErrorMsgInMap(rowIndex, ResManager.loadKDString((String)"\u5982\u9700\u8c03\u6574\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\uff0c\u9700\u586b\u5199\u53d8\u52a8\u7c7b\u578b\u4e3a\u201c\u8c03\u6574\u4e0a\u7ea7\u201d\u7684\u53d8\u52a8\u573a\u666f\u3002", (String)"FastchgImportValidateHelper_39", (String)"odc-homs-business", (Object[])new Object[0]));
            }
            if (!(orgchangetype != OrgBatchChgBillConstants.CHANGE_TYPE_ADD && orgchangetype != OrgBatchChgBillConstants.CHANGE_TYPE_PARENT || this.buids.contains(parentbuid = parentorg.getLong("org.id")))) {
                this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u7684\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastchgImportValidateHelper_62", (String)"odc-homs-business", (Object[])new Object[0]), parentName));
            }
            if ("true".equals(parentorg.getString("isvirtualorg"))) {
                this.recordErrorMsgInMap(rowIndex, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4e3a\u865a\u62df\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_65", (String)"odc-homs-business", (Object[])new Object[0]));
            }
            if (orgchangetype != OrgBatchChgBillConstants.CHANGE_TYPE_PARENT && orgchangetype != OrgBatchChgBillConstants.CHANGE_TYPE_ADD) {
                return;
            }
            if ("0".equals(parentorg.get("enable"))) {
                this.recordErrorMsgInMap(rowIndex, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5df2\u505c\u7528\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_4", (String)"odc-homs-business", (Object[])new Object[0]));
            } else if (originalOrgMap.containsKey(parentBoId) && "0".equals(parentorg.getString("enable"))) {
                this.recordErrorMsgInMap(rowIndex, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5df2\u505c\u7528\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_4", (String)"odc-homs-business", (Object[])new Object[0]));
            } else if (!originalOrgMap.containsKey(parentBoId)) {
                if (operateKey.equals("confirmchangenoaudit")) {
                    this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7 [%1$s/%2$s]\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_8", (String)"odc-homs-business", (Object[])new Object[0]), parentNumber, parentName));
                } else if (operateKey.equals("save") && orgnumbers.contains(parentNumber)) {
                    this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7 [%1$s/%2$s]\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_8", (String)"odc-homs-business", (Object[])new Object[0]), parentNumber, parentName));
                }
            } else if (!SystemParamHelper.getAllowTobeDisableChg(dataEntity.getLong("org.id")) && originalOrgMap.containsKey(parentBoId) && "1".equals(parentorg.getString("enable")) && parentorg.getBoolean("tobedisableflag")) {
                if (orgchangetype == OrgBatchChgBillConstants.CHANGE_TYPE_PARENT) {
                    this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u8c03\u6574\u5230\u8be5\u7ec4\u7ec7\u4e0b\u3002", (String)"FastchgImportValidateHelper_53", (String)"odc-homs-business", (Object[])new Object[0]), parentName));
                } else {
                    this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5728\u8be5\u7ec4\u7ec7\u4e0b\u65b0\u589e\u7ec4\u7ec7\u3002", (String)"FastchgImportValidateHelper_55", (String)"odc-homs-business", (Object[])new Object[0]), parentName));
                }
            }
            if (!(orgnumbers.contains(parentNumber) || this.permOrgs.contains(parentBoId) && (parentorg == null || this.buids.contains(parentorg.getLong("org.id"))))) {
                this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7[%1$s/%2$s]\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_5", (String)"odc-homs-business", (Object[])new Object[0]), parentNumber, parentName));
            }
            if (orgIdBillNoMap.containsKey(parentBoId)) {
                OrgBatchCheckDto dto = (OrgBatchCheckDto)orgIdBillNoMap.get(parentBoId);
                if (OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE.equals(dto.getChangeTypeId())) {
                    String errorMsg = "confirmchangenoaudit".equals(operateKey) ? ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5728\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%s\uff09\u4e2d\u505a\u4e86\u201c\u505c\u7528\u201d\u64cd\u4f5c\uff0c\u4e0d\u80fd\u8c03\u6574\u5230\u8be5\u7ec4\u7ec7\u4e0b\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastchgImportValidateHelper_6", (String)"odc-homs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5728\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%s\uff09\u4e2d\u505a\u4e86\u201c\u505c\u7528\u201d\u64cd\u4f5c\uff0c\u4e0d\u80fd\u5728\u8be5\u7ec4\u7ec7\u4e0b\u65b0\u589e\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastchgImportValidateHelper_51", (String)"odc-homs-business", (Object[])new Object[0]);
                    this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, errorMsg, dto.getBillNo()));
                } else if (dto.isTobeDisableFlag() && !SystemParamHelper.getAllowTobeDisableChg(dataEntity.getLong("org.id"))) {
                    if (orgchangetype == OrgBatchChgBillConstants.CHANGE_TYPE_PARENT) {
                        this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%1$s\u201d\u5728\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%2$s\uff09\u4e2d\u5df2\u8bbe\u7f6e\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u8c03\u6574\u5230\u8be5\u7ec4\u7ec7\u4e0b\u3002", (String)"FastchgImportValidateHelper_54", (String)"odc-homs-business", (Object[])new Object[0]), parentName, dto.getBillNo()));
                    } else {
                        this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%1$s\u201d\u5728\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%2$s\uff09\u4e2d\u5df2\u8bbe\u7f6e\u4e3a\u5f85\u505c\u7528\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5728\u8be5\u7ec4\u7ec7\u4e0b\u65b0\u589e\u7ec4\u7ec7\u3002", (String)"FastchgImportValidateHelper_9", (String)"odc-homs-business", (Object[])new Object[0]), parentName, dto.getBillNo()));
                    }
                }
            }
            dataEntity.set("changetype", (Object)this.changesceneMap.get(changesceneId).getDynamicObject("orgchangetype"));
            dataEntity.set("changescene", (Object)this.changesceneMap.get(changesceneId));
        }
    }

    public void checkAffiliation() {
        List<CycleOrgBean> billAffiliationList = this.queryBillOrgCoopList();
        ArrayList adminAffiliationList = Lists.newArrayListWithExpectedSize((int)10);
        this.bsedMap.forEach((bsed, list) -> {
            List<CycleOrgBean> adminCycleOrgList = FastCoopOrgInfoCheckServiceImpl.queryAdminCoopOrgColl(bsed);
            adminCycleOrgList.forEach(coop -> {
                if (1010L == coop.getCoopTypeId()) {
                    adminAffiliationList.add(coop);
                }
            });
        });
        ArrayList<CalibratorBean> result = new ArrayList<CalibratorBean>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject targetObject = dataEntity.getDataEntity();
            if (targetObject.getDate("effdt") == null) {
                targetObject.set("effdt", (Object)targetObject.getDate("bsed"));
            }
            Long orgBoId = targetObject.getLong("adminorg.boid");
            Long parentBoId = targetObject.getLong("parentorg.boid");
            Date effectDate = targetObject.getDate("effdt");
            if (effectDate == null) {
                return;
            }
            CycleOrgBean adminBean = OrgBatchBillCheckHelper.assembleCycleOrg(orgBoId, parentBoId, effectDate);
            adminAffiliationList.add(adminBean);
            LOG.info(String.format(Locale.ROOT, "containsCycle start time is %s", System.currentTimeMillis()));
            FastCoopOrgInfoCheckServiceImpl.affiliationCheck(targetObject, adminAffiliationList, billAffiliationList, result);
            LOG.info(String.format(Locale.ROOT, "containsCycle end time is %s", System.currentTimeMillis()));
            result.forEach(cb -> this.recordErrorMsgInMap(dataEntity.getDataEntityIndex(), cb.getMessage("odc-homs-business")));
        }
    }

    public List<CycleOrgBean> queryBillOrgCoopList() {
        ArrayList billAffiliationList = Lists.newArrayListWithExpectedSize((int)10);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fbillno,b.fadminorgboid,b.fadminorgid,b.fparentid, c.fboid as fparentboid,d.fboid   from t_homs_orgchgbill a ").append(" left join t_homs_orgchgbillentry b on b.fid = a.fid ").append(" left join t_haos_adminorg d on  d.fid = b.fadminorgid ").append(" left join t_haos_adminorg c on  c.fid = b.fparentid").append(" where a.fbillstatus in('B','D')");
        try (DataSet ds = HRDBUtil.queryDataSet((String)"queryBillOrgCoopList", (DBRoute)new DBRoute("haos"), (String)sb.toString(), null);){
            for (Row data : ds) {
                CycleOrgBean affiliationOrg = new CycleOrgBean();
                affiliationOrg.setBillNo(data.getString("fbillno"));
                affiliationOrg.setOrgId(data.getLong("fboid"));
                affiliationOrg.setCoopOrgId(data.getLong("fparentboid"));
                billAffiliationList.add(affiliationOrg);
            }
        }
        return billAffiliationList;
    }

    public void check4Model(String operateKey) {
        this.EffectiveParentLevel4ModelCheck();
        this.OntheWayParentLevel4ModelCheck(this.dataEntities, this.orgTypeStdIdMap);
        if ("save".equals(operateKey)) {
            return;
        }
        this.EffectiveChildLevel4ModelCheck();
        this.OntheWayChildLevel4ModelCheck(this.dataEntities, this.orgTypeStdIdMap);
    }

    private void OntheWayChildLevel4ModelCheck(ExtendedDataEntity[] dataEntities, Map<Long, Long> orgTypeStdIdMap) {
        Map onthewayBillLMap = this.checkDtoList.stream().collect(Collectors.toMap(dto -> dto.getParentOrgId(), Function.identity(), (oldV, newV) -> newV));
        Map<Long, List<DynamicObject>> entitiesMap = Arrays.stream(dataEntities).map(ex -> ex.getDataEntity()).collect(Collectors.groupingBy(dy -> dy.getLong("parentorg.boid")));
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            OrgBatchCheckDto childDto;
            Long childStdId;
            int rowIndex = extendedDataEntity.getDataEntityIndex();
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            long boid = dataEntity.getLong("boid");
            long sourcevid = dataEntity.getLong("sourcevid");
            DynamicObject adminorgtype = dataEntity.getDynamicObject("adminorgtype");
            if (adminorgtype == null) continue;
            long orgtypeStdId = adminorgtype.getLong("adminorgtypestd.id");
            String orgTypeName = adminorgtype.getString("name");
            if (onthewayBillLMap.containsKey(sourcevid) && !Objects.isNull(childStdId = orgTypeStdIdMap.get((childDto = (OrgBatchCheckDto)onthewayBillLMap.get(sourcevid)).getOrgTypeId()))) {
                Map<String, String> adminOrgTypeNameMap;
                String errorMsg = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b[%1$s]\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a %2$s\uff0c\u76ee\u524d\u6709\u5728\u9014\u5355[%3$s]\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_57", (String)"odc-homs-business", (Object[])new Object[0]);
                if (AdminOrgType.COMPANY.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_LOWER_COMPANY.contains(childStdId)) {
                    adminOrgTypeNameMap = OrgBatchBillCheckHelper.queryAdminOrgTypeNameMap(dataEntity.getLong("org.id"));
                    errorMsg = String.format(Locale.ROOT, errorMsg, orgTypeName, adminOrgTypeNameMap.get("level4_above_company"), childDto.getBillNo());
                    this.recordErrorMsgInMap(rowIndex, errorMsg);
                } else if (AdminOrgType.DEPARTMENT.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_LOWER_DEPT.contains(childStdId)) {
                    adminOrgTypeNameMap = OrgBatchBillCheckHelper.queryAdminOrgTypeNameMap(dataEntity.getLong("org.id"));
                    errorMsg = String.format(Locale.ROOT, errorMsg, orgTypeName, adminOrgTypeNameMap.get("level4_lower_dept"), childDto.getBillNo());
                    this.recordErrorMsgInMap(rowIndex, errorMsg);
                }
            }
            if (!entitiesMap.containsKey(boid)) continue;
            List<DynamicObject> childEntitys = entitiesMap.get(boid);
            for (DynamicObject childEntity : childEntitys) {
                Map<String, String> adminOrgTypeNameMap;
                Long childStdId2 = orgTypeStdIdMap.get(childEntity.getLong("adminorgtype.id"));
                if (Objects.isNull(childStdId2)) continue;
                String errorMsg = ResManager.loadKDString((String)"\u672c\u6a21\u677f \u884c\u653f\u7ec4\u7ec7\u7c7b\u578b[%1$s]\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a %2$s\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_13", (String)"odc-homs-business", (Object[])new Object[0]);
                if (AdminOrgType.COMPANY.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_LOWER_COMPANY.contains(childStdId2)) {
                    adminOrgTypeNameMap = OrgBatchBillCheckHelper.queryAdminOrgTypeNameMap(dataEntity.getLong("org.id"));
                    errorMsg = String.format(Locale.ROOT, errorMsg, orgTypeName, adminOrgTypeNameMap.get("level4_above_company"));
                    this.recordErrorMsgInMap(rowIndex, errorMsg);
                    continue;
                }
                if (AdminOrgType.DEPARTMENT.getId() != orgtypeStdId || OrgBatchCheckConstants.LEVEL4_LOWER_DEPT.contains(childStdId2)) continue;
                adminOrgTypeNameMap = OrgBatchBillCheckHelper.queryAdminOrgTypeNameMap(dataEntity.getLong("org.id"));
                errorMsg = String.format(Locale.ROOT, errorMsg, orgTypeName, adminOrgTypeNameMap.get("level4_lower_dept"));
                this.recordErrorMsgInMap(rowIndex, errorMsg);
            }
        }
    }

    private void EffectiveChildLevel4ModelCheck() {
        for (Map.Entry<Date, List<ExtendedDataEntity>> entry : this.bsedMap.entrySet()) {
            List<ExtendedDataEntity> list;
            List parentBoids;
            QFilter adminFilter;
            Date bsed = entry.getKey();
            List<OrgBatchCheckDto> effectiveChildOrgsInDB = this.queryAdminorgtypestd(bsed, adminFilter = new QFilter("parentorg", "in", parentBoids = (list = entry.getValue()).stream().map(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("boid")).distinct().collect(Collectors.toList())));
            if (effectiveChildOrgsInDB.isEmpty()) continue;
            Map<Long, List<OrgBatchCheckDto>> effectiveChildOrgsMap = effectiveChildOrgsInDB.stream().collect(Collectors.groupingBy(dto -> dto.getParentOrgBoId()));
            list.forEach(extendedDataEntity -> {
                DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                long boid = dataEntity.getLong("boid");
                DynamicObject adminorgtype = dataEntity.getDynamicObject("adminorgtype");
                if (adminorgtype == null) {
                    return;
                }
                long orgtypeStdId = adminorgtype.getLong("adminorgtypestd.id");
                String orgTypeName = adminorgtype.getString("name");
                if (!effectiveChildOrgsMap.containsKey(boid)) {
                    return;
                }
                List orgBatchCheckDtos = ((List)effectiveChildOrgsMap.get(boid)).stream().sorted(Comparator.comparing(OrgBatchCheckDto::getOrgBsled)).collect(Collectors.toList());
                Date endDate = new Date();
                Date start = bsed;
                int times = 0;
                for (OrgBatchCheckDto dto : orgBatchCheckDtos) {
                    Long childOrgTypeStdId = dto.getOrgTypeStdId();
                    if ((AdminOrgType.DEPARTMENT.getId() != orgtypeStdId || OrgBatchCheckConstants.LEVEL4_LOWER_DEPT.contains(childOrgTypeStdId)) && (AdminOrgType.COMPANY.getId() != orgtypeStdId || OrgBatchCheckConstants.LEVEL4_LOWER_COMPANY.contains(childOrgTypeStdId))) continue;
                    endDate = dto.getOrgBsled();
                    if (times == 0) {
                        start = dto.getOrgBsed().after(bsed) ? dto.getOrgBsed() : bsed;
                    }
                    ++times;
                }
                if (times == 0) {
                    return;
                }
                String errorMsg = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b[%1$s]\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a%2$s\uff0c\u5728[%3$s\u81f3%4$s]\u671f\u95f4\u4e0d\u6ee1\u8db3\u89c4\u5219\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_58", (String)"odc-homs-business", (Object[])new Object[0]);
                Map<String, String> adminOrgTypeNameMap = OrgBatchBillCheckHelper.queryAdminOrgTypeNameMap(dataEntity.getLong("org.id"));
                errorMsg = AdminOrgType.DEPARTMENT.getId() == orgtypeStdId ? String.format(Locale.ROOT, errorMsg, orgTypeName, adminOrgTypeNameMap.get("level4_lower_dept"), HRDateTimeUtils.format((Date)start, (String)YYYY_MM_DD), HRDateTimeUtils.format((Date)endDate, (String)YYYY_MM_DD)) : String.format(Locale.ROOT, errorMsg, orgTypeName, adminOrgTypeNameMap.get("level4_lower_company"), HRDateTimeUtils.format((Date)start, (String)YYYY_MM_DD), HRDateTimeUtils.format((Date)endDate, (String)YYYY_MM_DD));
                this.recordErrorMsgInMap(extendedDataEntity.getDataEntityIndex(), errorMsg);
            });
        }
    }

    private void OntheWayParentLevel4ModelCheck(ExtendedDataEntity[] dataEntities, Map<Long, Long> orgTypeStdIdMap) {
        Map onthewayBillLMap = this.checkDtoList.stream().collect(Collectors.toMap(dto -> dto.getOrgBoId(), Function.identity(), (oldV, newV) -> newV));
        Map entitiesMap = Arrays.stream(dataEntities).map(ex -> ex.getDataEntity()).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject parentEntity;
            Map<String, String> adminOrgTypeNameMap;
            String errorMsg;
            OrgBatchCheckDto dto2;
            Long parentStdId;
            int rowIndex = extendedDataEntity.getDataEntityIndex();
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObject adminorgtype = dataEntity.getDynamicObject("adminorgtype");
            if (dataEntity.getDynamicObject("parentorg") == null || adminorgtype == null) continue;
            long parentorgboid = dataEntity.getLong("parentorg.boid");
            long parentorgid = dataEntity.getLong("parentorg.id");
            long orgtypeStdId = adminorgtype.getLong("adminorgtypestd.id");
            String orgTypeName = adminorgtype.getString("name");
            if (onthewayBillLMap.containsKey(parentorgboid) && !Objects.isNull(parentStdId = orgTypeStdIdMap.get((dto2 = (OrgBatchCheckDto)onthewayBillLMap.get(parentorgboid)).getOrgTypeId()))) {
                errorMsg = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b[%1$s]\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a %2$s\uff0c\u76ee\u524d\u6709\u5728\u9014\u5355[%3$s]\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_12", (String)"odc-homs-business", (Object[])new Object[0]);
                if (AdminOrgType.GROUP.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_ABOVE_GROUP.contains(parentStdId)) {
                    adminOrgTypeNameMap = OrgBatchBillCheckHelper.queryAdminOrgTypeNameMap(dataEntity.getLong("org.id"));
                    errorMsg = String.format(Locale.ROOT, errorMsg, orgTypeName, adminOrgTypeNameMap.get("level4_above_group"), dto2.getBillNo());
                    this.recordErrorMsgInMap(rowIndex, errorMsg);
                } else if (AdminOrgType.COMPANY.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_ABOVE_COMPANY.contains(parentStdId)) {
                    adminOrgTypeNameMap = OrgBatchBillCheckHelper.queryAdminOrgTypeNameMap(dataEntity.getLong("org.id"));
                    errorMsg = String.format(Locale.ROOT, errorMsg, orgTypeName, adminOrgTypeNameMap.get("level4_above_company"), dto2.getBillNo());
                    this.recordErrorMsgInMap(rowIndex, errorMsg);
                }
            }
            if (!entitiesMap.containsKey(parentorgid) || Objects.isNull(parentStdId = orgTypeStdIdMap.get((parentEntity = (DynamicObject)entitiesMap.get(parentorgid)).getLong("adminorgtype.id")))) continue;
            errorMsg = ResManager.loadKDString((String)"\u672c\u6a21\u677f \u884c\u653f\u7ec4\u7ec7\u7c7b\u578b[%1$s]\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a %2$s\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_13", (String)"odc-homs-business", (Object[])new Object[0]);
            if (AdminOrgType.GROUP.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_ABOVE_GROUP.contains(parentStdId)) {
                adminOrgTypeNameMap = OrgBatchBillCheckHelper.queryAdminOrgTypeNameMap(dataEntity.getLong("org.id"));
                errorMsg = String.format(Locale.ROOT, errorMsg, orgTypeName, adminOrgTypeNameMap.get("level4_above_group"));
                this.recordErrorMsgInMap(rowIndex, errorMsg);
                continue;
            }
            if (AdminOrgType.COMPANY.getId() != orgtypeStdId || OrgBatchCheckConstants.LEVEL4_ABOVE_COMPANY.contains(parentStdId)) continue;
            adminOrgTypeNameMap = OrgBatchBillCheckHelper.queryAdminOrgTypeNameMap(dataEntity.getLong("org.id"));
            errorMsg = String.format(Locale.ROOT, errorMsg, orgTypeName, adminOrgTypeNameMap.get("level4_above_company"));
            this.recordErrorMsgInMap(rowIndex, errorMsg);
        }
    }

    private void EffectiveParentLevel4ModelCheck() {
        for (Map.Entry<Date, List<ExtendedDataEntity>> entry : this.bsedMap.entrySet()) {
            Date bsed = entry.getKey();
            List<ExtendedDataEntity> list = entry.getValue();
            List parentBoids = list.stream().map(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("parentorg.boid")).distinct().collect(Collectors.toList());
            QFilter adminFilter = new QFilter("boid", "in", parentBoids);
            List<OrgBatchCheckDto> effectiveParentInDBs = this.queryAdminorgtypestd(bsed, adminFilter);
            Map<Long, List<OrgBatchCheckDto>> adminorgtypestdMap = effectiveParentInDBs.stream().collect(Collectors.groupingBy(dto -> dto.getOrgBoId()));
            list.forEach(extendedDataEntity -> {
                DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                long parentorgboid = dataEntity.getLong("parentorg.boid");
                DynamicObject adminorgtype = dataEntity.getDynamicObject("adminorgtype");
                if (parentorgboid == 0L || adminorgtype == null) {
                    return;
                }
                long orgtypeStdId = adminorgtype.getLong("adminorgtypestd.id");
                String orgTypeName = adminorgtype.getLocaleString("name").getLocaleValue();
                if (!adminorgtypestdMap.containsKey(parentorgboid)) {
                    return;
                }
                List orgBatchCheckDtos = ((List)adminorgtypestdMap.get(parentorgboid)).stream().sorted(Comparator.comparing(OrgBatchCheckDto::getOrgBsled)).collect(Collectors.toList());
                Date endDate = new Date();
                Date start = bsed;
                int times = 0;
                int rowIndex = extendedDataEntity.getDataEntityIndex();
                for (OrgBatchCheckDto dto : orgBatchCheckDtos) {
                    Long parentOrgTypeStdId = dto.getOrgTypeStdId();
                    if ((AdminOrgType.GROUP.getId() != orgtypeStdId || OrgBatchCheckConstants.LEVEL4_ABOVE_GROUP.contains(parentOrgTypeStdId)) && (AdminOrgType.COMPANY.getId() != orgtypeStdId || OrgBatchCheckConstants.LEVEL4_ABOVE_COMPANY.contains(parentOrgTypeStdId))) continue;
                    endDate = dto.getOrgBsled();
                    if (times == 0) {
                        start = dto.getOrgBsed().after(bsed) ? dto.getOrgBsed() : bsed;
                    }
                    ++times;
                }
                if (times == 0) {
                    return;
                }
                String errorMsg = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b[%1$s]\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a%2$s\uff0c\u5728[%3$s\u81f3%4$s]\u671f\u95f4\u4e0d\u6ee1\u8db3\u89c4\u5219\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_11", (String)"odc-homs-business", (Object[])new Object[0]);
                Map<String, String> adminOrgTypeNameMap = OrgBatchBillCheckHelper.queryAdminOrgTypeNameMap(dataEntity.getLong("org.id"));
                errorMsg = AdminOrgType.GROUP.getId() == orgtypeStdId ? String.format(Locale.ROOT, errorMsg, orgTypeName, adminOrgTypeNameMap.get("level4_above_group"), HRDateTimeUtils.format((Date)start, (String)YYYY_MM_DD), HRDateTimeUtils.format((Date)endDate, (String)YYYY_MM_DD)) : String.format(Locale.ROOT, errorMsg, orgTypeName, adminOrgTypeNameMap.get("level4_above_company"), HRDateTimeUtils.format((Date)start, (String)YYYY_MM_DD), HRDateTimeUtils.format((Date)endDate, (String)YYYY_MM_DD));
                this.recordErrorMsgInMap(rowIndex, errorMsg);
            });
        }
    }

    private List<OrgBatchCheckDto> queryAdminorgtypestd(Date bsed, QFilter adminFilter) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgdetail");
        adminFilter.and(new QFilter("datastatus", "in", (Object)new String[]{"1", "2"}));
        adminFilter.and(new QFilter("enable", "=", (Object)"1"));
        adminFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        adminFilter.and(new QFilter("bsled", ">=", (Object)bsed));
        DynamicObject[] dynamicObjects = helper.queryOriginalArray("adminorgtype.id, adminorgtype.adminorgtypestd.id, boid, id, bsed, bsled, parentorg.id", adminFilter.toArray());
        ArrayList<OrgBatchCheckDto> list = new ArrayList<OrgBatchCheckDto>(dynamicObjects.length);
        for (DynamicObject dy : dynamicObjects) {
            OrgBatchCheckDto dto = new OrgBatchCheckDto();
            dto.setOrgTypeStdId(dy.getLong("adminorgtype.adminorgtypestd.id"));
            dto.setOrgTypeId(dy.getLong("adminorgtype.id"));
            dto.setOrgBoId(dy.getLong("boid"));
            dto.setParentOrgBoId(dy.getLong("parentorg.id"));
            dto.setOrgBsed(dy.getDate("bsed"));
            dto.setOrgBsled(dy.getDate("bsled"));
            list.add(dto);
        }
        return list;
    }

    public void checkBasedataInBU(DynamicObject dataEntity, int rowIndex, String operateKey) {
        DynamicObjectCollection relativeChangereasons;
        List relativeChangereasonIds;
        long changereason;
        long orgchangetype;
        ArrayList<Long> usableChangeTypes = new ArrayList<Long>(){
            {
                this.add(1020L);
                this.add(1030L);
            }
        };
        Long changescene = dataEntity.getLong("changescene.id");
        String changesceneName = dataEntity.getDynamicObject("changescene").getLocaleString("name").getLocaleValue();
        if ("confirmchangenoaudit".equals(operateKey)) {
            Long orgchangetype2;
            if (this.changesceneMap.containsKey(changescene) && !usableChangeTypes.contains(orgchangetype2 = Long.valueOf(this.changesceneMap.get(changescene).getLong("orgchangetype.id")))) {
                this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u9700\u586b\u5199\u53d8\u52a8\u7c7b\u578b\u4e3a[\u8c03\u6574\u4e0a\u7ea7][\u53d8\u66f4\u4fe1\u606f]\u7684\u53d8\u52a8\u573a\u666f\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_15", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
            }
            if (changescene == 1070L) {
                this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u53d8\u52a8\u573a\u666f\u4e0d\u80fd\u586b\u5199\u201c\u7ec4\u7ec7\u542f\u7528\u201d\u3002", (String)"FastchgImportValidateHelper_16", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
            }
        } else if ("save".equals(operateKey) && this.changesceneMap.containsKey(changescene) && (orgchangetype = this.changesceneMap.get(changescene).getLong("orgchangetype.id")) != 1010L) {
            this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u9700\u586b\u5199\u53d8\u52a8\u7c7b\u578b\u4e3a[\u65b0\u589e\u7ec4\u7ec7]\u7684\u53d8\u52a8\u573a\u666f\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_44", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
        }
        if ((changereason = dataEntity.getLong("changereason.id")) != 0L && this.changesceneMap.containsKey(changescene) && !(relativeChangereasonIds = (relativeChangereasons = this.changesceneMap.get(changescene).getDynamicObjectCollection("changereason")).stream().map(dy -> dy.getLong("fbasedataid.id")).distinct().collect(Collectors.toList())).contains(changereason)) {
            this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u9700\u586b\u5199\u53d8\u52a8\u573a\u666f\u4e3a[%s]\u5173\u8054\u7684\u7684\u53d8\u52a8\u539f\u56e0\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_18", (String)"odc-homs-business", (Object[])new Object[0]), changesceneName));
        }
        int index = dataEntity.getInt("index");
        if (operateKey.equals("confirmchangenoaudit") && (index > 99999 || index < 1)) {
            this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6392\u5e8f\u53f7\u53ea\u80fd\u586b\u51991-99999\u4e4b\u95f4\u7684\u6574\u6570\u3002", (String)"FastchgImportValidateHelper_19", (String)"odc-homs-business", (Object[])new Object[0]), changesceneName));
        } else if (operateKey.equals("save") && (index < 0 || index > 99999)) {
            this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6392\u5e8f\u53f7\u53ea\u80fd\u586b\u51991-99999\u4e4b\u95f4\u7684\u6574\u6570\u3002", (String)"FastchgImportValidateHelper_19", (String)"odc-homs-business", (Object[])new Object[0]), changesceneName));
        }
        long corporateorg = dataEntity.getLong("corporateorg.id");
        if (corporateorg != 0L && !this.lawentityMap.containsKey(corporateorg)) {
            String corporateorgName = dataEntity.getLocaleString("corporateorg.name").getLocaleValue();
            this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"%s \u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_33", (String)"odc-homs-business", (Object[])new Object[0]), corporateorgName));
        }
    }

    public void checkEffdt(ExtendedDataEntity[] dataEntities, Map<Long, DynamicObject> orgbaseinfoBsedMap) {
        List<Long> boids = Arrays.stream(dataEntities).map(dy -> dy.getDataEntity().getLong("boid")).distinct().collect(Collectors.toList());
        Map<Long, DynamicObject> adminorgGroupMap = this.getAdminorgOtherInfos("haos_adminorggroup", boids, "groupmission, groupvision");
        Map<Long, DynamicObject> adminorgcompanyMap = this.getAdminorgOtherInfos("haos_adminorgcompany", boids, "industrytype.id, companytype.id");
        Map<Long, DynamicObject> adminorgdepartmentMap = this.getAdminorgOtherInfos("haos_adminorgdepartment", boids, "departmenttype");
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject target = extendedDataEntity.getDataEntity();
            int rowIndex = extendedDataEntity.getDataEntityIndex();
            DynamicObject adminorgtype = target.getDynamicObject("adminorgtype");
            if (adminorgtype == null) continue;
            Long orgtypeStdId = adminorgtype.getLong("adminorgtypestd.id");
            long boid = target.getLong("boid");
            Date bsed = target.getDate("bsed");
            DynamicObject originalCompany = adminorgcompanyMap.get(boid);
            if (orgtypeStdId.longValue() == AdminOrgType.GROUP.getId()) {
                DynamicObject originalGroup = adminorgGroupMap.get(boid);
                this.compareILocaleString(target, "groupvision", originalGroup, bsed, rowIndex);
                this.compareILocaleString(target, "groupmission", originalGroup, bsed, rowIndex);
                this.compareBaseInfo(target, "companytype.id", originalCompany, bsed, rowIndex);
                this.compareBaseInfo(target, "industrytype.id", originalCompany, bsed, rowIndex);
            } else if (orgtypeStdId.longValue() == AdminOrgType.COMPANY.getId()) {
                this.compareBaseInfo(target, "companytype.id", originalCompany, bsed, rowIndex);
                this.compareBaseInfo(target, "industrytype.id", originalCompany, bsed, rowIndex);
            } else if (orgtypeStdId.longValue() == AdminOrgType.DEPARTMENT.getId()) {
                DynamicObject originalDepartmenttype = adminorgdepartmentMap.get(boid);
                this.compareBaseInfo(target, "departmenttype.id", originalDepartmenttype, bsed, rowIndex);
            }
            this.compareOrgBaseInfo(target, orgbaseinfoBsedMap.get(boid), bsed, rowIndex);
        }
    }

    private void compareOrgBaseInfo(DynamicObject target, DynamicObject original, Date bsed, int rowIndex) {
        for (String iLocaleString : iLocaleStrings) {
            this.compareILocaleString(target, iLocaleString, original, bsed, rowIndex);
        }
        for (String basedata : basedatas) {
            this.compareBaseInfo(target, basedata, original, bsed, rowIndex);
        }
    }

    private void compareBaseInfo(DynamicObject target, String propertyname, DynamicObject original, Date bsed, int rowIndex) {
        long companytype = target.getLong(propertyname);
        if (original != null && companytype != original.getLong(propertyname) && bsed.before(original.getDate("bsed"))) {
            this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7ec4\u7ec7\u8c03\u6574\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u8c03\u6574\u5185\u5bb9\u5f53\u524d\u751f\u6548\u65e5\u671f%s, \u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_38", (String)"odc-homs-business", (Object[])new Object[0]), HRDateTimeUtils.format((Date)original.getDate("bsed"), (String)YYYY_MM_DD)));
        }
    }

    private void compareILocaleString(DynamicObject target, String propertyname, DynamicObject original, Date bsed, int rowIndex) {
        if (original == null) {
            return;
        }
        ILocaleString iLocaleString = target.getLocaleString(propertyname);
        iLocaleString.forEach((localeid, value) -> {
            if ("GLang".equals(localeid)) {
                return;
            }
            if (original.get(propertyname) instanceof String) {
                LOG.info("property is" + propertyname);
                return;
            }
            String origGroupvision = (String)original.getLocaleString(propertyname).get(localeid);
            if (StringUtils.isEmpty((CharSequence)value) && StringUtils.isEmpty((CharSequence)origGroupvision)) {
                return;
            }
            if (!StringUtils.isEmpty((CharSequence)value) && !value.equals(origGroupvision) && bsed.before(original.getDate("bsed"))) {
                this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7ec4\u7ec7\u8c03\u6574\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u8c03\u6574\u5185\u5bb9\u5f53\u524d\u751f\u6548\u65e5\u671f%s, \u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_38", (String)"odc-homs-business", (Object[])new Object[0]), HRDateTimeUtils.format((Date)original.getDate("bsed"), (String)YYYY_MM_DD)));
            }
        });
    }

    private Map<Long, DynamicObject> getAdminorgOtherInfos(String entityName, List<Long> boids, String selectSql) {
        QFilter orgIdFilter = new QFilter("adminorg", "in", boids);
        QFilter dataStatusfilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter iscurrentversionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter initstatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter[] filters = new QFilter[]{orgIdFilter, dataStatusfilter, enableFilter, iscurrentversionFilter, initstatusFilter};
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        DynamicObject[] dynamicObjects = helper.queryOriginalArray("adminorg.boid, bsed," + selectSql, filters);
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("adminorg.boid"), Function.identity(), (oldV, newV) -> newV));
    }

    public Map<Integer, List<String>> getErrorMap() {
        return this.errorMap;
    }

    public void checkMustInput(int rowIndex, DynamicObject dataEntity, String operateKey) {
        if ("save".equals(operateKey)) {
            return;
        }
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        StringBuilder errroStr = new StringBuilder();
        String number = dataEntity.getString("number");
        if (StringUtils.isEmpty((CharSequence)number)) {
            errroStr.append(((IDataEntityProperty)properties.get((Object)"number")).getDisplayName().getLocaleValue()).append("\u3001");
        }
        if (dataEntity.getDate("bsed") == null) {
            errroStr.append(((IDataEntityProperty)properties.get((Object)"bsed")).getDisplayName().getLocaleValue()).append("\u3001");
        }
        if (dataEntity.getDynamicObject("changescene") == null) {
            errroStr.append(((IDataEntityProperty)properties.get((Object)"changescene")).getDisplayName().getLocaleValue()).append("\u3001");
        }
        if (errroStr.length() == 0) {
            return;
        }
        StringBuilder replaceError = errroStr.deleteCharAt(errroStr.length() - 1);
        this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u9879\u672a\u586b\u5199\uff1a%s, \u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_43", (String)"odc-homs-business", (Object[])new Object[0]), replaceError));
    }

    public void checkOrgAndBsed(DynamicObject dataEntity, int rowIndex) {
        Date bsed;
        long buid = dataEntity.getLong("org.id");
        if (buid != 0L && !this.buids.contains(buid)) {
            this.recordErrorMsgInMap(rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u9650\u5728\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7[%s]\u4e0b\u65b0\u589e\u7ec4\u7ec7;", (String)"FastchgImportValidateHelper_45", (String)"odc-homs-business", (Object[])new Object[0]), dataEntity.getLocaleString("org.name").getLocaleValue()));
        }
        if ((bsed = dataEntity.getDate("bsed")) != null && bsed.after(new Date())) {
            this.recordErrorMsgInMap(rowIndex, ResManager.loadKDString((String)"\u6210\u7acb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5f53\u524d\u65e5\u671f;", (String)"FastchgImportValidateHelper_50", (String)"odc-homs-business", (Object[])new Object[0]));
        }
    }

    public void checkNewImportOrgNumber() {
        ArrayList allNumbers = Lists.newArrayListWithExpectedSize((int)16);
        Map<String, String> onthewayMap = this.checkDtoList.stream().collect(Collectors.toMap(dto -> dto.getNumber(), dto -> dto.getBillNo(), (oldV, newV) -> newV));
        this.bsedMap.forEach((bsed, list) -> {
            ArrayList<DynamicObject> adminogrDys = new ArrayList<DynamicObject>(list.size());
            HashMap<Long, DynamicObject> orgDyMap = new HashMap<Long, DynamicObject>(list.size());
            for (ExtendedDataEntity extendedDataEntity : list) {
                DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                String number = dataEntity.getString("number");
                if (HRStringUtils.isNotEmpty((String)number)) {
                    allNumbers.add(number);
                    continue;
                }
                adminogrDys.add(AdminOrgBatchChgHelper.getAdminorgHrDy(dataEntity));
                orgDyMap.put(dataEntity.getLong("id"), dataEntity);
            }
            DynamicObject[] dysInDB = AdOrgRepository.getOrgDyArrByNumbers((List)allNumbers, (Date)bsed);
            Map<String, List<DynamicObject>> repeatMap = Arrays.stream(dysInDB).collect(Collectors.groupingBy(dy -> dy.getString("number")));
            list.forEach(ex -> {
                DynamicObject dataEntity = ex.getDataEntity();
                String number = dataEntity.getString("number");
                if (HRStringUtils.isNotEmpty((String)number) && repeatMap.containsKey(number)) {
                    List dynamicObjects = (List)repeatMap.get(number);
                    List repeatList = dynamicObjects.stream().sorted(Comparator.comparing(dy -> dy.getDate("bsled"))).collect(Collectors.toList());
                    Date orgBsed = ((DynamicObject)repeatList.get(0)).getDate("bsed");
                    Date start = orgBsed.after((Date)bsed) ? orgBsed : bsed;
                    Date end = ((DynamicObject)repeatList.get(repeatList.size() - 1)).getDate("bsled");
                    this.recordErrorMsgInMap(ex.getDataEntityIndex(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5728%1$s\u81f3%2$s\u671f\u95f4\uff0c\u6709\u76f8\u540c\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u5b58\u5728\uff0c\u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_47", (String)"odc-homs-business", (Object[])new Object[0]), HRDateTimeUtils.format((Date)start, (String)YYYY_MM_DD), HRDateTimeUtils.format((Date)end, (String)YYYY_MM_DD)));
                }
            });
            if (!CollectionUtils.isEmpty(adminogrDys)) {
                this.setOrgNumber((List<DynamicObject>)adminogrDys, onthewayMap, allNumbers, (Map<Long, DynamicObject>)orgDyMap, (Date)bsed);
            }
        });
        List duplicateNumbers = allNumbers.stream().collect(Collectors.toMap(nu -> nu, nu -> 1, (aa, bb) -> aa + bb)).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        Set<String> bosNumbers = OrgBatchBillCheckHelper.queryBosOrgNumberSet(null, new HashSet<String>(allNumbers));
        for (ExtendedDataEntity ex : this.dataEntities) {
            String number = ex.getDataEntity().getString("number");
            if (HRStringUtils.isEmpty((String)number)) continue;
            if (duplicateNumbers != null && !duplicateNumbers.isEmpty() && duplicateNumbers.contains(number)) {
                this.recordErrorMsgInMap(ex.getDataEntityIndex(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u201c%s\u201d\u5728\u672c\u6a21\u677f\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastchgImportValidateHelper_48", (String)"odc-homs-business", (Object[])new Object[0]), number));
            }
            if (onthewayMap != null && !onthewayMap.isEmpty() && onthewayMap.containsKey(number)) {
                this.recordErrorMsgInMap(ex.getDataEntityIndex(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728\u5728\u9014\u5355\u636e\uff08\u5355\u636e\u7f16\u53f7\uff1a%s\uff09\u4e2d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastchgImportValidateHelper_49", (String)"odc-homs-business", (Object[])new Object[0]), onthewayMap.get(number)));
            }
            if (bosNumbers != null && !bosNumbers.isEmpty() && bosNumbers.contains(number)) {
                this.recordErrorMsgInMap(ex.getDataEntityIndex(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u201c%s\u201d\u4e0e\u201c\u57fa\u7840\u670d\u52a1\u4e91>\u4f01\u4e1a\u5efa\u6a21>\u7ec4\u7ec7\u7ba1\u7406>\u884c\u653f\u7ec4\u7ec7/\u4e1a\u52a1\u5355\u5143\u201d\u4e2d\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastchgImportValidateHelper_59", (String)"odc-homs-business", (Object[])new Object[0]), number));
            }
            if (number.contains("!") || number.contains("\uff01")) {
                this.recordErrorMsgInMap(ex.getDataEntityIndex(), ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u4e2d\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\u201c!\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastchgImportValidateHelper_63", (String)"odc-homs-business", (Object[])new Object[0]));
            }
            if (!number.contains("!") && !number.contains("\uff01")) continue;
            this.recordErrorMsgInMap(ex.getDataEntityIndex(), ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u4e2d\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\u201c!\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastchgImportValidateHelper_63", (String)"odc-homs-business", (Object[])new Object[0]));
        }
    }

    private void setOrgNumber(List<DynamicObject> adminorgHrDys, Map<String, String> onthewayMap, List<String> allNumbers, Map<Long, DynamicObject> orgDyMap, Date bsed) {
        ArrayList<String> allOrgNumbers = new ArrayList<String>(allNumbers.size());
        allOrgNumbers.addAll(allNumbers);
        List orgNumbers = CodeRuleServiceHelper.getNumbers((String)"haos_adminorghr", adminorgHrDys);
        if (CollectionUtils.isEmpty((Collection)orgNumbers)) {
            return;
        }
        allOrgNumbers.addAll(orgNumbers);
        DynamicObject[] dysInDB = AdOrgRepository.getOrgDyArrByNumbers((List)orgNumbers, (Date)bsed);
        Map<String, List<DynamicObject>> repeatMap = Arrays.stream(dysInDB).collect(Collectors.groupingBy(dy -> dy.getString("number")));
        ArrayList<DynamicObject> orgHrDys = new ArrayList<DynamicObject>(adminorgHrDys.size());
        List duplicateNumbers = allOrgNumbers.stream().collect(Collectors.toMap(nu -> nu, nu -> 1, (aa, bb) -> aa + bb)).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        Set<String> bosNumbers = OrgBatchBillCheckHelper.queryBosOrgNumberSet(null, new HashSet<String>(orgNumbers));
        for (int i = 0; i < adminorgHrDys.size(); ++i) {
            if (orgNumbers.size() < i + 1 || !HRStringUtils.isNotEmpty((String)((String)orgNumbers.get(i)))) continue;
            String orgNumber = (String)orgNumbers.get(i);
            if (duplicateNumbers != null && !duplicateNumbers.isEmpty() && duplicateNumbers.contains(orgNumber) || onthewayMap != null && !onthewayMap.isEmpty() && onthewayMap.containsKey(orgNumber) || bosNumbers != null && !bosNumbers.isEmpty() && bosNumbers.contains(orgNumber) || repeatMap != null && !repeatMap.isEmpty() && repeatMap.containsKey(orgNumber)) {
                orgHrDys.add(adminorgHrDys.get(i));
                continue;
            }
            Long orgId = adminorgHrDys.get(i).getLong("id");
            DynamicObject orgDy = orgDyMap.get(orgId);
            orgDy.set("number", (Object)orgNumber);
        }
        if (!CollectionUtils.isEmpty(orgHrDys)) {
            this.setOrgNumber(orgHrDys, onthewayMap, allNumbers, orgDyMap, bsed);
        }
    }

    public void checkOperateTaskIng(DynamicObject dataEntity, int rowIndex, DynamicObject[] operateTaskIngArr) {
        Long orgId = dataEntity.getLong("boid");
        String orgStructLongNumber = dataEntity.getString("structlongnumber");
        for (DynamicObject orgOperateTask : operateTaskIngArr) {
            if (orgId.equals(orgOperateTask.getLong("adminorgid.id"))) {
                this.recordErrorMsgInMap(rowIndex, ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6b63\u5728\u6267\u884c\u201c\u53d8\u66f4\u201d\uff0c\u8bf7\u7a0d\u540e\u8fdb\u884c\u64cd\u4f5c\u3002\u53ef\u901a\u8fc7\u201c\u7ec4\u7ec7\u53d1\u5c55\u4e91>\u7ec4\u7ec7\u7ba1\u7406>\u7ec4\u7ec7\u5feb\u901f\u7ef4\u62a4\u201d\u70b9\u51fb\u201c\u66f4\u591a>\u67e5\u770b\u7ec4\u7ec7\u53d8\u52a8\u5f02\u6b65\u5904\u7406\u7ed3\u679c\u201d\u67e5\u770b\u5904\u7406\u8fdb\u5ea6\u3002", (String)"FastOrgOperateTaskCheckServiceImpl_0", (String)"odc-homs-business", (Object[])new Object[0]));
                return;
            }
            String operateTaskStructLongNumber = orgOperateTask.getString("structlongnumber");
            DynamicObject adminorg = orgOperateTask.getDynamicObject("adminorgid");
            if (orgId.equals(adminorg.getLong("id"))) continue;
            if (orgStructLongNumber.startsWith(operateTaskStructLongNumber)) {
                this.recordErrorMsgInMap(rowIndex, String.format(ResManager.loadKDString((String)"\u56e0\u4e0a\u7ea7\u7ec4\u7ec7\u201c%1$s\u201d/\u201c%2$s\u201d\u53d8\u66f4\u540c\u6b65\u66f4\u65b0\u672c\u7ec4\u7ec7\u7684\u4fe1\u606f\uff0c\u8be5\u52a8\u4f5c\u5c1a\u672a\u5b8c\u6210\uff0c\u8bf7\u7a0d\u540e\u8fdb\u884c\u64cd\u4f5c\u3002\u53ef\u901a\u8fc7\u201c\u7ec4\u7ec7\u53d1\u5c55\u4e91>\u7ec4\u7ec7\u7ba1\u7406>\u7ec4\u7ec7\u5feb\u901f\u7ef4\u62a4\u201d\u70b9\u51fb\u201c\u66f4\u591a>\u67e5\u770b\u7ec4\u7ec7\u53d8\u52a8\u5f02\u6b65\u5904\u7406\u7ed3\u679c\u201d\u67e5\u770b\u5904\u7406\u8fdb\u5ea6\u3002", (String)"FastOrgOperateTaskCheckServiceImpl_1", (String)"odc-homs-business", (Object[])new Object[0]), adminorg.getString("name"), adminorg.getString("number")));
                return;
            }
            if (!operateTaskStructLongNumber.startsWith(orgStructLongNumber)) continue;
            this.recordErrorMsgInMap(rowIndex, String.format(ResManager.loadKDString((String)"\u56e0\u672c\u7ec4\u7ec7\u53d8\u66f4\u9700\u8981\u540c\u6b65\u5904\u7406\u4e0b\u7ea7\u7ec4\u7ec7\u7684\u4fe1\u606f\uff0c\u4f46\u662f\u8fd9\u4e9b\u4e0b\u7ea7\u7ec4\u7ec7\u5728\u7ec4\u7ec7\u201c%1$s\u201d/\u201c%2$s\u201d\u53d8\u66f4\u4e8b\u52a1\u4e2d\u5c1a\u672a\u5b8c\u6210\uff0c\u8bf7\u7a0d\u540e\u8fdb\u884c\u64cd\u4f5c\u3002\u53ef\u901a\u8fc7\u201c\u7ec4\u7ec7\u53d1\u5c55\u4e91>\u7ec4\u7ec7\u7ba1\u7406>\u7ec4\u7ec7\u5feb\u901f\u7ef4\u62a4\u201d\u70b9\u51fb\u201c\u66f4\u591a>\u67e5\u770b\u7ec4\u7ec7\u53d8\u52a8\u5f02\u6b65\u5904\u7406\u7ed3\u679c\u201d\u67e5\u770b\u5904\u7406\u8fdb\u5ea6\u3002", (String)"FastOrgOperateTaskCheckServiceImpl_2", (String)"odc-homs-business", (Object[])new Object[0]), adminorg.getString("name"), adminorg.getString("number")));
            return;
        }
    }

    static {
        iLocaleStrings = new String[]{"name", "simplename", "detailaddress", "description", "safedescription", "positioning", "mainduty"};
        basedatas = new String[]{"adminorgtype.id", "parentorg.id", "corporateorg.id", "belongcompany.id", "adminorglayer.id", "adminorgfunction.id", "companyarea.id", "city.id", "workplace.id", "safelevel.id", "safetype.id"};
    }
}

