/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast.async;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.exception.KDBizException;
import kd.hr.homs.business.service.orgfast.async.AsyncEffectingReformHelper;
import kd.hr.homs.business.service.orgfast.async.event.AsyncEffectingEvent;
import kd.hr.homs.business.service.orgfast.async.listener.AbstractAsyncEffectingListener;
import kd.hr.homs.business.service.orgfast.async.listener.AsyncEffectingListener;

public class AsyncEffectingMultiCaster {
    public static final Integer OK = 1;
    public static final Integer ERROR = 0;
    List<AsyncEffectingListener> listeners = new ArrayList<AsyncEffectingListener>();

    public AsyncEffectingMultiCaster() {
        this.initSelf();
    }

    private void initSelf() {
        this.listeners.add(new AbstractAsyncEffectingListener.AsyncEffectingStartedListener());
        this.listeners.add(new AbstractAsyncEffectingListener.AsyncEffectingHandleCascadeListener());
        this.listeners.add(new AbstractAsyncEffectingListener.AsyncEffectingSaveAdminListener());
        this.listeners.add(new AbstractAsyncEffectingListener.AsyncEffectingSaveOtherListener());
        this.listeners.add(new AbstractAsyncEffectingListener.AsyncEffectingHandleOtherListener());
        this.listeners.add(new AbstractAsyncEffectingListener.AsyncEffectingSaveChangeDetailListener());
        this.listeners.add(new AbstractAsyncEffectingListener.AsyncEffectingSendMessageListener());
        this.listeners.add(new AbstractAsyncEffectingListener.AsyncEffectingSaveRollBackListener());
    }

    public void dispatchEvent(AsyncEffectingEvent effectingEvent) {
        Future submit = AsyncEffectingReformHelper.EVENT_HANDLE_THREAD_POOL.submit((Callable)new EventTask(this.listeners, effectingEvent));
        try {
            submit.get();
        }
        catch (Throwable throwable) {
            throw new KDBizException("AsyncEffectingReformHelper execute error");
        }
    }

    public static class EventTask
    implements Callable<Integer> {
        List<AsyncEffectingListener> listeners;
        AsyncEffectingEvent effectingEvent;

        public EventTask(List<AsyncEffectingListener> listeners, AsyncEffectingEvent effectingEvent) {
            this.listeners = listeners;
            this.effectingEvent = effectingEvent;
        }

        @Override
        public Integer call() throws Exception {
            Integer result = null;
            try {
                this.listeners.forEach(listener -> listener.onEvent(this.effectingEvent));
                result = OK;
            }
            catch (Exception ex) {
                result = ERROR;
            }
            return result;
        }
    }
}

