/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast.async;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.orgfast.async.ext.DefaultAsyncEffectingAffectSubService;
import kd.sdk.odc.homs.service.IAsyncEffectingAffectSubService;

public class AsyncEffectingReformHelper {
    private static final Log LOG = LogFactory.getLog(AsyncEffectingReformHelper.class);
    public static final ThreadPool SUBMIT_TASK_THREAD_POOL = ThreadPools.newCachedThreadPool((String)"AsyncEffectingReformHelper_submit", (int)1, (int)4);
    public static final ThreadPool EVENT_HANDLE_THREAD_POOL = ThreadPools.newCachedThreadPool((String)"AsyncEffectingReformHelper_eventHandle", (int)1, (int)4);
    public static final String STRUCT_PROJECT = "structproject";
    public static final String ADMIN_STD_TYPE = "adminorgtype.adminorgtypestd.id";
    public static final String ASYNC_SAVE = "async_save";
    public static final String HOMS_ORG_OPERATE_TASK = "homs_orgoperatetask";
    public static final HRBaseServiceHelper ORG_OPERATE_TASK = new HRBaseServiceHelper("homs_orgoperatetask");
    private static final HRBaseServiceHelper PARAM_HELPER = new HRBaseServiceHelper("haos_odcconfigparam");
    public static final HRBaseServiceHelper ADMIN_HELPER = new HRBaseServiceHelper("haos_adminorgdetail");
    private static final HRBaseServiceHelper ADMIN_STRUCT_HELPER = new HRBaseServiceHelper("haos_adminorgstruct");
    private static final HRBaseServiceHelper ADMIN_SORT_CODE_HELPER = new HRBaseServiceHelper("haos_orgsortcode");
    private static final DataEntityPropertyCollection EMPTY_STRUCT_DYN_PROPERTIES = ADMIN_STRUCT_HELPER.generateEmptyDynamicObject().getDynamicObjectType().getProperties();
    private static final QFilter STRUCT_Q_FILTER = new QFilter("structproject", "=", (Object)1010L);
    private static final long GROUP = 1010L;
    private static final long COMPANY = 1020L;
    private static final long AREA = 1030L;
    private static final long DEPARTMENT = 1040L;
    private static final Map<String, Boolean> BELONG_COMPANY_CHANGED = new HashMap<String, Boolean>();
    private static final QFilter IS_CURRENT_VERSION = new QFilter("iscurrentversion", "=", (Object)"1");

    public static int getThreshHold() {
        DynamicObject dynamicObject = PARAM_HELPER.queryOne("value", new QFilter[]{new QFilter("number", "=", (Object)"effectSubordinateThreshHold")});
        return dynamicObject == null ? Integer.MAX_VALUE : Integer.parseInt(dynamicObject.getString("value"));
    }

    public static boolean isRatherThreshHold(DynamicObject entity) {
        return AsyncEffectingReformHelper.getAffectSubordinate(entity) > AsyncEffectingReformHelper.getThreshHold();
    }

    public static int getAffectSubordinate(DynamicObject entity) {
        DynamicObject[] structLongNumbers;
        if (entity == null) {
            return 0;
        }
        long adminOrgBoId = entity.getLong("adminorg.boid");
        if (adminOrgBoId == 0L) {
            LOG.info("can not get adminorg boid");
            return 0;
        }
        QFilter qFilter = new QFilter("adminorg", "=", (Object)adminOrgBoId);
        qFilter.and(IS_CURRENT_VERSION);
        if (EMPTY_STRUCT_DYN_PROPERTIES.containsKey((Object)STRUCT_PROJECT)) {
            qFilter.and(STRUCT_Q_FILTER);
        }
        if ((structLongNumbers = ADMIN_STRUCT_HELPER.query("structlongnumber", new QFilter[]{qFilter})) == null || structLongNumbers.length <= 0) {
            LOG.info("can not get struct data , adminorg boid : {}", (Object)adminOrgBoId);
            return 0;
        }
        String structLongNumber = structLongNumbers[0].getString("structlongnumber");
        QFilter likeQFilter = new QFilter("structlongnumber", "like", (Object)(structLongNumber + "!%"));
        if (EMPTY_STRUCT_DYN_PROPERTIES.containsKey((Object)STRUCT_PROJECT)) {
            likeQFilter.and(STRUCT_Q_FILTER);
        }
        likeQFilter.and(IS_CURRENT_VERSION);
        DynamicObject[] subOgrArray = ADMIN_STRUCT_HELPER.query("structlongnumber,adminorg.id", new QFilter[]{likeQFilter});
        if (subOgrArray == null || subOgrArray.length <= 0) {
            LOG.info("this adminorg ha no subordinate");
            return 0;
        }
        Set allSubBoIdSet = Arrays.stream(subOgrArray).map(sub -> sub.getLong("adminorg.id")).collect(Collectors.toSet());
        HashSet effectedSubBoIdSet = new HashSet(allSubBoIdSet.size());
        QFilter adminQFilter = new QFilter("id", "=", (Object)adminOrgBoId);
        DynamicObject masterAdmin = ADMIN_HELPER.loadDynamicObject(new QFilter[]{adminQFilter});
        String name = entity.getDataEntityType().getName();
        boolean effectAll = false;
        if ("homs_orgfastchginfo".equals(name)) {
            int indexFromDB;
            int indexFromPage = entity.getInt("index");
            if (indexFromPage != (indexFromDB = masterAdmin.getInt("index"))) {
                effectAll = true;
            } else {
                long adminOrgStdIdFromPage = entity.getLong(ADMIN_STD_TYPE);
                long adminOrgStdIdFromDB = masterAdmin.getLong(ADMIN_STD_TYPE);
                if (Boolean.TRUE.equals(BELONG_COMPANY_CHANGED.get(adminOrgStdIdFromDB + "->" + adminOrgStdIdFromPage))) {
                    List allSubOrgBoId = Arrays.stream(subOgrArray).map(sub -> sub.getLong("adminorg.id")).collect(Collectors.toList());
                    QFilter belongCompanyQFilter = new QFilter("belongcompany", "=", (Object)masterAdmin.getLong("belongcompany.id"));
                    belongCompanyQFilter.and(new QFilter("id", "in", allSubOrgBoId));
                    DynamicObject[] query = ADMIN_HELPER.query("boid", new QFilter[]{belongCompanyQFilter});
                    effectedSubBoIdSet.addAll(Arrays.stream(query).map(admin -> admin.getLong("boid")).collect(Collectors.toSet()));
                }
            }
        } else if ("homs_orgfastchgparent".equals(name)) {
            effectAll = true;
        }
        if (!effectAll) {
            boolean hasExtendPlugins;
            PluginProxy iAsyncEffectingAffectSubServicePluginProxy = PluginProxy.create((Object)new DefaultAsyncEffectingAffectSubService(), IAsyncEffectingAffectSubService.class, (String)"kd.hr.homs.business.service.orgfast.async.ext.affectsub");
            boolean bl = hasExtendPlugins = iAsyncEffectingAffectSubServicePluginProxy.getPlugins().size() != 0;
            if (hasExtendPlugins) {
                iAsyncEffectingAffectSubServicePluginProxy.callReplace(plugin -> {
                    LOG.info(String.format("proxy plugin: %s", plugin.getClass()));
                    LOG.info("before callReplace calculateAffectSub");
                    plugin.calculateAffectSub(entity, masterAdmin, effectedSubBoIdSet);
                    LOG.info("after callReplace calculateAffectSub");
                    return null;
                });
            }
            return effectedSubBoIdSet.size();
        }
        return allSubBoIdSet.size();
    }

    public static void showConfirm(String operateKey, IFormView thatView, IDataModel thatModel, IFormPlugin iFormPlugin, DynamicObject dataEntity) {
        if ("save_donothing".equals(operateKey)) {
            if (AsyncEffectingReformHelper.isRatherThreshHold(dataEntity)) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("save_confirm", iFormPlugin);
                thatView.showConfirm(String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u672c\u6b21\u53d8\u66f4\u9700\u5904\u7406\u7ec4\u7ec7\u6570\u91cf\u8fc7\u5927\uff0c\u8017\u65f6\u8f83\u957f\uff0c\u4e3a\u907f\u514d\u60a8\u7b49\u5f85\u8f83\u957f\u65f6\u95f4\uff0c\u7cfb\u7edf\u5c06\u8fdb\u884c\u540e\u53f0\u5f02\u6b65\u5904\u7406\u3002\u540e\u53f0\u5f02\u6b65\u5904\u7406\u8fc7\u7a0b\u4e2d\uff0c\u8be5\u7ec4\u7ec7\u53ca\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u4e0d\u80fd\u518d\u6b21\u8fdb\u884c\u53d8\u66f4\u3002", (String)"AsyncEffectingReformHelper_0", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]), String.format(ResManager.loadKDString((String)"\u540e\u53f0\u6267\u884c\u8fc7\u7a0b\u4e2d\uff0c\u60a8\u53ef\u901a\u8fc7\u201c\u7ec4\u7ec7\u53d1\u5c55\u4e91>\u7ec4\u7ec7\u7ba1\u7406>\u7ec4\u7ec7\u5feb\u901f\u7ef4\u62a4\u201d\u70b9\u51fb\u201c\u66f4\u591a>\u67e5\u770b\u7ec4\u7ec7\u53d8\u52a8\u5f02\u6b65\u5904\u7406\u7ed3\u679c\u201d\u67e5\u770b\u5904\u7406\u8fdb\u5ea6\u3002", (String)"AsyncEffectingReformHelper_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener);
            } else {
                AsyncEffectingReformHelper.cancelConfirm(thatView, thatModel);
            }
        }
    }

    public static void cancelConfirm(IFormView thisView, IDataModel thisModel) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ignoreValidation", "true");
        OperationServiceImpl opImpl = new OperationServiceImpl();
        DynamicObject[] dyns = new DynamicObject[]{thisView.getModel().getDataEntity()};
        OperationResult operationResult = opImpl.localInvokeOperation("save", dyns, operateOption);
        if (operationResult.isSuccess()) {
            thisView.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AdminorgBatchBillPlugin_14", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            BillShowParameter formShowParameter = new BillShowParameter();
            formShowParameter.setFormId("homs_adminorgdetail");
            long entryid = thisModel.getDataEntity().getLong("entryid");
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("homs_batchorgentity");
            DynamicObject entryDy = hrBaseServiceHelper.queryOne("adminorg", new QFilter("id", "=", (Object)entryid));
            DynamicObject[] dynamicObjects = AdOrgRepository.getInstance().queryOrgInfoByBoId("id,boid,sourcevid,name,enable", Collections.singletonList(entryDy.getLong("adminorg.boid")));
            DynamicObject dynamicObject = dynamicObjects[0];
            formShowParameter.setPkId((Object)entryDy.getLong("adminorg.boid"));
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            String orgName = dynamicObject.getString("name");
            String caption = String.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7-%s", (String)"AdminorgDetailListPlugin_24", (String)"odc-homs-formplugin", (Object[])new Object[0]), orgName);
            formShowParameter.setCaption(caption);
            thisView.showForm((FormShowParameter)formShowParameter);
            thisView.getModel().setDataChanged(false);
            thisView.getPageCache().put("saveResult", "true");
            if (thisView.getParentView() != null && HRStringUtils.equals((String)thisView.getParentView().getEntityId(), (String)"homs_fastorgtreelist")) {
                if (HRStringUtils.equals((String)"homs_orgfastchginfo", (String)thisView.getEntityId())) {
                    long adminorgid = thisView.getModel().getDataEntity().getLong("adminorg.boid");
                    thisView.getParentView().getPageCache().put("searchnode", String.valueOf(adminorgid));
                } else {
                    long parentorgid = thisView.getModel().getDataEntity().getLong("parentorg.boid");
                    thisView.getParentView().getPageCache().put("searchnode", String.valueOf(parentorgid));
                }
                thisView.getParentView().getPageCache().put("delnode", String.valueOf(thisView.getModel().getDataEntity().getLong("adminorg.boid")));
                thisView.getParentView().invokeOperation("searchnode");
                thisView.sendFormAction(thisView.getParentView());
            }
            thisView.close();
        } else {
            thisView.showOperationResult(operationResult);
        }
    }

    public static void yesConfirm(IFormView thisView) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ignoreValidation", "true");
        operateOption.setVariableValue(ASYNC_SAVE, "true");
        OperationServiceImpl opImpl = new OperationServiceImpl();
        DynamicObject[] dyns = new DynamicObject[]{thisView.getModel().getDataEntity()};
        OperationResult operationResult = opImpl.localInvokeOperation("save", dyns, operateOption);
        if (operationResult.isSuccess()) {
            thisView.close();
        } else {
            thisView.showOperationResult(operationResult);
        }
    }

    static {
        BELONG_COMPANY_CHANGED.put("1010->1010", Boolean.FALSE);
        BELONG_COMPANY_CHANGED.put("1010->1020", Boolean.FALSE);
        BELONG_COMPANY_CHANGED.put("1010->1030", Boolean.TRUE);
        BELONG_COMPANY_CHANGED.put("1010->1040", Boolean.TRUE);
        BELONG_COMPANY_CHANGED.put("1020->1010", Boolean.FALSE);
        BELONG_COMPANY_CHANGED.put("1020->1020", Boolean.FALSE);
        BELONG_COMPANY_CHANGED.put("1020->1030", Boolean.TRUE);
        BELONG_COMPANY_CHANGED.put("1020->1040", Boolean.TRUE);
        BELONG_COMPANY_CHANGED.put("1030->1010", Boolean.TRUE);
        BELONG_COMPANY_CHANGED.put("1030->1020", Boolean.TRUE);
        BELONG_COMPANY_CHANGED.put("1030->1030", Boolean.FALSE);
        BELONG_COMPANY_CHANGED.put("1030->1040", Boolean.FALSE);
        BELONG_COMPANY_CHANGED.put("1040->1010", Boolean.TRUE);
        BELONG_COMPANY_CHANGED.put("1040->1020", Boolean.TRUE);
        BELONG_COMPANY_CHANGED.put("1040->1030", Boolean.FALSE);
        BELONG_COMPANY_CHANGED.put("1040->1040", Boolean.FALSE);
    }
}

