/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast.async;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.service.impl.orgmsg.CompanychangeMsgService;
import kd.hr.haos.business.domain.service.impl.orgmsg.OrgChangeMsgService;
import kd.hr.haos.business.service.orgchangetransaction.service.TransactionModelService;
import kd.hr.haos.business.service.orgchangetransaction.service.change.ChangeSceneSubService;
import kd.hr.homs.business.service.batcheffect.BatchEffectController;
import kd.hr.homs.business.service.chgbill.AdminChgDetailService;
import kd.hr.homs.business.service.orgfast.async.AsyncEffectingContext;
import kd.hr.homs.business.service.orgfast.async.AsyncEffectingMultiCaster;
import kd.hr.homs.business.service.orgfast.async.AsyncEffectingReformHelper;
import kd.hr.homs.business.service.orgfast.async.event.AsyncEffectingEvent;

public class AsyncEffectingTask
implements Runnable {
    private BatchEffectController effectController;
    private DynamicObject dataEntity;
    private Map<Long, List<Long>> sceneSubMap;
    private DynamicObject[] thisDataEntities;
    private DynamicObject thisBill;
    private AdminChgDetailService adminChgDetailService;
    private AsyncEffectingMultiCaster asyncEffectingMultiCaster;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (TXHandle required = TX.required();){
            boolean success = false;
            this.asyncEffectingMultiCaster = new AsyncEffectingMultiCaster();
            AsyncEffectingContext context = new AsyncEffectingContext();
            DynamicObject dynamicObject = AsyncEffectingReformHelper.ADMIN_HELPER.loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)this.dataEntity.getLong("adminorg.boid"))});
            context.setOrg(dynamicObject);
            context.setChangeOperateId(this.dataEntity.getLong("changetype.id"));
            try {
                this.sceneSubMap = new ChangeSceneSubService().getSceneSubId(Collections.singletonList(this.dataEntity));
                this.asyncEffectingMultiCaster.dispatchEvent(new AsyncEffectingEvent.AsyncEffectingStartedEvent(context.resetToStarted()));
                this.effectController = BatchEffectController.createBatchEffectWithMultiCasterController(this.thisBill, this.thisDataEntities, "0", this.asyncEffectingMultiCaster, context);
                this.effectController.saveAdminOrgAndBillEntryWithMultiCaster();
                TransactionModelService transactionService = new TransactionModelService();
                transactionService.changeTransactionSave(Long.valueOf(1010L), Long.valueOf(this.thisBill.getLong("id")), false, this.thisDataEntities, this.sceneSubMap);
                this.asyncEffectingMultiCaster.dispatchEvent(new AsyncEffectingEvent.AsyncEffectingSaveChangeDetailEvent(context.resetToStartThirdStep()));
                this.adminChgDetailService.saveAdminOrgChgDetail(this.thisBill, this.thisDataEntities);
                this.asyncEffectingMultiCaster.dispatchEvent(new AsyncEffectingEvent.AsyncEffectingSaveChangeDetailEvent(context.resetToEndThirdStep()));
                success = true;
                if (success) {
                    this.asyncEffectingMultiCaster.dispatchEvent(new AsyncEffectingEvent.AsyncEffectingSendMessageEvent(context.resetToStartFourthStep()));
                    this.sendEffectMsg(this.dataEntity, this.sceneSubMap);
                    List<DynamicObject> companyChangeOrgList = this.effectController.getCompanyChangeOrgList();
                    this.sendCompanyChangeMsg(companyChangeOrgList);
                    this.asyncEffectingMultiCaster.dispatchEvent(new AsyncEffectingEvent.AsyncEffectingSendMessageEvent(context.resetToEndFourthStep()));
                    this.asyncEffectingMultiCaster.dispatchEvent(new AsyncEffectingEvent.AsyncEffectingHandleOtherEvent(context.resetToStartFifthStep()));
                    this.effectController.afterEffectBill();
                    this.asyncEffectingMultiCaster.dispatchEvent(new AsyncEffectingEvent.AsyncEffectingHandleOtherEvent(context.resetToEndFifthStep()));
                }
            }
            catch (Throwable throwable) {
                try {
                    required.markRollback();
                    this.asyncEffectingMultiCaster.dispatchEvent(new AsyncEffectingEvent.AsyncEffectingSaveRollBackEvent(context.resetToRollBackStep(throwable)));
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (success) {
                        this.asyncEffectingMultiCaster.dispatchEvent(new AsyncEffectingEvent.AsyncEffectingSendMessageEvent(context.resetToStartFourthStep()));
                        this.sendEffectMsg(this.dataEntity, this.sceneSubMap);
                        List<DynamicObject> companyChangeOrgList = this.effectController.getCompanyChangeOrgList();
                        this.sendCompanyChangeMsg(companyChangeOrgList);
                        this.asyncEffectingMultiCaster.dispatchEvent(new AsyncEffectingEvent.AsyncEffectingSendMessageEvent(context.resetToEndFourthStep()));
                        this.asyncEffectingMultiCaster.dispatchEvent(new AsyncEffectingEvent.AsyncEffectingHandleOtherEvent(context.resetToStartFifthStep()));
                        this.effectController.afterEffectBill();
                        this.asyncEffectingMultiCaster.dispatchEvent(new AsyncEffectingEvent.AsyncEffectingHandleOtherEvent(context.resetToEndFifthStep()));
                    }
                }
            }
        }
    }

    protected void sendEffectMsg(DynamicObject dataEntity, Map<Long, List<Long>> sceneSubMap) {
        OrgChangeMsgService changeMsgService = new OrgChangeMsgService();
        changeMsgService.handleChangeMsg(Collections.singletonList(dataEntity), sceneSubMap, "C");
    }

    private void sendCompanyChangeMsg(List<DynamicObject> companyChangeOrgList) {
        CompanychangeMsgService companychangeMsgService = new CompanychangeMsgService();
        companychangeMsgService.handleChangeMsg(companyChangeOrgList, null, "C");
    }

    public AsyncEffectingMultiCaster getAsyncEffectingMultiCaster() {
        return this.asyncEffectingMultiCaster;
    }

    public void setAsyncEffectingMultiCaster(AsyncEffectingMultiCaster asyncEffectingMultiCaster) {
        this.asyncEffectingMultiCaster = asyncEffectingMultiCaster;
    }

    public DynamicObject getDataEntity() {
        return this.dataEntity;
    }

    public void setDataEntity(DynamicObject dataEntity) {
        this.dataEntity = dataEntity;
    }

    public Map<Long, List<Long>> getSceneSubMap() {
        return this.sceneSubMap;
    }

    public void setSceneSubMap(Map<Long, List<Long>> sceneSubMap) {
        this.sceneSubMap = sceneSubMap;
    }

    public DynamicObject[] getThisDataEntities() {
        return this.thisDataEntities;
    }

    public void setThisDataEntities(DynamicObject[] thisDataEntities) {
        this.thisDataEntities = thisDataEntities;
    }

    public DynamicObject getThisBill() {
        return this.thisBill;
    }

    public void setThisBill(DynamicObject thisBill) {
        this.thisBill = thisBill;
    }

    public AdminChgDetailService getAdminChgDetailService() {
        return this.adminChgDetailService;
    }

    public void setAdminChgDetailService(AdminChgDetailService adminChgDetailService) {
        this.adminChgDetailService = adminChgDetailService;
    }

    public static class AsyncEffectingTaskBuilder {
        private DynamicObject[] thisDataEntities;
        private DynamicObject thisBill;
        private AdminChgDetailService adminChgDetailService;
        private DynamicObject dataEntity;

        public AsyncEffectingTaskBuilder thisDataEntities(DynamicObject[] thisDataEntities) {
            this.thisDataEntities = thisDataEntities;
            return this;
        }

        public AsyncEffectingTaskBuilder dataEntity(DynamicObject dataEntity) {
            this.dataEntity = dataEntity;
            return this;
        }

        public AsyncEffectingTaskBuilder thisBill(DynamicObject thisBill) {
            this.thisBill = thisBill;
            return this;
        }

        public AsyncEffectingTaskBuilder adminChgDetailService(AdminChgDetailService adminChgDetailService) {
            this.adminChgDetailService = adminChgDetailService;
            return this;
        }

        public AsyncEffectingTask build() {
            AsyncEffectingTask asyncEffectingTask = new AsyncEffectingTask();
            asyncEffectingTask.setAdminChgDetailService(this.adminChgDetailService);
            asyncEffectingTask.setThisDataEntities(this.thisDataEntities);
            asyncEffectingTask.setThisBill(this.thisBill);
            asyncEffectingTask.setDataEntity(this.dataEntity);
            return asyncEffectingTask;
        }
    }
}

