/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast.async.listener;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.homs.business.domain.repository.OrgOperateTaskRepository;
import kd.hr.homs.business.service.helper.AdminOrgFastChgHelper;
import kd.hr.homs.business.service.orgfast.async.AsyncEffectingContext;
import kd.hr.homs.business.service.orgfast.async.event.AsyncEffectingEvent;
import kd.hr.homs.business.service.orgfast.async.listener.AsyncEffectingListener;
import kd.hr.homs.common.constants.fastchg.OrgOperateTaskConstants;

public abstract class AbstractAsyncEffectingListener<T extends EventObject>
implements AsyncEffectingListener {
    protected abstract T castEventType(EventObject var1);

    @Override
    public void onEvent(EventObject eventObject) {
        block18: {
            if (!this.isCanHandleEventObject(eventObject)) {
                return;
            }
            try (TXHandle required = TX.required();){
                try {
                    T t = this.castEventType(eventObject);
                    AsyncEffectingContext context = this.castSourceToContext(((EventObject)t).getSource());
                    if (1 == context.getEventSwitchType()) {
                        this.executeTransactionStartTime(context, t);
                        break block18;
                    }
                    if (0 == context.getEventSwitchType()) {
                        this.executeTransactionEndTime(context, t);
                        break block18;
                    }
                    if (2 == context.getEventSwitchType()) {
                        this.executeTransactionNoTime(context, t);
                        break block18;
                    }
                    this.getLogger().error("no such event switch type");
                }
                catch (Throwable ex) {
                    required.markRollback();
                    this.getLogger().error("on event error", ex);
                }
            }
        }
    }

    protected abstract boolean isCanHandleEventObject(EventObject var1);

    protected AsyncEffectingContext castSourceToContext(Object source) {
        return (AsyncEffectingContext)source;
    }

    protected abstract void executeTransactionStartTime(AsyncEffectingContext var1, T var2);

    protected abstract void executeTransactionEndTime(AsyncEffectingContext var1, T var2);

    protected abstract void executeTransactionNoTime(AsyncEffectingContext var1, T var2);

    protected abstract Log getLogger();

    public static void executeTransaction(AsyncEffectingContext context, boolean start) {
        Long operatorId = context.getOperatorId();
        DynamicObject[] orgOperateTaskByOrgId = OrgOperateTaskRepository.getInstance().loadByIds(Collections.singleton(operatorId));
        if (orgOperateTaskByOrgId == null || orgOperateTaskByOrgId.length <= 0) {
            return;
        }
        DynamicObject dynamicObject = orgOperateTaskByOrgId[0];
        if (!start && context.getStep() != null && context.getStep().equals(OrgOperateTaskConstants.SETPS_FIFTH)) {
            dynamicObject.set("savestatus", (Object)"2");
        }
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
        DynamicObject targetDynamicObject = null;
        for (DynamicObject dyn : dynamicObjectCollection) {
            if (context.getStep() == null || !context.getStep().equals(dyn.getLong("opstepsid.id"))) continue;
            targetDynamicObject = dyn;
            break;
        }
        if (targetDynamicObject == null) {
            return;
        }
        if (start) {
            targetDynamicObject.set("starttime", (Object)new Date());
            targetDynamicObject.set("stepsstatus", (Object)"1");
        } else {
            targetDynamicObject.set("endtime", (Object)new Date());
            targetDynamicObject.set("stepsstatus", (Object)"2");
        }
        OrgOperateTaskRepository.getInstance().update(new DynamicObject[]{dynamicObject});
    }

    protected void defaultExecuteTransactionImpl(AsyncEffectingContext context) {
    }

    public static class AsyncEffectingSaveRollBackListener
    extends AbstractAsyncEffectingListener<AsyncEffectingEvent.AsyncEffectingSaveRollBackEvent> {
        private static final Log LOG = LogFactory.getLog(AsyncEffectingSaveChangeDetailListener.class);

        @Override
        protected AsyncEffectingEvent.AsyncEffectingSaveRollBackEvent castEventType(EventObject eventObject) {
            return (AsyncEffectingEvent.AsyncEffectingSaveRollBackEvent)eventObject;
        }

        @Override
        protected boolean isCanHandleEventObject(EventObject eventObject) {
            return eventObject instanceof AsyncEffectingEvent.AsyncEffectingSaveRollBackEvent;
        }

        @Override
        protected void executeTransactionStartTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingSaveRollBackEvent event) {
            super.defaultExecuteTransactionImpl(context);
        }

        @Override
        protected void executeTransactionEndTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingSaveRollBackEvent event) {
            super.defaultExecuteTransactionImpl(context);
        }

        @Override
        protected void executeTransactionNoTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingSaveRollBackEvent event) {
            Long operatorId = context.getOperatorId();
            DynamicObject[] orgOperateTaskByOrgId = OrgOperateTaskRepository.getInstance().loadByIds(Collections.singleton(operatorId));
            if (orgOperateTaskByOrgId == null || orgOperateTaskByOrgId.length <= 0) {
                return;
            }
            DynamicObject dynamicObject = orgOperateTaskByOrgId[0];
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
            dynamicObject.set("savestatus", (Object)"3");
            if (context.getThrowable() != null) {
                String message = context.getThrowable().getMessage();
                if (message != null && message.length() < 2000) {
                    dynamicObject.set("errormessage", (Object)message);
                } else if (message != null) {
                    dynamicObject.set("errormessage", (Object)message.substring(0, 2000));
                } else {
                    dynamicObject.set("errormessage", (Object)"please check error message in log file");
                }
                this.getLogger().error("AsyncEffectingSaveRollBackListener error: ", context.getThrowable());
            }
            for (DynamicObject dyn : dynamicObjectCollection) {
                if (!"2".equals(dyn.getString("stepsstatus"))) continue;
                dyn.set("stepsstatus", (Object)"4");
            }
            OrgOperateTaskRepository.getInstance().update(new DynamicObject[]{dynamicObject});
        }

        @Override
        protected Log getLogger() {
            return LOG;
        }
    }

    public static class AsyncEffectingSendMessageListener
    extends AbstractAsyncEffectingListener<AsyncEffectingEvent.AsyncEffectingSendMessageEvent> {
        private static final Log LOG = LogFactory.getLog(AsyncEffectingSaveChangeDetailListener.class);

        @Override
        protected AsyncEffectingEvent.AsyncEffectingSendMessageEvent castEventType(EventObject eventObject) {
            return (AsyncEffectingEvent.AsyncEffectingSendMessageEvent)eventObject;
        }

        @Override
        protected boolean isCanHandleEventObject(EventObject eventObject) {
            return eventObject instanceof AsyncEffectingEvent.AsyncEffectingSendMessageEvent;
        }

        @Override
        protected void executeTransactionStartTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingSendMessageEvent event) {
            AsyncEffectingSendMessageListener.executeTransaction(context, true);
        }

        @Override
        protected void executeTransactionEndTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingSendMessageEvent event) {
            AsyncEffectingSendMessageListener.executeTransaction(context, false);
        }

        @Override
        protected void executeTransactionNoTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingSendMessageEvent event) {
            super.defaultExecuteTransactionImpl(context);
        }

        @Override
        protected Log getLogger() {
            return LOG;
        }
    }

    public static class AsyncEffectingSaveChangeDetailListener
    extends AbstractAsyncEffectingListener<AsyncEffectingEvent.AsyncEffectingSaveChangeDetailEvent> {
        private static final Log LOG = LogFactory.getLog(AsyncEffectingSaveChangeDetailListener.class);

        @Override
        protected AsyncEffectingEvent.AsyncEffectingSaveChangeDetailEvent castEventType(EventObject eventObject) {
            return (AsyncEffectingEvent.AsyncEffectingSaveChangeDetailEvent)eventObject;
        }

        @Override
        protected boolean isCanHandleEventObject(EventObject eventObject) {
            return eventObject instanceof AsyncEffectingEvent.AsyncEffectingSaveChangeDetailEvent;
        }

        @Override
        protected void executeTransactionStartTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingSaveChangeDetailEvent event) {
            AsyncEffectingSaveChangeDetailListener.executeTransaction(context, true);
        }

        @Override
        protected void executeTransactionEndTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingSaveChangeDetailEvent event) {
            AsyncEffectingSaveChangeDetailListener.executeTransaction(context, false);
        }

        @Override
        protected void executeTransactionNoTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingSaveChangeDetailEvent event) {
            super.defaultExecuteTransactionImpl(context);
        }

        @Override
        protected Log getLogger() {
            return LOG;
        }
    }

    public static class AsyncEffectingHandleOtherListener
    extends AbstractAsyncEffectingListener<AsyncEffectingEvent.AsyncEffectingHandleOtherEvent> {
        private static final Log LOG = LogFactory.getLog(AsyncEffectingHandleOtherListener.class);

        @Override
        protected AsyncEffectingEvent.AsyncEffectingHandleOtherEvent castEventType(EventObject eventObject) {
            return (AsyncEffectingEvent.AsyncEffectingHandleOtherEvent)eventObject;
        }

        @Override
        protected boolean isCanHandleEventObject(EventObject eventObject) {
            return eventObject instanceof AsyncEffectingEvent.AsyncEffectingHandleOtherEvent;
        }

        @Override
        protected void executeTransactionStartTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingHandleOtherEvent event) {
            AsyncEffectingHandleOtherListener.executeTransaction(context, true);
        }

        @Override
        protected void executeTransactionEndTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingHandleOtherEvent event) {
            AsyncEffectingHandleOtherListener.executeTransaction(context, false);
        }

        @Override
        protected void executeTransactionNoTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingHandleOtherEvent event) {
            super.defaultExecuteTransactionImpl(context);
        }

        @Override
        protected Log getLogger() {
            return LOG;
        }
    }

    public static class AsyncEffectingSaveOtherListener
    extends AbstractAsyncEffectingListener<AsyncEffectingEvent.AsyncEffectingSaveOtherEvent> {
        private static final Log LOG = LogFactory.getLog(AsyncEffectingSaveOtherListener.class);

        @Override
        protected AsyncEffectingEvent.AsyncEffectingSaveOtherEvent castEventType(EventObject eventObject) {
            return (AsyncEffectingEvent.AsyncEffectingSaveOtherEvent)eventObject;
        }

        @Override
        protected boolean isCanHandleEventObject(EventObject eventObject) {
            return eventObject instanceof AsyncEffectingEvent.AsyncEffectingSaveOtherEvent;
        }

        @Override
        protected void executeTransactionStartTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingSaveOtherEvent event) {
            AsyncEffectingSaveOtherListener.executeTransaction(context, true);
        }

        @Override
        protected void executeTransactionEndTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingSaveOtherEvent event) {
            AsyncEffectingSaveOtherListener.executeTransaction(context, false);
        }

        @Override
        protected void executeTransactionNoTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingSaveOtherEvent event) {
            super.defaultExecuteTransactionImpl(context);
        }

        @Override
        protected Log getLogger() {
            return LOG;
        }
    }

    public static class AsyncEffectingSaveAdminListener
    extends AbstractAsyncEffectingListener<AsyncEffectingEvent.AsyncEffectingSaveAdminEvent> {
        private static final Log LOG = LogFactory.getLog(AsyncEffectingSaveAdminListener.class);

        @Override
        protected AsyncEffectingEvent.AsyncEffectingSaveAdminEvent castEventType(EventObject eventObject) {
            return (AsyncEffectingEvent.AsyncEffectingSaveAdminEvent)eventObject;
        }

        @Override
        protected boolean isCanHandleEventObject(EventObject eventObject) {
            return eventObject instanceof AsyncEffectingEvent.AsyncEffectingSaveAdminEvent;
        }

        @Override
        protected void executeTransactionStartTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingSaveAdminEvent event) {
            AsyncEffectingSaveAdminListener.executeTransaction(context, true);
        }

        @Override
        protected void executeTransactionEndTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingSaveAdminEvent event) {
            AsyncEffectingSaveAdminListener.executeTransaction(context, false);
        }

        @Override
        protected void executeTransactionNoTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingSaveAdminEvent event) {
            super.defaultExecuteTransactionImpl(context);
        }

        @Override
        protected Log getLogger() {
            return LOG;
        }
    }

    public static class AsyncEffectingHandleCascadeListener
    extends AbstractAsyncEffectingListener<AsyncEffectingEvent.AsyncEffectingHandleCascadeEvent> {
        private static final Log LOG = LogFactory.getLog(AsyncEffectingHandleCascadeListener.class);

        @Override
        protected AsyncEffectingEvent.AsyncEffectingHandleCascadeEvent castEventType(EventObject eventObject) {
            return (AsyncEffectingEvent.AsyncEffectingHandleCascadeEvent)eventObject;
        }

        @Override
        protected boolean isCanHandleEventObject(EventObject eventObject) {
            return eventObject instanceof AsyncEffectingEvent.AsyncEffectingHandleCascadeEvent;
        }

        @Override
        protected void executeTransactionStartTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingHandleCascadeEvent event) {
            AsyncEffectingHandleCascadeListener.executeTransaction(context, true);
        }

        @Override
        protected void executeTransactionEndTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingHandleCascadeEvent event) {
            AsyncEffectingHandleCascadeListener.executeTransaction(context, false);
        }

        @Override
        protected void executeTransactionNoTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingHandleCascadeEvent event) {
            super.defaultExecuteTransactionImpl(context);
        }

        @Override
        protected Log getLogger() {
            return LOG;
        }
    }

    public static class AsyncEffectingStartedListener
    extends AbstractAsyncEffectingListener<AsyncEffectingEvent.AsyncEffectingStartedEvent> {
        private static final Log LOG = LogFactory.getLog(AsyncEffectingStartedListener.class);

        @Override
        protected AsyncEffectingEvent.AsyncEffectingStartedEvent castEventType(EventObject eventObject) {
            return (AsyncEffectingEvent.AsyncEffectingStartedEvent)eventObject;
        }

        @Override
        protected boolean isCanHandleEventObject(EventObject eventObject) {
            return eventObject instanceof AsyncEffectingEvent.AsyncEffectingStartedEvent;
        }

        @Override
        protected void executeTransactionStartTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingStartedEvent event) {
            super.defaultExecuteTransactionImpl(context);
        }

        @Override
        protected void executeTransactionEndTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingStartedEvent event) {
            super.defaultExecuteTransactionImpl(context);
        }

        @Override
        protected void executeTransactionNoTime(AsyncEffectingContext context, AsyncEffectingEvent.AsyncEffectingStartedEvent event) {
            DynamicObject newOperateTaskDy = AdminOrgFastChgHelper.createNewOperateTaskDy(context.getOrg(), context.getChangeOperateId());
            OrgOperateTaskRepository.getInstance().save(new DynamicObject[]{newOperateTaskDy});
            context.setOperatorId(newOperateTaskDy.getLong("id"));
        }

        @Override
        protected Log getLogger() {
            return LOG;
        }
    }
}

