/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast.revise;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.helper.AdminOrgFastChgHelper;
import kd.hr.homs.business.service.orgfast.revise.AdminOrgTypeRecognized;
import kd.hr.homs.business.service.orgfast.revise.AdminTypeChange;

public class AdminOrgReviseCompareService {
    public List<String> baseInfo = new ArrayList<String>(Arrays.asList("number", "name", "simplename", "adminorgtype", "parentorg", "establishmentdate", "org", "belongcompany", "corporateorg", "adminorglayer", "adminorgfunction", "tobedisableflag", "tobedisabledate", "enable", "companyarea", "city", "workplace", "detailaddress", "description", "index", "positioning", "mainduty", "safelevel", "safetype", "safedescription"));
    public static List<String> companyInfo = Arrays.asList("companytype", "industrytype");
    public static List<String> groupInfo = Arrays.asList("groupvision", "groupmission");
    public static List<String> departmentInfo = new ArrayList<String>(){
        {
            this.add("departmenttype");
        }
    };
    public static Set<String> chooseBoIdProps = new HashSet<String>(){
        {
            this.add("parentorg");
            this.add("belongcompany");
        }
    };
    public final DynamicObject needRevisedHisOrg;
    public final DynamicObject hisAdminFromDb;

    public AdminOrgReviseCompareService(DynamicObject needRevisedHisOrg, DynamicObject hisAdminFromDb) {
        if ("1".equals(needRevisedHisOrg.getString("isfirstversionnoparent"))) {
            needRevisedHisOrg.set("parentorg", null);
        }
        this.needRevisedHisOrg = needRevisedHisOrg;
        this.hisAdminFromDb = hisAdminFromDb;
    }

    public List<String> compareExceptFourLayer() {
        ArrayList<String> changedProperties = new ArrayList<String>(16);
        long originalAdminOrgType = this.hisAdminFromDb.getLong("adminorgtype.adminorgtypestd.id");
        long afterAdminOrgType = this.needRevisedHisOrg.getLong("adminorgtype.adminorgtypestd.id");
        long orgBoId = this.needRevisedHisOrg.getLong("boid");
        Date bseDate = this.needRevisedHisOrg.getDate("bsed");
        AdminTypeChange recognized = AdminOrgTypeRecognized.recognized(originalAdminOrgType, afterAdminOrgType);
        if (recognized != null) {
            switch (recognized) {
                case GROUP_TO_GROUP: {
                    DynamicObject group = AdminOrgFastChgHelper.getGroup(orgBoId, bseDate);
                    DynamicObject comp = AdminOrgFastChgHelper.getCompany(orgBoId, bseDate);
                    if (group != null) {
                        changedProperties.addAll(AdminOrgReviseCompareService.compare(group, this.needRevisedHisOrg, groupInfo));
                    }
                    if (comp == null) break;
                    changedProperties.addAll(AdminOrgReviseCompareService.compare(comp, this.needRevisedHisOrg, companyInfo));
                    break;
                }
                case COMPANY_TO_COMPANY: {
                    DynamicObject company = AdminOrgFastChgHelper.getCompany(orgBoId, bseDate);
                    if (company == null) break;
                    changedProperties.addAll(AdminOrgReviseCompareService.compare(company, this.needRevisedHisOrg, companyInfo));
                    break;
                }
                case DEPARTMENT_TO_DEPARTMENT: {
                    DynamicObject department = AdminOrgFastChgHelper.getDepartment(orgBoId, bseDate);
                    if (department == null) break;
                    changedProperties.addAll(AdminOrgReviseCompareService.compare(department, this.needRevisedHisOrg, departmentInfo));
                    break;
                }
            }
        }
        changedProperties.addAll(AdminOrgReviseCompareService.compare(this.needRevisedHisOrg, this.hisAdminFromDb, this.baseInfo));
        return changedProperties;
    }

    public static List<String> compare(DynamicObject hisAdmin, DynamicObject hisAdminFromDb, List<String> baseInfo) {
        ArrayList<String> list = new ArrayList<String>();
        for (String property : baseInfo) {
            Object be = hisAdmin.get(property);
            Object af = hisAdminFromDb.get(property);
            if (be instanceof DynamicObject && af instanceof DynamicObject) {
                long id2;
                long id1 = ((DynamicObject)be).getLong(chooseBoIdProps.contains(property) ? "boid" : "id");
                if (id1 == (id2 = ((DynamicObject)af).getLong(chooseBoIdProps.contains(property) ? "boid" : "id"))) continue;
                list.add(property);
                continue;
            }
            if (be instanceof OrmLocaleValue && af instanceof OrmLocaleValue) {
                AtomicBoolean breaked = new AtomicBoolean(false);
                ((OrmLocaleValue)be).forEach((beCode, beNameVal) -> {
                    if (HRStringUtils.equals((String)"GLang", (String)beCode)) {
                        return;
                    }
                    String afterVal = ((OrmLocaleValue)af).get(beCode);
                    if (afterVal == null && !HRStringUtils.isEmpty((String)beNameVal) && !breaked.get()) {
                        list.add(property);
                        breaked.set(true);
                        return;
                    }
                    if (!breaked.get() && !HRStringUtils.equals((String)beNameVal, (String)afterVal)) {
                        list.add(property);
                        breaked.set(true);
                        return;
                    }
                });
                ((OrmLocaleValue)af).forEach((afCode, afNameVal) -> {
                    if (HRStringUtils.equals((String)"GLang", (String)afCode)) {
                        return;
                    }
                    String beVal = ((OrmLocaleValue)be).get(afCode);
                    if (beVal == null && !HRStringUtils.isEmpty((String)afNameVal) && !breaked.get()) {
                        list.add(property);
                        breaked.set(true);
                        return;
                    }
                });
                continue;
            }
            if (be == null && af == null || be != null && af != null && be.equals(af)) continue;
            list.add(property);
        }
        return list;
    }
}

