/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast.revise;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.haos.business.util.TimeLogger;
import kd.hr.homs.business.service.helper.AdminOrgFastChgHelper;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.orgfast.revise.EmptyReviseValidator;
import kd.hr.homs.business.service.orgfast.revise.EstablishmentDateReviseValidator;
import kd.hr.homs.business.service.orgfast.revise.InBillNameReviseValidator;
import kd.hr.homs.business.service.orgfast.revise.InBillNumberReviseValidator;
import kd.hr.homs.business.service.orgfast.revise.InBillParentCyclicReviseValidator;
import kd.hr.homs.business.service.orgfast.revise.InBillTobeDisabledReviseValidator;
import kd.hr.homs.business.service.orgfast.revise.InBillUpFourLayerReviseValidator;
import kd.hr.homs.business.service.orgfast.revise.NameReviseValidator;
import kd.hr.homs.business.service.orgfast.revise.NumberReviseValidator;
import kd.hr.homs.business.service.orgfast.revise.ParentCyclicReviseValidator;
import kd.hr.homs.business.service.orgfast.revise.ReviseDateReviseValidator;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidateData;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidator;
import kd.hr.homs.business.service.orgfast.revise.TobeDisabledReviseValidator;
import kd.hr.homs.business.service.orgfast.revise.UpFourLayerReviseValidator;
import kd.hr.homs.common.model.CalibratorBean;

public class AdminOrgReviseValidatorContext {
    private DynamicObject needRevisedHisOrg;
    private DynamicObject hisAdminFromDb;
    private ReviseValidator headReviseValidator;
    private ReviseValidateData reviseValidateData;
    private List<String> changedProperties;
    private boolean isCurrentHis;
    static Map<String, Optional<Supplier<ReviseValidator>>> validatorFactory = new HashMap<String, Optional<Supplier<ReviseValidator>>>(16);
    static List<String> needQueryDbProperties = new ArrayList<String>(Arrays.asList("name", "number", "adminorgtype", "parentorg"));
    private TimeLogger timeLogger = TimeLogger.create();

    public AdminOrgReviseValidatorContext(DynamicObject needRevisedHisOrg, DynamicObject hisAdminFromDb, List<String> changedProperties, boolean isCurrentHis) {
        this.needRevisedHisOrg = needRevisedHisOrg;
        this.hisAdminFromDb = hisAdminFromDb;
        this.changedProperties = changedProperties;
        this.headReviseValidator = new EmptyReviseValidator(isCurrentHis);
        this.isCurrentHis = isCurrentHis;
        this.initSelf();
    }

    private void initSelf() {
        Date bsed = this.needRevisedHisOrg.getDate("bsed");
        Date bsled = this.needRevisedHisOrg.getDate("bsled");
        long parentBoId = this.needRevisedHisOrg.getLong("parentorg.boid");
        String number = this.needRevisedHisOrg.getString("number");
        long orgBoId = this.needRevisedHisOrg.getLong("boid");
        this.reviseValidateData = new ReviseValidateData();
        this.reviseValidateData.setNeedRevisedHisOrg(this.needRevisedHisOrg);
        this.reviseValidateData.setCurrentVersion(this.isCurrentHis);
        this.timeLogger.start();
        if (this.changedProperties.contains("establishmentdate")) {
            this.reviseValidateData.setEstablishmentDateChanged(true);
        }
        this.queryDataOnConditional(bsed, bsled, parentBoId, number, orgBoId);
        this.reviseValidateData.setHisDynamicObjectFromDb(this.hisAdminFromDb);
        if (this.changedProperties.contains("adminorgtype") || this.changedProperties.contains("parentorg")) {
            this.reviseValidateData.setAdminOrgTypeNameMap(OrgBatchBillCheckHelper.queryAdminOrgTypeNameMap(this.needRevisedHisOrg.getLong("org.id")));
            this.timeLogger.check("OrgBatchBillCheckHelper.queryAdminOrgTypeNameMap(needRevisedHisOrg.getLong(org.id))");
        }
        this.reviseValidateData.setCheckDtoList(OrgBatchBillCheckHelper.queryBillOrgList());
        this.timeLogger.check("OrgBatchBillCheckHelper.queryBillOrgList()");
        this.buildValidator();
    }

    private void queryDataOnConditional(Date bsed, Date bsled, long parentBoId, String number, long orgBoId) {
        boolean queryAll;
        boolean bl = queryAll = this.changedProperties.containsAll(needQueryDbProperties) || this.changedProperties.contains("parentorg");
        if (queryAll) {
            if (this.reviseValidateData.isEstablishmentDateChanged() && this.needRevisedHisOrg.getDate("establishmentdate") != null) {
                this.reviseValidateData.setOverLapAdminArray(AdminOrgFastChgHelper.getOverLapAdminArray(this.needRevisedHisOrg.getDate("establishmentdate"), bsled));
            } else {
                this.reviseValidateData.setOverLapAdminArray(AdminOrgFastChgHelper.getOverLapAdminArray(bsed, bsled));
            }
            this.timeLogger.check("reviseValidateData.setOverLapAdminArray");
        } else {
            this.changedProperties.forEach(proper -> {
                if ("name".equals(proper)) {
                    if (this.reviseValidateData.isEstablishmentDateChanged() && this.needRevisedHisOrg.getDate("establishmentdate") != null) {
                        this.reviseValidateData.setOverLapAdminNameArray(AdminOrgFastChgHelper.getOverNameLapAdminArray(this.needRevisedHisOrg.getDate("establishmentdate"), bsled, parentBoId));
                    } else {
                        this.reviseValidateData.setOverLapAdminNameArray(AdminOrgFastChgHelper.getOverNameLapAdminArray(bsed, bsled, parentBoId));
                    }
                    this.timeLogger.check("reviseValidateData.setOverLapAdminNameArray");
                }
                if ("number".equals(proper)) {
                    if (this.reviseValidateData.isEstablishmentDateChanged() && this.needRevisedHisOrg.getDate("establishmentdate") != null) {
                        this.reviseValidateData.setOverLapAdminNumberArray(AdminOrgFastChgHelper.getOverNumberLapAdminArray(this.needRevisedHisOrg.getDate("establishmentdate"), bsled, number));
                    } else {
                        this.reviseValidateData.setOverLapAdminNumberArray(AdminOrgFastChgHelper.getOverNumberLapAdminArray(bsed, bsled, number));
                    }
                    this.timeLogger.check("reviseValidateData.setOverLapAdminNumberArray");
                }
                if ("adminorgtype".equals(proper)) {
                    if (this.reviseValidateData.isEstablishmentDateChanged() && this.needRevisedHisOrg.getDate("establishmentdate") != null) {
                        this.reviseValidateData.setOverLapAdminOrgTypeArray(AdminOrgFastChgHelper.getOverAdminOrgTypeLapAdminArray(this.needRevisedHisOrg.getDate("establishmentdate"), bsled, orgBoId));
                    } else {
                        this.reviseValidateData.setOverLapAdminOrgTypeArray(AdminOrgFastChgHelper.getOverAdminOrgTypeLapAdminArray(bsed, bsled, orgBoId));
                    }
                    this.timeLogger.check("reviseValidateData.setOverLapAdminOrgTypeArray");
                }
            });
        }
    }

    private void buildValidator() {
        ArrayList validators = new ArrayList();
        this.changedProperties.forEach(proper -> {
            if (this.isCurrentHis) {
                validatorFactory.getOrDefault("in_bill_" + proper, Optional.empty()).ifPresent(supplier -> validators.add(supplier.get()));
                if ("parentorg".equals(proper)) {
                    validators.add(new InBillUpFourLayerReviseValidator(false));
                }
            }
            if ("parentorg".equals(proper)) {
                validators.add(new UpFourLayerReviseValidator(false));
            }
            validatorFactory.getOrDefault(proper, Optional.empty()).ifPresent(supplier -> validators.add(supplier.get()));
        });
        if (!this.isCurrentHis) {
            validatorFactory.getOrDefault("in_bill_name", Optional.empty()).ifPresent(supplier -> validators.add(supplier.get()));
            validatorFactory.getOrDefault("in_bill_number", Optional.empty()).ifPresent(supplier -> validators.add(supplier.get()));
            validatorFactory.getOrDefault("in_bill_parentorg", Optional.empty()).ifPresent(supplier -> validators.add(supplier.get()));
            validatorFactory.getOrDefault("in_bill_adminorgtype", Optional.empty()).ifPresent(supplier -> validators.add(supplier.get()));
        }
        ReviseValidator lastReviseValidator = null;
        for (ReviseValidator headReviseValidator = this.headReviseValidator; headReviseValidator != null; headReviseValidator = headReviseValidator.getNext()) {
            lastReviseValidator = headReviseValidator;
        }
        for (int idx = 0; idx < validators.size(); ++idx) {
            for (ReviseValidator reviseValidator = (ReviseValidator)validators.get(idx); reviseValidator != null; reviseValidator = reviseValidator.getNext()) {
                if (lastReviseValidator == null) continue;
                lastReviseValidator.setNext(reviseValidator);
                lastReviseValidator = reviseValidator;
            }
        }
    }

    public List<CalibratorBean> check() {
        this.headReviseValidator.doValid(this.reviseValidateData);
        return this.reviseValidateData.getCalibratorBeans();
    }

    static {
        validatorFactory.put("name", Optional.of(NameReviseValidator::new));
        validatorFactory.put("in_bill_name", Optional.of(InBillNameReviseValidator::new));
        validatorFactory.put("number", Optional.of(NumberReviseValidator::new));
        validatorFactory.put("in_bill_number", Optional.of(InBillNumberReviseValidator::new));
        validatorFactory.put("adminorgtype", Optional.of(UpFourLayerReviseValidator::new));
        validatorFactory.put("in_bill_adminorgtype", Optional.of(InBillUpFourLayerReviseValidator::new));
        validatorFactory.put("parentorg", Optional.of(ParentCyclicReviseValidator::new));
        validatorFactory.put("parentorg_date", Optional.of(ReviseDateReviseValidator::new));
        validatorFactory.put("in_bill_parentorg", Optional.of(InBillParentCyclicReviseValidator::new));
        validatorFactory.put("tobedisableflag", Optional.of(TobeDisabledReviseValidator::new));
        validatorFactory.put("in_bill_tobedisableflag", Optional.of(InBillTobeDisabledReviseValidator::new));
        validatorFactory.put("establishmentdate", Optional.of(EstablishmentDateReviseValidator::new));
    }
}

