/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast.revise;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidateData;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidator;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.CalibratorBean;

public class InBillChangeReviseValidator
extends ReviseValidator {
    private static Set<Long> changeScenes = new HashSet<Long>(Arrays.asList(OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE, OrgBatchChgBillConstants.CHANGE_SCENE_INFO, OrgBatchChgBillConstants.CHANGE_SCENE_PARENT, OrgBatchChgBillConstants.CHANGE_TYPE_MERGE, OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT));

    @Override
    public void valid(ReviseValidateData reviseValidateData) {
        Map<Long, String> changeTypeIdNameMap = OrgBatchBillCheckHelper.queryBaseDataInfo("haos_orgchangetype", "id,name");
        DynamicObject needRevisedHisOrg = reviseValidateData.getNeedRevisedHisOrg();
        String orgName = needRevisedHisOrg.getString("name");
        long orgId = needRevisedHisOrg.getLong("id");
        for (OrgBatchCheckDto dto : reviseValidateData.getCheckDtoList()) {
            long billOrgId = dto.getOrgId();
            if (billOrgId != orgId) continue;
            String billNo = dto.getBillNo();
            long changeTypeId = dto.getChangeTypeId();
            if (!changeScenes.contains(changeTypeId)) continue;
            reviseValidateData.getCalibratorBeans().add(new CalibratorBean("InBillChangeReviseValidator_0", ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u5b58\u5728\u5355\u636e\u201c%2$s\u201d \u7684\u201c%3$s\u201d\u4e2d\uff0c\u9700\u7b49\u5355\u636e\u751f\u6548\u540e\u518d\u8fdb\u884c\u4fee\u8ba2\u3002", (String)"InBillChangeReviseValidator_0", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgName, billNo, changeTypeIdNameMap.get(changeTypeId)}));
        }
    }
}

