/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast.revise;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.haos.common.constants.masterdata.AdminOrgType;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidateData;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidator;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckConstants;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.model.CalibratorBean;

public class InBillDownFourLayerReviseValidator
extends ReviseValidator {
    @Override
    protected void valid(ReviseValidateData reviseValidateData) {
        DynamicObject needRevisedHisOrg = reviseValidateData.getNeedRevisedHisOrg();
        Long orgBoId = needRevisedHisOrg.getLong("boid");
        DynamicObject adminOrgType = needRevisedHisOrg.getDynamicObject("adminorgtype");
        if (adminOrgType == null) {
            return;
        }
        long orgtypeStdId = needRevisedHisOrg.getLong("adminorgtype.adminorgtypestd.id");
        String orgTypeName = needRevisedHisOrg.getString("adminorgtype.name");
        List<OrgBatchCheckDto> billOrgList = reviseValidateData.getCheckDtoList();
        Map<Long, Long> orgTypeStdIdMap = OrgBatchBillCheckHelper.queryOrgTypeTypeStdIdMap();
        HashSet billNoSet = new HashSet(10);
        billOrgList.forEach(dto -> {
            Long childOrgStdId;
            if (orgBoId.equals(dto.getParentOrgBoId()) && this.validateDateOverLap(needRevisedHisOrg, (OrgBatchCheckDto)dto) && !Objects.isNull(childOrgStdId = (Long)orgTypeStdIdMap.get(dto.getOrgTypeId()))) {
                if (AdminOrgType.COMPANY.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_LOWER_COMPANY.contains(childOrgStdId) && billNoSet.add(dto.getBillNo())) {
                    reviseValidateData.getCalibratorBeans().add(new CalibratorBean("InBillDownFourLayerReviseValidator_0", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u76ee\u524d\u6709\u5728\u9014\u5355\u201c%3$s\u201d\u6570\u636e\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"InBillDownFourLayerReviseValidator_0", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgTypeName, reviseValidateData.getAdminOrgTypeNameMap() != null ? reviseValidateData.getAdminOrgTypeNameMap().get("level4_lower_company") : "null", dto.getBillNo()}));
                } else if (AdminOrgType.DEPARTMENT.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_LOWER_DEPT.contains(childOrgStdId) && billNoSet.add(dto.getBillNo())) {
                    reviseValidateData.getCalibratorBeans().add(new CalibratorBean("InBillDownFourLayerReviseValidator_0", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u76ee\u524d\u6709\u5728\u9014\u5355\u201c%3$s\u201d\u6570\u636e\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"InBillDownFourLayerReviseValidator_0", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgTypeName, reviseValidateData.getAdminOrgTypeNameMap() != null ? reviseValidateData.getAdminOrgTypeNameMap().get("level4_lower_dept") : "null", dto.getBillNo()}));
                }
            }
        });
    }
}

