/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast.revise;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.haos.business.util.NameSeparatorTipsUtil;
import kd.hr.haos.business.util.PatternUtil;
import kd.hr.haos.common.constants.MultiLangEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidateData;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidator;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.CalibratorBean;

public class InBillNameReviseValidator
extends ReviseValidator {
    PatternUtil patternUtil = new PatternUtil();
    private NameSeparatorTipsUtil nameSeparatorTipsUtil = new NameSeparatorTipsUtil();

    @Override
    protected void valid(ReviseValidateData reviseValidateData) {
        DynamicObject needRevisedHisOrg = reviseValidateData.getNeedRevisedHisOrg();
        DynamicObject parentorg = needRevisedHisOrg.getDynamicObject("parentorg");
        if (parentorg == null) {
            return;
        }
        long orgId = needRevisedHisOrg.getLong("id");
        String parentOrgName = needRevisedHisOrg.getString("parentorg.name");
        List<OrgBatchCheckDto> billOrgList = OrgBatchBillCheckHelper.queryBillOrgLocaleNamesByParentBoId(Sets.newHashSet((Object[])new Long[]{parentorg.getLong("boid")}));
        Map<String, List<OrgBatchCheckDto>> billGroupMap = billOrgList.stream().filter(dto -> !Objects.isNull(dto.getLocaleId())).filter(dto -> !dto.getOrgId().equals(orgId)).filter(dto -> this.validateDateOverLap(needRevisedHisOrg, (OrgBatchCheckDto)dto)).collect(Collectors.groupingBy(OrgBatchCheckDto::getLocaleId));
        ILocaleString orgNameLocale = needRevisedHisOrg.getLocaleString("name");
        orgNameLocale.forEach((code, nameVal) -> {
            if (HRStringUtils.equals((String)"GLang", (String)code) || HRStringUtils.isEmpty((String)nameVal)) {
                return;
            }
            List billDtoList = billGroupMap.getOrDefault(code, new ArrayList(48));
            billDtoList.forEach(dto -> {
                if (dto.getOrgBoId().equals(needRevisedHisOrg.getLong("boid"))) {
                    return;
                }
                if (HRStringUtils.equals((String)nameVal, (String)dto.getName())) {
                    if (OrgBatchChgBillConstants.CHANGE_TYPE_ADD.equals(dto.getChangeTypeId()) && dto.getEstablishmentDate() != null && this.isOverLap(dto.getEstablishmentDate(), needRevisedHisOrg)) {
                        reviseValidateData.getCalibratorBeans().add(new CalibratorBean("InBillNameReviseValidator_0", ResManager.loadKDString((String)"\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%1$s\uff09\u4e2d\u201c%2$s\u201d\u4e0b\u5df2\u5b58\u5728\u201c%3$s\u201d\u540d\u79f0\u201c%4$s\u201d\u7684\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"InBillNameReviseValidator_0", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{dto.getBillNo(), parentOrgName, MultiLangEnum.getName((String)code), nameVal}));
                    } else if ((OrgBatchChgBillConstants.CHANGE_TYPE_INFO.equals(dto.getChangeTypeId()) || OrgBatchChgBillConstants.CHANGE_TYPE_PARENT.equals(dto.getChangeTypeId())) && dto.getEffectDate() != null && this.isOverLap(dto.getEffectDate(), needRevisedHisOrg)) {
                        reviseValidateData.getCalibratorBeans().add(new CalibratorBean("InBillNameReviseValidator_0", ResManager.loadKDString((String)"\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%1$s\uff09\u4e2d\u201c%2$s\u201d\u4e0b\u5df2\u5b58\u5728\u201c%3$s\u201d\u540d\u79f0\u201c%4$s\u201d\u7684\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"InBillNameReviseValidator_0", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{dto.getBillNo(), parentOrgName, MultiLangEnum.getName((String)code), nameVal}));
                    }
                }
            });
            if (this.patternUtil.validName4Config(nameVal)) {
                reviseValidateData.getCalibratorBeans().add(new CalibratorBean("InBillNameReviseValidator_1", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u201c%1$s\u201d\u540d\u79f0\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\uff08%1$s\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"InBillNameReviseValidator_1", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{MultiLangEnum.getName((String)code), this.nameSeparatorTipsUtil.getAllSeparator()}));
            }
        });
    }
}

