/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast.revise;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidateData;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidator;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.CalibratorBean;

public class InBillNumberReviseValidator
extends ReviseValidator {
    @Override
    public void valid(ReviseValidateData reviseValidateData) {
        DynamicObject needRevisedHisOrg = reviseValidateData.getNeedRevisedHisOrg();
        String number = needRevisedHisOrg.getString("number");
        if (number == null || "".equals(number.trim())) {
            return;
        }
        long orgId = needRevisedHisOrg.getLong("id");
        List<OrgBatchCheckDto> checkDtoList = reviseValidateData.getCheckDtoList();
        Map<String, OrgBatchCheckDto> numberBillNoMap = checkDtoList.stream().filter(dto -> !dto.getOrgId().equals(orgId)).collect(Collectors.toMap(OrgBatchCheckDto::getNumber, dto -> dto, (v1, v2) -> v2));
        if (numberBillNoMap.containsKey(number) && numberBillNoMap.get(number) != null && numberBillNoMap.get(number).getOrgBoId().longValue() != needRevisedHisOrg.getLong("boid")) {
            OrgBatchCheckDto dto2 = numberBillNoMap.get(number);
            if (OrgBatchChgBillConstants.CHANGE_TYPE_ADD.equals(dto2.getChangeTypeId()) && dto2.getEstablishmentDate() != null && this.isOverLap(dto2.getEstablishmentDate(), needRevisedHisOrg)) {
                reviseValidateData.getCalibratorBeans().add(new CalibratorBean("InBillNumberReviseValidator_0", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u201c%1$s\u201d\u5df2\u5b58\u5728\u5728\u9014\u5355\u636e\uff08\u5355\u636e\u7f16\u53f7\uff1a%2$s\uff09\u4e2d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"InBillNumberReviseValidator_0", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{number, numberBillNoMap.get(number).getBillNo()}));
            } else if ((OrgBatchChgBillConstants.CHANGE_TYPE_INFO.equals(dto2.getChangeTypeId()) || OrgBatchChgBillConstants.CHANGE_TYPE_PARENT.equals(dto2.getChangeTypeId())) && dto2.getEffectDate() != null && this.isOverLap(dto2.getEffectDate(), needRevisedHisOrg)) {
                reviseValidateData.getCalibratorBeans().add(new CalibratorBean("InBillNumberReviseValidator_0", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u201c%1$s\u201d\u5df2\u5b58\u5728\u5728\u9014\u5355\u636e\uff08\u5355\u636e\u7f16\u53f7\uff1a%2$s\uff09\u4e2d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"InBillNumberReviseValidator_0", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{number, numberBillNoMap.get(number).getBillNo()}));
            }
        }
    }
}

