/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast.revise;

import java.util.Date;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidateData;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidator;
import kd.hr.homs.business.service.validcommon.CycleOrgBean;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.model.CalibratorBean;

public class InBillParentCyclicReviseValidator
extends ReviseValidator {
    @Override
    protected void valid(ReviseValidateData reviseValidateData) {
        DynamicObject needRevisedHisOrg = reviseValidateData.getNeedRevisedHisOrg();
        List<OrgBatchCheckDto> checkDtoList = reviseValidateData.getCheckDtoList();
        List<CycleOrgBean> billAffiliationList = checkDtoList.stream().filter(dto -> this.validateDateOverLap(needRevisedHisOrg, (OrgBatchCheckDto)dto)).map(dto -> {
            CycleOrgBean cycleOrgBean = new CycleOrgBean();
            cycleOrgBean.setOrgId(dto.getOrgBoId());
            cycleOrgBean.setCoopOrgId(dto.getAfterParentBoId());
            cycleOrgBean.setBillNo(dto.getBillNo());
            return cycleOrgBean;
        }).collect(Collectors.toList());
        Date effectDate = needRevisedHisOrg.getDate("bsed");
        Long orgId = needRevisedHisOrg.getLong("boid");
        Long parentId = needRevisedHisOrg.getLong("parentorg.boid");
        this.validCycle(orgId, parentId, effectDate, billAffiliationList, reviseValidateData);
    }

    private void validCycle(Long orgId, Long parentId, Date effectDate, List<CycleOrgBean> billAffiliationList, ReviseValidateData reviseValidateData) {
        Map<Long, List<CycleOrgBean>> billAffiliationMap;
        CycleOrgBean billBean = OrgBatchBillCheckHelper.assembleCycleOrg(orgId, parentId, effectDate);
        Deque<CycleOrgBean> billCycleOrgs = OrgBatchBillCheckHelper.containsCycle(billBean, billAffiliationMap = billAffiliationList.stream().collect(Collectors.groupingBy(CycleOrgBean::getOrgId, Collectors.toList())), false);
        if (!CollectionUtils.isEmpty(billCycleOrgs) && !HRStringUtils.isEmpty((String)billCycleOrgs.getFirst().getBillNo())) {
            Set billNoSet = billCycleOrgs.stream().map(CycleOrgBean::getBillNo).collect(Collectors.toSet());
            String billNoStr = String.join((CharSequence)",", billNoSet);
            reviseValidateData.getCalibratorBeans().add(new CalibratorBean("InBillParentCyclicReviseValidator_0", ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u5728\u9014\u5355\u636e\u201c%s\u201d\u4e2d\u81ea\u5df1\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"InBillParentCyclicReviseValidator_0", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{billNoStr}));
        }
    }
}

