/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast.revise;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.haos.business.service.adminorg.bean.Pair;
import kd.hr.homs.business.service.helper.SystemParamHelper;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidateData;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidator;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.model.CalibratorBean;

public class InBillTobeDisabledReviseValidator
extends ReviseValidator {
    @Override
    public void valid(ReviseValidateData reviseValidateData) {
        List<OrgBatchCheckDto> checkDtoList = reviseValidateData.getCheckDtoList();
        DynamicObject needRevisedHisOrg = reviseValidateData.getNeedRevisedHisOrg();
        DynamicObject parentorg = needRevisedHisOrg.getDynamicObject("parentorg");
        if (parentorg == null) {
            return;
        }
        long buOrgId = needRevisedHisOrg.getLong("org.id");
        long parentOrgId = needRevisedHisOrg.getLong("parentorg.id");
        Map<Long, Pair> billTobeDisableOrgIdSet = checkDtoList.stream().filter(dto -> dto.isTobeDisableFlag()).collect(Collectors.toMap(dto -> dto.getOrgId(), dto -> new Pair((Object)dto.getBillNo(), (Object)dto.getName()), (k1, k2) -> k1));
        if (billTobeDisableOrgIdSet.containsKey(parentOrgId) && !SystemParamHelper.getAllowTobeDisableChg(buOrgId)) {
            reviseValidateData.getCalibratorBeans().add(new CalibratorBean("InBillTobeDisabledReviseValidator_0", ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5728\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%s\uff09\u4e2d\u505a\u4e86\u201c\u5f85\u505c\u7528\u201d\u64cd\u4f5c\uff0c\u4e0d\u80fd\u8c03\u6574\u5230\u8be5\u7ec4\u7ec7\u4e0b\uff0c\u8bf7\u4fee\u6539\u3002", (String)"InBillTobeDisabledReviseValidator_0", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{billTobeDisableOrgIdSet.get(parentOrgId).getKey()}));
        }
    }
}

