/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast.revise;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.haos.common.constants.masterdata.AdminOrgType;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.orgfast.revise.InBillDownFourLayerReviseValidator;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidateData;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidator;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckConstants;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.model.CalibratorBean;

public class InBillUpFourLayerReviseValidator
extends ReviseValidator {
    public InBillUpFourLayerReviseValidator() {
        this.setNext(new InBillDownFourLayerReviseValidator());
    }

    public InBillUpFourLayerReviseValidator(boolean setNext) {
        if (setNext) {
            this.setNext(new InBillDownFourLayerReviseValidator());
        }
    }

    @Override
    protected void valid(ReviseValidateData reviseValidateData) {
        DynamicObject needRevisedHisOrg = reviseValidateData.getNeedRevisedHisOrg();
        DynamicObject parentOrg = needRevisedHisOrg.getDynamicObject("parentorg");
        if (parentOrg == null) {
            return;
        }
        Long parentId = parentOrg.getLong("id");
        Map<Long, Long> orgTypeStdIdMap = OrgBatchBillCheckHelper.queryOrgTypeTypeStdIdMap();
        long orgtypeStdId = needRevisedHisOrg.getLong("adminorgtype.adminorgtypestd.id");
        List<OrgBatchCheckDto> billOrgList = reviseValidateData.getCheckDtoList();
        String orgTypeName = needRevisedHisOrg.getString("adminorgtype.name");
        billOrgList.forEach(dto -> {
            Long parentStdId;
            if (parentId.equals(dto.getOrgId()) && !Objects.isNull(parentStdId = (Long)orgTypeStdIdMap.get(dto.getOrgTypeId()))) {
                if (AdminOrgType.GROUP.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_ABOVE_GROUP.contains(parentStdId) && this.validateDateOverLap(needRevisedHisOrg, (OrgBatchCheckDto)dto)) {
                    reviseValidateData.getCalibratorBeans().add(new CalibratorBean("InBillUpFourLayerReviseValidator_0", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u76ee\u524d\u6709\u5728\u9014\u5355\u201c%3$s\u201d\u6570\u636e\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"InBillUpFourLayerReviseValidator_0", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgTypeName, reviseValidateData.getAdminOrgTypeNameMap() != null ? reviseValidateData.getAdminOrgTypeNameMap().get("level4_above_group") : "null", dto.getBillNo()}));
                } else if (AdminOrgType.COMPANY.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_ABOVE_COMPANY.contains(parentStdId) && this.validateDateOverLap(needRevisedHisOrg, (OrgBatchCheckDto)dto)) {
                    reviseValidateData.getCalibratorBeans().add(new CalibratorBean("InBillUpFourLayerReviseValidator_0", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u76ee\u524d\u6709\u5728\u9014\u5355\u201c%3$s\u201d\u6570\u636e\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"InBillUpFourLayerReviseValidator_0", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgTypeName, reviseValidateData.getAdminOrgTypeNameMap() != null ? reviseValidateData.getAdminOrgTypeNameMap().get("level4_above_company") : "null", dto.getBillNo()}));
                }
            }
        });
    }
}

