/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast.revise;

import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.haos.common.constants.MultiLangEnum;
import kd.hr.haos.common.util.LocalDateRange;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidateData;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidator;
import kd.hr.homs.common.model.CalibratorBean;

public class NameReviseValidator
extends ReviseValidator {
    @Override
    public void valid(ReviseValidateData reviseValidateData) {
        block5: {
            LocalDateRange needDateRange;
            AtomicBoolean atomicBoolean;
            ILocaleString orgNameLocale;
            String parentOrgName;
            DynamicObject needRevisedHisOrg;
            block6: {
                DynamicObject[] overLapAdminArray = reviseValidateData.getOverLapAdminArray();
                needRevisedHisOrg = reviseValidateData.getNeedRevisedHisOrg();
                DynamicObject parentorg = needRevisedHisOrg.getDynamicObject("parentorg");
                if (parentorg == null) {
                    return;
                }
                long parentBoId = needRevisedHisOrg.getLong("parentorg.boid");
                parentOrgName = needRevisedHisOrg.getString("parentorg.name");
                orgNameLocale = needRevisedHisOrg.getLocaleString("name");
                atomicBoolean = new AtomicBoolean(false);
                Date effectDate = reviseValidateData.isEstablishmentDateChanged() && needRevisedHisOrg.getDate("establishmentdate") != null ? needRevisedHisOrg.getDate("establishmentdate") : needRevisedHisOrg.getDate("bsed");
                needDateRange = LocalDateRange.ofClosed((Date)effectDate, (Date)needRevisedHisOrg.getDate("bsled"));
                if (overLapAdminArray == null) break block6;
                for (DynamicObject dyn : overLapAdminArray) {
                    DynamicObject parent = dyn.getDynamicObject("parentorg");
                    if (parent == null || dyn.getLong("boid") == needRevisedHisOrg.getLong("boid")) continue;
                    if (!atomicBoolean.get()) {
                        if (dyn.getLong("parentorg.id") == 0L || dyn.getLong("parentorg.id") != parentBoId) continue;
                        this.validName(orgNameLocale, dyn, needDateRange, reviseValidateData, parentOrgName, atomicBoolean);
                        continue;
                    }
                    break block5;
                }
                break block5;
            }
            DynamicObject[] overLapAdminNameArray = reviseValidateData.getOverLapAdminNameArray();
            if (overLapAdminNameArray == null) break block5;
            for (DynamicObject dyn : overLapAdminNameArray) {
                if (dyn.getLong("boid") == needRevisedHisOrg.getLong("boid")) continue;
                if (!atomicBoolean.get()) {
                    this.validName(orgNameLocale, dyn, needDateRange, reviseValidateData, parentOrgName, atomicBoolean);
                    continue;
                }
                break;
            }
        }
    }

    private void validName(ILocaleString orgNameLocale, DynamicObject dyn, LocalDateRange needDateRange, ReviseValidateData reviseValidateData, String parentOrgName, AtomicBoolean atomicBoolean) {
        orgNameLocale.forEach((code, nameVal) -> {
            if (HRStringUtils.equals((String)"GLang", (String)code) || HRStringUtils.isEmpty((String)nameVal)) {
                return;
            }
            ILocaleString localeString = dyn.getLocaleString("name");
            localeString.forEach((codeHis, nameValHis) -> {
                if (HRStringUtils.equals((String)"GLang", (String)codeHis) || HRStringUtils.isEmpty((String)nameValHis)) {
                    return;
                }
                if (HRStringUtils.equals((String)code, (String)codeHis) && HRStringUtils.equals((String)nameVal, (String)nameValHis)) {
                    LocalDateRange localDateRange = LocalDateRange.ofClosed((Date)dyn.getDate("bsed"), (Date)dyn.getDate("bsled"));
                    LocalDateRange intersection = localDateRange.intersection(needDateRange);
                    reviseValidateData.getCalibratorBeans().add(new CalibratorBean("NameReviseValidator_0", ResManager.loadKDString((String)"\u201c%1$s\u201d\u671f\u95f4\uff0c\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%2$s\u201d\u4e0b\u5df2\u5b58\u5728\u201c%3$s\u201d\u540d\u79f0\u201c%4$s\u201d\u7684\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"NameReviseValidator_0", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{OrgBatchBillCheckHelper.getTimeSpan(LocalDateRangeUtils.getStartDate((LocalDateRange)intersection), LocalDateRangeUtils.getEndInclusiveDate((LocalDateRange)intersection)), parentOrgName, MultiLangEnum.getName((String)code), nameVal}));
                    atomicBoolean.set(true);
                }
            });
        });
    }
}

