/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast.revise;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.haos.common.util.LocalDateRange;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidateData;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidator;
import kd.hr.homs.common.model.CalibratorBean;

public class NumberReviseValidator
extends ReviseValidator {
    @Override
    public void valid(ReviseValidateData reviseValidateData) {
        DynamicObject[] overLapAdminArray = reviseValidateData.getOverLapAdminArray();
        DynamicObject needRevisedHisOrg = reviseValidateData.getNeedRevisedHisOrg();
        String number = needRevisedHisOrg.getString("number");
        if (number == null || "".equals(number.trim())) {
            return;
        }
        if (number.contains("!") || number.contains("\uff01")) {
            reviseValidateData.getCalibratorBeans().add(new CalibratorBean("NumberReviseValidator_0", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u4e2d\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\u201c!\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"NumberReviseValidator_0", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
        }
        Date effectDate = reviseValidateData.isEstablishmentDateChanged() && needRevisedHisOrg.getDate("establishmentdate") != null ? needRevisedHisOrg.getDate("establishmentdate") : needRevisedHisOrg.getDate("bsed");
        LocalDateRange needDateRange = LocalDateRange.ofClosed((Date)effectDate, (Date)needRevisedHisOrg.getDate("bsled"));
        if (overLapAdminArray != null) {
            this.validNumber(overLapAdminArray, number, needDateRange, reviseValidateData);
        } else {
            DynamicObject[] overLapAdminNumberArray = reviseValidateData.getOverLapAdminNumberArray();
            this.validNumber(overLapAdminNumberArray, number, needDateRange, reviseValidateData);
        }
        long orgBoId = needRevisedHisOrg.getLong("boid");
        QFilter bosOrgFilter = new QFilter("isfreeze", "=", (Object)"0");
        if (!OrgBatchBillCheckHelper.isValidateOrgId(orgBoId)) {
            bosOrgFilter.and("org.id", "<>", (Object)orgBoId);
        }
        bosOrgFilter.and("org.number", "=", (Object)number);
        HRBaseServiceHelper bosOrgHelper = new HRBaseServiceHelper("bos_org_structure");
        if (bosOrgHelper.isExists(bosOrgFilter)) {
            reviseValidateData.getCalibratorBeans().add(new CalibratorBean("NumberReviseValidator_2", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u4e0e\u201c\u57fa\u7840\u670d\u52a1\u4e91>\u4f01\u4e1a\u5efa\u6a21>\u7ec4\u7ec7\u7ba1\u7406>\u884c\u653f\u7ec4\u7ec7/\u4e1a\u52a1\u5355\u5143\u201d\u4e2d\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"NumberReviseValidator_2", (String)"odc-homs-business", (Object[])new Object[0]), new Object[0]));
        }
    }

    private void validNumber(DynamicObject[] overLapAdminNumberArray, String number, LocalDateRange needDateRange, ReviseValidateData reviseValidateData) {
        if (overLapAdminNumberArray != null && overLapAdminNumberArray.length != 0) {
            for (DynamicObject dyn : overLapAdminNumberArray) {
                if (!number.equals(dyn.getString("number"))) continue;
                LocalDateRange localDateRange = LocalDateRange.ofClosed((Date)dyn.getDate("bsed"), (Date)dyn.getDate("bsled"));
                LocalDateRange intersection = localDateRange.intersection(needDateRange);
                String timeSpan = OrgBatchBillCheckHelper.getTimeSpan(LocalDateRangeUtils.getStartDate((LocalDateRange)intersection), LocalDateRangeUtils.getEndInclusiveDate((LocalDateRange)intersection));
                String message = String.format(ResManager.loadKDString((String)"%1$s\u671f\u95f4\uff0c\u884c\u653f\u7ec4\u7ec7\u7f16\u7801%2$s\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539", (String)"NumberReviseValidator_1", (String)"odc-homs-business", (Object[])new Object[0]), timeSpan, number);
                reviseValidateData.getCalibratorBeans().add(new CalibratorBean(message));
                break;
            }
        }
    }
}

