/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast.revise;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.service.impl.orgmsg.ReviseCompanyMsgService;
import kd.hr.haos.business.domain.service.impl.orgmsg.ReviseMsgService;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgUnitSyncService;
import kd.hr.haos.business.service.orgteam.OrgTeamReviseService;
import kd.hr.haos.business.service.orgteam.OrgTeamSynService;
import kd.hr.haos.business.util.IdCreator;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.haos.business.util.SynOrgChangeToOtherDomainUtil;
import kd.hr.haos.business.util.TimeLogger;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.haos.common.model.orgteam.BatchSynModel;
import kd.hr.haos.common.util.LocalDateRange;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.homs.business.service.batcheffect.MethodHelper;
import kd.hr.homs.business.service.batcheffect.QueryHelper;
import kd.hr.homs.business.service.batcheffect.constant.EffectBillConstant;
import kd.hr.homs.business.service.domain.service.impl.orgfast.ReviseLogServiceImpl;
import kd.hr.homs.business.service.ext.function.DefaultOrgReviseServiceExtend;
import kd.hr.homs.business.service.helper.OrgStrategyHelper;
import kd.hr.homs.business.service.orgfast.revise.handler.IOrgReviseHandler;
import kd.hr.homs.business.service.orgfast.revise.handler.OrgEDateReviseHandler;
import kd.hr.homs.business.service.orgfast.revise.handler.OrgFourLayerReviseHandler;
import kd.hr.homs.business.service.orgfast.revise.handler.OrgOtherReviseHandler;
import kd.hr.homs.business.service.orgfast.revise.handler.OrgParentReviseHandler;
import kd.hr.homs.business.service.orgfast.revise.handler.OrgSubReviseHandler;
import kd.hr.homs.business.service.orgfast.revise.handler.OrgTobeDisableFlagReviseHandler;
import kd.hr.homs.business.service.orgfast.revise.handler.OrgTypeReviseHandler;
import kd.hr.homs.business.service.orgfast.revise.model.OrgReviseModel;
import kd.hr.homs.business.service.utils.OrgChgUtil;
import kd.hr.homs.common.model.ReviseLogEntity;
import kd.hr.homs.common.model.ReviseLogVO;
import kd.sdk.odc.homs.service.IOrgReviseServiceExtend;

public class OrgReviseService {
    private final List<IOrgReviseHandler> list = Arrays.asList(new OrgEDateReviseHandler(), new OrgTypeReviseHandler(), new OrgParentReviseHandler(), new OrgOtherReviseHandler(), new OrgTobeDisableFlagReviseHandler(), new OrgFourLayerReviseHandler());
    private final OrgReviseModel model;
    private Long eventId;
    private Map<String, List<DynamicObject>> resultMap;
    private Map<Long, List<Long>> sceneSubMap;
    private TimeLogger timeLogger = TimeLogger.create();
    private static final Log LOGGER = LogFactory.getLog(OrgReviseService.class);

    public OrgReviseService(DynamicObject dy) {
        this.model = new OrgReviseModel(dy);
    }

    public void revise() {
        this.timeLogger.start();
        this.execute();
        this.eventId = ORM.create().genLongId(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
        this.splitData();
        this.resultMap = this.mergeData();
        ReviseLogEntity entity = this.buildReviseLogEntity();
        this.timeLogger.check("before hisVersionChange");
        this.batchHisVersionChange(this.buildHisVersionParamList(this.model.getResultFirstMap(), true));
        this.batchHisVersionChange(this.buildHisVersionParamList(this.resultMap, false));
        this.timeLogger.check("after hisVersionChange");
        this.reviseEstablishmentDate();
        this.beforeReviseExtend();
        this.synOt(this.resultMap.get(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey()));
        this.timeLogger.check("after synOt");
        ReviseLogServiceImpl service = new ReviseLogServiceImpl();
        this.sceneSubMap = service.getSceneSubMap(entity);
        service.saveLog(entity, this.sceneSubMap);
        this.timeLogger.check("after log");
    }

    private void beforeReviseExtend() {
        PluginProxy extendPluginProxy = PluginProxy.create((Object)new DefaultOrgReviseServiceExtend(), IOrgReviseServiceExtend.class, (String)"kd.hr.homs.business.service.orgfast.revise.OrgReviseService.revise");
        extendPluginProxy.callReplace(plugin -> {
            LOGGER.info(String.format("proxy plugin: %s", plugin.getClass()));
            LOGGER.info("before callReplace beforeReviseExtend");
            plugin.beforeSaveAdminOrg(this.resultMap.get(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey()));
            LOGGER.info("after callReplace beforeReviseExtend");
            return null;
        });
    }

    public String getNewOrgIdStr() {
        String orgIdStr = String.valueOf(this.model.getDy().getLong("id"));
        List<Object> list = this.resultMap.get(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
        if (CollectionUtils.isEmpty(list)) {
            return orgIdStr;
        }
        long boId = this.model.getDy().getLong("boid");
        if (!CollectionUtils.isEmpty(list = list.stream().filter(dy -> dy.getLong("boid") == boId).collect(Collectors.toList()))) {
            list.sort(Comparator.comparing(o -> o.getDate("bsed")));
            orgIdStr = String.valueOf(((DynamicObject)list.get(list.size() - 1)).getLong("id"));
        }
        return orgIdStr;
    }

    private void execute() {
        for (IOrgReviseHandler handler : this.list) {
            if (!handler.isChanged(this.model)) continue;
            handler.execute(this.model);
        }
        this.setDefaultValue();
        OrgSubReviseHandler handler = new OrgSubReviseHandler();
        if (handler.isChanged(this.model)) {
            handler.execute(this.model);
        }
    }

    private ReviseLogEntity buildReviseLogEntity() {
        List<String> entityList = Arrays.asList(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey());
        ArrayList<ReviseLogVO> logList = new ArrayList<ReviseLogVO>(10);
        DynamicObject reviseDy = this.model.getDy();
        Date startDate = reviseDy.getDate("bsed");
        for (Map.Entry<String, List<DynamicObject>> entry : this.resultMap.entrySet()) {
            if (!entityList.contains(entry.getKey())) continue;
            List<Object> dyList = entry.getValue();
            if (AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey().equals(entry.getKey())) {
                dyList = dyList.stream().filter(dy -> dy.getLong("id") == reviseDy.getLong("id")).collect(Collectors.toList());
                dyList.sort(Comparator.comparing(o -> o.getDate("bsed")));
                if (dyList.size() > 1 && ((DynamicObject)dyList.get(0)).getLong("parentorg.boid") == 0L) {
                    dyList.remove(0);
                }
            } else {
                dyList = this.getContainStartDateDy(startDate, dyList);
            }
            logList.addAll(this.buildLogList(dyList, this.model.getHisDy(entry.getKey()), entry.getKey()));
        }
        for (Map.Entry<String, List<DynamicObject>> entry : this.model.getResultFirstMap().entrySet()) {
            logList.addAll(this.buildLogList(this.getContainStartDateDy(startDate, entry.getValue()), this.model.getHisDy(entry.getKey()), entry.getKey()));
        }
        return new ReviseLogEntity(reviseDy, this.eventId, logList);
    }

    private List<DynamicObject> getContainStartDateDy(Date startDate, List<DynamicObject> dyList) {
        return dyList.stream().filter(dy -> dy.getDate("bsed").compareTo(startDate) <= 0 && dy.getDate("bsled").compareTo(startDate) >= 0).collect(Collectors.toList());
    }

    private List<ReviseLogVO> buildLogList(List<DynamicObject> list, DynamicObject hisDy, String entityName) {
        ArrayList<ReviseLogVO> logList = new ArrayList<ReviseLogVO>(list.size());
        for (DynamicObject dy : list) {
            logList.add(new ReviseLogVO(entityName, hisDy, dy));
        }
        return logList;
    }

    public void afterRevise() {
        this.timeLogger.start();
        this.sendChangeMsg();
        this.sendCompanyChangeMsg();
        this.timeLogger.check("send change msg");
        DynamicObject dy = this.model.getDy();
        if (!EnumHisDataVersionStatus.EFFECTING.getStatus().equals(this.model.getDy().getString("datastatus"))) {
            return;
        }
        if (this.model.getResultMap().get(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey()) == null) {
            return;
        }
        Optional<DynamicObject> dyOp = this.model.getResultMap().get(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey()).stream().filter(orgDy -> orgDy.getLong("boid") == dy.getLong("boid")).max(Comparator.comparing(o -> o.getDate("bsled")));
        if (!dyOp.isPresent()) {
            return;
        }
        this.asyOrgUnitAndStrategy(dyOp.get());
    }

    private void asyOrgUnitAndStrategy(DynamicObject orgDy) {
        ThreadPools.executeOnce((String)"asyOrgUnitAndStrategy", () -> {
            this.synOrgUnit(orgDy);
            this.timeLogger.check("synOrgUnit");
            this.synStrategy(orgDy);
            this.timeLogger.check("synStrategy");
        });
    }

    private void sendChangeMsg() {
        List<Object> orgDyList = this.resultMap.get(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
        if (CollectionUtils.isEmpty(orgDyList)) {
            return;
        }
        DynamicObject reviseDy = this.model.getDy();
        if (CollectionUtils.isEmpty(orgDyList = orgDyList.stream().filter(dy -> dy.getLong("boid") == reviseDy.getLong("boid")).collect(Collectors.toList()))) {
            return;
        }
        if (orgDyList.size() != 1) {
            orgDyList.sort(Comparator.comparing(o -> o.getDate("bsed")));
            orgDyList = Collections.singletonList(orgDyList.get(orgDyList.size() - 1));
        }
        ReviseMsgService changeMsgService = new ReviseMsgService(this.eventId, Long.valueOf(reviseDy.getLong("changereason.id")), (Object)reviseDy.getString("reviseexplain"), this.sceneSubMap);
        changeMsgService.handleChangeMsg(orgDyList, null, "C");
    }

    private void sendCompanyChangeMsg() {
        List<Object> orgDyList = this.resultMap.get(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
        if (CollectionUtils.isEmpty(orgDyList)) {
            return;
        }
        if (!EnumHisDataVersionStatus.EFFECTING.getStatus().equals(this.model.getDy().getString("datastatus"))) {
            return;
        }
        if (CollectionUtils.isEmpty(orgDyList = orgDyList.stream().filter(orgDy -> (AdminOrgConstants.CompanyChangeType.FOLLOW_CHANGE.code().equals(orgDy.getString("companychangetype")) || AdminOrgConstants.CompanyChangeType.SELF_CHANGE.code().equals(orgDy.getString("companychangetype"))) && orgDy.getDate("bsled").compareTo(this.model.getDy().getDate("bsled")) == 0).collect(Collectors.toList()))) {
            return;
        }
        ReviseCompanyMsgService changeMsgService = new ReviseCompanyMsgService();
        changeMsgService.handleChangeMsg(orgDyList, null, "C");
        SynOrgChangeToOtherDomainUtil.synOrgChange(orgDyList);
    }

    private void setDefaultValue() {
        DynamicObject newDy = this.model.getResultDy(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), this.model.getDy().getLong("id"));
        if (newDy != null) {
            newDy.set("companychangetype", (Object)AdminOrgConstants.CompanyChangeType.NO_CHANGE.code());
        }
    }

    private void synOrgUnit(DynamicObject newOrgDy) {
        List<String> propertiesList = Arrays.asList("number", "name");
        if (this.model.isParentChanged() || OrgChgUtil.getChangeProperties(this.model.getHisDy(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey()), newOrgDy, propertiesList).size() > 0) {
            AdminOrgUnitSyncService.getInstance().syncOrgChgUnit(new DynamicObject[]{newOrgDy});
        }
    }

    private void synStrategy(DynamicObject newOrgDy) {
        DynamicObject oldDy = this.model.getHisDy(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
        OrgStrategyHelper.changeStrategyModify(oldDy, newOrgDy);
    }

    private void synOt(List<DynamicObject> orgList) {
        if (CollectionUtils.isEmpty(orgList)) {
            return;
        }
        OrgTeamReviseService service = new OrgTeamReviseService(this.buildBatchSynModel(orgList));
        service.revise();
    }

    private BatchSynModel buildBatchSynModel(List<DynamicObject> orgList) {
        String orgTeamNumberPrefix = OrgTeamSynService.getOrgTeamNumberPrefix((Long)1010L);
        List<Long> orgIdList = orgList.stream().map(orgDy -> orgDy.getLong("boid")).collect(Collectors.toList());
        Map<Long, DynamicObject> orgTeamMap = Arrays.stream(QueryHelper.loadOrgTeamByOrgBoId(orgIdList)).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        List saveList = orgList.stream().map(orgDy -> {
            DynamicObject orgTeam = (DynamicObject)orgTeamMap.get(orgDy.getLong("boid"));
            if (orgTeam == null) {
                throw new KDBizException("no find orgTeam data---orgTeamId=" + orgDy.getLong("boid"));
            }
            DynamicObject newOrgTeam = new DynamicObject(orgTeam.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)orgTeam, (DynamicObject)newOrgTeam);
            newOrgTeam.set("id", (Object)orgDy.getLong("id"));
            newOrgTeam.set("createtime", (Object)orgDy.getDate("createtime"));
            newOrgTeam.set("parent", orgDy.get("parentorg"));
            OrgTeamSynService.getInstance().synOrgTeamBizFields(newOrgTeam, orgDy, orgTeamNumberPrefix);
            return newOrgTeam;
        }).collect(Collectors.toList());
        BatchSynModel batchSynModel = new BatchSynModel();
        HashMap<Long, Date> esDateBoIdMap = new HashMap<Long, Date>(1);
        DynamicObject dy2 = this.model.getDy();
        if (this.model.isEstablishmentDateChanged()) {
            esDateBoIdMap.put(dy2.getLong("boid"), dy2.getDate("establishmentdate"));
        }
        if (this.model.isParentChanged()) {
            batchSynModel.setChgParentList(Collections.singletonList(this.createOt(dy2)));
        } else {
            batchSynModel.setChgInfoList(Collections.singletonList(this.createOt(dy2)));
        }
        batchSynModel.setEsDateBoIdMap(esDateBoIdMap);
        batchSynModel.setSaveList(saveList);
        return batchSynModel;
    }

    private DynamicObject createOt(DynamicObject orgDy) {
        DynamicObjectType otDt = EntityMetadataCache.getSubDataEntityType((String)"haos_adminorgteam", Arrays.asList("id", "boid", "parent", "bsed", "bsled", "structnumber", "enable"));
        DynamicObject ot = new DynamicObject(otDt);
        ot.set("id", orgDy.get("id"));
        ot.set("boid", orgDy.get("boid"));
        Long parentBoId = orgDy.getLong("parentorg.boid");
        DynamicObject parent = new DynamicObject(otDt);
        parent.set("id", (Object)parentBoId);
        parent.set("boid", (Object)parentBoId);
        ot.set("parent", (Object)parent);
        ot.set("structnumber", orgDy.get("structnumber"));
        LocalDateRangeUtils.synEffectRange((DynamicObject)orgDy, (DynamicObject)ot);
        return ot;
    }

    private void reviseEstablishmentDate() {
        if (this.model.isEstablishmentDateChanged()) {
            Long adminOrgId = this.model.getDy().getLong("boid");
            DynamicObject[] orgDys = AdOrgRepository.getInstance().queryByBoIdAndDataStatus("id,establishmentdate,firstbsed", adminOrgId, Arrays.asList(EnumHisDataVersionStatus.INVALIDED.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus()));
            Date establishmentDate = this.model.getDy().getDate("establishmentdate");
            for (DynamicObject orgDy : orgDys) {
                orgDy.set("establishmentdate", (Object)establishmentDate);
                orgDy.set("firstbsed", (Object)establishmentDate);
            }
            AdOrgRepository.getInstance().save(orgDys);
        }
    }

    private List<HisVersionParamBo> buildHisVersionParamList(Map<String, List<DynamicObject>> resultMap, boolean first) {
        DynamicObject creatorDy = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        creatorDy.set("id", (Object)RequestContext.get().getCurrUserId());
        IdCreator idCreator = new IdCreator();
        Date date = new Date();
        ArrayList<HisVersionParamBo> paramBoList = new ArrayList<HisVersionParamBo>(4);
        for (Map.Entry<String, List<DynamicObject>> entry : resultMap.entrySet()) {
            DynamicObject[] hisDyns = (DynamicObject[])entry.getValue().stream().peek(dy -> {
                if (!first) {
                    dy.set("id", (Object)idCreator.getId());
                }
                dy.set("createtime", (Object)date);
                dy.set("creator", (Object)creatorDy);
                MethodHelper.setInitFields(dy);
            }).toArray(DynamicObject[]::new);
            if (hisDyns.length <= 0) continue;
            HisVersionParamBo paramBo = AdminOrgHisServiceHelper.getHisVersionParam((DynamicObject[])hisDyns, (String)entry.getKey(), (boolean)false);
            paramBo.setNeedProcessAttachment(false);
            paramBoList.add(paramBo);
        }
        return paramBoList;
    }

    private HisResponse<BatchVersionChangeRespData> batchHisVersionChange(List<HisVersionParamBo> hisBoList) {
        if (CollectionUtils.isEmpty(hisBoList)) {
            return new HisResponse();
        }
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        hisVersionParamListBo.setAtomicTrans(false);
        hisVersionParamListBo.setEventId(this.eventId);
        hisVersionParamListBo.setListHisVersionParamBo(hisBoList);
        return HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
    }

    private Map<String, List<DynamicObject>> mergeData() {
        Map<String, List<DynamicObject>> orgMap = this.model.getResultMap();
        Map<String, List<DynamicObject>> subOrgMap = this.model.getSubResultMap();
        if (CollectionUtils.isEmpty(subOrgMap)) {
            return orgMap;
        }
        HashMap<String, List<DynamicObject>> resultMap = new HashMap<String, List<DynamicObject>>(8);
        String entityName = AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey();
        resultMap.put(entityName, this.mergeData(orgMap.get(entityName), subOrgMap.get(entityName)));
        entityName = AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey();
        List<DynamicObject> list = this.mergeData(orgMap.get(entityName), subOrgMap.get(entityName));
        if (!CollectionUtils.isEmpty(list)) {
            resultMap.put(entityName, list);
        }
        if (!CollectionUtils.isEmpty(list = this.mergeData(orgMap.get(entityName = AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey()), subOrgMap.get(entityName)))) {
            resultMap.put(entityName, list);
        }
        List<String> entityList = Arrays.asList(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey());
        for (Map.Entry<String, List<DynamicObject>> entry : orgMap.entrySet()) {
            if (entityList.contains(entry.getKey())) continue;
            resultMap.put(entry.getKey(), entry.getValue());
        }
        return resultMap;
    }

    private List<DynamicObject> mergeData(List<DynamicObject> list, List<DynamicObject> subList) {
        if (CollectionUtils.isEmpty(subList)) {
            return list;
        }
        if (CollectionUtils.isEmpty(list)) {
            return subList;
        }
        Map<Long, List<DynamicObject>> subMap = subList.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong("id")));
        for (DynamicObject itemDy : list) {
            List<DynamicObject> dyList = subMap.get(itemDy.getLong("id"));
            if (CollectionUtils.isEmpty(dyList)) {
                subList.add(itemDy);
                continue;
            }
            this.splitData(itemDy, dyList, subList);
        }
        return subList;
    }

    private void splitData(DynamicObject itemDy, List<DynamicObject> dyList, List<DynamicObject> subList) {
        LocalDateRange itemDateRange = LocalDateRangeUtils.getEffectRange((DynamicObject)itemDy);
        if (dyList.stream().anyMatch(dy -> itemDateRange.overlaps(LocalDateRangeUtils.getEffectRange((DynamicObject)dy)))) {
            ArrayList dateRangeList = new ArrayList(dyList.size());
            dyList.forEach(dy -> dateRangeList.add(LocalDateRangeUtils.getEffectRange((DynamicObject)dy)));
            List subtractList = itemDateRange.subtract(dateRangeList);
            for (LocalDateRange dateRange : subtractList) {
                DynamicObject newDy = new DynamicObject(itemDy.getDynamicObjectType());
                HRDynamicObjectUtils.copy((DynamicObject)itemDy, (DynamicObject)newDy);
                LocalDateRangeUtils.setEffectRange((DynamicObject)newDy, (LocalDateRange)dateRange);
                newDy.set("id", itemDy.get("id"));
                subList.add(newDy);
            }
        } else {
            subList.add(itemDy);
        }
    }

    private void splitData() {
        if (this.model.isEstablishmentDateChanged()) {
            Date minDate = AdOrgRepository.getInstance().getMinDateByBoId(Long.valueOf(this.model.getDy().getLong("parentorg.boid")));
            Date date = HRDateTimeUtils.truncateDate((Date)minDate);
            String entityName = AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey();
            this.splitData(entityName, this.model.getHisDy(entityName).getLong("id"), date);
            entityName = AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey();
            this.splitData(entityName, this.model.getHisDy(entityName).getLong("id"), date);
            entityName = AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey();
            this.splitData(entityName, this.model.getHisDy(entityName).getLong("id"), date);
        }
    }

    private void splitData(String entityName, Long hisId, Date parentEstablishmentDateDate) {
        if (parentEstablishmentDateDate == null) {
            return;
        }
        DynamicObject dy = this.model.getResultDy(entityName, hisId);
        if (dy == null) {
            return;
        }
        if (dy.getDate("bsed").compareTo(parentEstablishmentDateDate) < 0) {
            DynamicObject newDy = new DynamicObject(dy.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)newDy);
            dy.set("bsled", (Object)HRDateTimeUtils.addDay((Date)parentEstablishmentDateDate, (long)-1L));
            if (AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey().equals(entityName)) {
                dy.set("parentorg", null);
                dy.set("belongcompany", EffectBillConstant.BELONG_COMPANY_SELF_TYPE.contains(dy.getLong("adminorgtype.adminorgtypestd.id")) ? QueryHelper.generateEmptySubEntityMasterDy(dy.getLong("boid")) : null);
            } else if (AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey().equals(entityName)) {
                dy.set("parentorg", null);
                dy.set("structlongnumber", (Object)this.model.getDy().getString("structnumber"));
                dy.set("level", (Object)1);
            } else {
                dy.set("sortcode", (Object)String.format("%05d", this.model.getDy().getInt("index")));
            }
            newDy.set("id", (Object)dy.getLong("id"));
            newDy.set("bsed", (Object)parentEstablishmentDateDate);
            List<DynamicObject> list = this.model.getResultMap().get(entityName);
            list.add(newDy);
        }
    }
}

