/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast.revise;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.haos.common.util.LocalDateRange;
import kd.hr.homs.business.service.orgfast.revise.ReviseDateReviseValidator;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidateData;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidator;

public class ParentCyclicReviseValidator
extends ReviseValidator {
    private Long boId;
    private Long parentBoId;
    private static final int MAX_DEPTH = 5000;

    public ParentCyclicReviseValidator() {
        this.setNext(new ReviseDateReviseValidator());
    }

    @Override
    protected void valid(ReviseValidateData reviseValidateData) {
        DynamicObject[] overLapAdminArray = reviseValidateData.getOverLapAdminArray();
        DynamicObject needRevisedHisOrg = reviseValidateData.getNeedRevisedHisOrg();
        DynamicObject parentorg = needRevisedHisOrg.getDynamicObject("parentorg");
        if (parentorg == null) {
            return;
        }
        TreeNode treeNode = this.buildTree(overLapAdminArray, needRevisedHisOrg.getLong("boid"), parentorg);
        this.boId = needRevisedHisOrg.getLong("boid");
        this.parentBoId = parentorg.getLong("boid");
        try {
            this.backTrack(treeNode, new LinkedList<TreeNode>(), 0);
        }
        catch (IllegalArgumentException ex) {
            String errorMessage = ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u81ea\u5df1\u6216\u81ea\u5df1\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ParentCyclicReviseValidator_0", (String)"odc-homs-business", (Object[])new Object[0]);
            throw new KDBizException(errorMessage);
        }
    }

    private void backTrack(TreeNode treeNode, Deque<TreeNode> set, int i) {
        if (treeNode == null) {
            return;
        }
        if (i > 5000) {
            return;
        }
        for (TreeNode node : treeNode.getChildren()) {
            if (set.contains(node) && (node.getPid().equals(this.boId) || node.getBoId().equals(this.parentBoId))) {
                throw new IllegalArgumentException("cyclic circle");
            }
            set.addLast(node);
            this.backTrack(node, set, i++);
            set.removeLast();
        }
    }

    private TreeNode buildTree(DynamicObject[] overLapAdminArray, Long boId, DynamicObject newParentDyn) {
        TreeNode virtualRoot = new TreeNode(-1L, -1L, LocalDateRange.ALL);
        HashMap map = new HashMap(16);
        Arrays.stream(overLapAdminArray).forEach(dyn -> {
            List treeNodes = map.computeIfAbsent(dyn.getLong("boid"), k -> new ArrayList());
            if (boId.equals(dyn.getLong("boid"))) {
                treeNodes.add(new TreeNode(dyn.getLong("boid"), newParentDyn.getLong("boid"), LocalDateRangeUtils.getEffectRange((DynamicObject)dyn)));
            } else {
                treeNodes.add(new TreeNode(dyn.getLong("boid"), dyn.getLong("parentorg.id"), LocalDateRangeUtils.getEffectRange((DynamicObject)dyn)));
            }
        });
        map.values().forEach(nodeList -> nodeList.forEach(node -> {
            List parentNodeList = map.getOrDefault(node.getPid(), new ArrayList());
            AtomicBoolean noRealRoot = new AtomicBoolean(true);
            parentNodeList.forEach(parentNode -> {
                if (node.getPid().equals(parentNode.getBoId()) && parentNode.getDataRange().overlaps(node.getDataRange())) {
                    parentNode.getChildren().add((TreeNode)node);
                    noRealRoot.set(false);
                }
            });
            if (noRealRoot.get()) {
                virtualRoot.getChildren().add((TreeNode)node);
            }
        }));
        return virtualRoot;
    }

    public static class TreeNode {
        private Long boId;
        private Long pid;
        LocalDateRange dataRange;
        private List<TreeNode> children = new ArrayList<TreeNode>();

        public TreeNode(Long boId, Long pid, LocalDateRange dataRange) {
            this.boId = boId;
            this.pid = pid;
            this.dataRange = dataRange;
        }

        public LocalDateRange getDataRange() {
            return this.dataRange;
        }

        public void setDataRange(LocalDateRange dataRange) {
            this.dataRange = dataRange;
        }

        public Long getBoId() {
            return this.boId;
        }

        public void setBoId(Long boId) {
            this.boId = boId;
        }

        public Long getPid() {
            return this.pid;
        }

        public void setPid(Long pid) {
            this.pid = pid;
        }

        public List<TreeNode> getChildren() {
            return this.children;
        }

        public void setChildren(List<TreeNode> children) {
            this.children = children;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TreeNode node = (TreeNode)o;
            return Objects.equals(this.boId, node.boId) && Objects.equals(this.pid, node.pid) && Objects.equals(this.dataRange, node.dataRange);
        }

        public int hashCode() {
            return Objects.hash(this.boId, this.pid, this.dataRange);
        }
    }
}

