/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast.revise;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.haos.business.util.TimeLogger;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidateData;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;

public abstract class ReviseValidator {
    private TimeLogger timeLogger = TimeLogger.create();
    private ReviseValidator next;

    public ReviseValidator getNext() {
        return this.next;
    }

    public void setNext(ReviseValidator next) {
        this.next = next;
    }

    protected abstract void valid(ReviseValidateData var1);

    public void doValid(ReviseValidateData reviseValidateData) {
        this.timeLogger.start();
        this.valid(reviseValidateData);
        this.timeLogger.check(this.getClass().getName());
        if (this.next != null) {
            this.next.doValid(reviseValidateData);
        }
    }

    protected boolean isOverLap(Date checkDate, DynamicObject needRevisedHisOrg) {
        if (checkDate.compareTo(needRevisedHisOrg.getDate("bsed")) >= 0 && checkDate.compareTo(needRevisedHisOrg.getDate("bsled")) <= 0) {
            return true;
        }
        return checkDate.compareTo(needRevisedHisOrg.getDate("bsed")) <= 0;
    }

    protected boolean validateDateOverLap(DynamicObject needRevisedHisOrg, OrgBatchCheckDto dto) {
        if (OrgBatchChgBillConstants.CHANGE_TYPE_ADD.equals(dto.getChangeTypeId()) && dto.getEstablishmentDate() != null && this.isOverLap(dto.getEstablishmentDate(), needRevisedHisOrg)) {
            return true;
        }
        return (OrgBatchChgBillConstants.CHANGE_TYPE_INFO.equals(dto.getChangeTypeId()) || OrgBatchChgBillConstants.CHANGE_TYPE_PARENT.equals(dto.getChangeTypeId())) && dto.getEffectDate() != null && this.isOverLap(dto.getEffectDate(), needRevisedHisOrg);
    }
}

