/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast.revise;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.hr.haos.common.constants.masterdata.AdminOrgType;
import kd.hr.homs.business.service.helper.AdminOrgBatchChartBaseHelper;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.orgfast.revise.DownFourLayerReviseValidator;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidateData;
import kd.hr.homs.business.service.orgfast.revise.ReviseValidator;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckConstants;
import kd.hr.homs.common.model.CalibratorBean;

public class UpFourLayerReviseValidator
extends ReviseValidator {
    public UpFourLayerReviseValidator() {
        this.setNext(new DownFourLayerReviseValidator());
    }

    public UpFourLayerReviseValidator(boolean setNext) {
        if (setNext) {
            this.setNext(new DownFourLayerReviseValidator());
        }
    }

    @Override
    public void valid(ReviseValidateData reviseValidateData) {
        DynamicObject needRevisedHisOrg = reviseValidateData.getNeedRevisedHisOrg();
        DynamicObject parentOrg = needRevisedHisOrg.getDynamicObject("parentorg");
        long boId = needRevisedHisOrg.getLong("boid");
        if (parentOrg == null) {
            return;
        }
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        if (boId == rootOrgId) {
            return;
        }
        parentOrg = AdminOrgBatchChartBaseHelper.HAOS_ADMINORGDETAIL_HELPER.queryOne("adminorgtype", new QFilter[]{this.buildHisFilter("boid", needRevisedHisOrg.getDate("bsed"), needRevisedHisOrg.getLong("parentorg.boid"))});
        if (parentOrg == null) {
            return;
        }
        String orgTypeName = needRevisedHisOrg.getString("adminorgtype.name");
        long parentAdminOrgTypeId = parentOrg.getLong("adminorgtype.id");
        DynamicObject parentAdminOrgTypeDy = OrgBatchBillCheckHelper.queryOrgTypeById(parentAdminOrgTypeId);
        if (parentAdminOrgTypeDy == null) {
            return;
        }
        long parentAdminOrgStdId = parentAdminOrgTypeDy.getLong("adminorgtypestd.id");
        long adminOrgStdId = needRevisedHisOrg.getLong("adminorgtype.adminorgtypestd.id");
        if (AdminOrgType.GROUP.getId() == adminOrgStdId && !OrgBatchCheckConstants.LEVEL4_ABOVE_GROUP.contains(parentAdminOrgStdId)) {
            reviseValidateData.getCalibratorBeans().add(new CalibratorBean("UpFourLayerReviseValidator_0", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"UpFourLayerReviseValidator_0", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgTypeName, reviseValidateData.getAdminOrgTypeNameMap() != null ? reviseValidateData.getAdminOrgTypeNameMap().get("level4_above_group") : "null"}));
        } else if (AdminOrgType.COMPANY.getId() == adminOrgStdId && !OrgBatchCheckConstants.LEVEL4_ABOVE_COMPANY.contains(parentAdminOrgStdId)) {
            reviseValidateData.getCalibratorBeans().add(new CalibratorBean("UpFourLayerReviseValidator_0", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"UpFourLayerReviseValidator_0", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{orgTypeName, reviseValidateData.getAdminOrgTypeNameMap() != null ? reviseValidateData.getAdminOrgTypeNameMap().get("level4_above_company") : "null"}));
        }
    }

    private QFilter buildHisFilter(String property, Date searchDate, Object ... id) {
        QFilter filter = new QFilter(property, "in", (Object)id);
        if (searchDate == null) {
            filter.and(new QFilter("iscurrentversion", "in", (Object)"1"));
        } else {
            filter.and(new QFilter("bsed", "<=", (Object)searchDate).and(new QFilter("bsled", ">=", (Object)searchDate)));
            QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2"}).and("iscurrentversion", "=", (Object)"0");
            filter.and(statusFilter);
        }
        return filter;
    }
}

