/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast.revise.handler;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.homs.business.service.helper.AdminOrgFastChgHelper;
import kd.hr.homs.business.service.orgfast.revise.AdminOrgReviseCompareService;
import kd.hr.homs.business.service.orgfast.revise.AdminOrgTypeRecognized;
import kd.hr.homs.business.service.orgfast.revise.AdminTypeChange;
import kd.hr.homs.business.service.orgfast.revise.fourlayer.FourLayerReviseFactory;
import kd.hr.homs.business.service.orgfast.revise.fourlayer.IFourLayerRevise;
import kd.hr.homs.business.service.orgfast.revise.handler.IOrgReviseHandler;
import kd.hr.homs.business.service.orgfast.revise.model.OrgReviseModel;

public class OrgFourLayerReviseHandler
implements IOrgReviseHandler {
    private AdminTypeChange adminTypeChange;

    @Override
    public boolean isChanged(OrgReviseModel model) {
        boolean isChanged = false;
        ArrayList<String> changedProperties = new ArrayList<String>(16);
        long originalAdminOrgType = model.getHisDy(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey()).getLong("adminorgtype.adminorgtypestd.id");
        long afterAdminOrgType = model.getDy().getLong("adminorgtype.adminorgtypestd.id");
        long orgBoId = model.getDy().getLong("boid");
        Date bseDate = model.getDy().getDate("bsed");
        isChanged = isChanged || originalAdminOrgType != afterAdminOrgType;
        this.adminTypeChange = AdminOrgTypeRecognized.recognized(originalAdminOrgType, afterAdminOrgType);
        boolean isCompany = false;
        switch (this.adminTypeChange) {
            case GROUP_TO_GROUP: {
                DynamicObject groupOrgCompany;
                DynamicObject group = AdminOrgFastChgHelper.getGroup(orgBoId, bseDate);
                if (group != null) {
                    changedProperties.addAll(AdminOrgReviseCompareService.compare(group, model.getDy(), AdminOrgReviseCompareService.groupInfo));
                }
                if ((groupOrgCompany = AdminOrgFastChgHelper.getCompany(orgBoId, bseDate)) != null) {
                    changedProperties.addAll(AdminOrgReviseCompareService.compare(groupOrgCompany, model.getDy(), AdminOrgReviseCompareService.companyInfo));
                }
                isCompany = true;
                break;
            }
            case COMPANY_TO_COMPANY: {
                DynamicObject company = AdminOrgFastChgHelper.getCompany(orgBoId, bseDate);
                if (company != null) {
                    changedProperties.addAll(AdminOrgReviseCompareService.compare(company, model.getDy(), AdminOrgReviseCompareService.companyInfo));
                }
                isCompany = true;
                break;
            }
            case DEPARTMENT_TO_DEPARTMENT: {
                DynamicObject department = AdminOrgFastChgHelper.getDepartment(orgBoId, bseDate);
                if (department == null) break;
                changedProperties.addAll(AdminOrgReviseCompareService.compare(department, model.getDy(), AdminOrgReviseCompareService.departmentInfo));
                break;
            }
        }
        return isChanged || changedProperties.size() != 0 || isCompany && model.isNameChanged();
    }

    @Override
    public void execute(OrgReviseModel model) {
        IFourLayerRevise fourLayerRevise = FourLayerReviseFactory.getFourLayerRevise(this.adminTypeChange);
        if (fourLayerRevise != null) {
            fourLayerRevise.revise(model);
        }
    }
}

