/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.business.service.orgfast.revise.handler;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.homs.business.service.orgfast.revise.handler.IOrgReviseHandler;
import kd.hr.homs.business.service.orgfast.revise.model.OrgReviseModel;
import kd.hr.homs.business.service.utils.OrgChgUtil;
import kd.hr.homs.business.service.utils.PatternUtil;

public class OrgOtherReviseHandler
implements IOrgReviseHandler {
    private final List<String> propertiesList = Arrays.asList("number", "name", "simplename", "corporateorg", "adminorglayer", "adminorgfunction", "companyarea", "city", "workplace", "detailaddress", "description", "positioning", "mainduty", "safelevel", "safetype", "safedescription");
    private List<String> extPropertiesList;

    @Override
    public boolean isChanged(OrgReviseModel model) {
        DynamicObject oldDy = model.getHisDy(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
        List<String> changedList = OrgChgUtil.getChangeProperties(oldDy, model.getDy(), this.propertiesList);
        if (!CollectionUtils.isEmpty(changedList)) {
            return true;
        }
        changedList = OrgChgUtil.getChangeProperties(oldDy, model.getDy(), this.getExtPropertiesList());
        return !CollectionUtils.isEmpty(changedList);
    }

    @Override
    public void execute(OrgReviseModel model) {
        DynamicObject dy = model.getDy();
        DynamicObject newDy = model.getNewDy(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), dy.getLong("id"));
        for (String propertyName : this.propertiesList) {
            newDy.set(propertyName, dy.get(propertyName));
        }
        for (String property : this.getExtPropertiesList()) {
            newDy.set(property, dy.get(property));
        }
    }

    private List<String> getExtPropertiesList() {
        if (this.extPropertiesList == null) {
            this.extPropertiesList = Lists.newArrayListWithExpectedSize((int)10);
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"homs_adminorgdetailrevise");
            DataEntityPropertyCollection properties = mainEntityType.getProperties();
            for (IDataEntityProperty property : properties) {
                if (!PatternUtil.isExProperty(property.getName())) continue;
                this.extPropertiesList.add(property.getName());
            }
        }
        return this.extPropertiesList;
    }
}

